/*
 * This file was generated by running ./tools/make-bluetooth.py.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * The Bluetooth public SIG repository is available at:
 * <https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/>
 *
 */

#include "packet-bluetooth.h"

const value_string bluetooth_uuid_vals[] = {
    /* Protocol Identifiers - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/protocol_identifiers.yaml */
    { 0x0001,   "SDP" },
    { 0x0002,   "UDP" },
    { 0x0003,   "RFCOMM" },
    { 0x0004,   "TCP" },
    { 0x0005,   "TCS-BIN" },
    { 0x0006,   "TCS-AT" },
    { 0x0007,   "ATT" },
    { 0x0008,   "OBEX" },
    { 0x0009,   "IP" },
    { 0x000A,   "FTP" },
    { 0x000C,   "HTTP" },
    { 0x000E,   "WSP" },
    { 0x000F,   "BNEP" },
    { 0x0010,   "UPNP" },
    { 0x0011,   "HID Protocol" },
    { 0x0012,   "Hardcopy Control Channel" },
    { 0x0014,   "Hardcopy Data Channel" },
    { 0x0016,   "Hardcopy Notification Channel" },
    { 0x0017,   "AVCTP" },
    { 0x0019,   "AVDTP" },
    { 0x001B,   "CMTP" },
    { 0x001D,   "UDI C-Plane" },
    { 0x001E,   "MCAP Control Channel" },
    { 0x001F,   "MCAP Data Channel" },
    { 0x0100,   "L2CAP" },
    /* Service Class - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/service_class.yaml */
    { 0x1000,   "Service Discovery Server Service Class ID" },
    { 0x1001,   "Browse Group Descriptor Service Class ID" },
    { 0x1002,   "Public Browse Group" },
    { 0x1101,   "Serial Port" },
    { 0x1102,   "LAN Access Using PPP" },
    { 0x1103,   "Dial-Up Networking" },
    { 0x1104,   "IrMC Sync" },
    { 0x1105,   "OBEX Object Push" },
    { 0x1106,   "OBEX File Transfer" },
    { 0x1107,   "IrMC Sync Command" },
    { 0x1108,   "Headset" },
    { 0x1109,   "Cordless Telephony" },
    { 0x110A,   "Audio Source" },
    { 0x110B,   "Audio Sink" },
    { 0x110C,   "A/V Remote Control Target" },
    { 0x110D,   "Advanced Audio Distribution" },
    { 0x110E,   "A/V Remote Control" },
    { 0x110F,   "A/V Remote Control Controller" },
    { 0x1110,   "Intercom" },
    { 0x1111,   "Fax" },
    { 0x1112,   "Headset Audio Gateway" },
    { 0x1113,   "WAP" },
    { 0x1114,   "WAP CLIENT" },
    { 0x1115,   "PANU" },
    { 0x1116,   "NAP" },
    { 0x1117,   "GN" },
    { 0x1118,   "Direct Printing" },
    { 0x1119,   "Reference Printing" },
    { 0x111A,   "Imaging" },
    { 0x111B,   "Imaging Responder" },
    { 0x111C,   "Imaging Automatic Archive" },
    { 0x111D,   "Imaging Referenced Objects" },
    { 0x111E,   "Hands-Free" },
    { 0x111F,   "AG Hands-Free" },
    { 0x1120,   "Direct Printing Referenced Objects Service" },
    { 0x1121,   "Reflected UI" },
    { 0x1122,   "Basic Printing" },
    { 0x1123,   "Printing Status" },
    { 0x1124,   "HID" },
    { 0x1125,   "Hardcopy Cable Replacement" },
    { 0x1126,   "HCR Print" },
    { 0x1127,   "HCR Scan" },
    { 0x1128,   "Common ISDN Access" },
    { 0x1129,   "Video Conferencing GW" },
    { 0x112A,   "UDI MT" },
    { 0x112B,   "UDI TA" },
    { 0x112C,   "Audio/Video" },
    { 0x112D,   "SIM Access" },
    { 0x112E,   "Phonebook Access Client" },
    { 0x112F,   "Phonebook Access Server" },
    { 0x1130,   "Phonebook Access Profile" },
    { 0x1131,   "Headset - HS" },
    { 0x1132,   "Message Access Server" },
    { 0x1133,   "Message Notification Server" },
    { 0x1134,   "Message Access Profile" },
    { 0x1135,   "GNSS" },
    { 0x1136,   "GNSS Server" },
    { 0x1137,   "3D Display" },
    { 0x1138,   "3D Glasses" },
    { 0x1139,   "3D Synch Profile" },
    { 0x113A,   "Multi Profile Specification" },
    { 0x113B,   "MPS" },
    { 0x113C,   "CTN Access Service" },
    { 0x113D,   "CTN Notification Service" },
    { 0x113E,   "Calendar Tasks and Notes Profile" },
    { 0x1200,   "PnP Information" },
    { 0x1201,   "Generic Networking" },
    { 0x1202,   "Generic File Transfer" },
    { 0x1203,   "Generic Audio" },
    { 0x1204,   "Generic Telephony" },
    { 0x1205,   "UPNP Service" },
    { 0x1206,   "UPNP IP Service" },
    { 0x1300,   "ESDP UPNP IP PAN" },
    { 0x1301,   "ESDP UPNP IP LAP" },
    { 0x1302,   "ESDP UPNP L2CAP" },
    { 0x1303,   "Video Source" },
    { 0x1304,   "Video Sink" },
    { 0x1305,   "Video Distribution" },
    { 0x1400,   "HDP" },
    { 0x1401,   "HDP Source" },
    { 0x1402,   "HDP Sink" },
    /* Mesh Profile - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/mesh_profile_uuids.yaml */
    { 0x1600,   "Ambient Light Sensor NLC Profile 1.0" },
    { 0x1601,   "Basic Lightness Controller NLC Profile 1.0" },
    { 0x1602,   "Basic Scene Selector NLC Profile 1.0" },
    { 0x1603,   "Dimming Control NLC Profile 1.0" },
    { 0x1604,   "Energy Monitor NLC Profile 1.0" },
    { 0x1605,   "Occupancy Sensor NLC Profile 1.0" },
    { 0x1606,   "HVAC Integration NLC Profile 1.0" },
    /* Service - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/service_uuids.yaml */
    { 0x1800,   "GAP" },
    { 0x1801,   "GATT" },
    { 0x1802,   "Immediate Alert" },
    { 0x1803,   "Link Loss" },
    { 0x1804,   "Tx Power" },
    { 0x1805,   "Current Time" },
    { 0x1806,   "Reference Time Update" },
    { 0x1807,   "Next DST Change" },
    { 0x1808,   "Glucose" },
    { 0x1809,   "Health Thermometer" },
    { 0x180A,   "Device Information" },
    { 0x180D,   "Heart Rate" },
    { 0x180E,   "Phone Alert Status" },
    { 0x180F,   "Battery" },
    { 0x1810,   "Blood Pressure" },
    { 0x1811,   "Alert Notification" },
    { 0x1812,   "Human Interface Device" },
    { 0x1813,   "Scan Parameters" },
    { 0x1814,   "Running Speed and Cadence" },
    { 0x1815,   "Automation IO" },
    { 0x1816,   "Cycling Speed and Cadence" },
    { 0x1818,   "Cycling Power" },
    { 0x1819,   "Location and Navigation" },
    { 0x181A,   "Environmental Sensing" },
    { 0x181B,   "Body Composition" },
    { 0x181C,   "User Data" },
    { 0x181D,   "Weight Scale" },
    { 0x181E,   "Bond Management" },
    { 0x181F,   "Continuous Glucose Monitoring" },
    { 0x1820,   "Internet Protocol Support" },
    { 0x1821,   "Indoor Positioning" },
    { 0x1822,   "Pulse Oximeter" },
    { 0x1823,   "HTTP Proxy" },
    { 0x1824,   "Transport Discovery" },
    { 0x1825,   "Object Transfer" },
    { 0x1826,   "Fitness Machine" },
    { 0x1827,   "Mesh Provisioning" },
    { 0x1828,   "Mesh Proxy" },
    { 0x1829,   "Reconnection Configuration" },
    { 0x183A,   "Insulin Delivery" },
    { 0x183B,   "Binary Sensor" },
    { 0x183C,   "Emergency Configuration" },
    { 0x183D,   "Authorization Control" },
    { 0x183E,   "Physical Activity Monitor" },
    { 0x183F,   "Elapsed Time" },
    { 0x1840,   "Generic Health Sensor" },
    { 0x1843,   "Audio Input Control" },
    { 0x1844,   "Volume Control" },
    { 0x1845,   "Volume Offset Control" },
    { 0x1846,   "Coordinated Set Identification" },
    { 0x1847,   "Device Time" },
    { 0x1848,   "Media Control" },
    { 0x1849,   "Generic Media Control" },
    { 0x184A,   "Constant Tone Extension" },
    { 0x184B,   "Telephone Bearer" },
    { 0x184C,   "Generic Telephone Bearer" },
    { 0x184D,   "Microphone Control" },
    { 0x184E,   "Audio Stream Control" },
    { 0x184F,   "Broadcast Audio Scan" },
    { 0x1850,   "Published Audio Capabilities" },
    { 0x1851,   "Basic Audio Announcement" },
    { 0x1852,   "Broadcast Audio Announcement" },
    { 0x1853,   "Common Audio" },
    { 0x1854,   "Hearing Access" },
    { 0x1855,   "Telephony and Media Audio" },
    { 0x1856,   "Public Broadcast Announcement" },
    { 0x1857,   "Electronic Shelf Label" },
    { 0x1858,   "Gaming Audio" },
    { 0x1859,   "Mesh Proxy Solicitation" },
    { 0x185A,   "Industrial Measurement Device" },
    { 0x185B,   "Ranging" },
    { 0x185C,   "HID ISO" },
    { 0x185D,   "Cookware" },
    /* Units - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/units.yaml */
    { 0x2700,   "unitless" },
    { 0x2701,   "length (metre)" },
    { 0x2702,   "mass (kilogram)" },
    { 0x2703,   "time (second)" },
    { 0x2704,   "electric current (ampere)" },
    { 0x2705,   "thermodynamic temperature (kelvin)" },
    { 0x2706,   "amount of substance (mole)" },
    { 0x2707,   "luminous intensity (candela)" },
    { 0x2710,   "area (square metres)" },
    { 0x2711,   "volume (cubic metres)" },
    { 0x2712,   "velocity (metres per second)" },
    { 0x2713,   "acceleration (metres per second squared)" },
    { 0x2714,   "wavenumber (reciprocal metre)" },
    { 0x2715,   "density (kilogram per cubic metre)" },
    { 0x2716,   "surface density (kilogram per square metre)" },
    { 0x2717,   "specific volume (cubic metre per kilogram)" },
    { 0x2718,   "current density (ampere per square metre)" },
    { 0x2719,   "magnetic field strength (ampere per metre)" },
    { 0x271A,   "amount concentration (mole per cubic metre)" },
    { 0x271B,   "mass concentration (kilogram per cubic metre)" },
    { 0x271C,   "luminance (candela per square metre)" },
    { 0x271D,   "refractive index" },
    { 0x271E,   "relative permeability" },
    { 0x2720,   "plane angle (radian)" },
    { 0x2721,   "solid angle (steradian)" },
    { 0x2722,   "frequency (hertz)" },
    { 0x2723,   "force (newton)" },
    { 0x2724,   "pressure (pascal)" },
    { 0x2725,   "energy (joule)" },
    { 0x2726,   "power (watt)" },
    { 0x2727,   "electric charge (coulomb)" },
    { 0x2728,   "electric potential difference (volt)" },
    { 0x2729,   "capacitance (farad)" },
    { 0x272A,   "electric resistance (ohm)" },
    { 0x272B,   "electric conductance (siemens)" },
    { 0x272C,   "magnetic flux (weber)" },
    { 0x272D,   "magnetic flux density (tesla)" },
    { 0x272E,   "inductance (henry)" },
    { 0x272F,   "Celsius temperature (degree Celsius)" },
    { 0x2730,   "luminous flux (lumen)" },
    { 0x2731,   "illuminance (lux)" },
    { 0x2732,   "activity referred to a radionuclide (becquerel)" },
    { 0x2733,   "absorbed dose (gray)" },
    { 0x2734,   "dose equivalent (sievert)" },
    { 0x2735,   "catalytic activity (katal)" },
    { 0x2740,   "dynamic viscosity (pascal second)" },
    { 0x2741,   "moment of force (newton metre)" },
    { 0x2742,   "surface tension (newton per metre)" },
    { 0x2743,   "angular velocity (radian per second)" },
    { 0x2744,   "angular acceleration (radian per second squared)" },
    { 0x2745,   "heat flux density (watt per square metre)" },
    { 0x2746,   "heat capacity (joule per kelvin)" },
    { 0x2747,   "specific heat capacity (joule per kilogram kelvin)" },
    { 0x2748,   "specific energy (joule per kilogram)" },
    { 0x2749,   "thermal conductivity (watt per metre kelvin)" },
    { 0x274A,   "energy density (joule per cubic metre)" },
    { 0x274B,   "electric field strength (volt per metre)" },
    { 0x274C,   "electric charge density (coulomb per cubic metre)" },
    { 0x274D,   "surface charge density (coulomb per square metre)" },
    { 0x274E,   "electric flux density (coulomb per square metre)" },
    { 0x274F,   "permittivity (farad per metre)" },
    { 0x2750,   "permeability (henry per metre)" },
    { 0x2751,   "molar energy (joule per mole)" },
    { 0x2752,   "molar entropy (joule per mole kelvin)" },
    { 0x2753,   "exposure (coulomb per kilogram)" },
    { 0x2754,   "absorbed dose rate (gray per second)" },
    { 0x2755,   "radiant intensity (watt per steradian)" },
    { 0x2756,   "radiance (watt per square metre steradian)" },
    { 0x2757,   "catalytic activity concentration (katal per cubic metre)" },
    { 0x2760,   "time (minute)" },
    { 0x2761,   "time (hour)" },
    { 0x2762,   "time (day)" },
    { 0x2763,   "plane angle (degree)" },
    { 0x2764,   "plane angle (minute)" },
    { 0x2765,   "plane angle (second)" },
    { 0x2766,   "area (hectare)" },
    { 0x2767,   "volume (litre)" },
    { 0x2768,   "mass (tonne)" },
    { 0x2780,   "pressure (bar)" },
    { 0x2781,   "pressure (millimetre of mercury)" },
    { 0x2782,   "length (ångström)" },
    { 0x2783,   "length (nautical mile)" },
    { 0x2784,   "area (barn)" },
    { 0x2785,   "velocity (knot)" },
    { 0x2786,   "logarithmic radio quantity (neper)" },
    { 0x2787,   "logarithmic radio quantity (bel)" },
    { 0x27A0,   "length (yard)" },
    { 0x27A1,   "length (parsec)" },
    { 0x27A2,   "length (inch)" },
    { 0x27A3,   "length (foot)" },
    { 0x27A4,   "length (mile)" },
    { 0x27A5,   "pressure (pound-force per square inch)" },
    { 0x27A6,   "velocity (kilometre per hour)" },
    { 0x27A7,   "velocity (mile per hour)" },
    { 0x27A8,   "angular velocity (revolution per minute)" },
    { 0x27A9,   "energy (gram calorie)" },
    { 0x27AA,   "energy (kilogram calorie)" },
    { 0x27AB,   "energy (kilowatt hour)" },
    { 0x27AC,   "thermodynamic temperature (degree Fahrenheit)" },
    { 0x27AD,   "percentage" },
    { 0x27AE,   "per mille" },
    { 0x27AF,   "period (beats per minute)" },
    { 0x27B0,   "electric charge (ampere hours)" },
    { 0x27B1,   "mass density (milligram per decilitre)" },
    { 0x27B2,   "mass density (millimole per litre)" },
    { 0x27B3,   "time (year)" },
    { 0x27B4,   "time (month)" },
    { 0x27B5,   "concentration (count per cubic metre)" },
    { 0x27B6,   "irradiance (watt per square metre)" },
    { 0x27B7,   "milliliter (per kilogram per minute)" },
    { 0x27B8,   "mass (pound)" },
    { 0x27B9,   "metabolic equivalent" },
    { 0x27BA,   "step (per minute)" },
    { 0x27BC,   "stroke (per minute)" },
    { 0x27BD,   "pace (kilometre per minute)" },
    { 0x27BE,   "luminous efficacy (lumen per watt)" },
    { 0x27BF,   "luminous energy (lumen hour)" },
    { 0x27C0,   "luminous exposure (lux hour)" },
    { 0x27C1,   "mass flow (gram per second)" },
    { 0x27C2,   "volume flow (litre per second)" },
    { 0x27C3,   "sound pressure (decibel)" },
    { 0x27C4,   "parts per million" },
    { 0x27C5,   "parts per billion" },
    { 0x27C6,   "mass density rate ((milligram per decilitre) per minute)" },
    { 0x27C7,   "Electrical Apparent Energy (kilovolt ampere hour)" },
    { 0x27C8,   "Electrical Apparent Power (volt ampere)" },
    { 0x27C9,   "Gravity (g\textsubscript{n})" },
    /* Declarations - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/declarations.yaml */
    { 0x2800,   "Primary Service" },
    { 0x2801,   "Secondary Service" },
    { 0x2802,   "Include" },
    { 0x2803,   "Characteristic" },
    /* Descriptors - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/descriptors.yaml */
    { 0x2900,   "Characteristic Extended Properties" },
    { 0x2901,   "Characteristic User Description" },
    { 0x2902,   "Client Characteristic Configuration" },
    { 0x2903,   "Server Characteristic Configuration" },
    { 0x2904,   "Characteristic Presentation Format" },
    { 0x2905,   "Characteristic Aggregate Format" },
    { 0x2906,   "Valid Range" },
    { 0x2907,   "External Report Reference" },
    { 0x2908,   "Report Reference" },
    { 0x2909,   "Number of Digitals" },
    { 0x290A,   "Value Trigger Setting" },
    { 0x290B,   "Environmental Sensing Configuration" },
    { 0x290C,   "Environmental Sensing Measurement" },
    { 0x290D,   "Environmental Sensing Trigger Setting" },
    { 0x290E,   "Time Trigger Setting" },
    { 0x290F,   "Complete BR-EDR Transport Block Data" },
    { 0x2910,   "Observation Schedule" },
    { 0x2911,   "Valid Range and Accuracy" },
    { 0x2912,   "Measurement Description" },
    { 0x2913,   "Manufacturer Limits" },
    { 0x2914,   "Process Tolerances" },
    { 0x2915,   "IMD Trigger Setting" },
    { 0x2916,   "Cooking Sensor Info" },
    { 0x2917,   "Cooking Trigger Setting" },
    /* Characteristics - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/characteristic_uuids.yaml */
    { 0x2A00,   "Device Name" },
    { 0x2A01,   "Appearance" },
    { 0x2A02,   "Peripheral Privacy Flag" },
    { 0x2A03,   "Reconnection Address" },
    { 0x2A04,   "Peripheral Preferred Connection Parameters" },
    { 0x2A05,   "Service Changed" },
    { 0x2A06,   "Alert Level" },
    { 0x2A07,   "Tx Power Level" },
    { 0x2A08,   "Date Time" },
    { 0x2A09,   "Day of Week" },
    { 0x2A0A,   "Day Date Time" },
    { 0x2A0B,   "Exact Time 100" },
    { 0x2A0C,   "Exact Time 256" },
    { 0x2A0D,   "DST Offset" },
    { 0x2A0E,   "Time Zone" },
    { 0x2A0F,   "Local Time Information" },
    { 0x2A10,   "Secondary Time Zone" },
    { 0x2A11,   "Time with DST" },
    { 0x2A12,   "Time Accuracy" },
    { 0x2A13,   "Time Source" },
    { 0x2A14,   "Reference Time Information" },
    { 0x2A15,   "Time Broadcast" },
    { 0x2A16,   "Time Update Control Point" },
    { 0x2A17,   "Time Update State" },
    { 0x2A18,   "Glucose Measurement" },
    { 0x2A19,   "Battery Level" },
    { 0x2A1A,   "Battery Power State" },
    { 0x2A1B,   "Battery Level State" },
    { 0x2A1C,   "Temperature Measurement" },
    { 0x2A1D,   "Temperature Type" },
    { 0x2A1E,   "Intermediate Temperature" },
    { 0x2A1F,   "Temperature Celsius" },
    { 0x2A20,   "Temperature Fahrenheit" },
    { 0x2A21,   "Measurement Interval" },
    { 0x2A22,   "Boot Keyboard Input Report" },
    { 0x2A23,   "System ID" },
    { 0x2A24,   "Model Number String" },
    { 0x2A25,   "Serial Number String" },
    { 0x2A26,   "Firmware Revision String" },
    { 0x2A27,   "Hardware Revision String" },
    { 0x2A28,   "Software Revision String" },
    { 0x2A29,   "Manufacturer Name String" },
    { 0x2A2A,   "IEEE 11073-20601 Regulatory Certification Data List" },
    { 0x2A2B,   "Current Time" },
    { 0x2A2C,   "Magnetic Declination" },
    { 0x2A2F,   "Position 2D" },
    { 0x2A30,   "Position 3D" },
    { 0x2A31,   "Scan Refresh" },
    { 0x2A32,   "Boot Keyboard Output Report" },
    { 0x2A33,   "Boot Mouse Input Report" },
    { 0x2A34,   "Glucose Measurement Context" },
    { 0x2A35,   "Blood Pressure Measurement" },
    { 0x2A36,   "Intermediate Cuff Pressure" },
    { 0x2A37,   "Heart Rate Measurement" },
    { 0x2A38,   "Body Sensor Location" },
    { 0x2A39,   "Heart Rate Control Point" },
    { 0x2A3A,   "Removable" },
    { 0x2A3B,   "Service Required" },
    { 0x2A3C,   "Scientific Temperature Celsius" },
    { 0x2A3D,   "String" },
    { 0x2A3E,   "Network Availability" },
    { 0x2A3F,   "Alert Status" },
    { 0x2A40,   "Ringer Control Point" },
    { 0x2A41,   "Ringer Setting" },
    { 0x2A42,   "Alert Category ID Bit Mask" },
    { 0x2A43,   "Alert Category ID" },
    { 0x2A44,   "Alert Notification Control Point" },
    { 0x2A45,   "Unread Alert Status" },
    { 0x2A46,   "New Alert" },
    { 0x2A47,   "Supported New Alert Category" },
    { 0x2A48,   "Supported Unread Alert Category" },
    { 0x2A49,   "Blood Pressure Feature" },
    { 0x2A4A,   "HID Information" },
    { 0x2A4B,   "Report Map" },
    { 0x2A4C,   "HID Control Point" },
    { 0x2A4D,   "Report" },
    { 0x2A4E,   "Protocol Mode" },
    { 0x2A4F,   "Scan Interval Window" },
    { 0x2A50,   "PnP ID" },
    { 0x2A51,   "Glucose Feature" },
    { 0x2A52,   "Record Access Control Point" },
    { 0x2A53,   "RSC Measurement" },
    { 0x2A54,   "RSC Feature" },
    { 0x2A55,   "SC Control Point" },
    { 0x2A56,   "Digital" },
    { 0x2A57,   "Digital Output" },
    { 0x2A58,   "Analog" },
    { 0x2A59,   "Analog Output" },
    { 0x2A5A,   "Aggregate" },
    { 0x2A5B,   "CSC Measurement" },
    { 0x2A5C,   "CSC Feature" },
    { 0x2A5D,   "Sensor Location" },
    { 0x2A5E,   "PLX Spot-Check Measurement" },
    { 0x2A5F,   "PLX Continuous Measurement" },
    { 0x2A60,   "PLX Features" },
    { 0x2A62,   "Pulse Oximetry Control Point" },
    { 0x2A63,   "Cycling Power Measurement" },
    { 0x2A64,   "Cycling Power Vector" },
    { 0x2A65,   "Cycling Power Feature" },
    { 0x2A66,   "Cycling Power Control Point" },
    { 0x2A67,   "Location and Speed" },
    { 0x2A68,   "Navigation" },
    { 0x2A69,   "Position Quality" },
    { 0x2A6A,   "LN Feature" },
    { 0x2A6B,   "LN Control Point" },
    { 0x2A6C,   "Elevation" },
    { 0x2A6D,   "Pressure" },
    { 0x2A6E,   "Temperature" },
    { 0x2A6F,   "Humidity" },
    { 0x2A70,   "True Wind Speed" },
    { 0x2A71,   "True Wind Direction" },
    { 0x2A72,   "Apparent Wind Speed" },
    { 0x2A73,   "Apparent Wind Direction" },
    { 0x2A74,   "Gust Factor" },
    { 0x2A75,   "Pollen Concentration" },
    { 0x2A76,   "UV Index" },
    { 0x2A77,   "Irradiance" },
    { 0x2A78,   "Rainfall" },
    { 0x2A79,   "Wind Chill" },
    { 0x2A7A,   "Heat Index" },
    { 0x2A7B,   "Dew Point" },
    { 0x2A7D,   "Descriptor Value Changed" },
    { 0x2A7E,   "Aerobic Heart Rate Lower Limit" },
    { 0x2A7F,   "Aerobic Threshold" },
    { 0x2A80,   "Age" },
    { 0x2A81,   "Anaerobic Heart Rate Lower Limit" },
    { 0x2A82,   "Anaerobic Heart Rate Upper Limit" },
    { 0x2A83,   "Anaerobic Threshold" },
    { 0x2A84,   "Aerobic Heart Rate Upper Limit" },
    { 0x2A85,   "Date of Birth" },
    { 0x2A86,   "Date of Threshold Assessment" },
    { 0x2A87,   "Email Address" },
    { 0x2A88,   "Fat Burn Heart Rate Lower Limit" },
    { 0x2A89,   "Fat Burn Heart Rate Upper Limit" },
    { 0x2A8A,   "First Name" },
    { 0x2A8B,   "Five Zone Heart Rate Limits" },
    { 0x2A8C,   "Gender" },
    { 0x2A8D,   "Heart Rate Max" },
    { 0x2A8E,   "Height" },
    { 0x2A8F,   "Hip Circumference" },
    { 0x2A90,   "Last Name" },
    { 0x2A91,   "Maximum Recommended Heart Rate" },
    { 0x2A92,   "Resting Heart Rate" },
    { 0x2A93,   "Sport Type for Aerobic and Anaerobic Thresholds" },
    { 0x2A94,   "Three Zone Heart Rate Limits" },
    { 0x2A95,   "Two Zone Heart Rate Limits" },
    { 0x2A96,   "VO2 Max" },
    { 0x2A97,   "Waist Circumference" },
    { 0x2A98,   "Weight" },
    { 0x2A99,   "Database Change Increment" },
    { 0x2A9A,   "User Index" },
    { 0x2A9B,   "Body Composition Feature" },
    { 0x2A9C,   "Body Composition Measurement" },
    { 0x2A9D,   "Weight Measurement" },
    { 0x2A9E,   "Weight Scale Feature" },
    { 0x2A9F,   "User Control Point" },
    { 0x2AA0,   "Magnetic Flux Density - 2D" },
    { 0x2AA1,   "Magnetic Flux Density - 3D" },
    { 0x2AA2,   "Language" },
    { 0x2AA3,   "Barometric Pressure Trend" },
    { 0x2AA4,   "Bond Management Control Point" },
    { 0x2AA5,   "Bond Management Feature" },
    { 0x2AA6,   "Central Address Resolution" },
    { 0x2AA7,   "CGM Measurement" },
    { 0x2AA8,   "CGM Feature" },
    { 0x2AA9,   "CGM Status" },
    { 0x2AAA,   "CGM Session Start Time" },
    { 0x2AAB,   "CGM Session Run Time" },
    { 0x2AAC,   "CGM Specific Ops Control Point" },
    { 0x2AAD,   "Indoor Positioning Configuration" },
    { 0x2AAE,   "Latitude" },
    { 0x2AAF,   "Longitude" },
    { 0x2AB0,   "Local North Coordinate" },
    { 0x2AB1,   "Local East Coordinate" },
    { 0x2AB2,   "Floor Number" },
    { 0x2AB3,   "Altitude" },
    { 0x2AB4,   "Uncertainty" },
    { 0x2AB5,   "Location Name" },
    { 0x2AB6,   "URI" },
    { 0x2AB7,   "HTTP Headers" },
    { 0x2AB8,   "HTTP Status Code" },
    { 0x2AB9,   "HTTP Entity Body" },
    { 0x2ABA,   "HTTP Control Point" },
    { 0x2ABB,   "HTTPS Security" },
    { 0x2ABC,   "TDS Control Point" },
    { 0x2ABD,   "OTS Feature" },
    { 0x2ABE,   "Object Name" },
    { 0x2ABF,   "Object Type" },
    { 0x2AC0,   "Object Size" },
    { 0x2AC1,   "Object First-Created" },
    { 0x2AC2,   "Object Last-Modified" },
    { 0x2AC3,   "Object ID" },
    { 0x2AC4,   "Object Properties" },
    { 0x2AC5,   "Object Action Control Point" },
    { 0x2AC6,   "Object List Control Point" },
    { 0x2AC7,   "Object List Filter" },
    { 0x2AC8,   "Object Changed" },
    { 0x2AC9,   "Resolvable Private Address Only" },
    { 0x2ACA,   "Unspecified" },
    { 0x2ACB,   "Directory Listing" },
    { 0x2ACC,   "Fitness Machine Feature" },
    { 0x2ACD,   "Treadmill Data" },
    { 0x2ACE,   "Cross Trainer Data" },
    { 0x2ACF,   "Step Climber Data" },
    { 0x2AD0,   "Stair Climber Data" },
    { 0x2AD1,   "Rower Data" },
    { 0x2AD2,   "Indoor Bike Data" },
    { 0x2AD3,   "Training Status" },
    { 0x2AD4,   "Supported Speed Range" },
    { 0x2AD5,   "Supported Inclination Range" },
    { 0x2AD6,   "Supported Resistance Level Range" },
    { 0x2AD7,   "Supported Heart Rate Range" },
    { 0x2AD8,   "Supported Power Range" },
    { 0x2AD9,   "Fitness Machine Control Point" },
    { 0x2ADA,   "Fitness Machine Status" },
    { 0x2ADB,   "Mesh Provisioning Data In" },
    { 0x2ADC,   "Mesh Provisioning Data Out" },
    { 0x2ADD,   "Mesh Proxy Data In" },
    { 0x2ADE,   "Mesh Proxy Data Out" },
    { 0x2AE0,   "Average Current" },
    { 0x2AE1,   "Average Voltage" },
    { 0x2AE2,   "Boolean" },
    { 0x2AE3,   "Chromatic Distance from Planckian" },
    { 0x2AE4,   "Chromaticity Coordinates" },
    { 0x2AE5,   "Chromaticity in CCT and Duv Values" },
    { 0x2AE6,   "Chromaticity Tolerance" },
    { 0x2AE7,   "CIE 13.3-1995 Color Rendering Index" },
    { 0x2AE8,   "Coefficient" },
    { 0x2AE9,   "Correlated Color Temperature" },
    { 0x2AEA,   "Count 16" },
    { 0x2AEB,   "Count 24" },
    { 0x2AEC,   "Country Code" },
    { 0x2AED,   "Date UTC" },
    { 0x2AEE,   "Electric Current" },
    { 0x2AEF,   "Electric Current Range" },
    { 0x2AF0,   "Electric Current Specification" },
    { 0x2AF1,   "Electric Current Statistics" },
    { 0x2AF2,   "Energy" },
    { 0x2AF3,   "Energy in a Period of Day" },
    { 0x2AF4,   "Event Statistics" },
    { 0x2AF5,   "Fixed String 16" },
    { 0x2AF6,   "Fixed String 24" },
    { 0x2AF7,   "Fixed String 36" },
    { 0x2AF8,   "Fixed String 8" },
    { 0x2AF9,   "Generic Level" },
    { 0x2AFA,   "Global Trade Item Number" },
    { 0x2AFB,   "Illuminance" },
    { 0x2AFC,   "Luminous Efficacy" },
    { 0x2AFD,   "Luminous Energy" },
    { 0x2AFE,   "Luminous Exposure" },
    { 0x2AFF,   "Luminous Flux" },
    { 0x2B00,   "Luminous Flux Range" },
    { 0x2B01,   "Luminous Intensity" },
    { 0x2B02,   "Mass Flow" },
    { 0x2B03,   "Perceived Lightness" },
    { 0x2B04,   "Percentage 8" },
    { 0x2B05,   "Power" },
    { 0x2B06,   "Power Specification" },
    { 0x2B07,   "Relative Runtime in a Current Range" },
    { 0x2B08,   "Relative Runtime in a Generic Level Range" },
    { 0x2B09,   "Relative Value in a Voltage Range" },
    { 0x2B0A,   "Relative Value in an Illuminance Range" },
    { 0x2B0B,   "Relative Value in a Period of Day" },
    { 0x2B0C,   "Relative Value in a Temperature Range" },
    { 0x2B0D,   "Temperature 8" },
    { 0x2B0E,   "Temperature 8 in a Period of Day" },
    { 0x2B0F,   "Temperature 8 Statistics" },
    { 0x2B10,   "Temperature Range" },
    { 0x2B11,   "Temperature Statistics" },
    { 0x2B12,   "Time Decihour 8" },
    { 0x2B13,   "Time Exponential 8" },
    { 0x2B14,   "Time Hour 24" },
    { 0x2B15,   "Time Millisecond 24" },
    { 0x2B16,   "Time Second 16" },
    { 0x2B17,   "Time Second 8" },
    { 0x2B18,   "Voltage" },
    { 0x2B19,   "Voltage Specification" },
    { 0x2B1A,   "Voltage Statistics" },
    { 0x2B1B,   "Volume Flow" },
    { 0x2B1C,   "Chromaticity Coordinate" },
    { 0x2B1D,   "RC Feature" },
    { 0x2B1E,   "RC Settings" },
    { 0x2B1F,   "Reconnection Configuration Control Point" },
    { 0x2B20,   "IDD Status Changed" },
    { 0x2B21,   "IDD Status" },
    { 0x2B22,   "IDD Annunciation Status" },
    { 0x2B23,   "IDD Features" },
    { 0x2B24,   "IDD Status Reader Control Point" },
    { 0x2B25,   "IDD Command Control Point" },
    { 0x2B26,   "IDD Command Data" },
    { 0x2B27,   "IDD Record Access Control Point" },
    { 0x2B28,   "IDD History Data" },
    { 0x2B29,   "Client Supported Features" },
    { 0x2B2A,   "Database Hash" },
    { 0x2B2B,   "BSS Control Point" },
    { 0x2B2C,   "BSS Response" },
    { 0x2B2D,   "Emergency ID" },
    { 0x2B2E,   "Emergency Text" },
    { 0x2B2F,   "ACS Status" },
    { 0x2B30,   "ACS Data In" },
    { 0x2B31,   "ACS Data Out Notify" },
    { 0x2B32,   "ACS Data Out Indicate" },
    { 0x2B33,   "ACS Control Point" },
    { 0x2B34,   "Enhanced Blood Pressure Measurement" },
    { 0x2B35,   "Enhanced Intermediate Cuff Pressure" },
    { 0x2B36,   "Blood Pressure Record" },
    { 0x2B37,   "Registered User" },
    { 0x2B38,   "BR-EDR Handover Data" },
    { 0x2B39,   "Bluetooth SIG Data" },
    { 0x2B3A,   "Server Supported Features" },
    { 0x2B3B,   "Physical Activity Monitor Features" },
    { 0x2B3C,   "General Activity Instantaneous Data" },
    { 0x2B3D,   "General Activity Summary Data" },
    { 0x2B3E,   "CardioRespiratory Activity Instantaneous Data" },
    { 0x2B3F,   "CardioRespiratory Activity Summary Data" },
    { 0x2B40,   "Step Counter Activity Summary Data" },
    { 0x2B41,   "Sleep Activity Instantaneous Data" },
    { 0x2B42,   "Sleep Activity Summary Data" },
    { 0x2B43,   "Physical Activity Monitor Control Point" },
    { 0x2B44,   "Physical Activity Current Session" },
    { 0x2B45,   "Physical Activity Session Descriptor" },
    { 0x2B46,   "Preferred Units" },
    { 0x2B47,   "High Resolution Height" },
    { 0x2B48,   "Middle Name" },
    { 0x2B49,   "Stride Length" },
    { 0x2B4A,   "Handedness" },
    { 0x2B4B,   "Device Wearing Position" },
    { 0x2B4C,   "Four Zone Heart Rate Limits" },
    { 0x2B4D,   "High Intensity Exercise Threshold" },
    { 0x2B4E,   "Activity Goal" },
    { 0x2B4F,   "Sedentary Interval Notification" },
    { 0x2B50,   "Caloric Intake" },
    { 0x2B51,   "TMAP Role" },
    { 0x2B77,   "Audio Input State" },
    { 0x2B78,   "Gain Settings Attribute" },
    { 0x2B79,   "Audio Input Type" },
    { 0x2B7A,   "Audio Input Status" },
    { 0x2B7B,   "Audio Input Control Point" },
    { 0x2B7C,   "Audio Input Description" },
    { 0x2B7D,   "Volume State" },
    { 0x2B7E,   "Volume Control Point" },
    { 0x2B7F,   "Volume Flags" },
    { 0x2B80,   "Volume Offset State" },
    { 0x2B81,   "Audio Location" },
    { 0x2B82,   "Volume Offset Control Point" },
    { 0x2B83,   "Audio Output Description" },
    { 0x2B84,   "Set Identity Resolving Key" },
    { 0x2B85,   "Coordinated Set Size" },
    { 0x2B86,   "Set Member Lock" },
    { 0x2B87,   "Set Member Rank" },
    { 0x2B88,   "Encrypted Data Key Material" },
    { 0x2B89,   "Apparent Energy 32" },
    { 0x2B8A,   "Apparent Power" },
    { 0x2B8B,   "Live Health Observations" },
    { 0x2B8C,   "CO₂ Concentration" },
    { 0x2B8D,   "Cosine of the Angle" },
    { 0x2B8E,   "Device Time Feature" },
    { 0x2B8F,   "Device Time Parameters" },
    { 0x2B90,   "Device Time" },
    { 0x2B91,   "Device Time Control Point" },
    { 0x2B92,   "Time Change Log Data" },
    { 0x2B93,   "Media Player Name" },
    { 0x2B94,   "Media Player Icon Object ID" },
    { 0x2B95,   "Media Player Icon URL" },
    { 0x2B96,   "Track Changed" },
    { 0x2B97,   "Track Title" },
    { 0x2B98,   "Track Duration" },
    { 0x2B99,   "Track Position" },
    { 0x2B9A,   "Playback Speed" },
    { 0x2B9B,   "Seeking Speed" },
    { 0x2B9C,   "Current Track Segments Object ID" },
    { 0x2B9D,   "Current Track Object ID" },
    { 0x2B9E,   "Next Track Object ID" },
    { 0x2B9F,   "Parent Group Object ID" },
    { 0x2BA0,   "Current Group Object ID" },
    { 0x2BA1,   "Playing Order" },
    { 0x2BA2,   "Playing Orders Supported" },
    { 0x2BA3,   "Media State" },
    { 0x2BA4,   "Media Control Point" },
    { 0x2BA5,   "Media Control Point Opcodes Supported" },
    { 0x2BA6,   "Search Results Object ID" },
    { 0x2BA7,   "Search Control Point" },
    { 0x2BA8,   "Energy 32" },
    { 0x2BA9,   "Media Player Icon Object Type" },
    { 0x2BAA,   "Track Segments Object Type" },
    { 0x2BAB,   "Track Object Type" },
    { 0x2BAC,   "Group Object Type" },
    { 0x2BAD,   "Constant Tone Extension Enable" },
    { 0x2BAE,   "Advertising Constant Tone Extension Minimum Length" },
    { 0x2BAF,   "Advertising Constant Tone Extension Minimum Transmit Count" },
    { 0x2BB0,   "Advertising Constant Tone Extension Transmit Duration" },
    { 0x2BB1,   "Advertising Constant Tone Extension Interval" },
    { 0x2BB2,   "Advertising Constant Tone Extension PHY" },
    { 0x2BB3,   "Bearer Provider Name" },
    { 0x2BB4,   "Bearer UCI" },
    { 0x2BB5,   "Bearer Technology" },
    { 0x2BB6,   "Bearer URI Schemes Supported List" },
    { 0x2BB7,   "Bearer Signal Strength" },
    { 0x2BB8,   "Bearer Signal Strength Reporting Interval" },
    { 0x2BB9,   "Bearer List Current Calls" },
    { 0x2BBA,   "Content Control ID" },
    { 0x2BBB,   "Status Flags" },
    { 0x2BBC,   "Incoming Call Target Bearer URI" },
    { 0x2BBD,   "Call State" },
    { 0x2BBE,   "Call Control Point" },
    { 0x2BBF,   "Call Control Point Optional Opcodes" },
    { 0x2BC0,   "Termination Reason" },
    { 0x2BC1,   "Incoming Call" },
    { 0x2BC2,   "Call Friendly Name" },
    { 0x2BC3,   "Mute" },
    { 0x2BC4,   "Sink ASE" },
    { 0x2BC5,   "Source ASE" },
    { 0x2BC6,   "ASE Control Point" },
    { 0x2BC7,   "Broadcast Audio Scan Control Point" },
    { 0x2BC8,   "Broadcast Receive State" },
    { 0x2BC9,   "Sink PAC" },
    { 0x2BCA,   "Sink Audio Locations" },
    { 0x2BCB,   "Source PAC" },
    { 0x2BCC,   "Source Audio Locations" },
    { 0x2BCD,   "Available Audio Contexts" },
    { 0x2BCE,   "Supported Audio Contexts" },
    { 0x2BCF,   "Ammonia Concentration" },
    { 0x2BD0,   "Carbon Monoxide Concentration" },
    { 0x2BD1,   "Methane Concentration" },
    { 0x2BD2,   "Nitrogen Dioxide Concentration" },
    { 0x2BD3,   "Non-Methane Volatile Organic Compounds Concentration" },
    { 0x2BD4,   "Ozone Concentration" },
    { 0x2BD5,   "Particulate Matter - PM1 Concentration" },
    { 0x2BD6,   "Particulate Matter - PM2.5 Concentration" },
    { 0x2BD7,   "Particulate Matter - PM10 Concentration" },
    { 0x2BD8,   "Sulfur Dioxide Concentration" },
    { 0x2BD9,   "Sulfur Hexafluoride Concentration" },
    { 0x2BDA,   "Hearing Aid Features" },
    { 0x2BDB,   "Hearing Aid Preset Control Point" },
    { 0x2BDC,   "Active Preset Index" },
    { 0x2BDD,   "Stored Health Observations" },
    { 0x2BDE,   "Fixed String 64" },
    { 0x2BDF,   "High Temperature" },
    { 0x2BE0,   "High Voltage" },
    { 0x2BE1,   "Light Distribution" },
    { 0x2BE2,   "Light Output" },
    { 0x2BE3,   "Light Source Type" },
    { 0x2BE4,   "Noise" },
    { 0x2BE5,   "Relative Runtime in a Correlated Color Temperature Range" },
    { 0x2BE6,   "Time Second 32" },
    { 0x2BE7,   "VOC Concentration" },
    { 0x2BE8,   "Voltage Frequency" },
    { 0x2BE9,   "Battery Critical Status" },
    { 0x2BEA,   "Battery Health Status" },
    { 0x2BEB,   "Battery Health Information" },
    { 0x2BEC,   "Battery Information" },
    { 0x2BED,   "Battery Level Status" },
    { 0x2BEE,   "Battery Time Status" },
    { 0x2BEF,   "Estimated Service Date" },
    { 0x2BF0,   "Battery Energy Status" },
    { 0x2BF1,   "Observation Schedule Changed" },
    { 0x2BF2,   "Current Elapsed Time" },
    { 0x2BF3,   "Health Sensor Features" },
    { 0x2BF4,   "GHS Control Point" },
    { 0x2BF5,   "LE GATT Security Levels" },
    { 0x2BF6,   "ESL Address" },
    { 0x2BF7,   "AP Sync Key Material" },
    { 0x2BF8,   "ESL Response Key Material" },
    { 0x2BF9,   "ESL Current Absolute Time" },
    { 0x2BFA,   "ESL Display Information" },
    { 0x2BFB,   "ESL Image Information" },
    { 0x2BFC,   "ESL Sensor Information" },
    { 0x2BFD,   "ESL LED Information" },
    { 0x2BFE,   "ESL Control Point" },
    { 0x2BFF,   "UDI for Medical Devices" },
    { 0x2C00,   "GMAP Role" },
    { 0x2C01,   "UGG Features" },
    { 0x2C02,   "UGT Features" },
    { 0x2C03,   "BGS Features" },
    { 0x2C04,   "BGR Features" },
    { 0x2C05,   "Percentage 8 Steps" },
    { 0x2C06,   "Acceleration" },
    { 0x2C07,   "Force" },
    { 0x2C08,   "Linear Position" },
    { 0x2C09,   "Rotational Speed" },
    { 0x2C0A,   "Length" },
    { 0x2C0B,   "Torque" },
    { 0x2C0C,   "IMD Status" },
    { 0x2C0D,   "IMDS Descriptor Value Changed" },
    { 0x2C0E,   "First Use Date" },
    { 0x2C0F,   "Life Cycle Data" },
    { 0x2C10,   "Work Cycle Data" },
    { 0x2C11,   "Service Cycle Data" },
    { 0x2C12,   "IMD Control" },
    { 0x2C13,   "IMD Historical Data" },
    { 0x2C14,   "RAS Features" },
    { 0x2C15,   "Real-time Ranging Data" },
    { 0x2C16,   "On-demand Ranging Data" },
    { 0x2C17,   "RAS Control Point" },
    { 0x2C18,   "Ranging Data Ready" },
    { 0x2C19,   "Ranging Data Overwritten" },
    { 0x2C1A,   "Coordinated Set Name" },
    { 0x2C1B,   "Humidity 8" },
    { 0x2C1C,   "Illuminance 16" },
    { 0x2C1D,   "Acceleration - 3D" },
    { 0x2C1E,   "Precise Acceleration - 3D" },
    { 0x2C1F,   "Acceleration Detection Status" },
    { 0x2C20,   "Door/Window Status" },
    { 0x2C21,   "Pushbutton Status 8" },
    { 0x2C22,   "Contact Status 8" },
    { 0x2C23,   "HID ISO Properties" },
    { 0x2C24,   "LE HID Operation Mode" },
    { 0x2C25,   "Cookware Description" },
    { 0x2C26,   "Recipe Control" },
    { 0x2C27,   "Recipe Parameters" },
    { 0x2C28,   "Cooking Step Status" },
    { 0x2C29,   "Cooking Zone Capabilities" },
    { 0x2C2A,   "Cooking Zone Desired Cooking Conditions" },
    { 0x2C2B,   "Cooking Zone Actual Cooking Conditions" },
    { 0x2C2C,   "Cookware Sensor Data" },
    { 0x2C2D,   "Cookware Sensor Aggregate" },
    { 0x2C2E,   "Cooking Temperature" },
    { 0x2C2F,   "Cooking Zone Perceived Power" },
    { 0x2C30,   "Kitchen Appliance Airflow" },
    /* Members - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/member_uuids.yaml */
    { 0xFC47,   "Shanghai Ingeek Technology Co., Ltd." },
    { 0xFC48,   "Michelin" },
    { 0xFC49,   "Golioth, Inc." },
    { 0xFC4A,   "Shenzhen Shokz Co.,Ltd." },
    { 0xFC4B,   "WinMagic Inc." },
    { 0xFC4C,   "HP Inc." },
    { 0xFC4D,   "Lodestar Technology Inc." },
    { 0xFC4E,   "Lodestar Technology Inc." },
    { 0xFC4F,   "WaveRF, Corp." },
    { 0xFC50,   "Ant Group Co., Ltd." },
    { 0xFC51,   "Ant Group Co., Ltd." },
    { 0xFC52,   "LG Electronics Inc." },
    { 0xFC53,   "LEGIC Identsystems AG" },
    { 0xFC54,   "Shenzhen Yinwang Intelligent Technologies Co., Ltd." },
    { 0xFC55,   "BYD Company Limited" },
    { 0xFC56,   "Google LLC" },
    { 0xFC57,   "Ambient Life Inc." },
    { 0xFC58,   "Shenzhen Minew Technologies Co., Ltd." },
    { 0xFC59,   "Ant Group Co., Ltd." },
    { 0xFC5A,   "LAST LOCK INC." },
    { 0xFC5B,   "Time Location Systems AS" },
    { 0xFC5C,   "PLASTIC RESEARCH AND DEVELOPMENT CORPORATION" },
    { 0xFC5D,   "GP Acoustics International Limited" },
    { 0xFC5E,   "KUBU SMART LIMITED" },
    { 0xFC5F,   "PI-CRYSTAL INC." },
    { 0xFC60,   "Ohme Operations UK Limited" },
    { 0xFC61,   "QIKCONNEX LLC" },
    { 0xFC62,   "SPRiNTUS GmbH" },
    { 0xFC63,   "Volvo Technology AB" },
    { 0xFC64,   "Volvo Technology AB" },
    { 0xFC65,   "Robor Electronics B.V." },
    { 0xFC66,   "Xiaomi Inc." },
    { 0xFC67,   "Guangdong Hengqin Xingtong Technology Co.,ltd." },
    { 0xFC68,   "RIGH, INC." },
    { 0xFC69,   "Harman International" },
    { 0xFC6A,   "Sonos Inc" },
    { 0xFC6B,   "Sonos Inc" },
    { 0xFC6C,   "Powerstick.com" },
    { 0xFC6D,   "MOTIVE TECHNOLOGIES, INC." },
    { 0xFC6E,   "stryker" },
    { 0xFC6F,   "NextSense, Inc." },
    { 0xFC70,   "MOTIVE TECHNOLOGIES, INC." },
    { 0xFC71,   "Hive-Zox International SA" },
    { 0xFC72,   "iodyne, LLC" },
    { 0xFC73,   "Google LLC" },
    { 0xFC74,   "EMBEINT INC" },
    { 0xFC75,   "Xiaomi Inc." },
    { 0xFC76,   "Weber-Stephen Products LLC" },
    { 0xFC77,   "SING SUN TECHNOLOGY (INTERNATIONAL) LIMITED" },
    { 0xFC78,   "DHL" },
    { 0xFC79,   "LG Electronics Inc." },
    { 0xFC7A,   "Outshiny India Private Limited" },
    { 0xFC7B,   "Testo SE & Co. KGaA" },
    { 0xFC7C,   "Motorola Mobility, LLC" },
    { 0xFC7D,   "MML US, Inc" },
    { 0xFC7E,   "Harman International" },
    { 0xFC7F,   "Southco" },
    { 0xFC80,   "TELE System Communications Pte. Ltd." },
    { 0xFC81,   "Axon Enterprise, Inc." },
    { 0xFC82,   "Zwift, Inc." },
    { 0xFC83,   "iHealth Labs, Inc." },
    { 0xFC84,   "NINGBO FOTILE KITCHENWARE CO., LTD." },
    { 0xFC85,   "Zhejiang Huanfu Technology Co., LTD" },
    { 0xFC86,   "Samsara Networks, Inc" },
    { 0xFC87,   "Samsara Networks, Inc" },
    { 0xFC88,   "CCC del Uruguay" },
    { 0xFC89,   "Intel Corporation" },
    { 0xFC8A,   "Intel Corporation" },
    { 0xFC8B,   "Kaspersky Lab Middle East FZ-LLC" },
    { 0xFC8C,   "VusionGroup" },
    { 0xFC8D,   "Caire Inc." },
    { 0xFC8E,   "Blue Iris Labs, Inc." },
    { 0xFC8F,   "Bose Corporation" },
    { 0xFC90,   "Wiliot LTD." },
    { 0xFC91,   "Samsung Electronics Co., Ltd." },
    { 0xFC92,   "Furuno Electric Co., Ltd." },
    { 0xFC93,   "Komatsu Ltd." },
    { 0xFC94,   "Apple Inc." },
    { 0xFC95,   "Hippo Camp Software Ltd." },
    { 0xFC96,   "LEGO System A/S" },
    { 0xFC97,   "Japan Display Inc." },
    { 0xFC98,   "Ruuvi Innovations Ltd." },
    { 0xFC99,   "Badger Meter" },
    { 0xFC9A,   "Koppli AB" },
    { 0xFC9B,   "Merry Electronics (S) Pte Ltd" },
    { 0xFC9D,   "Lenovo (Singapore) Pte Ltd." },
    { 0xFC9E,   "Dell Computer Corporation" },
    { 0xFC9F,   "Delta Development Team, Inc" },
    { 0xFCA0,   "Apple Inc." },
    { 0xFCA1,   "PF SCHWEISSTECHNOLOGIE GMBH" },
    { 0xFCA2,   "Meizu Technology Co., Ltd." },
    { 0xFCA3,   "Gunnebo Aktiebolag" },
    { 0xFCA4,   "HP Inc." },
    { 0xFCA5,   "HAYWARD INDUSTRIES, INC." },
    { 0xFCA6,   "Hubble Network Inc." },
    { 0xFCA7,   "Hubble Network Inc." },
    { 0xFCA8,   "Medtronic Inc." },
    { 0xFCA9,   "Medtronic Inc." },
    { 0xFCAA,   "Spintly, Inc." },
    { 0xFCAB,   "IRISS INC." },
    { 0xFCAC,   "IRISS INC." },
    { 0xFCAD,   "Beijing 99help Safety Technology Co., Ltd" },
    { 0xFCAE,   "Imagine Marketing Limited" },
    { 0xFCAF,   "AltoBeam Inc." },
    { 0xFCB0,   "Ford Motor Company" },
    { 0xFCB1,   "Google LLC" },
    { 0xFCB2,   "Apple Inc." },
    { 0xFCB3,   "SWEEN" },
    { 0xFCB4,   "OMRON HEALTHCARE Co., Ltd." },
    { 0xFCB5,   "OMRON HEALTHCARE Co., Ltd." },
    { 0xFCB6,   "OMRON HEALTHCARE Co., Ltd." },
    { 0xFCB7,   "T-Mobile USA" },
    { 0xFCB8,   "Ribbiot, INC." },
    { 0xFCB9,   "Lumi United Technology Co., Ltd" },
    { 0xFCBA,   "BlueID GmbH" },
    { 0xFCBB,   "SharkNinja Operating LLC" },
    { 0xFCBC,   "Drowsy Digital, Inc." },
    { 0xFCBD,   "Toshiba Corporation" },
    { 0xFCBE,   "Musen Connect, Inc." },
    { 0xFCBF,   "ASSA ABLOY Opening Solutions Sweden AB" },
    { 0xFCC0,   "Xiaomi Inc." },
    { 0xFCC1,   "TIMECODE SYSTEMS LIMITED" },
    { 0xFCC2,   "Qualcomm Technologies, Inc." },
    { 0xFCC3,   "HP Inc." },
    { 0xFCC4,   "OMRON(DALIAN) CO,.LTD." },
    { 0xFCC5,   "OMRON(DALIAN) CO,.LTD." },
    { 0xFCC6,   "Wiliot LTD." },
    { 0xFCC7,   "PB INC." },
    { 0xFCC8,   "Allthenticate, Inc." },
    { 0xFCC9,   "SkyHawke Technologies" },
    { 0xFCCA,   "Cosmed s.r.l." },
    { 0xFCCB,   "TOTO LTD." },
    { 0xFCCC,   "Wi-Fi Easy Connect Specification" },
    { 0xFCCD,   "Marshall Group AB" },
    { 0xFCCE,   "Luna Health, Inc." },
    { 0xFCCF,   "Google LLC" },
    { 0xFCD0,   "Laerdal Medical AS" },
    { 0xFCD1,   "Shenzhen Benwei Media Co.,Ltd." },
    { 0xFCD2,   "Allterco Robotics ltd" },
    { 0xFCD3,   "Fisher & Paykel Healthcare" },
    { 0xFCD4,   "OMRON HEALTHCARE" },
    { 0xFCD5,   "Nortek Security & Control" },
    { 0xFCD6,   "SWISSINNO SOLUTIONS AG" },
    { 0xFCD7,   "PowerPal Pty Ltd" },
    { 0xFCD8,   "Appex Factory S.L." },
    { 0xFCD9,   "Huso, INC" },
    { 0xFCDA,   "Draeger" },
    { 0xFCDB,   "aconno GmbH" },
    { 0xFCDC,   "Amazon.com Services, LLC" },
    { 0xFCDD,   "Mobilaris AB" },
    { 0xFCDE,   "ARCTOP, INC." },
    { 0xFCDF,   "NIO USA, Inc." },
    { 0xFCE0,   "Akciju sabiedriba \"SAF TEHNIKA\"" },
    { 0xFCE1,   "Sony Group Corporation" },
    { 0xFCE2,   "Baracoda Daily Healthtech" },
    { 0xFCE3,   "Smith & Nephew Medical Limited" },
    { 0xFCE4,   "Samsara Networks, Inc" },
    { 0xFCE5,   "Samsara Networks, Inc" },
    { 0xFCE6,   "Guard RFID Solutions Inc." },
    { 0xFCE7,   "TKH Security B.V." },
    { 0xFCE8,   "ITT Industries" },
    { 0xFCE9,   "MindRhythm, Inc." },
    { 0xFCEA,   "Chess Wise B.V." },
    { 0xFCEB,   "Avi-On" },
    { 0xFCEC,   "Griffwerk GmbH" },
    { 0xFCED,   "Workaround Gmbh" },
    { 0xFCEE,   "Velentium, LLC" },
    { 0xFCEF,   "Divesoft s.r.o." },
    { 0xFCF0,   "Security Enhancement Systems, LLC" },
    { 0xFCF1,   "Google LLC" },
    { 0xFCF2,   "Bitwards Oy" },
    { 0xFCF3,   "Armatura LLC" },
    { 0xFCF4,   "Allegion" },
    { 0xFCF5,   "Trident Communication Technology, LLC" },
    { 0xFCF6,   "The Linux Foundation" },
    { 0xFCF7,   "Honor Device Co., Ltd." },
    { 0xFCF8,   "Honor Device Co., Ltd." },
    { 0xFCF9,   "Leupold & Stevens, Inc." },
    { 0xFCFA,   "Leupold & Stevens, Inc." },
    { 0xFCFB,   "Shenzhen Benwei Media Co., Ltd." },
    { 0xFCFC,   "Barrot Technology Co.,Ltd." },
    { 0xFCFD,   "Barrot Technology Co.,Ltd." },
    { 0xFCFE,   "Sonova Consumer Hearing GmbH" },
    { 0xFCFF,   "701x" },
    { 0xFD00,   "FUTEK Advanced Sensor Technology, Inc." },
    { 0xFD01,   "Sanvita Medical Corporation" },
    { 0xFD02,   "LEGO System A/S" },
    { 0xFD03,   "Quuppa Oy" },
    { 0xFD04,   "Shure Inc." },
    { 0xFD05,   "Qualcomm Technologies, Inc." },
    { 0xFD06,   "RACE-AI LLC" },
    { 0xFD07,   "Swedlock AB" },
    { 0xFD08,   "Bull Group Incorporated Company" },
    { 0xFD09,   "Cousins and Sears LLC" },
    { 0xFD0A,   "Luminostics, Inc." },
    { 0xFD0B,   "Luminostics, Inc." },
    { 0xFD0C,   "OSM HK Limited" },
    { 0xFD0D,   "Blecon Ltd" },
    { 0xFD0E,   "HerdDogg, Inc" },
    { 0xFD0F,   "AEON MOTOR CO.,LTD." },
    { 0xFD10,   "AEON MOTOR CO.,LTD." },
    { 0xFD11,   "AEON MOTOR CO.,LTD." },
    { 0xFD12,   "AEON MOTOR CO.,LTD." },
    { 0xFD13,   "BRG Sports, Inc." },
    { 0xFD14,   "BRG Sports, Inc." },
    { 0xFD15,   "Panasonic Corporation" },
    { 0xFD16,   "Sensitech, Inc." },
    { 0xFD17,   "LEGIC Identsystems AG" },
    { 0xFD18,   "LEGIC Identsystems AG" },
    { 0xFD19,   "Smith & Nephew Medical Limited" },
    { 0xFD1A,   "CSIRO" },
    { 0xFD1B,   "Helios Sports, Inc." },
    { 0xFD1C,   "Brady Worldwide Inc." },
    { 0xFD1D,   "Samsung Electronics Co., Ltd" },
    { 0xFD1E,   "Plume Design Inc." },
    { 0xFD1F,   "3M" },
    { 0xFD20,   "GN Hearing A/S" },
    { 0xFD21,   "Huawei Technologies Co., Ltd." },
    { 0xFD22,   "Huawei Technologies Co., Ltd." },
    { 0xFD23,   "DOM Sicherheitstechnik GmbH & Co. KG" },
    { 0xFD24,   "GD Midea Air-Conditioning Equipment Co., Ltd." },
    { 0xFD25,   "GD Midea Air-Conditioning Equipment Co., Ltd." },
    { 0xFD26,   "Novo Nordisk A/S" },
    { 0xFD27,   "Integrated Illumination Systems, Inc." },
    { 0xFD28,   "Julius Blum GmbH" },
    { 0xFD29,   "Asahi Kasei Corporation" },
    { 0xFD2A,   "Sony Corporation" },
    { 0xFD2B,   "The Access Technologies" },
    { 0xFD2C,   "The Access Technologies" },
    { 0xFD2D,   "Xiaomi Inc." },
    { 0xFD2E,   "Bitstrata Systems Inc." },
    { 0xFD2F,   "Bitstrata Systems Inc." },
    { 0xFD30,   "Sesam Solutions BV" },
    { 0xFD31,   "LG Electronics Inc." },
    { 0xFD32,   "Gemalto Holding BV" },
    { 0xFD33,   "DashLogic, Inc." },
    { 0xFD34,   "Aerosens LLC." },
    { 0xFD35,   "Transsion Holdings Limited" },
    { 0xFD36,   "Google LLC" },
    { 0xFD37,   "TireCheck GmbH" },
    { 0xFD38,   "Danfoss A/S" },
    { 0xFD39,   "PREDIKTAS" },
    { 0xFD3A,   "Verkada Inc." },
    { 0xFD3B,   "Verkada Inc." },
    { 0xFD3C,   "Redline Communications Inc." },
    { 0xFD3D,   "Woan Technology (Shenzhen) Co., Ltd." },
    { 0xFD3E,   "Pure Watercraft, inc." },
    { 0xFD3F,   "Cognosos, Inc" },
    { 0xFD40,   "Beflex Inc." },
    { 0xFD41,   "Amazon Lab126" },
    { 0xFD42,   "Globe (Jiangsu) Co.,Ltd" },
    { 0xFD43,   "Apple Inc." },
    { 0xFD44,   "Apple Inc." },
    { 0xFD45,   "GB Solution co.,Ltd" },
    { 0xFD46,   "Lemco IKE" },
    { 0xFD47,   "Liberty Global Inc." },
    { 0xFD48,   "Geberit International AG" },
    { 0xFD49,   "Panasonic Corporation" },
    { 0xFD4A,   "Sigma Elektro GmbH" },
    { 0xFD4B,   "Samsung Electronics Co., Ltd." },
    { 0xFD4C,   "Adolf Wuerth GmbH & Co KG" },
    { 0xFD4D,   "70mai Co.,Ltd." },
    { 0xFD4E,   "70mai Co.,Ltd." },
    { 0xFD4F,   "SONITOR TECHNOLOGIES AS" },
    { 0xFD50,   "Hangzhou Tuya Information  Technology Co., Ltd" },
    { 0xFD51,   "UTC Fire and Security" },
    { 0xFD52,   "UTC Fire and Security" },
    { 0xFD53,   "PCI Private Limited" },
    { 0xFD54,   "Qingdao Haier Technology Co., Ltd." },
    { 0xFD55,   "Braveheart Wireless, Inc." },
    { 0xFD56,   "Resmed Ltd" },
    { 0xFD57,   "Volvo Car Corporation" },
    { 0xFD58,   "Volvo Car Corporation" },
    { 0xFD59,   "Samsung Electronics Co., Ltd." },
    { 0xFD5A,   "Samsung Electronics Co., Ltd." },
    { 0xFD5B,   "V2SOFT INC." },
    { 0xFD5C,   "React Mobile" },
    { 0xFD5D,   "maxon motor ltd." },
    { 0xFD5E,   "Tapkey GmbH" },
    { 0xFD5F,   "Meta Platforms Technologies, LLC" },
    { 0xFD60,   "Sercomm Corporation" },
    { 0xFD61,   "Arendi AG" },
    { 0xFD62,   "Google LLC" },
    { 0xFD63,   "Google LLC" },
    { 0xFD64,   "INRIA" },
    { 0xFD65,   "Razer Inc." },
    { 0xFD66,   "Zebra Technologies Corporation" },
    { 0xFD67,   "Montblanc Simplo GmbH" },
    { 0xFD68,   "Ubique Innovation AG" },
    { 0xFD69,   "Samsung Electronics Co., Ltd" },
    { 0xFD6A,   "Emerson" },
    { 0xFD6B,   "rapitag GmbH" },
    { 0xFD6C,   "Samsung Electronics Co., Ltd." },
    { 0xFD6D,   "Sigma Elektro GmbH" },
    { 0xFD6E,   "Polidea sp. z o.o." },
    { 0xFD6F,   "Apple, Inc." },
    { 0xFD70,   "GuangDong Oppo Mobile Telecommunications Corp., Ltd" },
    { 0xFD71,   "GN Hearing A/S" },
    { 0xFD72,   "Logitech International SA" },
    { 0xFD73,   "BRControls Products BV" },
    { 0xFD74,   "BRControls Products BV" },
    { 0xFD75,   "Insulet Corporation" },
    { 0xFD76,   "Insulet Corporation" },
    { 0xFD77,   "Withings" },
    { 0xFD78,   "Withings" },
    { 0xFD79,   "Withings" },
    { 0xFD7A,   "Withings" },
    { 0xFD7B,   "WYZE LABS, INC." },
    { 0xFD7C,   "Toshiba Information Systems(Japan) Corporation" },
    { 0xFD7D,   "Center for Advanced Research Wernher Von Braun" },
    { 0xFD7E,   "Samsung Electronics Co., Ltd." },
    { 0xFD7F,   "Husqvarna AB" },
    { 0xFD80,   "Phindex Technologies, Inc" },
    { 0xFD81,   "CANDY HOUSE, Inc." },
    { 0xFD82,   "Sony Corporation" },
    { 0xFD83,   "iNFORM Technology GmbH" },
    { 0xFD84,   "Tile, Inc." },
    { 0xFD85,   "Husqvarna AB" },
    { 0xFD86,   "Abbott" },
    { 0xFD87,   "Google LLC" },
    { 0xFD88,   "Urbanminded LTD" },
    { 0xFD89,   "Urbanminded LTD" },
    { 0xFD8A,   "Signify Netherlands B.V." },
    { 0xFD8B,   "Jigowatts Inc." },
    { 0xFD8C,   "Google LLC" },
    { 0xFD8D,   "quip NYC Inc." },
    { 0xFD8E,   "Motorola Solutions" },
    { 0xFD90,   "Guangzhou SuperSound Information Technology Co.,Ltd" },
    { 0xFD91,   "Groove X, Inc." },
    { 0xFD92,   "Qualcomm Technologies International, Ltd. (QTIL)" },
    { 0xFD93,   "Bayerische Motoren Werke AG" },
    { 0xFD94,   "Hewlett Packard Enterprise" },
    { 0xFD95,   "Rigado" },
    { 0xFD96,   "Google LLC" },
    { 0xFD97,   "June Life, Inc." },
    { 0xFD98,   "Disney Worldwide Services, Inc." },
    { 0xFD99,   "ABB Oy" },
    { 0xFD9A,   "Huawei Technologies Co., Ltd." },
    { 0xFD9B,   "Huawei Technologies Co., Ltd." },
    { 0xFD9C,   "Huawei Technologies Co., Ltd." },
    { 0xFD9D,   "Gastec Corporation" },
    { 0xFD9E,   "The Coca-Cola Company" },
    { 0xFD9F,   "VitalTech Affiliates LLC" },
    { 0xFDA0,   "Secugen Corporation" },
    { 0xFDA1,   "Groove X, Inc" },
    { 0xFDA2,   "Groove X, Inc" },
    { 0xFDA3,   "Inseego Corp." },
    { 0xFDA4,   "Inseego Corp." },
    { 0xFDA5,   "Neurostim OAB, Inc." },
    { 0xFDA6,   "WWZN Information Technology Company Limited" },
    { 0xFDA7,   "WWZN Information Technology Company Limited" },
    { 0xFDA8,   "PSA Peugeot Citroën" },
    { 0xFDA9,   "Rhombus Systems, Inc." },
    { 0xFDAA,   "Xiaomi Inc." },
    { 0xFDAB,   "Xiaomi Inc." },
    { 0xFDAC,   "Tentacle Sync GmbH" },
    { 0xFDAD,   "Houwa System Design, k.k." },
    { 0xFDAE,   "Houwa System Design, k.k." },
    { 0xFDAF,   "Wiliot LTD" },
    { 0xFDB0,   "Oura Health Ltd" },
    { 0xFDB1,   "Oura Health Ltd" },
    { 0xFDB2,   "Portable Multimedia Ltd" },
    { 0xFDB3,   "Audiodo AB" },
    { 0xFDB4,   "HP Inc" },
    { 0xFDB5,   "ECSG" },
    { 0xFDB6,   "GWA Hygiene GmbH" },
    { 0xFDB7,   "LivaNova USA Inc." },
    { 0xFDB8,   "LivaNova USA Inc." },
    { 0xFDBB,   "Profoto" },
    { 0xFDBC,   "Emerson" },
    { 0xFDBD,   "Clover Network, Inc." },
    { 0xFDBE,   "California Things Inc." },
    { 0xFDBF,   "California Things Inc." },
    { 0xFDC0,   "Hunter Douglas" },
    { 0xFDC1,   "Hunter Douglas" },
    { 0xFDC2,   "Baidu Online Network Technology (Beijing) Co., Ltd" },
    { 0xFDC3,   "Baidu Online Network Technology (Beijing) Co., Ltd" },
    { 0xFDC4,   "Simavita (Aust) Pty Ltd" },
    { 0xFDC5,   "Automatic Labs" },
    { 0xFDC6,   "Eli Lilly and Company" },
    { 0xFDC7,   "Eli Lilly and Company" },
    { 0xFDC8,   "Hach – Danaher" },
    { 0xFDC9,   "Busch-Jaeger Elektro GmbH" },
    { 0xFDCA,   "Fortin Electronic Systems" },
    { 0xFDCB,   "Meggitt SA" },
    { 0xFDCC,   "Shoof Technologies" },
    { 0xFDCD,   "Qingping Technology (Beijing) Co., Ltd." },
    { 0xFDCE,   "SENNHEISER electronic GmbH & Co. KG" },
    { 0xFDCF,   "Nalu Medical, Inc" },
    { 0xFDD0,   "Huawei Technologies Co., Ltd" },
    { 0xFDD1,   "Huawei Technologies Co., Ltd" },
    { 0xFDD2,   "Bose Corporation" },
    { 0xFDD3,   "FUBA Automotive Electronics GmbH" },
    { 0xFDD4,   "LX Solutions Pty Limited" },
    { 0xFDD5,   "Brompton Bicycle Ltd" },
    { 0xFDD6,   "Ministry of Supply" },
    { 0xFDD7,   "Copeland Cold Chain LP" },
    { 0xFDD8,   "Jiangsu Teranovo Tech Co., Ltd." },
    { 0xFDD9,   "Jiangsu Teranovo Tech Co., Ltd." },
    { 0xFDDA,   "MHCS" },
    { 0xFDDB,   "Samsung Electronics Co., Ltd." },
    { 0xFDDC,   "4iiii Innovations Inc." },
    { 0xFDDD,   "Arch Systems Inc" },
    { 0xFDDE,   "Noodle Technology Inc." },
    { 0xFDDF,   "Harman International" },
    { 0xFDE0,   "John Deere" },
    { 0xFDE1,   "Fortin Electronic Systems" },
    { 0xFDE2,   "Google LLC" },
    { 0xFDE3,   "Abbott Diabetes Care" },
    { 0xFDE4,   "JUUL Labs, Inc." },
    { 0xFDE5,   "SMK Corporation" },
    { 0xFDE6,   "Intelletto Technologies Inc" },
    { 0xFDE7,   "SECOM Co., LTD" },
    { 0xFDE8,   "Robert Bosch GmbH" },
    { 0xFDE9,   "Spacesaver Corporation" },
    { 0xFDEA,   "SeeScan, Inc" },
    { 0xFDEB,   "Syntronix Corporation" },
    { 0xFDEC,   "Mannkind Corporation" },
    { 0xFDED,   "Pole Star" },
    { 0xFDEE,   "Huawei Technologies Co., Ltd." },
    { 0xFDEF,   "ART AND PROGRAM, INC." },
    { 0xFDF0,   "Google LLC" },
    { 0xFDF1,   "LAMPLIGHT Co.,Ltd" },
    { 0xFDF2,   "AMICCOM Electronics Corporation" },
    { 0xFDF3,   "Amersports" },
    { 0xFDF4,   "O. E. M. Controls, Inc." },
    { 0xFDF5,   "Milwaukee Electric Tools" },
    { 0xFDF6,   "AIAIAI ApS" },
    { 0xFDF7,   "HP Inc." },
    { 0xFDF8,   "Onvocal" },
    { 0xFDF9,   "INIA" },
    { 0xFDFA,   "Tandem Diabetes Care" },
    { 0xFDFB,   "Tandem Diabetes Care" },
    { 0xFDFC,   "Optrel AG" },
    { 0xFDFD,   "RecursiveSoft Inc." },
    { 0xFDFE,   "ADHERIUM(NZ) LIMITED" },
    { 0xFDFF,   "OSRAM GmbH" },
    { 0xFE00,   "Amazon.com Services, Inc." },
    { 0xFE01,   "Duracell U.S. Operations Inc." },
    { 0xFE02,   "Robert Bosch GmbH" },
    { 0xFE03,   "Amazon.com Services, Inc." },
    { 0xFE04,   "Motorola Solutions, Inc." },
    { 0xFE05,   "CORE Transport Technologies NZ Limited" },
    { 0xFE06,   "Qualcomm Technologies, Inc." },
    { 0xFE07,   "Sonos, Inc." },
    { 0xFE08,   "Microsoft" },
    { 0xFE09,   "Pillsy, Inc." },
    { 0xFE0A,   "ruwido austria gmbh" },
    { 0xFE0B,   "ruwido austria gmbh" },
    { 0xFE0C,   "Procter & Gamble" },
    { 0xFE0D,   "Procter & Gamble" },
    { 0xFE0E,   "Setec Pty Ltd" },
    { 0xFE0F,   "Signify Netherlands B.V. (formerly Philips Lighting B.V.)" },
    { 0xFE10,   "LAPIS Technology Co., Ltd." },
    { 0xFE11,   "GMC-I Messtechnik GmbH" },
    { 0xFE12,   "M-Way Solutions GmbH" },
    { 0xFE13,   "Apple Inc." },
    { 0xFE14,   "Flextronics International USA Inc." },
    { 0xFE15,   "Amazon.com Services, Inc.." },
    { 0xFE16,   "Footmarks, Inc." },
    { 0xFE17,   "Telit Wireless Solutions GmbH" },
    { 0xFE18,   "Runtime, Inc." },
    { 0xFE19,   "Google LLC" },
    { 0xFE1A,   "Tyto Life LLC" },
    { 0xFE1B,   "Tyto Life LLC" },
    { 0xFE1C,   "NetMedia, Inc." },
    { 0xFE1D,   "Illuminati Instrument Corporation" },
    { 0xFE1E,   "LAMPLIGHT Co., Ltd." },
    { 0xFE1F,   "Garmin International, Inc." },
    { 0xFE20,   "Emerson" },
    { 0xFE21,   "Bose Corporation" },
    { 0xFE22,   "Zoll Medical Corporation" },
    { 0xFE23,   "Zoll Medical Corporation" },
    { 0xFE24,   "August Home Inc" },
    { 0xFE25,   "Apple, Inc." },
    { 0xFE26,   "Google LLC" },
    { 0xFE27,   "Google LLC" },
    { 0xFE28,   "Ayla Networks" },
    { 0xFE29,   "Gibson Innovations" },
    { 0xFE2A,   "DaisyWorks, Inc." },
    { 0xFE2B,   "ITT Industries" },
    { 0xFE2C,   "Google LLC" },
    { 0xFE2D,   "LAMPLIGHT Co., Ltd." },
    { 0xFE2E,   "ERi,Inc." },
    { 0xFE2F,   "CRESCO Wireless, Inc" },
    { 0xFE30,   "Volkswagen AG" },
    { 0xFE31,   "Volkswagen AG" },
    { 0xFE32,   "Pro-Mark, Inc." },
    { 0xFE33,   "CHIPOLO d.o.o." },
    { 0xFE34,   "SmallLoop LLC" },
    { 0xFE35,   "HUAWEI Technologies Co., Ltd" },
    { 0xFE36,   "HUAWEI Technologies Co., Ltd" },
    { 0xFE39,   "TTS Tooltechnic Systems AG & Co. KG" },
    { 0xFE3A,   "TTS Tooltechnic Systems AG & Co. KG" },
    { 0xFE3B,   "Dolby Laboratories" },
    { 0xFE3C,   "alibaba" },
    { 0xFE3D,   "BD Medical" },
    { 0xFE3E,   "BD Medical" },
    { 0xFE3F,   "Friday Labs Limited" },
    { 0xFE40,   "Inugo Systems Limited" },
    { 0xFE41,   "Inugo Systems Limited" },
    { 0xFE42,   "Nets A/S" },
    { 0xFE43,   "Andreas Stihl AG & Co. KG" },
    { 0xFE44,   "SK Telecom" },
    { 0xFE45,   "Snapchat Inc" },
    { 0xFE46,   "B&O Play A/S" },
    { 0xFE47,   "General Motors" },
    { 0xFE48,   "General Motors" },
    { 0xFE49,   "SenionLab AB" },
    { 0xFE4A,   "OMRON HEALTHCARE Co., Ltd." },
    { 0xFE4B,   "Signify Netherlands B.V. (formerly Philips Lighting B.V.)" },
    { 0xFE4C,   "Volkswagen AG" },
    { 0xFE4D,   "Casambi Technologies Oy" },
    { 0xFE4E,   "NTT docomo" },
    { 0xFE4F,   "Molekule, Inc." },
    { 0xFE50,   "Google LLC" },
    { 0xFE51,   "SRAM" },
    { 0xFE52,   "SetPoint Medical" },
    { 0xFE53,   "3M" },
    { 0xFE54,   "Motiv, Inc." },
    { 0xFE55,   "Google LLC" },
    { 0xFE56,   "Google LLC" },
    { 0xFE57,   "Dotted Labs" },
    { 0xFE58,   "Nordic Semiconductor ASA" },
    { 0xFE59,   "Nordic Semiconductor ASA" },
    { 0xFE5A,   "Cronologics Corporation" },
    { 0xFE5B,   "GT-tronics HK Ltd" },
    { 0xFE5C,   "million hunters GmbH" },
    { 0xFE5D,   "Grundfos A/S" },
    { 0xFE5E,   "Plastc Corporation" },
    { 0xFE5F,   "Eyefi, Inc." },
    { 0xFE60,   "Lierda Science & Technology Group Co., Ltd." },
    { 0xFE61,   "Logitech International SA" },
    { 0xFE62,   "Indagem Tech LLC" },
    { 0xFE63,   "Connected Yard, Inc." },
    { 0xFE64,   "Siemens AG" },
    { 0xFE65,   "CHIPOLO d.o.o." },
    { 0xFE66,   "Intel Corporation" },
    { 0xFE67,   "Lab Sensor Solutions" },
    { 0xFE68,   "Capsle Technologies Inc." },
    { 0xFE69,   "Capsle Technologies Inc." },
    { 0xFE6A,   "Kontakt Micro-Location Sp. z o.o." },
    { 0xFE6B,   "TASER International, Inc." },
    { 0xFE6C,   "TASER International, Inc." },
    { 0xFE6D,   "The University of Tokyo" },
    { 0xFE6E,   "The University of Tokyo" },
    { 0xFE6F,   "LINE Corporation" },
    { 0xFE70,   "Beijing Jingdong Century Trading Co., Ltd." },
    { 0xFE71,   "Plume Design Inc" },
    { 0xFE72,   "Abbott (formerly St. Jude Medical, Inc.)" },
    { 0xFE73,   "Abbott (formerly St. Jude Medical, Inc.)" },
    { 0xFE74,   "unwire" },
    { 0xFE75,   "TangoMe" },
    { 0xFE76,   "TangoMe" },
    { 0xFE77,   "Hewlett-Packard Company" },
    { 0xFE78,   "Hewlett-Packard Company" },
    { 0xFE79,   "Zebra Technologies" },
    { 0xFE7A,   "Bragi GmbH" },
    { 0xFE7B,   "Orion Labs, Inc." },
    { 0xFE7C,   "Telit Wireless Solutions (Formerly Stollmann E+V GmbH)" },
    { 0xFE7D,   "Aterica Health Inc." },
    { 0xFE7E,   "Awear Solutions Ltd" },
    { 0xFE7F,   "Doppler Lab" },
    { 0xFE80,   "Doppler Lab" },
    { 0xFE81,   "Medtronic Inc." },
    { 0xFE82,   "Medtronic Inc." },
    { 0xFE83,   "Blue Bite" },
    { 0xFE84,   "RF Digital Corp" },
    { 0xFE85,   "RF Digital Corp" },
    { 0xFE86,   "HUAWEI Technologies Co., Ltd" },
    { 0xFE87,   "Qingdao Yeelink Information Technology Co., Ltd. ( 青岛亿联客信息技术有限公司 )" },
    { 0xFE88,   "SALTO SYSTEMS S.L." },
    { 0xFE89,   "B&O Play A/S" },
    { 0xFE8A,   "Apple, Inc." },
    { 0xFE8B,   "Apple, Inc." },
    { 0xFE8C,   "TRON Forum" },
    { 0xFE8D,   "Interaxon Inc." },
    { 0xFE8E,   "ARM Ltd" },
    { 0xFE8F,   "CSR" },
    { 0xFE90,   "JUMA" },
    { 0xFE91,   "Shanghai Imilab Technology Co.,Ltd" },
    { 0xFE92,   "Jarden Safety & Security" },
    { 0xFE93,   "OttoQ In" },
    { 0xFE94,   "OttoQ In" },
    { 0xFE95,   "Xiaomi Inc." },
    { 0xFE96,   "Tesla Motors Inc." },
    { 0xFE97,   "Tesla Motors Inc." },
    { 0xFE98,   "Currant Inc" },
    { 0xFE99,   "Currant Inc" },
    { 0xFE9A,   "Estimote" },
    { 0xFE9B,   "Samsara Networks, Inc" },
    { 0xFE9C,   "GSI Laboratories, Inc." },
    { 0xFE9D,   "Mobiquity Networks Inc" },
    { 0xFE9E,   "Renesas Design Netherlands B.V." },
    { 0xFE9F,   "Google LLC" },
    { 0xFEA0,   "Google LLC" },
    { 0xFEA3,   "ITT Industries" },
    { 0xFEA4,   "Paxton Access Ltd" },
    { 0xFEA5,   "GoPro, Inc." },
    { 0xFEA6,   "GoPro, Inc." },
    { 0xFEA7,   "UTC Fire and Security" },
    { 0xFEA8,   "Savant Systems LLC" },
    { 0xFEA9,   "Savant Systems LLC" },
    { 0xFEAA,   "Google LLC" },
    { 0xFEAB,   "Nokia" },
    { 0xFEAC,   "Nokia" },
    { 0xFEAD,   "Nokia" },
    { 0xFEAE,   "Nokia" },
    { 0xFEAF,   "Nest Labs Inc" },
    { 0xFEB0,   "Nest Labs Inc" },
    { 0xFEB1,   "Electronics Tomorrow Limited" },
    { 0xFEB2,   "Microsoft Corporation" },
    { 0xFEB3,   "Taobao" },
    { 0xFEB4,   "WiSilica Inc." },
    { 0xFEB5,   "WiSilica Inc." },
    { 0xFEB6,   "Vencer Co., Ltd" },
    { 0xFEB7,   "Meta Platforms, Inc." },
    { 0xFEB8,   "Meta Platforms, Inc." },
    { 0xFEB9,   "LG Electronics" },
    { 0xFEBA,   "Tencent Holdings Limited" },
    { 0xFEBB,   "adafruit industries" },
    { 0xFEBC,   "Dexcom Inc" },
    { 0xFEBD,   "Clover Network, Inc" },
    { 0xFEBE,   "Bose Corporation" },
    { 0xFEBF,   "Nod, Inc." },
    { 0xFEC0,   "KDDI Corporation" },
    { 0xFEC1,   "KDDI Corporation" },
    { 0xFEC2,   "Blue Spark Technologies, Inc." },
    { 0xFEC3,   "360fly, Inc." },
    { 0xFEC4,   "PLUS Location Systems" },
    { 0xFEC5,   "Realtek Semiconductor Corp." },
    { 0xFEC6,   "Kocomojo, LLC" },
    { 0xFEC7,   "Apple, Inc." },
    { 0xFEC8,   "Apple, Inc." },
    { 0xFEC9,   "Apple, Inc." },
    { 0xFECA,   "Apple, Inc." },
    { 0xFECB,   "Apple, Inc." },
    { 0xFECC,   "Apple, Inc." },
    { 0xFECD,   "Apple, Inc." },
    { 0xFECE,   "Apple, Inc." },
    { 0xFECF,   "Apple, Inc." },
    { 0xFED0,   "Apple, Inc." },
    { 0xFED1,   "Apple, Inc." },
    { 0xFED2,   "Apple, Inc." },
    { 0xFED3,   "Apple, Inc." },
    { 0xFED4,   "Apple, Inc." },
    { 0xFED5,   "Plantronics Inc." },
    { 0xFED6,   "Broadcom" },
    { 0xFED7,   "Broadcom" },
    { 0xFED8,   "Google LLC" },
    { 0xFED9,   "Pebble Technology Corporation" },
    { 0xFEDA,   "ISSC Technologies Corp." },
    { 0xFEDB,   "Perka, Inc." },
    { 0xFEDC,   "Jawbone" },
    { 0xFEDD,   "Jawbone" },
    { 0xFEDE,   "Coin, Inc." },
    { 0xFEE0,   "Anhui Huami Information Technology Co., Ltd." },
    { 0xFEE1,   "Anhui Huami Information Technology Co., Ltd." },
    { 0xFEE2,   "Anki, Inc." },
    { 0xFEE3,   "Anki, Inc." },
    { 0xFEE4,   "Nordic Semiconductor ASA" },
    { 0xFEE5,   "Nordic Semiconductor ASA" },
    { 0xFEE6,   "Silvair, Inc." },
    { 0xFEE7,   "Tencent Holdings Limited." },
    { 0xFEE8,   "Quintic Corp." },
    { 0xFEE9,   "Quintic Corp." },
    { 0xFEEA,   "Swirl Networks, Inc." },
    { 0xFEEB,   "Swirl Networks, Inc." },
    { 0xFEEC,   "Tile, Inc." },
    { 0xFEED,   "Tile, Inc." },
    { 0xFEEE,   "Polar Electro Oy" },
    { 0xFEEF,   "Polar Electro Oy" },
    { 0xFEF0,   "Intel" },
    { 0xFEF1,   "CSR" },
    { 0xFEF2,   "CSR" },
    { 0xFEF3,   "Google LLC" },
    { 0xFEF4,   "Google LLC" },
    { 0xFEF5,   "Dialog Semiconductor GmbH" },
    { 0xFEF6,   "Wicentric, Inc." },
    { 0xFEF7,   "Aplix Corporation" },
    { 0xFEF8,   "Aplix Corporation" },
    { 0xFEF9,   "PayPal, Inc." },
    { 0xFEFA,   "PayPal, Inc." },
    { 0xFEFB,   "Telit Wireless Solutions (Formerly Stollmann E+V GmbH)" },
    { 0xFEFC,   "Gimbal, Inc." },
    { 0xFEFD,   "Gimbal, Inc." },
    { 0xFEFE,   "GN Hearing A/S" },
    { 0xFEFF,   "GN Netcom" },
    /* SDO - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/sdo_uuids.yaml */
    { 0xFFEF,   "Wi-Fi Direct Specification" },
    { 0xFFF0,   "Public Key Open Credential (PKOC)" },
    { 0xFFF1,   "ICCE Digital Key" },
    { 0xFFF2,   "Aliro" },
    { 0xFFF3,   "FiRa Consortium" },
    { 0xFFF4,   "FiRa Consortium" },
    { 0xFFF5,   "Car Connectivity Consortium, LLC" },
    { 0xFFF6,   "Matter Profile ID" },
    { 0xFFF7,   "Zigbee Direct" },
    { 0xFFF8,   "Mopria Alliance BLE" },
    { 0xFFF9,   "FIDO2 secure client-to-authenticator transport" },
    { 0xFFFA,   "ASTM Remote ID" },
    { 0xFFFB,   "Direct Thread Commissioning" },
    { 0xFFFC,   "Wireless Power Transfer (WPT)" },
    { 0xFFFD,   "Universal Second Factor Authenticator" },
    { 0xFFFE,   "Wireless Power Transfer" },
    {      0,   NULL }
};
value_string_ext bluetooth_uuid_vals_ext = VALUE_STRING_EXT_INIT(bluetooth_uuid_vals);

/* Taken from https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/company_identifiers/company_identifiers.yaml */
static const value_string bluetooth_company_id_vals[] = {
    { 0x0000,   "Ericsson AB" },
    { 0x0001,   "Nokia Mobile Phones" },
    { 0x0002,   "Intel Corp." },
    { 0x0003,   "IBM Corp." },
    { 0x0004,   "Toshiba Corp." },
    { 0x0005,   "3Com" },
    { 0x0006,   "Microsoft" },
    { 0x0007,   "Lucent" },
    { 0x0008,   "Motorola" },
    { 0x0009,   "Infineon Technologies AG" },
    { 0x000A,   "Qualcomm Technologies International, Ltd. (QTIL)" },
    { 0x000B,   "Silicon Wave" },
    { 0x000C,   "Digianswer A/S" },
    { 0x000D,   "Texas Instruments Inc." },
    { 0x000E,   "Parthus Technologies Inc." },
    { 0x000F,   "Broadcom Corporation" },
    { 0x0010,   "Mitel Semiconductor" },
    { 0x0011,   "Widcomm, Inc." },
    { 0x0012,   "Zeevo, Inc." },
    { 0x0013,   "Atmel Corporation" },
    { 0x0014,   "Mitsubishi Electric Corporation" },
    { 0x0015,   "RTX A/S" },
    { 0x0016,   "KC Technology Inc." },
    { 0x0017,   "Newlogic" },
    { 0x0018,   "Transilica, Inc." },
    { 0x0019,   "Rohde & Schwarz GmbH & Co. KG" },
    { 0x001A,   "TTPCom Limited" },
    { 0x001B,   "Signia Technologies, Inc." },
    { 0x001C,   "Conexant Systems Inc." },
    { 0x001D,   "Qualcomm" },
    { 0x001E,   "Inventel" },
    { 0x001F,   "AVM Berlin" },
    { 0x0020,   "BandSpeed, Inc." },
    { 0x0021,   "Mansella Ltd" },
    { 0x0022,   "NEC Corporation" },
    { 0x0023,   "WavePlus Technology Co., Ltd." },
    { 0x0024,   "Alcatel" },
    { 0x0025,   "NXP B.V." },
    { 0x0026,   "C Technologies" },
    { 0x0027,   "Open Interface" },
    { 0x0028,   "R F Micro Devices" },
    { 0x0029,   "Hitachi Ltd" },
    { 0x002A,   "Symbol Technologies, Inc." },
    { 0x002B,   "Tenovis" },
    { 0x002C,   "Macronix International Co. Ltd." },
    { 0x002D,   "GCT Semiconductor" },
    { 0x002E,   "Norwood Systems" },
    { 0x002F,   "MewTel Technology Inc." },
    { 0x0030,   "ST Microelectronics" },
    { 0x0031,   "Synopsys, Inc." },
    { 0x0032,   "Red-M (Communications) Ltd" },
    { 0x0033,   "Commil Ltd" },
    { 0x0034,   "Computer Access Technology Corporation (CATC)" },
    { 0x0035,   "Eclipse (HQ Espana) S.L." },
    { 0x0036,   "Renesas Electronics Corporation" },
    { 0x0037,   "Mobilian Corporation" },
    { 0x0038,   "Syntronix Corporation" },
    { 0x0039,   "Integrated System Solution Corp." },
    { 0x003A,   "Panasonic Holdings Corporation" },
    { 0x003B,   "Gennum Corporation" },
    { 0x003C,   "BlackBerry Limited" },
    { 0x003D,   "IPextreme, Inc." },
    { 0x003E,   "Systems and Chips, Inc" },
    { 0x003F,   "Bluetooth SIG, Inc" },
    { 0x0040,   "Seiko Epson Corporation" },
    { 0x0041,   "Integrated Silicon Solution Taiwan, Inc." },
    { 0x0042,   "CONWISE Technology Corporation Ltd" },
    { 0x0043,   "PARROT AUTOMOTIVE SAS" },
    { 0x0044,   "Socket Mobile" },
    { 0x0045,   "Atheros Communications, Inc." },
    { 0x0046,   "MediaTek, Inc." },
    { 0x0047,   "Bluegiga" },
    { 0x0048,   "Marvell Technology Group Ltd." },
    { 0x0049,   "3DSP Corporation" },
    { 0x004A,   "Accel Semiconductor Ltd." },
    { 0x004B,   "Continental Automotive Systems" },
    { 0x004C,   "Apple, Inc." },
    { 0x004D,   "Staccato Communications, Inc." },
    { 0x004E,   "Avago Technologies" },
    { 0x004F,   "APT Ltd." },
    { 0x0050,   "SiRF Technology, Inc." },
    { 0x0051,   "Tzero Technologies, Inc." },
    { 0x0052,   "J&M Corporation" },
    { 0x0053,   "Free2move AB" },
    { 0x0054,   "3DiJoy Corporation" },
    { 0x0055,   "Plantronics, Inc." },
    { 0x0056,   "Sony Ericsson Mobile Communications" },
    { 0x0057,   "Harman International Industries, Inc." },
    { 0x0058,   "Vizio, Inc." },
    { 0x0059,   "Nordic Semiconductor ASA" },
    { 0x005A,   "EM Microelectronic-Marin SA" },
    { 0x005B,   "Ralink Technology Corporation" },
    { 0x005C,   "Belkin International, Inc." },
    { 0x005D,   "Realtek Semiconductor Corporation" },
    { 0x005E,   "Stonestreet One, LLC" },
    { 0x005F,   "Wicentric, Inc." },
    { 0x0060,   "RivieraWaves S.A.S" },
    { 0x0061,   "RDA Microelectronics" },
    { 0x0062,   "Gibson Guitars" },
    { 0x0063,   "MiCommand Inc." },
    { 0x0064,   "Band XI International, LLC" },
    { 0x0065,   "HP, Inc." },
    { 0x0067,   "GN Hearing" },
    { 0x0068,   "General Motors" },
    { 0x0069,   "A&D Engineering, Inc." },
    { 0x006A,   "LTIMINDTREE LIMITED" },
    { 0x006B,   "Polar Electro OY" },
    { 0x006C,   "Beautiful Enterprise Co., Ltd." },
    { 0x006E,   "Summit Data Communications, Inc." },
    { 0x006F,   "Sound ID" },
    { 0x0070,   "Monster, LLC" },
    { 0x0071,   "connectBlue AB" },
    { 0x0072,   "ShangHai Super Smart Electronics Co. Ltd." },
    { 0x0073,   "Group Sense Ltd." },
    { 0x0074,   "Zomm, LLC" },
    { 0x0075,   "Samsung Electronics Co. Ltd." },
    { 0x0076,   "Creative Technology Ltd." },
    { 0x0077,   "Laird Connectivity LLC" },
    { 0x0078,   "Nike, Inc." },
    { 0x0079,   "lesswire AG" },
    { 0x007A,   "MStar Semiconductor, Inc." },
    { 0x007B,   "Hanlynn Technologies" },
    { 0x007D,   "Seers Technology Co., Ltd." },
    { 0x007E,   "Sports Tracking Technologies Ltd." },
    { 0x007F,   "Autonet Mobile" },
    { 0x0080,   "DeLorme Publishing Company, Inc." },
    { 0x0081,   "WuXi Vimicro" },
    { 0x0082,   "DSEA A/S" },
    { 0x0083,   "TimeKeeping Systems, Inc." },
    { 0x0084,   "Ludus Helsinki Ltd." },
    { 0x0085,   "BlueRadios, Inc." },
    { 0x0086,   "Equinux AG" },
    { 0x0087,   "Garmin International, Inc." },
    { 0x0088,   "Ecotest" },
    { 0x0089,   "GN Hearing A/S" },
    { 0x008A,   "Jawbone" },
    { 0x008B,   "Topcon Positioning Systems, LLC" },
    { 0x008C,   "Gimbal Inc." },
    { 0x008D,   "Zscan Software" },
    { 0x008E,   "Quintic Corp" },
    { 0x008F,   "Telit Wireless Solutions GmbH" },
    { 0x0090,   "Funai Electric Co., Ltd." },
    { 0x0091,   "Advanced PANMOBIL systems GmbH & Co. KG" },
    { 0x0092,   "ThinkOptics, Inc." },
    { 0x0093,   "Universal Electronics, Inc." },
    { 0x0094,   "Airoha Technology Corp." },
    { 0x0095,   "NEC Lighting, Ltd." },
    { 0x0096,   "ODM Technology, Inc." },
    { 0x0097,   "ConnecteDevice Ltd." },
    { 0x0098,   "zero1.tv GmbH" },
    { 0x0099,   "i.Tech Dynamic Global Distribution Ltd." },
    { 0x009A,   "Alpwise" },
    { 0x009B,   "Jiangsu Toppower Automotive Electronics Co., Ltd." },
    { 0x009C,   "Colorfy, Inc." },
    { 0x009D,   "Geoforce Inc." },
    { 0x009E,   "Bose Corporation" },
    { 0x009F,   "Suunto Oy" },
    { 0x00A0,   "Kensington Computer Products Group" },
    { 0x00A1,   "SR-Medizinelektronik" },
    { 0x00A2,   "Vertu Corporation Limited" },
    { 0x00A3,   "Meta Watch Ltd." },
    { 0x00A4,   "LINAK A/S" },
    { 0x00A5,   "OTL Dynamics LLC" },
    { 0x00A6,   "Panda Ocean Inc." },
    { 0x00A7,   "Visteon Corporation" },
    { 0x00A8,   "ARP Devices Limited" },
    { 0x00A9,   "MARELLI EUROPE S.P.A." },
    { 0x00AA,   "CAEN RFID srl" },
    { 0x00AB,   "Ingenieur-Systemgruppe Zahn GmbH" },
    { 0x00AC,   "Green Throttle Games" },
    { 0x00AD,   "Peter Systemtechnik GmbH" },
    { 0x00AE,   "Omegawave Oy" },
    { 0x00AF,   "Cinetix" },
    { 0x00B0,   "Passif Semiconductor Corp" },
    { 0x00B1,   "Saris Cycling Group, Inc" },
    { 0x00B2,   "Bekey A/S" },
    { 0x00B3,   "Clarinox Technologies Pty. Ltd." },
    { 0x00B4,   "BDE Technology Co., Ltd." },
    { 0x00B5,   "Swirl Networks" },
    { 0x00B6,   "Meso international" },
    { 0x00B7,   "TreLab Ltd" },
    { 0x00B8,   "Qualcomm Innovation Center, Inc. (QuIC)" },
    { 0x00B9,   "Johnson Controls, Inc." },
    { 0x00BA,   "Starkey Hearing Technologies" },
    { 0x00BB,   "S-Power Electronics Limited" },
    { 0x00BC,   "Ace Sensor Inc" },
    { 0x00BD,   "Aplix Corporation" },
    { 0x00BE,   "AAMP of America" },
    { 0x00BF,   "Stalmart Technology Limited" },
    { 0x00C0,   "AMICCOM Electronics Corporation" },
    { 0x00C1,   "Shenzhen Excelsecu Data Technology Co.,Ltd" },
    { 0x00C2,   "Geneq Inc." },
    { 0x00C3,   "adidas AG" },
    { 0x00C4,   "LG Electronics" },
    { 0x00C5,   "Onset Computer Corporation" },
    { 0x00C6,   "Selfly BV" },
    { 0x00C7,   "Quuppa Oy." },
    { 0x00C8,   "GeLo Inc" },
    { 0x00C9,   "Evluma" },
    { 0x00CA,   "MC10" },
    { 0x00CB,   "Binauric SE" },
    { 0x00CC,   "Beats Electronics" },
    { 0x00CD,   "Microchip Technology Inc." },
    { 0x00CE,   "Eve Systems GmbH" },
    { 0x00CF,   "ARCHOS SA" },
    { 0x00D0,   "Dexcom, Inc." },
    { 0x00D1,   "Polar Electro Europe B.V." },
    { 0x00D2,   "Renesas Design Netherlands B.V." },
    { 0x00D3,   "Taixingbang Technology (HK) Co,. LTD." },
    { 0x00D5,   "Austco Communication Systems" },
    { 0x00D6,   "Timex Group USA, Inc." },
    { 0x00D7,   "Qualcomm Technologies, Inc." },
    { 0x00D8,   "Qualcomm Connected Experiences, Inc." },
    { 0x00D9,   "Voyetra Turtle Beach" },
    { 0x00DA,   "txtr GmbH" },
    { 0x00DB,   "Snuza (Pty) Ltd" },
    { 0x00DC,   "Procter & Gamble" },
    { 0x00DD,   "Hosiden Corporation" },
    { 0x00DE,   "Muzik LLC" },
    { 0x00DF,   "Misfit Wearables Corp" },
    { 0x00E0,   "Google" },
    { 0x00E1,   "Danlers Ltd" },
    { 0x00E2,   "Semilink Inc" },
    { 0x00E3,   "inMusic Brands, Inc" },
    { 0x00E4,   "L.S. Research, Inc." },
    { 0x00E5,   "Eden Software Consultants Ltd." },
    { 0x00E7,   "KS Technologies" },
    { 0x00E8,   "ACTS Technologies" },
    { 0x00E9,   "Vtrack Systems" },
    { 0x00EA,   "Nielsen-Kellerman" },
    { 0x00EB,   "Server Technology Inc." },
    { 0x00EC,   "BioResearch Associates" },
    { 0x00ED,   "Jolly Logic, LLC" },
    { 0x00EE,   "Above Average Outcomes, Inc." },
    { 0x00EF,   "Bitsplitters GmbH" },
    { 0x00F0,   "PayPal, Inc." },
    { 0x00F1,   "Witron Technology Limited" },
    { 0x00F2,   "Morse Project Inc." },
    { 0x00F3,   "Kent Displays Inc." },
    { 0x00F4,   "Nautilus Inc." },
    { 0x00F5,   "Smartifier Oy" },
    { 0x00F6,   "Elcometer Limited" },
    { 0x00F7,   "VSN Technologies, Inc." },
    { 0x00F8,   "AceUni Corp., Ltd." },
    { 0x00FA,   "Crystal Alarm AB" },
    { 0x00FB,   "KOUKAAM a.s." },
    { 0x00FC,   "Delphi Corporation" },
    { 0x00FD,   "ValenceTech Limited" },
    { 0x00FE,   "Stanley Black and Decker" },
    { 0x00FF,   "Typo Products, LLC" },
    { 0x0100,   "TomTom International BV" },
    { 0x0101,   "Fugoo, Inc." },
    { 0x0102,   "Keiser Corporation" },
    { 0x0103,   "Bang & Olufsen A/S" },
    { 0x0104,   "PLUS Location Systems Pty Ltd" },
    { 0x0105,   "Ubiquitous Computing Technology Corporation" },
    { 0x0106,   "Innovative Yachtter Solutions" },
    { 0x0107,   "Demant A/S" },
    { 0x0108,   "Chicony Electronics Co., Ltd." },
    { 0x0109,   "Atus BV" },
    { 0x010A,   "Codegate Ltd" },
    { 0x010B,   "ERi, Inc" },
    { 0x010C,   "Transducers Direct, LLC" },
    { 0x010D,   "DENSO TEN Limited" },
    { 0x010E,   "Audi AG" },
    { 0x010F,   "HiSilicon Technologies CO., LIMITED" },
    { 0x0110,   "Nippon Seiki Co., Ltd." },
    { 0x0111,   "Steelseries ApS" },
    { 0x0112,   "Visybl Inc." },
    { 0x0113,   "Openbrain Technologies, Co., Ltd." },
    { 0x0115,   "e.solutions" },
    { 0x0116,   "10AK Technologies" },
    { 0x0117,   "Wimoto Technologies Inc" },
    { 0x0118,   "Radius Networks, Inc." },
    { 0x011A,   "Qualcomm Labs, Inc." },
    { 0x011B,   "Hewlett Packard Enterprise" },
    { 0x011C,   "Baidu" },
    { 0x011D,   "Arendi AG" },
    { 0x011E,   "Skoda Auto a.s." },
    { 0x011F,   "Volkswagen AG" },
    { 0x0120,   "Porsche AG" },
    { 0x0121,   "Sino Wealth Electronic Ltd." },
    { 0x0122,   "AirTurn, Inc." },
    { 0x0123,   "Kinsa, Inc" },
    { 0x0124,   "HID Global" },
    { 0x0125,   "SEAT es" },
    { 0x0126,   "Promethean Ltd." },
    { 0x0127,   "Salutica Allied Solutions" },
    { 0x0128,   "GPSI Group Pty Ltd" },
    { 0x0129,   "Nimble Devices Oy" },
    { 0x012A,   "Changzhou Yongse Infotech  Co., Ltd." },
    { 0x012B,   "SportIQ" },
    { 0x012C,   "TEMEC Instruments B.V." },
    { 0x012D,   "Sony Corporation" },
    { 0x012E,   "ASSA ABLOY" },
    { 0x012F,   "Clarion Co. Inc." },
    { 0x0130,   "Warehouse Innovations" },
    { 0x0131,   "Cypress Semiconductor" },
    { 0x0132,   "MADS Inc" },
    { 0x0133,   "Blue Maestro Limited" },
    { 0x0134,   "Resolution Products, Ltd." },
    { 0x0135,   "Aireware LLC" },
    { 0x0136,   "Silvair, Inc." },
    { 0x0137,   "Prestigio Plaza Ltd." },
    { 0x0138,   "NTEO Inc." },
    { 0x0139,   "Focus Systems Corporation" },
    { 0x013A,   "Tencent Holdings Ltd." },
    { 0x013B,   "Allegion" },
    { 0x013C,   "Murata Manufacturing Co., Ltd." },
    { 0x013D,   "WirelessWERX" },
    { 0x013E,   "Nod, Inc." },
    { 0x0140,   "Alpine Electronics (China) Co., Ltd" },
    { 0x0141,   "FedEx Services" },
    { 0x0142,   "Grape Systems Inc." },
    { 0x0143,   "Bkon Connect" },
    { 0x0144,   "Lintech GmbH" },
    { 0x0145,   "Novatel Wireless" },
    { 0x0146,   "Ciright" },
    { 0x0147,   "Mighty Cast, Inc." },
    { 0x0148,   "Ambimat Electronics" },
    { 0x0149,   "Perytons Ltd." },
    { 0x014A,   "Tivoli Audio, LLC" },
    { 0x014B,   "Master Lock" },
    { 0x014C,   "Mesh-Net Ltd" },
    { 0x014D,   "HUIZHOU DESAY SV AUTOMOTIVE CO., LTD." },
    { 0x014E,   "Tangerine, Inc." },
    { 0x014F,   "B&W Group Ltd." },
    { 0x0150,   "Pioneer Corporation" },
    { 0x0151,   "OnBeep" },
    { 0x0152,   "Vernier Software & Technology" },
    { 0x0153,   "ROL Ergo" },
    { 0x0154,   "Pebble Technology" },
    { 0x0155,   "NETATMO" },
    { 0x0156,   "Accumulate AB" },
    { 0x0157,   "Anhui Huami Information Technology Co., Ltd." },
    { 0x0158,   "Inmite s.r.o." },
    { 0x0159,   "ChefSteps, Inc." },
    { 0x015A,   "micas AG" },
    { 0x015B,   "Biomedical Research Ltd." },
    { 0x015C,   "Pitius Tec S.L." },
    { 0x015D,   "Estimote, Inc." },
    { 0x015E,   "Unikey Technologies, Inc." },
    { 0x015F,   "Timer Cap Co." },
    { 0x0160,   "AwoX" },
    { 0x0161,   "yikes" },
    { 0x0162,   "MADSGlobalNZ Ltd." },
    { 0x0163,   "PCH International" },
    { 0x0164,   "Qingdao Yeelink Information Technology Co., Ltd." },
    { 0x0165,   "Milwaukee Electric Tools" },
    { 0x0166,   "MISHIK Pte Ltd" },
    { 0x0167,   "Ascensia Diabetes Care US Inc." },
    { 0x0168,   "Spicebox LLC" },
    { 0x0169,   "emberlight" },
    { 0x016A,   "Copeland Cold Chain LP" },
    { 0x016B,   "Qblinks" },
    { 0x016C,   "MYSPHERA" },
    { 0x016D,   "LifeScan Inc" },
    { 0x016E,   "Volantic AB" },
    { 0x016F,   "Podo Labs, Inc" },
    { 0x0170,   "Roche Diabetes Care AG" },
    { 0x0171,   "Amazon.com Services LLC" },
    { 0x0172,   "Connovate Technology Private Limited" },
    { 0x0173,   "Kocomojo, LLC" },
    { 0x0174,   "Everykey Inc." },
    { 0x0175,   "Dynamic Controls" },
    { 0x0176,   "SentriLock" },
    { 0x0177,   "I-SYST inc." },
    { 0x0178,   "CASIO COMPUTER CO., LTD." },
    { 0x0179,   "LAPIS Semiconductor Co.,Ltd" },
    { 0x017A,   "Telemonitor, Inc." },
    { 0x017B,   "taskit GmbH" },
    { 0x017C,   "Mercedes-Benz Group AG" },
    { 0x017D,   "BatAndCat" },
    { 0x017E,   "BluDotz Ltd" },
    { 0x017F,   "XTel Wireless ApS" },
    { 0x0180,   "Gigaset Technologies GmbH" },
    { 0x0181,   "Gecko Health Innovations, Inc." },
    { 0x0182,   "HOP Ubiquitous" },
    { 0x0183,   "Walt Disney" },
    { 0x0184,   "Nectar" },
    { 0x0186,   "CORE Lighting Ltd" },
    { 0x0187,   "Seraphim Sense Ltd" },
    { 0x0188,   "Unico RBC" },
    { 0x0189,   "Physical Enterprises Inc." },
    { 0x018A,   "Able Trend Technology Limited" },
    { 0x018B,   "Konica Minolta, Inc." },
    { 0x018C,   "Wilo SE" },
    { 0x018D,   "Extron Design Services" },
    { 0x018E,   "Google LLC" },
    { 0x0190,   "Intelletto Technologies Inc." },
    { 0x0191,   "FDK CORPORATION" },
    { 0x0192,   "Cloudleaf, Inc" },
    { 0x0193,   "Maveric Automation LLC" },
    { 0x0194,   "Acoustic Stream Corporation" },
    { 0x0195,   "Zuli" },
    { 0x0196,   "Paxton Access Ltd" },
    { 0x0197,   "WiSilica Inc." },
    { 0x0198,   "VENGIT Korlatolt Felelossegu Tarsasag" },
    { 0x0199,   "SALTO SYSTEMS S.L." },
    { 0x019A,   "TRON Forum" },
    { 0x019B,   "CUBETECH s.r.o." },
    { 0x019C,   "Cokiya Incorporated" },
    { 0x019D,   "CVS Health" },
    { 0x019E,   "Ceruus" },
    { 0x019F,   "Strainstall Ltd" },
    { 0x01A0,   "Channel Enterprises (HK) Ltd." },
    { 0x01A1,   "FIAMM" },
    { 0x01A2,   "GIGALANE.CO.,LTD" },
    { 0x01A3,   "EROAD" },
    { 0x01A4,   "MSA Innovation, LLC" },
    { 0x01A5,   "Icon Health and Fitness" },
    { 0x01A6,   "Wille Engineering" },
    { 0x01A7,   "ENERGOUS CORPORATION" },
    { 0x01A8,   "Taobao" },
    { 0x01A9,   "Canon Inc." },
    { 0x01AA,   "Geophysical Technology Inc." },
    { 0x01AB,   "Meta Platforms, Inc." },
    { 0x01AC,   "Trividia Health, Inc." },
    { 0x01AD,   "FlightSafety International" },
    { 0x01AF,   "Sunrise Micro Devices, Inc." },
    { 0x01B0,   "Star Micronics Co., Ltd." },
    { 0x01B1,   "Netizens Sp. z o.o." },
    { 0x01B2,   "Nymi Inc." },
    { 0x01B3,   "Nytec, Inc." },
    { 0x01B4,   "Trineo Sp. z o.o." },
    { 0x01B5,   "Nest Labs Inc." },
    { 0x01B6,   "LM Technologies Ltd" },
    { 0x01B7,   "General Electric Company" },
    { 0x01B8,   "i+D3 S.L." },
    { 0x01B9,   "HANA Micron" },
    { 0x01BA,   "Stages Cycling LLC" },
    { 0x01BB,   "Cochlear Bone Anchored Solutions AB" },
    { 0x01BC,   "SenionLab AB" },
    { 0x01BD,   "Syszone Co., Ltd" },
    { 0x01BE,   "Pulsate Mobile Ltd." },
    { 0x01BF,   "Hongkong OnMicro Electronics Limited" },
    { 0x01C1,   "BRADATECH Corp." },
    { 0x01C2,   "Transenergooil AG" },
    { 0x01C4,   "DME Microelectronics" },
    { 0x01C5,   "Bitcraze AB" },
    { 0x01C6,   "HASWARE Inc." },
    { 0x01C7,   "Abiogenix Inc." },
    { 0x01C8,   "Poly-Control ApS" },
    { 0x01C9,   "Avi-on" },
    { 0x01CA,   "Laerdal Medical AS" },
    { 0x01CB,   "Fetch My Pet" },
    { 0x01CC,   "Sam Labs Ltd." },
    { 0x01CD,   "Chengdu Synwing Technology Ltd" },
    { 0x01CE,   "HOUWA SYSTEM DESIGN, k.k." },
    { 0x01CF,   "BSH" },
    { 0x01D0,   "Primus Inter Pares Ltd" },
    { 0x01D1,   "August Home, Inc" },
    { 0x01D2,   "Gill Electronics" },
    { 0x01D3,   "Sky Wave Design" },
    { 0x01D4,   "Newlab S.r.l." },
    { 0x01D5,   "ELAD srl" },
    { 0x01D6,   "G-wearables inc." },
    { 0x01D8,   "Code Corporation" },
    { 0x01D9,   "Savant Systems LLC" },
    { 0x01DA,   "Logitech International SA" },
    { 0x01DB,   "Innblue Consulting" },
    { 0x01DC,   "iParking Ltd." },
    { 0x01DD,   "Koninklijke Philips N.V." },
    { 0x01DE,   "Minelab Electronics Pty Limited" },
    { 0x01DF,   "Bison Group Ltd." },
    { 0x01E0,   "Widex A/S" },
    { 0x01E1,   "Jolla Ltd" },
    { 0x01E3,   "Caterpillar Inc" },
    { 0x01E4,   "Freedom Innovations" },
    { 0x01E5,   "Dynamic Devices Ltd" },
    { 0x01E6,   "Technology Solutions (UK) Ltd" },
    { 0x01EA,   "Advanced Application Design, Inc." },
    { 0x01EC,   "Spreadtrum Communications Shanghai Ltd" },
    { 0x01ED,   "CuteCircuit LTD" },
    { 0x01EE,   "Valeo Service" },
    { 0x01EF,   "Fullpower Technologies, Inc." },
    { 0x01F0,   "KloudNation" },
    { 0x01F1,   "Zebra Technologies Corporation" },
    { 0x01F2,   "Itron, Inc." },
    { 0x01F3,   "The University of Tokyo" },
    { 0x01F4,   "UTC Fire and Security" },
    { 0x01F5,   "Cool Webthings Limited" },
    { 0x01F6,   "DJO Global" },
    { 0x01F7,   "Gelliner Limited" },
    { 0x01F8,   "Anyka (Guangzhou) Microelectronics Technology Co, LTD" },
    { 0x01F9,   "Medtronic Inc." },
    { 0x01FA,   "Gozio Inc." },
    { 0x01FB,   "Form Lifting, LLC" },
    { 0x01FC,   "Wahoo Fitness, LLC" },
    { 0x01FD,   "Kontakt Micro-Location Sp. z o.o." },
    { 0x01FE,   "Radio Systems Corporation" },
    { 0x01FF,   "Freescale Semiconductor, Inc." },
    { 0x0200,   "Verifone Systems Pte Ltd. Taiwan Branch" },
    { 0x0201,   "AR Timing" },
    { 0x0202,   "Rigado LLC" },
    { 0x0203,   "Kemppi Oy" },
    { 0x0206,   "Otter Products, LLC" },
    { 0x0207,   "STEMP Inc." },
    { 0x0208,   "LumiGeek LLC" },
    { 0x0209,   "InvisionHeart Inc." },
    { 0x020A,   "Macnica Inc." },
    { 0x020B,   "Jaguar Land Rover Limited" },
    { 0x020C,   "CoroWare Technologies, Inc" },
    { 0x020E,   "Omron Healthcare Co., LTD" },
    { 0x020F,   "Comodule GMBH" },
    { 0x0210,   "ikeGPS" },
    { 0x0211,   "Telink Semiconductor Co. Ltd" },
    { 0x0212,   "Interplan Co., Ltd" },
    { 0x0213,   "Wyler AG" },
    { 0x0214,   "IK Multimedia Production srl" },
    { 0x0215,   "Lukoton Experience Oy" },
    { 0x0216,   "MTI Ltd" },
    { 0x0217,   "Tech4home, Lda" },
    { 0x0219,   "DOTT Limited" },
    { 0x021A,   "Blue Speck Labs, LLC" },
    { 0x021B,   "Cisco Systems, Inc" },
    { 0x021C,   "Mobicomm Inc" },
    { 0x021D,   "Edamic" },
    { 0x021E,   "Goodnet, Ltd" },
    { 0x021F,   "Luster Leaf Products  Inc" },
    { 0x0220,   "Manus Machina BV" },
    { 0x0221,   "Mobiquity Networks Inc" },
    { 0x0222,   "Praxis Dynamics" },
    { 0x0223,   "Philip Morris Products S.A." },
    { 0x0224,   "Comarch SA" },
    { 0x0225,   "Nestlé Nespresso S.A." },
    { 0x0226,   "Merlinia A/S" },
    { 0x0227,   "LifeBEAM Technologies" },
    { 0x0228,   "Twocanoes Labs, LLC" },
    { 0x0229,   "Muoverti Limited" },
    { 0x022A,   "Stamer Musikanlagen GMBH" },
    { 0x022B,   "Tesla, Inc." },
    { 0x022C,   "Pharynks Corporation" },
    { 0x022D,   "Lupine" },
    { 0x022E,   "Siemens AG" },
    { 0x0230,   "Foster Electric Company, Ltd" },
    { 0x0231,   "ETA SA" },
    { 0x0232,   "x-Senso Solutions Kft" },
    { 0x0233,   "Shenzhen SuLong Communication Ltd" },
    { 0x0234,   "FengFan (BeiJing) Technology Co, Ltd" },
    { 0x0235,   "Qrio Inc" },
    { 0x0236,   "Pitpatpet Ltd" },
    { 0x0237,   "MSHeli s.r.l." },
    { 0x0238,   "Trakm8 Ltd" },
    { 0x0239,   "JIN CO, Ltd" },
    { 0x023A,   "Alatech Tehnology" },
    { 0x023B,   "Beijing CarePulse Electronic Technology Co, Ltd" },
    { 0x023D,   "ViCentra B.V." },
    { 0x023E,   "Raven Industries" },
    { 0x023F,   "WaveWare Technologies Inc." },
    { 0x0240,   "Argenox Technologies" },
    { 0x0241,   "Bragi GmbH" },
    { 0x0243,   "Masimo Corp" },
    { 0x0244,   "Iotera Inc" },
    { 0x0245,   "Endress+Hauser" },
    { 0x0246,   "ACKme Networks, Inc." },
    { 0x0247,   "FiftyThree Inc." },
    { 0x0248,   "Parker Hannifin Corp" },
    { 0x024A,   "Uwatec AG" },
    { 0x024B,   "Orlan LLC" },
    { 0x024C,   "Blue Clover Devices" },
    { 0x024D,   "M-Way Solutions GmbH" },
    { 0x024E,   "Microtronics Engineering GmbH" },
    { 0x024F,   "Schneider Schreibgeräte GmbH" },
    { 0x0250,   "Sapphire Circuits LLC" },
    { 0x0251,   "Lumo Bodytech Inc." },
    { 0x0252,   "UKC Technosolution" },
    { 0x0253,   "Xicato Inc." },
    { 0x0254,   "Playbrush" },
    { 0x0255,   "Dai Nippon Printing Co., Ltd." },
    { 0x0256,   "G24 Power Limited" },
    { 0x0257,   "AdBabble Local Commerce Inc." },
    { 0x0258,   "Devialet SA" },
    { 0x0259,   "ALTYOR" },
    { 0x025A,   "University of Applied Sciences Valais/Haute Ecole Valaisanne" },
    { 0x025B,   "Five Interactive, LLC dba Zendo" },
    { 0x025C,   "NetEase（Hangzhou）Network co.Ltd." },
    { 0x025D,   "Lexmark International Inc." },
    { 0x025E,   "Fluke Corporation" },
    { 0x025F,   "Yardarm Technologies" },
    { 0x0261,   "SECVRE GmbH" },
    { 0x0262,   "Glacial Ridge Technologies" },
    { 0x0263,   "Identiv, Inc." },
    { 0x0264,   "DDS, Inc." },
    { 0x0265,   "SMK Corporation" },
    { 0x0266,   "Schawbel Technologies LLC" },
    { 0x0267,   "XMI Systems SA" },
    { 0x0268,   "Cerevo" },
    { 0x0269,   "Torrox GmbH & Co KG" },
    { 0x026A,   "Gemalto" },
    { 0x026B,   "DEKA Research & Development Corp." },
    { 0x026C,   "Domster Tadeusz Szydlowski" },
    { 0x026D,   "Technogym SPA" },
    { 0x026E,   "FLEURBAEY BVBA" },
    { 0x026F,   "Aptcode Solutions" },
    { 0x0270,   "LSI ADL Technology" },
    { 0x0271,   "Animas Corp" },
    { 0x0272,   "Alps Alpine Co., Ltd." },
    { 0x0273,   "OCEASOFT" },
    { 0x0274,   "Motsai Research" },
    { 0x0275,   "Geotab" },
    { 0x0276,   "E.G.O. Elektro-Geraetebau GmbH" },
    { 0x0277,   "bewhere inc" },
    { 0x0278,   "Johnson Outdoors Inc" },
    { 0x0279,   "steute Schaltgerate GmbH & Co. KG" },
    { 0x027A,   "Ekomini inc." },
    { 0x027B,   "DEFA AS" },
    { 0x027C,   "Aseptika Ltd" },
    { 0x027D,   "HUAWEI Technologies Co., Ltd." },
    { 0x027E,   "HabitAware, LLC" },
    { 0x027F,   "ruwido austria gmbh" },
    { 0x0280,   "ITEC corporation" },
    { 0x0281,   "StoneL" },
    { 0x0282,   "Sonova AG" },
    { 0x0283,   "Maven Machines, Inc." },
    { 0x0284,   "Synapse Electronics" },
    { 0x0285,   "WOWTech Canada Ltd." },
    { 0x0286,   "RF Code, Inc." },
    { 0x0287,   "Wally Ventures S.L." },
    { 0x0289,   "SK Telecom" },
    { 0x028A,   "Jetro AS" },
    { 0x028B,   "Code Gears LTD" },
    { 0x028C,   "NANOLINK APS" },
    { 0x028E,   "RF Digital Corp" },
    { 0x028F,   "Church & Dwight Co., Inc" },
    { 0x0290,   "Multibit Oy" },
    { 0x0291,   "CliniCloud Inc" },
    { 0x0293,   "Blue Bite" },
    { 0x0294,   "ELIAS GmbH" },
    { 0x0295,   "Sivantos GmbH" },
    { 0x0296,   "Petzl" },
    { 0x0297,   "storm power ltd" },
    { 0x0298,   "EISST Ltd" },
    { 0x0299,   "Inexess Technology Simma KG" },
    { 0x029A,   "Currant, Inc." },
    { 0x029B,   "C2 Development, Inc." },
    { 0x029C,   "Blue Sky Scientific, LLC" },
    { 0x029D,   "ALOTTAZS LABS, LLC" },
    { 0x029E,   "Kupson spol. s r.o." },
    { 0x029F,   "Areus Engineering GmbH" },
    { 0x02A0,   "Impossible Camera GmbH" },
    { 0x02A2,   "Sera4 Ltd." },
    { 0x02A3,   "Itude" },
    { 0x02A4,   "Pacific Lock Company" },
    { 0x02A5,   "Tendyron Corporation" },
    { 0x02A6,   "Robert Bosch GmbH" },
    { 0x02A7,   "Illuxtron international B.V." },
    { 0x02A8,   "miSport Ltd." },
    { 0x02A9,   "Chargelib" },
    { 0x02AA,   "Doppler Lab" },
    { 0x02AB,   "BBPOS Limited" },
    { 0x02AC,   "RTB Elektronik GmbH & Co. KG" },
    { 0x02AD,   "Rx Networks, Inc." },
    { 0x02AE,   "WeatherFlow, Inc." },
    { 0x02AF,   "Technicolor USA Inc." },
    { 0x02B0,   "Bestechnic(Shanghai),Ltd" },
    { 0x02B1,   "Raden Inc" },
    { 0x02B2,   "Oura Health Oy" },
    { 0x02B3,   "CLABER S.P.A." },
    { 0x02B4,   "Hyginex, Inc." },
    { 0x02B5,   "HANSHIN ELECTRIC RAILWAY CO.,LTD." },
    { 0x02B6,   "Schneider Electric" },
    { 0x02B7,   "Oort Technologies LLC" },
    { 0x02B8,   "Chrono Therapeutics" },
    { 0x02B9,   "Rinnai Corporation" },
    { 0x02BA,   "Swissprime Technologies AG" },
    { 0x02BB,   "Koha.,Co.Ltd" },
    { 0x02BC,   "Genevac Ltd" },
    { 0x02BD,   "Chemtronics" },
    { 0x02BE,   "Seguro Technology Sp. z o.o." },
    { 0x02BF,   "Redbird Flight Simulations" },
    { 0x02C0,   "Dash Robotics" },
    { 0x02C1,   "LINE Corporation" },
    { 0x02C2,   "Guillemot Corporation" },
    { 0x02C3,   "Techtronic Power Tools Technology Limited" },
    { 0x02C4,   "Wilson Sporting Goods" },
    { 0x02C5,   "Lenovo (Singapore) Pte Ltd." },
    { 0x02C6,   "Ayatan Sensors" },
    { 0x02C7,   "Electronics Tomorrow Limited" },
    { 0x02C8,   "OneSpan" },
    { 0x02C9,   "PayRange Inc." },
    { 0x02CA,   "ABOV Semiconductor" },
    { 0x02CB,   "AINA-Wireless Inc." },
    { 0x02CD,   "BMA ergonomics b.v." },
    { 0x02CE,   "Teva Branded Pharmaceutical Products R&D, Inc." },
    { 0x02CF,   "Anima" },
    { 0x02D0,   "3M" },
    { 0x02D1,   "Empatica Srl" },
    { 0x02D2,   "Afero, Inc." },
    { 0x02D3,   "Powercast Corporation" },
    { 0x02D4,   "Secuyou ApS" },
    { 0x02D5,   "OMRON Corporation" },
    { 0x02D6,   "Send Solutions" },
    { 0x02D7,   "NIPPON SYSTEMWARE CO.,LTD." },
    { 0x02D8,   "Neosfar" },
    { 0x02D9,   "Fliegl Agrartechnik GmbH" },
    { 0x02DA,   "Gilvader" },
    { 0x02DB,   "Digi International Inc (R)" },
    { 0x02DC,   "DeWalch Technologies, Inc." },
    { 0x02DD,   "Flint Rehabilitation Devices, LLC" },
    { 0x02DE,   "Samsung SDS Co., Ltd." },
    { 0x02DF,   "Blur Product Development" },
    { 0x02E0,   "University of Michigan" },
    { 0x02E1,   "Victron Energy BV" },
    { 0x02E2,   "NTT docomo" },
    { 0x02E3,   "Carmanah Technologies Corp." },
    { 0x02E4,   "Bytestorm Ltd." },
    { 0x02E5,   "Espressif Systems (Shanghai) Co., Ltd." },
    { 0x02E6,   "Unwire" },
    { 0x02E7,   "Connected Yard, Inc." },
    { 0x02E8,   "American Music Environments" },
    { 0x02E9,   "Sensogram Technologies, Inc." },
    { 0x02EA,   "Fujitsu Limited" },
    { 0x02EB,   "Ardic Technology" },
    { 0x02EC,   "Delta Systems, Inc" },
    { 0x02ED,   "HTC Corporation" },
    { 0x02EE,   "Citizen Holdings Co., Ltd." },
    { 0x02EF,   "SMART-INNOVATION.inc" },
    { 0x02F0,   "Blackrat Software" },
    { 0x02F1,   "The Idea Cave, LLC" },
    { 0x02F2,   "GoPro, Inc." },
    { 0x02F3,   "AuthAir, Inc" },
    { 0x02F4,   "Vensi, Inc." },
    { 0x02F5,   "Indagem Tech LLC" },
    { 0x02F6,   "Intemo Technologies" },
    { 0x02F8,   "Runteq Oy Ltd" },
    { 0x02F9,   "IMAGINATION TECHNOLOGIES LTD" },
    { 0x02FB,   "Clarius Mobile Health Corp." },
    { 0x02FC,   "Shanghai Frequen Microelectronics Co., Ltd." },
    { 0x02FE,   "Lierda Science & Technology Group Co., Ltd." },
    { 0x02FF,   "Silicon Laboratories" },
    { 0x0300,   "World Moto Inc." },
    { 0x0301,   "Giatec Scientific Inc." },
    { 0x0302,   "Loop Devices, Inc" },
    { 0x0303,   "IACA electronique" },
    { 0x0304,   "Oura Health Ltd" },
    { 0x0305,   "Swipp ApS" },
    { 0x0306,   "Life Laboratory Inc." },
    { 0x0307,   "FUJI INDUSTRIAL CO.,LTD." },
    { 0x0308,   "Surefire, LLC" },
    { 0x0309,   "Dolby Labs" },
    { 0x030A,   "Ellisys" },
    { 0x030B,   "Magnitude Lighting Converters" },
    { 0x030C,   "Hilti AG" },
    { 0x030D,   "Devdata S.r.l." },
    { 0x030F,   "Shortcut Labs" },
    { 0x0310,   "SGL Italia S.r.l." },
    { 0x0311,   "PEEQ DATA" },
    { 0x0312,   "Ducere Technologies Pvt Ltd" },
    { 0x0313,   "DiveNav, Inc." },
    { 0x0314,   "RIIG AI Sp. z o.o." },
    { 0x0315,   "Thermo Fisher Scientific" },
    { 0x0316,   "AG Measurematics Pvt. Ltd." },
    { 0x0317,   "CHUO Electronics CO., LTD." },
    { 0x0318,   "Aspenta International" },
    { 0x0319,   "Eugster Frismag AG" },
    { 0x031A,   "Wurth Elektronik eiSos GmbH & Co. KG" },
    { 0x031B,   "HQ Inc" },
    { 0x031C,   "Lab Sensor Solutions" },
    { 0x031D,   "Enterlab ApS" },
    { 0x031E,   "Eyefi, Inc." },
    { 0x031F,   "MetaSystem S.p.A." },
    { 0x0320,   "SONO ELECTRONICS. CO., LTD" },
    { 0x0323,   "Rotor Bike Components" },
    { 0x0324,   "Astro, Inc." },
    { 0x0325,   "Amotus Solutions" },
    { 0x0326,   "Healthwear Technologies (Changzhou)Ltd" },
    { 0x0327,   "Essex Electronics" },
    { 0x0328,   "Grundfos A/S" },
    { 0x0329,   "Eargo, Inc." },
    { 0x032A,   "Electronic Design Lab" },
    { 0x032B,   "ESYLUX" },
    { 0x032C,   "NIPPON SMT.CO.,Ltd" },
    { 0x032D,   "BM innovations GmbH" },
    { 0x032E,   "indoormap" },
    { 0x032F,   "OttoQ Inc" },
    { 0x0330,   "North Pole Engineering" },
    { 0x0331,   "3flares Technologies Inc." },
    { 0x0333,   "Mul-T-Lock" },
    { 0x0334,   "Airthings ASA" },
    { 0x0335,   "Enlighted Inc" },
    { 0x0336,   "GISTIC" },
    { 0x0337,   "AJP2 Holdings, LLC" },
    { 0x0338,   "COBI GmbH" },
    { 0x0339,   "Blue Sky Scientific, LLC" },
    { 0x033A,   "Appception, Inc." },
    { 0x033B,   "Courtney Thorne Limited" },
    { 0x033C,   "Virtuosys" },
    { 0x033D,   "TPV Technology Limited" },
    { 0x033E,   "Monitra SA" },
    { 0x033F,   "Automation Components, Inc." },
    { 0x0340,   "Letsense s.r.l." },
    { 0x0341,   "Etesian Technologies LLC" },
    { 0x0342,   "GERTEC BRASIL LTDA." },
    { 0x0343,   "Drekker Development Pty. Ltd." },
    { 0x0344,   "Whirl Inc" },
    { 0x0345,   "Locus Positioning" },
    { 0x0346,   "Acuity Brands Lighting, Inc" },
    { 0x0347,   "Prevent Biometrics" },
    { 0x0349,   "VersaMe" },
    { 0x034B,   "Libratone A/S" },
    { 0x034C,   "HM Electronics, Inc." },
    { 0x034D,   "TASER International, Inc." },
    { 0x034F,   "Heartland Payment Systems" },
    { 0x0350,   "Bitstrata Systems Inc." },
    { 0x0351,   "Pieps GmbH" },
    { 0x0352,   "iRiding(Xiamen)Technology Co.,Ltd." },
    { 0x0353,   "Alpha Audiotronics, Inc." },
    { 0x0354,   "TOPPAN FORMS CO.,LTD." },
    { 0x0355,   "Sigma Designs, Inc." },
    { 0x0356,   "Spectrum Brands, Inc." },
    { 0x0357,   "Polymap Wireless" },
    { 0x0358,   "MagniWare Ltd." },
    { 0x0359,   "Novotec Medical GmbH" },
    { 0x035A,   "Phillips-Medisize A/S" },
    { 0x035B,   "Matrix Inc." },
    { 0x035C,   "Eaton Corporation" },
    { 0x035D,   "KYS" },
    { 0x035E,   "Naya Health, Inc." },
    { 0x035F,   "Acromag" },
    { 0x0360,   "Insulet Corporation" },
    { 0x0361,   "Wellinks Inc." },
    { 0x0362,   "ON Semiconductor" },
    { 0x0363,   "FREELAP SA" },
    { 0x0364,   "Favero Electronics Srl" },
    { 0x0365,   "BioMech Sensor LLC" },
    { 0x0366,   "BOLTT Sports technologies Private limited" },
    { 0x0368,   "Metormote AB" },
    { 0x0369,   "littleBits" },
    { 0x036A,   "SetPoint Medical" },
    { 0x036B,   "BRControls Products BV" },
    { 0x036C,   "Zipcar" },
    { 0x036D,   "AirBolt Pty Ltd" },
    { 0x036E,   "MOTIVE TECHNOLOGIES, INC." },
    { 0x036F,   "Motiv, Inc." },
    { 0x0370,   "Wazombi Labs OÜ" },
    { 0x0372,   "Nixie Labs, Inc." },
    { 0x0373,   "AppNearMe Ltd" },
    { 0x0374,   "Holman Industries" },
    { 0x0375,   "Expain AS" },
    { 0x0376,   "Electronic Temperature Instruments Ltd" },
    { 0x0377,   "Plejd AB" },
    { 0x0378,   "Propeller Health" },
    { 0x0379,   "Shenzhen iMCO Electronic Technology Co.,Ltd" },
    { 0x037A,   "Algoria" },
    { 0x037B,   "Apption Labs Inc." },
    { 0x037C,   "Cronologics Corporation" },
    { 0x037D,   "MICRODIA Ltd." },
    { 0x037E,   "lulabytes S.L." },
    { 0x037F,   "Société des Produits Nestlé S.A." },
    { 0x0380,   "LLC \"MEGA-F service\"" },
    { 0x0381,   "Sharp Corporation" },
    { 0x0382,   "Precision Outcomes Ltd" },
    { 0x0383,   "Kronos Incorporated" },
    { 0x0385,   "Embedded Electronic Solutions Ltd. dba e2Solutions" },
    { 0x0386,   "Aterica Inc." },
    { 0x0387,   "BluStor PMC, Inc." },
    { 0x0388,   "Kapsch TrafficCom AB" },
    { 0x0389,   "ActiveBlu Corporation" },
    { 0x038A,   "Kohler Mira Limited" },
    { 0x038B,   "Noke" },
    { 0x038C,   "Appion Inc." },
    { 0x038D,   "Resmed Ltd" },
    { 0x038E,   "Crownstone B.V." },
    { 0x038F,   "Xiaomi Inc." },
    { 0x0390,   "INFOTECH s.r.o." },
    { 0x0391,   "Thingsquare AB" },
    { 0x0392,   "T&D" },
    { 0x0393,   "LAVAZZA S.p.A." },
    { 0x0395,   "SDATAWAY" },
    { 0x0396,   "BLOKS GmbH" },
    { 0x0397,   "LEGO System A/S" },
    { 0x0398,   "Thetatronics Ltd" },
    { 0x0399,   "Nikon Corporation" },
    { 0x039A,   "NeST" },
    { 0x039B,   "South Silicon Valley Microelectronics" },
    { 0x039C,   "ALE International" },
    { 0x039D,   "CareView Communications, Inc." },
    { 0x039E,   "SchoolBoard Limited" },
    { 0x039F,   "Molex Corporation" },
    { 0x03A0,   "IVT Wireless Limited" },
    { 0x03A1,   "Alpine Labs LLC" },
    { 0x03A2,   "Candura Instruments" },
    { 0x03A3,   "SmartMovt Technology Co., Ltd" },
    { 0x03A4,   "Token Zero Ltd" },
    { 0x03A5,   "ACE CAD Enterprise Co., Ltd. (ACECAD)" },
    { 0x03A6,   "Medela, Inc" },
    { 0x03A7,   "AeroScout" },
    { 0x03A8,   "Esrille Inc." },
    { 0x03AA,   "Exon Sp. z o.o." },
    { 0x03AB,   "Meizu Technology Co., Ltd." },
    { 0x03AD,   "XiQ" },
    { 0x03AE,   "Allswell Inc." },
    { 0x03AF,   "Comm-N-Sense Corp DBA Verigo" },
    { 0x03B0,   "VIBRADORM GmbH" },
    { 0x03B1,   "Otodata Wireless Network Inc." },
    { 0x03B2,   "Propagation Systems Limited" },
    { 0x03B3,   "Midwest Instruments & Controls" },
    { 0x03B4,   "Alpha Nodus, inc." },
    { 0x03B5,   "petPOMM, Inc" },
    { 0x03B6,   "Mattel" },
    { 0x03B7,   "Airbly Inc." },
    { 0x03B8,   "A-Safe Limited" },
    { 0x03B9,   "FREDERIQUE CONSTANT SA" },
    { 0x03BA,   "Maxscend Microelectronics Company Limited" },
    { 0x03BB,   "Abbott" },
    { 0x03BC,   "ASB Bank Ltd" },
    { 0x03BD,   "amadas" },
    { 0x03BE,   "Applied Science, Inc." },
    { 0x03BF,   "iLumi Solutions Inc." },
    { 0x03C0,   "Arch Systems Inc." },
    { 0x03C1,   "Ember Technologies, Inc." },
    { 0x03C2,   "Snapchat Inc" },
    { 0x03C3,   "Casambi Technologies Oy" },
    { 0x03C4,   "Pico Technology Inc." },
    { 0x03C5,   "St. Jude Medical, Inc." },
    { 0x03C6,   "Intricon" },
    { 0x03C7,   "Structural Health Systems, Inc." },
    { 0x03C8,   "Avvel International" },
    { 0x03C9,   "Gallagher Group" },
    { 0x03CA,   "In2things Automation Pvt. Ltd." },
    { 0x03CB,   "SYSDEV Srl" },
    { 0x03CC,   "Vonkil Technologies Ltd" },
    { 0x03CD,   "Wynd Technologies, Inc." },
    { 0x03CE,   "CONTRINEX S.A." },
    { 0x03CF,   "MIRA, Inc." },
    { 0x03D0,   "Watteam Ltd" },
    { 0x03D1,   "Density Inc." },
    { 0x03D2,   "IOT Pot India Private Limited" },
    { 0x03D3,   "Sigma Connectivity AB" },
    { 0x03D4,   "PEG PEREGO SPA" },
    { 0x03D5,   "Wyzelink Systems Inc." },
    { 0x03D6,   "Yota Devices LTD" },
    { 0x03D7,   "FINSECUR" },
    { 0x03D8,   "Zen-Me Labs Ltd" },
    { 0x03D9,   "3IWare Co., Ltd." },
    { 0x03DA,   "EnOcean GmbH" },
    { 0x03DB,   "Instabeat, Inc" },
    { 0x03DC,   "Nima Labs" },
    { 0x03DD,   "Andreas Stihl AG & Co. KG" },
    { 0x03DE,   "Nathan Rhoades LLC" },
    { 0x03DF,   "Grob Technologies, LLC" },
    { 0x03E0,   "Actions Technology Co.,Ltd" },
    { 0x03E1,   "SPD Development Company Ltd" },
    { 0x03E2,   "Sensoan Oy" },
    { 0x03E3,   "Qualcomm Life Inc" },
    { 0x03E4,   "Chip-ing AG" },
    { 0x03E5,   "ffly4u" },
    { 0x03E6,   "IoT Instruments Oy" },
    { 0x03E7,   "TRUE Fitness Technology" },
    { 0x03E8,   "Reiner Kartengeraete GmbH & Co. KG." },
    { 0x03E9,   "SHENZHEN LEMONJOY TECHNOLOGY CO., LTD." },
    { 0x03EA,   "Hello Inc." },
    { 0x03EB,   "Ozo Edu, Inc." },
    { 0x03EC,   "Jigowatts Inc." },
    { 0x03ED,   "BASIC MICRO.COM,INC." },
    { 0x03EE,   "CUBE TECHNOLOGIES" },
    { 0x03EF,   "foolography GmbH" },
    { 0x03F0,   "CLINK" },
    { 0x03F1,   "Hestan Smart Cooking Inc." },
    { 0x03F2,   "WindowMaster A/S" },
    { 0x03F4,   "PAL Technologies Ltd" },
    { 0x03F5,   "WHERE, Inc." },
    { 0x03F6,   "Iton Technology Corp." },
    { 0x03F7,   "Owl Labs Inc." },
    { 0x03F8,   "Rockford Corp." },
    { 0x03F9,   "Becon Technologies Co.,Ltd." },
    { 0x03FA,   "Vyassoft Technologies Inc" },
    { 0x03FB,   "Nox Medical" },
    { 0x03FC,   "Kimberly-Clark" },
    { 0x03FD,   "Trimble Inc." },
    { 0x03FE,   "Littelfuse" },
    { 0x03FF,   "Withings" },
    { 0x0400,   "i-developer IT Beratung UG" },
    { 0x0401,   "Relations Inc." },
    { 0x0402,   "Sears Holdings Corporation" },
    { 0x0403,   "Gantner Electronic GmbH" },
    { 0x0404,   "Authomate Inc" },
    { 0x0405,   "Vertex International, Inc." },
    { 0x0407,   "Swiss Audio SA" },
    { 0x0408,   "ToGetHome Inc." },
    { 0x0409,   "RYSE INC." },
    { 0x040A,   "ZF OPENMATICS s.r.o." },
    { 0x040B,   "Jana Care Inc." },
    { 0x040C,   "Senix Corporation" },
    { 0x040D,   "NorthStar Battery Company, LLC" },
    { 0x040E,   "SKF (U.K.) Limited" },
    { 0x040F,   "CO-AX Technology, Inc." },
    { 0x0410,   "Fender Musical Instruments" },
    { 0x0411,   "Luidia Inc" },
    { 0x0412,   "SEFAM" },
    { 0x0413,   "Wireless Cables Inc" },
    { 0x0416,   "SODA GmbH" },
    { 0x0417,   "Fatigue Science" },
    { 0x0418,   "Alpine Electronics Inc." },
    { 0x0419,   "Novalogy LTD" },
    { 0x041A,   "Friday Labs Limited" },
    { 0x041B,   "OrthoAccel Technologies" },
    { 0x041C,   "WaterGuru, Inc." },
    { 0x041D,   "Benning Elektrotechnik und Elektronik GmbH & Co. KG" },
    { 0x041E,   "Dell Computer Corporation" },
    { 0x041F,   "Kopin Corporation" },
    { 0x0420,   "TecBakery GmbH" },
    { 0x0421,   "Backbone Labs, Inc." },
    { 0x0422,   "DELSEY SA" },
    { 0x0423,   "Chargifi Limited" },
    { 0x0424,   "Trainesense Ltd." },
    { 0x0425,   "Unify Software and Solutions GmbH & Co. KG" },
    { 0x0426,   "Husqvarna AB" },
    { 0x0427,   "Focus fleet and fuel management inc" },
    { 0x0428,   "SmallLoop, LLC" },
    { 0x0429,   "Prolon Inc." },
    { 0x042A,   "BD Medical" },
    { 0x042B,   "iMicroMed Incorporated" },
    { 0x042C,   "Ticto N.V." },
    { 0x042D,   "Meshtech AS" },
    { 0x042E,   "MemCachier Inc." },
    { 0x042F,   "Danfoss A/S" },
    { 0x0430,   "SnapStyk Inc." },
    { 0x0431,   "Alticor Inc." },
    { 0x0432,   "Silk Labs, Inc." },
    { 0x0433,   "Pillsy Inc." },
    { 0x0434,   "Hatch Baby, Inc." },
    { 0x0435,   "Blocks Wearables Ltd." },
    { 0x0436,   "Drayson Technologies (Europe) Limited" },
    { 0x0437,   "eBest IOT Inc." },
    { 0x0438,   "Helvar Ltd" },
    { 0x0439,   "Radiance Technologies" },
    { 0x043A,   "Nuheara Limited" },
    { 0x043B,   "Appside co., ltd." },
    { 0x043D,   "Coiler Corporation" },
    { 0x043E,   "Thermomedics, Inc." },
    { 0x043F,   "Tentacle Sync GmbH" },
    { 0x0440,   "Valencell, Inc." },
    { 0x0442,   "SECOM CO., LTD." },
    { 0x0443,   "Tucker International LLC" },
    { 0x0444,   "Metanate Limited" },
    { 0x0445,   "Kobian Canada Inc." },
    { 0x0446,   "NETGEAR, Inc." },
    { 0x0447,   "Fabtronics Australia Pty Ltd" },
    { 0x0448,   "Grand Centrix GmbH" },
    { 0x0449,   "1UP USA.com llc" },
    { 0x044A,   "SHIMANO INC." },
    { 0x044B,   "Nain Inc." },
    { 0x044C,   "LifeStyle Lock, LLC" },
    { 0x044D,   "VEGA Grieshaber KG" },
    { 0x044E,   "Xtrava Inc." },
    { 0x044F,   "TTS Tooltechnic Systems AG & Co. KG" },
    { 0x0450,   "Teenage Engineering AB" },
    { 0x0451,   "Tunstall Nordic AB" },
    { 0x0452,   "Svep Design Center AB" },
    { 0x0453,   "Qorvo Utrecht B.V." },
    { 0x0454,   "Sphinx Electronics GmbH & Co KG" },
    { 0x0455,   "Atomation" },
    { 0x0456,   "Nemik Consulting Inc" },
    { 0x0457,   "RF INNOVATION" },
    { 0x0458,   "Mini Solution Co., Ltd." },
    { 0x045A,   "2048450 Ontario Inc" },
    { 0x045C,   "Delta T Corporation" },
    { 0x045D,   "Boston Scientific Corporation" },
    { 0x045E,   "Nuviz, Inc." },
    { 0x045F,   "Real Time Automation, Inc." },
    { 0x0460,   "Kolibree" },
    { 0x0461,   "vhf elektronik GmbH" },
    { 0x0462,   "Bonsai Systems GmbH" },
    { 0x0463,   "Fathom Systems Inc." },
    { 0x0464,   "Bellman & Symfon Group AB" },
    { 0x0465,   "International Forte Group LLC" },
    { 0x0467,   "Codenex Oy" },
    { 0x0468,   "Kynesim Ltd" },
    { 0x0469,   "Palago AB" },
    { 0x046A,   "INSIGMA INC." },
    { 0x046B,   "PMD Solutions" },
    { 0x046C,   "Qingdao Realtime Technology Co., Ltd." },
    { 0x046D,   "BEGA Gantenbrink-Leuchten KG" },
    { 0x046E,   "Pambor Ltd." },
    { 0x046F,   "Develco Products A/S" },
    { 0x0470,   "iDesign s.r.l." },
    { 0x0471,   "TiVo Corp" },
    { 0x0472,   "Control-J Pty Ltd" },
    { 0x0473,   "Steelcase, Inc." },
    { 0x0474,   "iApartment co., ltd." },
    { 0x0475,   "Icom inc." },
    { 0x0477,   "Blue Spark Technologies" },
    { 0x0478,   "FarSite Communications Limited" },
    { 0x0479,   "mywerk system GmbH" },
    { 0x047A,   "Sinosun Technology Co., Ltd." },
    { 0x047B,   "MIYOSHI ELECTRONICS CORPORATION" },
    { 0x047C,   "POWERMAT LTD" },
    { 0x047D,   "Occly LLC" },
    { 0x047E,   "OurHub Dev IvS" },
    { 0x047F,   "Pro-Mark, Inc." },
    { 0x0481,   "Quintrax Limited" },
    { 0x0482,   "POS Tuning Udo Vosshenrich GmbH & Co. KG" },
    { 0x0484,   "Revol Technologies Inc" },
    { 0x0485,   "SKIDATA AG" },
    { 0x0486,   "DEV TECNOLOGIA INDUSTRIA, COMERCIO E MANUTENCAO DE EQUIPAMENTOS LTDA. - ME" },
    { 0x0487,   "Centrica Connected Home" },
    { 0x0488,   "Automotive Data Solutions Inc" },
    { 0x0489,   "Igarashi Engineering" },
    { 0x048A,   "Taelek Oy" },
    { 0x048C,   "Vectronix AG" },
    { 0x048D,   "S-Labs Sp. z o.o." },
    { 0x048E,   "Companion Medical, Inc." },
    { 0x048F,   "BlueKitchen GmbH" },
    { 0x0490,   "Matting AB" },
    { 0x0491,   "SOREX - Wireless Solutions GmbH" },
    { 0x0492,   "ADC Technology, Inc." },
    { 0x0493,   "Lynxemi Pte Ltd" },
    { 0x0494,   "SENNHEISER electronic GmbH & Co. KG" },
    { 0x0496,   "Polymorphic Labs LLC" },
    { 0x0497,   "Cochlear Limited" },
    { 0x0498,   "METER Group, Inc. USA" },
    { 0x0499,   "Ruuvi Innovations Ltd." },
    { 0x049A,   "Situne AS" },
    { 0x049B,   "nVisti, LLC" },
    { 0x049C,   "DyOcean" },
    { 0x049D,   "Uhlmann & Zacher GmbH" },
    { 0x049E,   "AND!XOR LLC" },
    { 0x049F,   "Popper Pay AB" },
    { 0x04A2,   "ovrEngineered, LLC" },
    { 0x04A3,   "GT-tronics HK Ltd" },
    { 0x04A4,   "Herbert Waldmann GmbH & Co. KG" },
    { 0x04A5,   "Guangzhou FiiO Electronics Technology Co.,Ltd" },
    { 0x04A6,   "Vinetech Co., Ltd" },
    { 0x04A7,   "Dallas Logic Corporation" },
    { 0x04A8,   "BioTex, Inc." },
    { 0x04AA,   "LINKIO SAS" },
    { 0x04AB,   "Harbortronics, Inc." },
    { 0x04AC,   "Undagrid B.V." },
    { 0x04AD,   "Shure Inc" },
    { 0x04AE,   "ERM Electronic Systems LTD" },
    { 0x04AF,   "BIOROWER Handelsagentur GmbH" },
    { 0x04B1,   "Kartographers Technologies Pvt. Ltd." },
    { 0x04B2,   "The Shadow on the Moon" },
    { 0x04B3,   "mobike (Hong Kong) Limited" },
    { 0x04B4,   "Inuheat Group AB" },
    { 0x04B5,   "Swiftronix AB" },
    { 0x04B6,   "Diagnoptics Technologies" },
    { 0x04B7,   "Analog Devices, Inc." },
    { 0x04B8,   "Soraa Inc." },
    { 0x04B9,   "CSR Building Products Limited" },
    { 0x04BA,   "Crestron Electronics, Inc." },
    { 0x04BB,   "Neatebox Ltd" },
    { 0x04BC,   "Draegerwerk AG & Co. KGaA" },
    { 0x04BD,   "AlbynMedical" },
    { 0x04BE,   "Averos FZCO" },
    { 0x04BF,   "VIT Initiative, LLC" },
    { 0x04C0,   "Statsports International" },
    { 0x04C1,   "Sospitas, s.r.o." },
    { 0x04C2,   "Dmet Products Corp." },
    { 0x04C3,   "Mantracourt Electronics Limited" },
    { 0x04C4,   "TeAM Hutchins AB" },
    { 0x04C5,   "Seibert Williams Glass, LLC" },
    { 0x04C6,   "Insta GmbH" },
    { 0x04C7,   "Svantek Sp. z o.o." },
    { 0x04C8,   "Shanghai Flyco Electrical Appliance Co., Ltd." },
    { 0x04C9,   "Thornwave Labs Inc" },
    { 0x04CA,   "Steiner-Optik GmbH" },
    { 0x04CB,   "Novo Nordisk A/S" },
    { 0x04CD,   "Safetech Products LLC" },
    { 0x04CE,   "GOOOLED S.R.L." },
    { 0x04CF,   "DOM Sicherheitstechnik GmbH & Co. KG" },
    { 0x04D0,   "Olympus Corporation" },
    { 0x04D1,   "KTS GmbH" },
    { 0x04D2,   "Anloq Technologies Inc." },
    { 0x04D3,   "Queercon, Inc" },
    { 0x04D4,   "5th Element Ltd" },
    { 0x04D5,   "Gooee Limited" },
    { 0x04D6,   "LUGLOC LLC" },
    { 0x04D7,   "Blincam, Inc." },
    { 0x04D8,   "FUJIFILM Corporation" },
    { 0x04D9,   "RM Acquisition LLC" },
    { 0x04DA,   "Franceschi Marina snc" },
    { 0x04DB,   "Engineered Audio, LLC." },
    { 0x04DC,   "IOTTIVE (OPC) PRIVATE LIMITED" },
    { 0x04DD,   "4MOD Technology" },
    { 0x04DE,   "Lutron Electronics Co., Inc." },
    { 0x04DF,   "Emerson Electric Co." },
    { 0x04E0,   "Guardtec, Inc." },
    { 0x04E1,   "REACTEC LIMITED" },
    { 0x04E3,   "Under Armour" },
    { 0x04E4,   "Woodenshark" },
    { 0x04E5,   "Avack Oy" },
    { 0x04E6,   "Smart Solution Technology, Inc." },
    { 0x04E8,   "STABILO International" },
    { 0x04E9,   "Busch Jaeger Elektro GmbH" },
    { 0x04EA,   "Pacific Bioscience Laboratories, Inc" },
    { 0x04EB,   "Bird Home Automation GmbH" },
    { 0x04EC,   "Motorola Solutions" },
    { 0x04EE,   "Auxivia" },
    { 0x04EF,   "DaisyWorks, Inc" },
    { 0x04F0,   "Kosi Limited" },
    { 0x04F1,   "Theben AG" },
    { 0x04F2,   "InDreamer Techsol Private Limited" },
    { 0x04F3,   "Cerevast Medical" },
    { 0x04F4,   "ZanCompute Inc." },
    { 0x04F5,   "Pirelli Tyre S.P.A." },
    { 0x04F6,   "McLear Limited" },
    { 0x04F7,   "Shenzhen Goodix Technology Co., Ltd" },
    { 0x04F8,   "Convergence Systems Limited" },
    { 0x04F9,   "Interactio" },
    { 0x04FA,   "Androtec GmbH" },
    { 0x04FB,   "Benchmark Drives GmbH & Co. KG" },
    { 0x04FC,   "SwingLync L. L. C." },
    { 0x04FD,   "Tapkey GmbH" },
    { 0x04FE,   "Woosim Systems Inc." },
    { 0x04FF,   "Microsemi Corporation" },
    { 0x0500,   "Wiliot LTD." },
    { 0x0501,   "Polaris IND" },
    { 0x0502,   "Specifi-Kali LLC" },
    { 0x0503,   "Locoroll, Inc" },
    { 0x0504,   "PHYPLUS Inc" },
    { 0x0505,   "InPlay, Inc." },
    { 0x0506,   "Hager" },
    { 0x0507,   "Yellowcog" },
    { 0x0508,   "Axes System sp. z o. o." },
    { 0x0509,   "Garage Smart, Inc." },
    { 0x050A,   "Shake-on B.V." },
    { 0x050B,   "Vibrissa Inc." },
    { 0x050C,   "OSRAM GmbH" },
    { 0x050D,   "TRSystems GmbH" },
    { 0x050E,   "Yichip Microelectronics (Hangzhou) Co.,Ltd." },
    { 0x050F,   "Foundation Engineering LLC" },
    { 0x0510,   "UNI-ELECTRONICS, INC." },
    { 0x0511,   "Brookfield Equinox LLC" },
    { 0x0512,   "Soprod SA" },
    { 0x0513,   "9974091 Canada Inc." },
    { 0x0514,   "FIBRO GmbH" },
    { 0x0515,   "RB Controls Co., Ltd." },
    { 0x0516,   "Footmarks" },
    { 0x0517,   "Amtronic Sverige AB" },
    { 0x0518,   "MAMORIO.inc" },
    { 0x0519,   "Tyto Life LLC" },
    { 0x051A,   "Leica Camera AG" },
    { 0x051C,   "EDPS" },
    { 0x051D,   "OFF Line Co., Ltd." },
    { 0x051E,   "Detect Blue Limited" },
    { 0x051F,   "Setec Pty Ltd" },
    { 0x0520,   "Target Corporation" },
    { 0x0521,   "IAI Corporation" },
    { 0x0522,   "NS Tech, Inc." },
    { 0x0523,   "MTG Co., Ltd." },
    { 0x0524,   "Hangzhou iMagic Technology Co., Ltd" },
    { 0x0525,   "HONGKONG NANO IC TECHNOLOGIES  CO., LIMITED" },
    { 0x0526,   "Honeywell International Inc." },
    { 0x0527,   "Albrecht JUNG" },
    { 0x0528,   "Lunera Lighting Inc." },
    { 0x0529,   "Lumen UAB" },
    { 0x052A,   "Keynes Controls Ltd" },
    { 0x052B,   "Novartis AG" },
    { 0x052C,   "Geosatis SA" },
    { 0x052D,   "EXFO, Inc." },
    { 0x052E,   "LEDVANCE GmbH" },
    { 0x052F,   "Center ID Corp." },
    { 0x0530,   "Adolene, Inc." },
    { 0x0531,   "D&M Holdings Inc." },
    { 0x0532,   "CRESCO Wireless, Inc." },
    { 0x0533,   "Nura Operations Pty Ltd" },
    { 0x0534,   "Frontiergadget, Inc." },
    { 0x0535,   "Smart Component Technologies Limited" },
    { 0x0536,   "ZTR Control Systems LLC" },
    { 0x0537,   "MetaLogics Corporation" },
    { 0x0538,   "Medela AG" },
    { 0x0539,   "OPPLE Lighting Co., Ltd" },
    { 0x053A,   "Savitech Corp.," },
    { 0x053B,   "prodigy" },
    { 0x053C,   "Screenovate Technologies Ltd" },
    { 0x053D,   "TESA SA" },
    { 0x053E,   "CLIM8 LIMITED" },
    { 0x053F,   "Silergy Corp" },
    { 0x0540,   "SilverPlus, Inc" },
    { 0x0541,   "Sharknet srl" },
    { 0x0542,   "Mist Systems, Inc." },
    { 0x0543,   "MIWA LOCK CO.,Ltd" },
    { 0x0544,   "OrthoSensor, Inc." },
    { 0x0546,   "Apexar Technologies S.A." },
    { 0x0547,   "LOGICDATA Electronic & Software Entwicklungs GmbH" },
    { 0x0548,   "Knick Elektronische Messgeraete GmbH & Co. KG" },
    { 0x0549,   "Smart Technologies and Investment Limited" },
    { 0x054A,   "Linough Inc." },
    { 0x054B,   "Advanced Electronic Designs, Inc." },
    { 0x054C,   "Carefree Scott Fetzer Co Inc" },
    { 0x054D,   "Sensome" },
    { 0x054E,   "FORTRONIK storitve d.o.o." },
    { 0x054F,   "Sinnoz" },
    { 0x0551,   "Sylero" },
    { 0x0552,   "Avempace SARL" },
    { 0x0553,   "Nintendo Co., Ltd." },
    { 0x0554,   "National Instruments" },
    { 0x0555,   "KROHNE Messtechnik GmbH" },
    { 0x0556,   "Otodynamics Ltd" },
    { 0x0557,   "Arwin Technology Limited" },
    { 0x0558,   "benegear, inc." },
    { 0x0559,   "Newcon Optik" },
    { 0x055A,   "CANDY HOUSE, Inc." },
    { 0x055B,   "FRANKLIN TECHNOLOGY INC" },
    { 0x055C,   "Lely" },
    { 0x055D,   "Valve Corporation" },
    { 0x055E,   "Hekatron Vertriebs GmbH" },
    { 0x055F,   "PROTECH S.A.S. DI GIRARDI ANDREA & C." },
    { 0x0560,   "Sarita CareTech APS" },
    { 0x0561,   "Finder S.p.A." },
    { 0x0562,   "Thalmic Labs Inc." },
    { 0x0563,   "Steinel Vertrieb GmbH" },
    { 0x0564,   "Beghelli Spa" },
    { 0x0566,   "CORE TRANSPORT TECHNOLOGIES NZ LIMITED" },
    { 0x0567,   "Xiamen Everesports Goods Co., Ltd" },
    { 0x0568,   "Bodyport Inc." },
    { 0x056A,   "Flipnavi Co.,Ltd." },
    { 0x056B,   "Rion Co., Ltd." },
    { 0x056C,   "Long Range Systems, LLC" },
    { 0x056D,   "Redmond Industrial Group LLC" },
    { 0x056E,   "VIZPIN INC." },
    { 0x056F,   "BikeFinder AS" },
    { 0x0570,   "Consumer Sleep Solutions LLC" },
    { 0x0571,   "PSIKICK, INC." },
    { 0x0572,   "AntTail.com" },
    { 0x0573,   "Lighting Science Group Corp." },
    { 0x0574,   "AFFORDABLE ELECTRONICS INC" },
    { 0x0575,   "Integral Memroy Plc" },
    { 0x0576,   "Globalstar, Inc." },
    { 0x0577,   "True Wearables, Inc." },
    { 0x0578,   "Wellington Drive Technologies Ltd" },
    { 0x057A,   "OMNI Remotes" },
    { 0x057B,   "Duracell U.S. Operations Inc." },
    { 0x057C,   "Toor Technologies LLC" },
    { 0x057D,   "Instinct Performance" },
    { 0x057E,   "Beco, Inc" },
    { 0x057F,   "Scuf Gaming International, LLC" },
    { 0x0581,   "LYS TECHNOLOGIES LTD" },
    { 0x0582,   "Breakwall Analytics, LLC" },
    { 0x0583,   "Code Blue Communications" },
    { 0x0584,   "Gira Giersiepen GmbH & Co. KG" },
    { 0x0585,   "Hearing Lab Technology" },
    { 0x0586,   "LEGRAND" },
    { 0x0587,   "Derichs GmbH" },
    { 0x0588,   "ALT-TEKNIK LLC" },
    { 0x0589,   "Star Technologies" },
    { 0x058A,   "START TODAY CO.,LTD." },
    { 0x058B,   "Maxim Integrated Products" },
    { 0x058C,   "Fracarro Radioindustrie SRL" },
    { 0x058D,   "Jungheinrich Aktiengesellschaft" },
    { 0x058E,   "Meta Platforms Technologies, LLC" },
    { 0x058F,   "HENDON SEMICONDUCTORS PTY LTD" },
    { 0x0590,   "Pur3 Ltd" },
    { 0x0591,   "Viasat Group S.p.A." },
    { 0x0592,   "IZITHERM" },
    { 0x0593,   "Spaulding Clinical Research" },
    { 0x0594,   "Kohler Company" },
    { 0x0595,   "Inor Process AB" },
    { 0x0596,   "My Smart Blinds" },
    { 0x0597,   "RadioPulse Inc" },
    { 0x0598,   "rapitag GmbH" },
    { 0x0599,   "Lazlo326, LLC." },
    { 0x059A,   "Teledyne Lecroy, Inc." },
    { 0x059B,   "Dataflow Systems Limited" },
    { 0x059C,   "Macrogiga Electronics" },
    { 0x059D,   "Tandem Diabetes Care" },
    { 0x059E,   "Polycom, Inc." },
    { 0x059F,   "Fisher & Paykel Healthcare" },
    { 0x05A0,   "Dream Devices Technologies Oy" },
    { 0x05A1,   "Shanghai Xiaoyi Technology Co.,Ltd." },
    { 0x05A2,   "ADHERIUM(NZ) LIMITED" },
    { 0x05A3,   "Axiomware Systems Incorporated" },
    { 0x05A4,   "O. E. M. Controls, Inc." },
    { 0x05A5,   "Kiiroo BV" },
    { 0x05A6,   "Telecon Mobile Limited" },
    { 0x05A7,   "Sonos Inc" },
    { 0x05A8,   "Tom Allebrandi Consulting" },
    { 0x05A9,   "Monidor" },
    { 0x05AA,   "Tramex Limited" },
    { 0x05AB,   "Nofence AS" },
    { 0x05AC,   "GoerTek Dynaudio Co., Ltd." },
    { 0x05AD,   "INIA" },
    { 0x05AE,   "CARMATE MFG.CO.,LTD" },
    { 0x05AF,   "OV LOOP, INC." },
    { 0x05B0,   "NewTec GmbH" },
    { 0x05B1,   "Medallion Instrumentation Systems" },
    { 0x05B2,   "CAREL INDUSTRIES S.P.A." },
    { 0x05B3,   "Parabit Systems, Inc." },
    { 0x05B4,   "White Horse Scientific ltd" },
    { 0x05B5,   "verisilicon" },
    { 0x05B6,   "Elecs Industry Co.,Ltd." },
    { 0x05B7,   "Beijing Pinecone Electronics Co.,Ltd." },
    { 0x05B8,   "Ambystoma Labs Inc." },
    { 0x05B9,   "Suzhou Pairlink Network Technology" },
    { 0x05BA,   "igloohome" },
    { 0x05BB,   "Oxford Metrics plc" },
    { 0x05BC,   "Leviton Mfg. Co., Inc." },
    { 0x05BD,   "ULC Robotics Inc." },
    { 0x05BF,   "Real-World-Systems Corporation" },
    { 0x05C0,   "Nalu Medical, Inc." },
    { 0x05C1,   "P.I.Engineering" },
    { 0x05C2,   "Grote Industries" },
    { 0x05C3,   "Runtime, Inc." },
    { 0x05C4,   "Codecoup sp. z o.o. sp. k." },
    { 0x05C5,   "SELVE GmbH & Co. KG" },
    { 0x05C7,   "Lippert Components, INC" },
    { 0x05C8,   "SOMFY SAS" },
    { 0x05C9,   "TBS Electronics B.V." },
    { 0x05CA,   "MHL Custom Inc" },
    { 0x05CB,   "LucentWear LLC" },
    { 0x05CC,   "WATTS ELECTRONICS" },
    { 0x05CD,   "RJ Brands LLC" },
    { 0x05CE,   "V-ZUG Ltd" },
    { 0x05CF,   "Biowatch SA" },
    { 0x05D0,   "Anova Applied Electronics" },
    { 0x05D1,   "Lindab AB" },
    { 0x05D2,   "frogblue TECHNOLOGY GmbH" },
    { 0x05D3,   "Acurable Limited" },
    { 0x05D4,   "LAMPLIGHT Co., Ltd." },
    { 0x05D5,   "TEGAM, Inc." },
    { 0x05D6,   "Zhuhai Jieli technology Co.,Ltd" },
    { 0x05D7,   "modum.io AG" },
    { 0x05D8,   "Farm Jenny LLC" },
    { 0x05D9,   "Toyo Electronics Corporation" },
    { 0x05DA,   "Applied Neural Research Corp" },
    { 0x05DB,   "Avid Identification Systems, Inc." },
    { 0x05DC,   "Petronics Inc." },
    { 0x05DD,   "essentim GmbH" },
    { 0x05DE,   "QT Medical INC." },
    { 0x05DF,   "VIRTUALCLINIC.DIRECT LIMITED" },
    { 0x05E0,   "Viper Design LLC" },
    { 0x05E1,   "Human, Incorporated" },
    { 0x05E2,   "stAPPtronics GmbH" },
    { 0x05E3,   "Elemental Machines, Inc." },
    { 0x05E4,   "Taiyo Yuden Co., Ltd" },
    { 0x05E5,   "INEO ENERGY& SYSTEMS" },
    { 0x05E6,   "Motion Instruments Inc." },
    { 0x05E7,   "PressurePro" },
    { 0x05E8,   "COWBOY" },
    { 0x05E9,   "iconmobile GmbH" },
    { 0x05EA,   "ACS-Control-System GmbH" },
    { 0x05EB,   "Bayerische Motoren Werke AG" },
    { 0x05EC,   "Gycom Svenska AB" },
    { 0x05ED,   "Fuji Xerox Co., Ltd" },
    { 0x05EF,   "SIKOM AS" },
    { 0x05F0,   "beken" },
    { 0x05F1,   "The Linux Foundation" },
    { 0x05F2,   "Try and E CO.,LTD." },
    { 0x05F3,   "SeeScan" },
    { 0x05F4,   "Clearity, LLC" },
    { 0x05F5,   "GS TAG" },
    { 0x05F6,   "DPTechnics" },
    { 0x05F7,   "TRACMO, INC." },
    { 0x05F8,   "Anki Inc." },
    { 0x05F9,   "Hagleitner Hygiene International GmbH" },
    { 0x05FA,   "Konami Sports Life Co., Ltd." },
    { 0x05FB,   "Arblet Inc." },
    { 0x05FC,   "Masbando GmbH" },
    { 0x05FD,   "Innoseis" },
    { 0x05FE,   "Niko nv" },
    { 0x05FF,   "Wellnomics Ltd" },
    { 0x0600,   "iRobot Corporation" },
    { 0x0601,   "Schrader Electronics" },
    { 0x0602,   "Geberit International AG" },
    { 0x0603,   "Fourth Evolution Inc" },
    { 0x0605,   "FMW electronic Futterer u. Maier-Wolf OHG" },
    { 0x0606,   "John Deere" },
    { 0x0607,   "Rookery Technology Ltd" },
    { 0x0608,   "KeySafe-Cloud" },
    { 0x0609,   "BUCHI Labortechnik AG" },
    { 0x060A,   "IQAir AG" },
    { 0x060B,   "Triax Technologies Inc" },
    { 0x060C,   "Vuzix Corporation" },
    { 0x060D,   "TDK Corporation" },
    { 0x060E,   "Blueair AB" },
    { 0x060F,   "Signify Netherlands B.V." },
    { 0x0610,   "ADH GUARDIAN USA LLC" },
    { 0x0611,   "Beurer GmbH" },
    { 0x0612,   "Playfinity AS" },
    { 0x0613,   "Hans Dinslage GmbH" },
    { 0x0614,   "OnAsset Intelligence, Inc." },
    { 0x0615,   "INTER ACTION Corporation" },
    { 0x0616,   "OS42 UG (haftungsbeschraenkt)" },
    { 0x0617,   "WIZCONNECTED COMPANY LIMITED" },
    { 0x0618,   "Audio-Technica Corporation" },
    { 0x0619,   "Six Guys Labs, s.r.o." },
    { 0x061A,   "R.W. Beckett Corporation" },
    { 0x061B,   "silex technology, inc." },
    { 0x061C,   "Univations Limited" },
    { 0x061D,   "SENS Innovation ApS" },
    { 0x061E,   "Diamond Kinetics, Inc." },
    { 0x061F,   "Phrame Inc." },
    { 0x0620,   "Forciot Oy" },
    { 0x0621,   "Noordung d.o.o." },
    { 0x0622,   "Beam Labs, LLC" },
    { 0x0624,   "Biovotion AG" },
    { 0x0625,   "Square Panda, Inc." },
    { 0x0626,   "Amplifico" },
    { 0x0627,   "WEG S.A." },
    { 0x0628,   "Ensto Oy" },
    { 0x0629,   "PHONEPE PVT LTD" },
    { 0x062B,   "MinebeaMitsumi Inc." },
    { 0x062C,   "ASPion GmbH" },
    { 0x062D,   "Vossloh-Schwabe Deutschland GmbH" },
    { 0x062E,   "Procept" },
    { 0x062F,   "ONKYO Corporation" },
    { 0x0630,   "Asthrea D.O.O." },
    { 0x0631,   "Fortiori Design LLC" },
    { 0x0632,   "Hugo Muller GmbH & Co KG" },
    { 0x0633,   "Wangi Lai PLT" },
    { 0x0634,   "Fanstel Corp" },
    { 0x0635,   "Crookwood" },
    { 0x0636,   "ELECTRONICA INTEGRAL DE SONIDO S.A." },
    { 0x0637,   "GiP Innovation Tools GmbH" },
    { 0x0638,   "LX SOLUTIONS PTY LIMITED" },
    { 0x0639,   "Shenzhen Minew Technologies Co., Ltd." },
    { 0x063A,   "Prolojik Limited" },
    { 0x063B,   "Kromek Group Plc" },
    { 0x063C,   "Contec Medical Systems Co., Ltd." },
    { 0x063D,   "Xradio Technology Co.,Ltd." },
    { 0x063E,   "The Indoor Lab, LLC" },
    { 0x063F,   "LDL TECHNOLOGY" },
    { 0x0640,   "Dish Network LLC" },
    { 0x0641,   "Revenue Collection Systems FRANCE SAS" },
    { 0x0642,   "Bluetrum Technology Co.,Ltd" },
    { 0x0643,   "makita corporation" },
    { 0x0644,   "Apogee Instruments" },
    { 0x0645,   "BM3" },
    { 0x0646,   "SGV Group Holding GmbH & Co. KG" },
    { 0x0647,   "MED-EL" },
    { 0x0648,   "Ultune Technologies" },
    { 0x0649,   "Ryeex Technology Co.,Ltd." },
    { 0x064A,   "Open Research Institute, Inc." },
    { 0x064B,   "Scale-Tec, Ltd" },
    { 0x064C,   "Zumtobel Group AG" },
    { 0x064D,   "iLOQ Oy" },
    { 0x064E,   "KRUXWorks Technologies Private Limited" },
    { 0x064F,   "Digital Matter Pty Ltd" },
    { 0x0650,   "Coravin, Inc." },
    { 0x0651,   "Stasis Labs, Inc." },
    { 0x0652,   "ITZ Innovations- und Technologiezentrum GmbH" },
    { 0x0653,   "Meggitt SA" },
    { 0x0654,   "Ledlenser GmbH & Co. KG" },
    { 0x0655,   "Renishaw PLC" },
    { 0x0656,   "ZhuHai AdvanPro Technology Company Limited" },
    { 0x0657,   "Meshtronix Limited" },
    { 0x0658,   "Payex Norge AS" },
    { 0x0659,   "UnSeen Technologies Oy" },
    { 0x065A,   "Marshall Group AB" },
    { 0x065B,   "Sesam Solutions BV" },
    { 0x065C,   "PixArt Imaging Inc." },
    { 0x065D,   "Panduit Corp." },
    { 0x065E,   "Alo AB" },
    { 0x065F,   "Ricoh Company Ltd" },
    { 0x0660,   "RTC Industries, Inc." },
    { 0x0661,   "Mode Lighting Limited" },
    { 0x0662,   "Particle Industries, Inc." },
    { 0x0663,   "Advanced Telemetry Systems, Inc." },
    { 0x0664,   "RHA TECHNOLOGIES LTD" },
    { 0x0665,   "Pure International Limited" },
    { 0x0666,   "WTO Werkzeug-Einrichtungen GmbH" },
    { 0x0667,   "Spark Technology Labs Inc." },
    { 0x0668,   "Bleb Technology srl" },
    { 0x0669,   "Livanova USA, Inc." },
    { 0x066A,   "Brady Worldwide Inc." },
    { 0x066B,   "DewertOkin GmbH" },
    { 0x066C,   "Ztove ApS" },
    { 0x066D,   "Venso EcoSolutions AB" },
    { 0x066E,   "Eurotronik Kranj d.o.o." },
    { 0x066F,   "Hug Technology Ltd" },
    { 0x0670,   "Gema Switzerland GmbH" },
    { 0x0671,   "Buzz Products Ltd." },
    { 0x0672,   "Kopi" },
    { 0x0673,   "Innova Ideas Limited" },
    { 0x0674,   "BeSpoon" },
    { 0x0676,   "Expai Solutions Private Limited" },
    { 0x0677,   "Innovation First, Inc." },
    { 0x0678,   "SABIK Offshore GmbH" },
    { 0x0679,   "4iiii Innovations Inc." },
    { 0x067A,   "The Energy Conservatory, Inc." },
    { 0x067B,   "I.FARM, INC." },
    { 0x067C,   "Tile, Inc." },
    { 0x067D,   "Form Athletica Inc." },
    { 0x067F,   "NETGRID S.N.C. DI BISSOLI MATTEO, CAMPOREALE SIMONE, TOGNETTI FEDERICO" },
    { 0x0680,   "Mannkind Corporation" },
    { 0x0681,   "Trade FIDES a.s." },
    { 0x0682,   "Photron Limited" },
    { 0x0683,   "Eltako GmbH" },
    { 0x0684,   "Dermalapps, LLC" },
    { 0x0685,   "Greenwald Industries" },
    { 0x0686,   "inQs Co., Ltd." },
    { 0x0687,   "Cherry GmbH" },
    { 0x0688,   "Amsted Digital Solutions Inc." },
    { 0x0689,   "Tacx b.v." },
    { 0x068A,   "Raytac Corporation" },
    { 0x068B,   "Jiangsu Teranovo Tech Co., Ltd." },
    { 0x068E,   "Razer Inc." },
    { 0x068F,   "JRM Group Limited" },
    { 0x0690,   "Eccrine Systems, Inc." },
    { 0x0691,   "Curie Point AB" },
    { 0x0692,   "Georg Fischer AG" },
    { 0x0693,   "Hach - Danaher" },
    { 0x0694,   "T&A Laboratories LLC" },
    { 0x0695,   "Koki Holdings Co., Ltd." },
    { 0x0696,   "Gunakar Private Limited" },
    { 0x0697,   "Stemco Products Inc" },
    { 0x0698,   "Wood IT Security, LLC" },
    { 0x0699,   "RandomLab SAS" },
    { 0x069A,   "Adero, Inc." },
    { 0x069B,   "Dragonchip Limited" },
    { 0x069C,   "Noomi AB" },
    { 0x069E,   "Delta Electronics, Inc." },
    { 0x069F,   "FlowMotion Technologies AS" },
    { 0x06A0,   "OBIQ Location Technology Inc." },
    { 0x06A1,   "Cardo Systems, Ltd" },
    { 0x06A2,   "Globalworx GmbH" },
    { 0x06A3,   "Nymbus, LLC" },
    { 0x06A4,   "LIMNO Co. Ltd." },
    { 0x06A5,   "TEKZITEL PTY LTD" },
    { 0x06A6,   "Roambee Corporation" },
    { 0x06A7,   "Chipsea Technologies (ShenZhen) Corp." },
    { 0x06A8,   "GD Midea Air-Conditioning Equipment Co., Ltd." },
    { 0x06A9,   "Soundmax Electronics Limited" },
    { 0x06AA,   "Produal Oy" },
    { 0x06AB,   "HMS Industrial Networks AB" },
    { 0x06AC,   "Ingchips Technology Co., Ltd." },
    { 0x06AD,   "InnovaSea Systems Inc." },
    { 0x06AE,   "SenseQ Inc." },
    { 0x06AF,   "Shoof Technologies" },
    { 0x06B0,   "BRK Brands, Inc." },
    { 0x06B1,   "SimpliSafe, Inc." },
    { 0x06B2,   "Tussock Innovation 2013 Limited" },
    { 0x06B4,   "Sencilion Oy" },
    { 0x06B5,   "Wabilogic Ltd." },
    { 0x06B6,   "Sociometric Solutions, Inc." },
    { 0x06B7,   "iCOGNIZE GmbH" },
    { 0x06B8,   "ShadeCraft, Inc" },
    { 0x06B9,   "Beflex Inc." },
    { 0x06BA,   "Beaconzone Ltd" },
    { 0x06BB,   "Leaftronix Analogic Solutions Private Limited" },
    { 0x06BC,   "TWS Srl" },
    { 0x06BD,   "ABB Oy" },
    { 0x06BE,   "HitSeed Oy" },
    { 0x06C0,   "CAME S.p.A." },
    { 0x06C1,   "Alarm.com Holdings, Inc" },
    { 0x06C2,   "Measurlogic Inc." },
    { 0x06C3,   "King I Electronics.Co.,Ltd" },
    { 0x06C4,   "Dream Labs GmbH" },
    { 0x06C5,   "Urban Compass, Inc" },
    { 0x06C6,   "Simm Tronic Limited" },
    { 0x06C7,   "Somatix Inc" },
    { 0x06C8,   "Storz & Bickel GmbH & Co. KG" },
    { 0x06C9,   "MYLAPS B.V." },
    { 0x06CA,   "Shenzhen Zhongguang Infotech Technology Development Co., Ltd" },
    { 0x06CB,   "Dyeware, LLC" },
    { 0x06CC,   "Dongguan SmartAction Technology Co.,Ltd." },
    { 0x06CD,   "DIG Corporation" },
    { 0x06CE,   "FIOR & GENTZ" },
    { 0x06D0,   "Etekcity Corporation" },
    { 0x06D1,   "Meyer Sound Laboratories, Incorporated" },
    { 0x06D2,   "CeoTronics AG" },
    { 0x06D4,   "DYNAKODE TECHNOLOGY PRIVATE LIMITED" },
    { 0x06D5,   "Sensirion AG" },
    { 0x06D6,   "JCT Healthcare Pty Ltd" },
    { 0x06D7,   "FUBA Automotive Electronics GmbH" },
    { 0x06D8,   "AW Company" },
    { 0x06D9,   "Shanghai Mountain View Silicon Co.,Ltd." },
    { 0x06DA,   "Zliide Technologies ApS" },
    { 0x06DB,   "Automatic Labs, Inc." },
    { 0x06DC,   "Industrial Network Controls, LLC" },
    { 0x06DD,   "Intellithings Ltd." },
    { 0x06DE,   "Navcast, Inc." },
    { 0x06DF,   "HLI Solutions Inc." },
    { 0x06E0,   "Avaya Inc." },
    { 0x06E1,   "Milestone AV Technologies LLC" },
    { 0x06E2,   "Alango Technologies Ltd" },
    { 0x06E3,   "Spinlock Ltd" },
    { 0x06E4,   "Aluna" },
    { 0x06E5,   "OPTEX CO.,LTD." },
    { 0x06E6,   "NIHON DENGYO KOUSAKU" },
    { 0x06E7,   "VELUX A/S" },
    { 0x06E8,   "Almendo Technologies GmbH" },
    { 0x06E9,   "Zmartfun Electronics, Inc." },
    { 0x06EA,   "SafeLine Sweden AB" },
    { 0x06EB,   "Houston Radar LLC" },
    { 0x06EC,   "Sigur" },
    { 0x06ED,   "J Neades Ltd" },
    { 0x06EF,   "ALCARE Co., Ltd." },
    { 0x06F0,   "Chargy Technologies, SL" },
    { 0x06F1,   "Shibutani Co., Ltd." },
    { 0x06F2,   "Trapper Data AB" },
    { 0x06F3,   "Alfred International Inc." },
    { 0x06F4,   "Touché Technology Ltd" },
    { 0x06F5,   "Vigil Technologies Inc." },
    { 0x06F6,   "Vitulo Plus BV" },
    { 0x06F7,   "WILKA Schliesstechnik GmbH" },
    { 0x06F8,   "BodyPlus Technology Co.,Ltd" },
    { 0x06F9,   "happybrush GmbH" },
    { 0x06FA,   "Enequi AB" },
    { 0x06FB,   "Sartorius AG" },
    { 0x06FC,   "Tom Communication Industrial Co.,Ltd." },
    { 0x06FD,   "ESS Embedded System Solutions Inc." },
    { 0x06FE,   "Mahr GmbH" },
    { 0x06FF,   "Redpine Signals Inc" },
    { 0x0700,   "TraqFreq LLC" },
    { 0x0701,   "PAFERS TECH" },
    { 0x0702,   "Akciju sabiedriba \"SAF TEHNIKA\"" },
    { 0x0703,   "Beijing Jingdong Century Trading Co., Ltd." },
    { 0x0704,   "JBX Designs Inc." },
    { 0x0705,   "AB Electrolux" },
    { 0x0706,   "Wernher von Braun Center for ASdvanced Research" },
    { 0x0707,   "Essity Hygiene and Health Aktiebolag" },
    { 0x0708,   "Be Interactive Co., Ltd" },
    { 0x0709,   "Carewear Corp." },
    { 0x070A,   "Huf Hülsbeck & Fürst GmbH & Co. KG" },
    { 0x070B,   "Element Products, Inc." },
    { 0x070C,   "Beijing Winner Microelectronics Co.,Ltd" },
    { 0x070D,   "SmartSnugg Pty Ltd" },
    { 0x070E,   "FiveCo Sarl" },
    { 0x070F,   "California Things Inc." },
    { 0x0710,   "Audiodo AB" },
    { 0x0711,   "ABAX AS" },
    { 0x0712,   "Bull Group Company Limited" },
    { 0x0713,   "Respiri Limited" },
    { 0x0714,   "MindPeace Safety LLC" },
    { 0x0715,   "MBARC LABS Inc" },
    { 0x0716,   "Altonics" },
    { 0x0718,   "IDIBAIX enginneering" },
    { 0x0719,   "COREIOT PTY LTD" },
    { 0x071A,   "REVSMART WEARABLE HK CO LTD" },
    { 0x071B,   "Precor" },
    { 0x071C,   "F5 Sports, Inc" },
    { 0x071D,   "exoTIC Systems" },
    { 0x071E,   "DONGGUAN HELE ELECTRONICS CO., LTD" },
    { 0x071F,   "Dongguan Liesheng Electronic Co.Ltd" },
    { 0x0720,   "Oculeve, Inc." },
    { 0x0721,   "Clover Network, Inc." },
    { 0x0722,   "Xiamen Eholder Electronics Co.Ltd" },
    { 0x0723,   "Ford Motor Company" },
    { 0x0724,   "Guangzhou SuperSound Information Technology Co.,Ltd" },
    { 0x0725,   "Tedee Sp. z o.o." },
    { 0x0726,   "PHC Corporation" },
    { 0x0728,   "Eli Lilly and Company" },
    { 0x0729,   "SwaraLink Technologies" },
    { 0x072A,   "JMR embedded systems GmbH" },
    { 0x072B,   "Bitkey Inc." },
    { 0x072C,   "GWA Hygiene GmbH" },
    { 0x072D,   "Safera Oy" },
    { 0x072E,   "Open Platform Systems LLC" },
    { 0x072F,   "OnePlus Electronics (Shenzhen) Co., Ltd." },
    { 0x0730,   "Wildlife Acoustics, Inc." },
    { 0x0731,   "ABLIC Inc." },
    { 0x0732,   "Dairy Tech, LLC" },
    { 0x0733,   "Iguanavation, Inc." },
    { 0x0734,   "DiUS Computing Pty Ltd" },
    { 0x0735,   "UpRight Technologies LTD" },
    { 0x0736,   "Luna XIO, Inc." },
    { 0x0737,   "LLC Navitek" },
    { 0x0738,   "Glass Security Pte Ltd" },
    { 0x0739,   "Jiangsu Qinheng Co., Ltd." },
    { 0x073A,   "Chandler Systems Inc." },
    { 0x073B,   "Fantini Cosmi s.p.a." },
    { 0x073D,   "Beijing Hao Heng Tian Tech Co., Ltd." },
    { 0x073E,   "Bluepack S.R.L." },
    { 0x073F,   "Beijing Unisoc Technologies Co., Ltd." },
    { 0x0741,   "MAC SRL" },
    { 0x0742,   "DML LLC" },
    { 0x0743,   "Sanofi" },
    { 0x0744,   "SOCOMEC" },
    { 0x0745,   "WIZNOVA, Inc." },
    { 0x0746,   "Seitec Elektronik GmbH" },
    { 0x0747,   "OR Technologies Pty Ltd" },
    { 0x0748,   "GuangZhou KuGou Computer Technology Co.Ltd" },
    { 0x0749,   "DIAODIAO (Beijing) Technology Co., Ltd." },
    { 0x074A,   "Illusory Studios LLC" },
    { 0x074B,   "Sarvavid Software Solutions LLP" },
    { 0x074D,   "Amtech Systems, LLC" },
    { 0x074E,   "EAGLE DETECTION SA" },
    { 0x074F,   "MEDIATECH S.R.L." },
    { 0x0750,   "Hamilton Professional Services of Canada Incorporated" },
    { 0x0751,   "Changsha JEMO IC Design Co.,Ltd" },
    { 0x0752,   "Elatec GmbH" },
    { 0x0753,   "JLG Industries, Inc." },
    { 0x0754,   "Michael Parkin" },
    { 0x0755,   "Brother Industries, Ltd" },
    { 0x0756,   "Lumens For Less, Inc" },
    { 0x0757,   "ELA Innovation" },
    { 0x0758,   "umanSense AB" },
    { 0x0759,   "Shanghai InGeek Cyber Security Co., Ltd." },
    { 0x075A,   "HARMAN CO.,LTD." },
    { 0x075B,   "Smart Sensor Devices AB" },
    { 0x075C,   "Antitronics Inc." },
    { 0x075D,   "RHOMBUS SYSTEMS, INC." },
    { 0x075E,   "Katerra Inc." },
    { 0x075F,   "Remote Solution Co., LTD." },
    { 0x0760,   "Vimar SpA" },
    { 0x0761,   "Mantis Tech LLC" },
    { 0x0762,   "TerOpta Ltd" },
    { 0x0763,   "PIKOLIN S.L." },
    { 0x0764,   "WWZN Information Technology Company Limited" },
    { 0x0765,   "Voxx International" },
    { 0x0766,   "ART AND PROGRAM, INC." },
    { 0x0767,   "NITTO DENKO ASIA TECHNICAL CENTRE PTE. LTD." },
    { 0x0768,   "Peloton Interactive Inc." },
    { 0x0769,   "Force Impact Technologies" },
    { 0x076A,   "Dmac Mobile Developments, LLC" },
    { 0x076B,   "Engineered Medical Technologies" },
    { 0x076C,   "Noodle Technology inc" },
    { 0x076D,   "Graesslin GmbH" },
    { 0x076E,   "WuQi technologies, Inc." },
    { 0x076F,   "Successful Endeavours Pty Ltd" },
    { 0x0770,   "InnoCon Medical ApS" },
    { 0x0771,   "Corvex Connected Safety" },
    { 0x0772,   "Thirdwayv Inc." },
    { 0x0773,   "Echoflex Solutions Inc." },
    { 0x0774,   "C-MAX Asia Limited" },
    { 0x0775,   "4eBusiness GmbH" },
    { 0x0776,   "Cyber Transport Control GmbH" },
    { 0x0777,   "Cue" },
    { 0x0778,   "KOAMTAC INC." },
    { 0x0779,   "Loopshore Oy" },
    { 0x077A,   "Niruha Systems Private Limited" },
    { 0x077C,   "radius co., ltd." },
    { 0x077D,   "Sensority, s.r.o." },
    { 0x077E,   "Sparkage Inc." },
    { 0x077F,   "Glenview Software Corporation" },
    { 0x0780,   "Finch Technologies Ltd." },
    { 0x0781,   "Qingping Technology (Beijing) Co., Ltd." },
    { 0x0782,   "DeviceDrive AS" },
    { 0x0783,   "ESEMBER LIMITED LIABILITY COMPANY" },
    { 0x0784,   "audifon GmbH & Co. KG" },
    { 0x0785,   "O2 Micro, Inc." },
    { 0x0786,   "HLP Controls Pty Limited" },
    { 0x0788,   "BubblyNet, LLC" },
    { 0x0789,   "PCB Piezotronics, Inc." },
    { 0x078A,   "The Wildflower Foundation" },
    { 0x078B,   "Optikam Tech Inc." },
    { 0x078C,   "MINIBREW HOLDING B.V" },
    { 0x078D,   "Cybex GmbH" },
    { 0x078E,   "FUJIMIC NIIGATA, INC." },
    { 0x078F,   "Hanna Instruments, Inc." },
    { 0x0790,   "KOMPAN A/S" },
    { 0x0791,   "Scosche Industries, Inc." },
    { 0x0792,   "Cricut, Inc." },
    { 0x0793,   "AEV spol. s r.o." },
    { 0x0794,   "The Coca-Cola Company" },
    { 0x0795,   "GASTEC CORPORATION" },
    { 0x0796,   "StarLeaf Ltd" },
    { 0x0797,   "Water-i.d. GmbH" },
    { 0x0798,   "HoloKit, Inc." },
    { 0x0799,   "PlantChoir Inc." },
    { 0x079A,   "GuangDong Oppo Mobile Telecommunications Corp., Ltd." },
    { 0x079B,   "CST ELECTRONICS (PROPRIETARY) LIMITED" },
    { 0x079C,   "Sky UK Limited" },
    { 0x079D,   "Digibale Pty Ltd" },
    { 0x079E,   "Smartloxx GmbH" },
    { 0x079F,   "Pune Scientific LLP" },
    { 0x07A0,   "Regent Beleuchtungskorper AG" },
    { 0x07A1,   "Apollo Neuroscience, Inc." },
    { 0x07A2,   "Roku, Inc." },
    { 0x07A4,   "Xiamen Mage Information Technology Co., Ltd." },
    { 0x07A5,   "RAB Lighting, Inc." },
    { 0x07A6,   "Musen Connect, Inc." },
    { 0x07A7,   "Zume, Inc." },
    { 0x07A8,   "conbee GmbH" },
    { 0x07A9,   "Bruel & Kjaer Sound & Vibration" },
    { 0x07AA,   "The Kroger Co." },
    { 0x07AB,   "Granite River Solutions, Inc." },
    { 0x07AC,   "LoupeDeck Oy" },
    { 0x07AD,   "New H3C Technologies Co.,Ltd" },
    { 0x07AE,   "Aurea Solucoes Tecnologicas Ltda." },
    { 0x07AF,   "Hong Kong Bouffalo Lab Limited" },
    { 0x07B0,   "GV Concepts Inc." },
    { 0x07B1,   "Thomas Dynamics, LLC" },
    { 0x07B2,   "Moeco IOT Inc." },
    { 0x07B3,   "2N TELEKOMUNIKACE a.s." },
    { 0x07B4,   "Hormann KG Antriebstechnik" },
    { 0x07B5,   "CRONO CHIP, S.L." },
    { 0x07B6,   "Soundbrenner Limited" },
    { 0x07B7,   "ETABLISSEMENTS GEORGES RENAULT" },
    { 0x07B8,   "iSwip" },
    { 0x07B9,   "Epona Biotec Limited" },
    { 0x07BA,   "Battery-Biz Inc." },
    { 0x07BB,   "EPIC S.R.L." },
    { 0x07BC,   "KD CIRCUITS LLC" },
    { 0x07BD,   "Genedrive Diagnostics Ltd" },
    { 0x07BE,   "Axentia Technologies AB" },
    { 0x07BF,   "REGULA Ltd." },
    { 0x07C0,   "Biral AG" },
    { 0x07C2,   "Radinn AB" },
    { 0x07C3,   "CIMTechniques, Inc." },
    { 0x07C4,   "Johnson Health Tech NA" },
    { 0x07C5,   "June Life, Inc." },
    { 0x07C6,   "Bluenetics GmbH" },
    { 0x07C7,   "iaconicDesign Inc." },
    { 0x07C8,   "WRLDS Creations AB" },
    { 0x07C9,   "Skullcandy, Inc." },
    { 0x07CA,   "Modul-System HH AB" },
    { 0x07CB,   "West Pharmaceutical Services, Inc." },
    { 0x07CC,   "Barnacle Systems Inc." },
    { 0x07CD,   "Smart Wave Technologies Canada Inc" },
    { 0x07CE,   "Shanghai Top-Chip Microelectronics Tech. Co., LTD" },
    { 0x07CF,   "NeoSensory, Inc." },
    { 0x07D0,   "Hangzhou Tuya Information  Technology Co., Ltd" },
    { 0x07D1,   "Shanghai Panchip Microelectronics Co., Ltd" },
    { 0x07D2,   "React Accessibility Limited" },
    { 0x07D3,   "LIVNEX Co.,Ltd." },
    { 0x07D4,   "Kano Computing Limited" },
    { 0x07D5,   "hoots classic GmbH" },
    { 0x07D6,   "ecobee Inc." },
    { 0x07D7,   "Nanjing Qinheng Microelectronics Co., Ltd" },
    { 0x07D8,   "SOLUTIONS AMBRA INC." },
    { 0x07D9,   "Micro-Design, Inc." },
    { 0x07DA,   "STARLITE Co., Ltd." },
    { 0x07DB,   "Remedee Labs" },
    { 0x07DC,   "ThingOS GmbH & Co KG" },
    { 0x07DD,   "Linear Circuits" },
    { 0x07DE,   "Unlimited Engineering SL" },
    { 0x07DF,   "Snap-on Incorporated" },
    { 0x07E0,   "Edifier International Limited" },
    { 0x07E1,   "Lucie Labs" },
    { 0x07E2,   "Alfred Kaercher SE & Co. KG" },
    { 0x07E3,   "Airoha Technology Corp." },
    { 0x07E4,   "Geeksme S.L." },
    { 0x07E5,   "Minut, Inc." },
    { 0x07E6,   "Waybeyond Limited" },
    { 0x07E7,   "Komfort IQ, Inc." },
    { 0x07E8,   "Packetcraft, Inc." },
    { 0x07E9,   "Häfele GmbH & Co KG" },
    { 0x07EA,   "ShapeLog, Inc." },
    { 0x07EB,   "NOVABASE S.R.L." },
    { 0x07EC,   "Frecce LLC" },
    { 0x07ED,   "Joule IQ, INC." },
    { 0x07EE,   "KidzTek LLC" },
    { 0x07EF,   "Aktiebolaget Sandvik Coromant" },
    { 0x07F0,   "e-moola.com Pty Ltd" },
    { 0x07F1,   "Zimi Innovations Pty Ltd" },
    { 0x07F2,   "SERENE GROUP, INC" },
    { 0x07F3,   "DIGISINE ENERGYTECH CO. LTD." },
    { 0x07F4,   "MEDIRLAB Orvosbiologiai Fejleszto Korlatolt Felelossegu Tarsasag" },
    { 0x07F5,   "Byton North America Corporation" },
    { 0x07F6,   "Shenzhen TonliScience and Technology Development Co.,Ltd" },
    { 0x07F7,   "Cesar Systems Ltd." },
    { 0x07F8,   "quip NYC Inc." },
    { 0x07F9,   "Direct Communication Solutions, Inc." },
    { 0x07FA,   "Klipsch Group, Inc." },
    { 0x07FB,   "Access Co., Ltd" },
    { 0x07FC,   "Renault SA" },
    { 0x07FD,   "JSK CO., LTD." },
    { 0x07FE,   "BIROTA" },
    { 0x07FF,   "maxon motor ltd." },
    { 0x0800,   "Optek" },
    { 0x0801,   "CRONUS ELECTRONICS LTD" },
    { 0x0802,   "NantSound, Inc." },
    { 0x0803,   "Domintell s.a." },
    { 0x0804,   "Andon Health Co.,Ltd" },
    { 0x0805,   "Urbanminded Ltd" },
    { 0x0806,   "TYRI Sweden AB" },
    { 0x0807,   "ECD Electronic Components GmbH Dresden" },
    { 0x0808,   "SISTEMAS KERN, SOCIEDAD ANÓMINA" },
    { 0x0809,   "Trulli Audio" },
    { 0x080A,   "Altaneos" },
    { 0x080B,   "Nanoleaf Canada Limited" },
    { 0x080C,   "Ingy B.V." },
    { 0x080D,   "Azbil Co." },
    { 0x080E,   "TATTCOM LLC" },
    { 0x080F,   "Paradox Engineering SA" },
    { 0x0810,   "LECO Corporation" },
    { 0x0811,   "Becker Antriebe GmbH" },
    { 0x0812,   "Mstream Technologies., Inc." },
    { 0x0813,   "Flextronics International USA Inc." },
    { 0x0814,   "Ossur hf." },
    { 0x0815,   "SKC Inc" },
    { 0x0816,   "SPICA SYSTEMS LLC" },
    { 0x0817,   "Wangs Alliance Corporation" },
    { 0x0818,   "tatwah SA" },
    { 0x0819,   "Hunter Douglas Inc" },
    { 0x081A,   "Shenzhen Conex" },
    { 0x081B,   "DIM3" },
    { 0x081C,   "Bobrick Washroom Equipment, Inc." },
    { 0x081D,   "Potrykus Holdings and Development LLC" },
    { 0x081E,   "iNFORM Technology GmbH" },
    { 0x081F,   "eSenseLab LTD" },
    { 0x0820,   "Brilliant Home Technology, Inc." },
    { 0x0821,   "INOVA Geophysical, Inc." },
    { 0x0822,   "adafruit industries" },
    { 0x0823,   "Nexite Ltd" },
    { 0x0824,   "8Power Limited" },
    { 0x0825,   "CME PTE. LTD." },
    { 0x0826,   "Hyundai Motor Company" },
    { 0x0827,   "Kickmaker" },
    { 0x0828,   "Shanghai Suisheng Information Technology Co., Ltd." },
    { 0x0829,   "HEXAGON METROLOGY DIVISION ROMER" },
    { 0x082A,   "Mitutoyo Corporation" },
    { 0x082B,   "shenzhen fitcare electronics Co.,Ltd" },
    { 0x082C,   "INGICS TECHNOLOGY CO., LTD." },
    { 0x082D,   "INCUS PERFORMANCE LTD." },
    { 0x082E,   "ABB S.p.A." },
    { 0x082F,   "Blippit AB" },
    { 0x0831,   "Foxble, LLC" },
    { 0x0832,   "Intermotive,Inc." },
    { 0x0833,   "Conneqtech B.V." },
    { 0x0834,   "RIKEN KEIKI CO., LTD.," },
    { 0x0835,   "Canopy Growth Corporation" },
    { 0x0836,   "Bitwards Oy" },
    { 0x0837,   "vivo Mobile Communication Co., Ltd." },
    { 0x0838,   "Etymotic Research, Inc." },
    { 0x0839,   "A puissance 3" },
    { 0x083A,   "BPW Bergische Achsen Kommanditgesellschaft" },
    { 0x083B,   "Piaggio Fast Forward" },
    { 0x083C,   "BeerTech LTD" },
    { 0x083D,   "Tokenize, Inc." },
    { 0x083E,   "Zorachka LTD" },
    { 0x083F,   "D-Link Corp." },
    { 0x0840,   "Down Range Systems LLC" },
    { 0x0841,   "General Luminaire (Shanghai) Co., Ltd." },
    { 0x0842,   "Tangshan HongJia electronic technology co., LTD." },
    { 0x0843,   "FRAGRANCE DELIVERY TECHNOLOGIES LTD" },
    { 0x0844,   "Pepperl + Fuchs GmbH" },
    { 0x0845,   "Dometic Corporation" },
    { 0x0846,   "USound GmbH" },
    { 0x0847,   "DNANUDGE LIMITED" },
    { 0x0848,   "JUJU JOINTS CANADA CORP." },
    { 0x0849,   "Dopple Technologies B.V." },
    { 0x084A,   "ARCOM" },
    { 0x084B,   "Biotechware SRL" },
    { 0x084C,   "ORSO Inc." },
    { 0x084D,   "SafePort" },
    { 0x084E,   "Carol Cole Company" },
    { 0x084F,   "Embedded Fitness B.V." },
    { 0x0850,   "Yealink (Xiamen) Network Technology Co.,LTD" },
    { 0x0851,   "Subeca, Inc." },
    { 0x0852,   "Cognosos, Inc." },
    { 0x0853,   "Pektron Group Limited" },
    { 0x0854,   "Tap Sound System" },
    { 0x0855,   "Helios Sports, Inc." },
    { 0x0856,   "Canopy Growth Corporation" },
    { 0x0857,   "Parsyl Inc" },
    { 0x0858,   "SOUNDBOKS" },
    { 0x0859,   "BlueUp" },
    { 0x085A,   "DAKATECH" },
    { 0x085B,   "Nisshinbo Micro Devices Inc." },
    { 0x085C,   "ACOS CO.,LTD." },
    { 0x085D,   "Guilin Zhishen Information Technology Co.,Ltd." },
    { 0x085E,   "Krog Systems LLC" },
    { 0x0860,   "Alflex Products B.V." },
    { 0x0861,   "SmartSensor Labs Ltd" },
    { 0x0862,   "SmartDrive" },
    { 0x0863,   "Yo-tronics Technology Co., Ltd." },
    { 0x0864,   "Rafaelmicro" },
    { 0x0865,   "Emergency Lighting Products Limited" },
    { 0x0866,   "LAONZ Co.,Ltd" },
    { 0x0867,   "Western Digital Techologies, Inc." },
    { 0x0868,   "WIOsense GmbH & Co. KG" },
    { 0x0869,   "EVVA Sicherheitstechnologie GmbH" },
    { 0x086A,   "Odic Incorporated" },
    { 0x086B,   "Pacific Track, LLC" },
    { 0x086C,   "Revvo Technologies, Inc." },
    { 0x086D,   "Biometrika d.o.o." },
    { 0x086E,   "Vorwerk Elektrowerke GmbH & Co. KG" },
    { 0x086F,   "Trackunit A/S" },
    { 0x0870,   "Wyze Labs, Inc" },
    { 0x0871,   "Dension Elektronikai Kft." },
    { 0x0872,   "11 Health & Technologies Limited" },
    { 0x0873,   "Innophase Incorporated" },
    { 0x0874,   "Treegreen Limited" },
    { 0x0875,   "Berner International LLC" },
    { 0x0876,   "SmartResQ ApS" },
    { 0x0877,   "Valtech" },
    { 0x0878,   "The Chamberlain Group, Inc." },
    { 0x0879,   "MIZUNO Corporation" },
    { 0x087A,   "ZRF, LLC" },
    { 0x087B,   "BYSTAMP" },
    { 0x087C,   "Crosscan GmbH" },
    { 0x087D,   "Konftel AB" },
    { 0x087E,   "1bar.net Limited" },
    { 0x087F,   "Phillips Connect Technologies LLC" },
    { 0x0880,   "imagiLabs AB" },
    { 0x0881,   "Optalert" },
    { 0x0882,   "PSYONIC, Inc." },
    { 0x0883,   "Wintersteiger AG" },
    { 0x0884,   "Controlid Industria, Comercio de Hardware e Servicos de Tecnologia Ltda" },
    { 0x0886,   "Movella Technologies B.V." },
    { 0x0887,   "Hydro-Gear Limited Partnership" },
    { 0x0888,   "EnPointe Fencing Pty Ltd" },
    { 0x0889,   "XANTHIO" },
    { 0x088A,   "sclak s.r.l." },
    { 0x088B,   "Tricorder Arraay Technologies LLC" },
    { 0x088C,   "GB Solution co.,Ltd" },
    { 0x088D,   "Soliton Systems K.K." },
    { 0x088F,   "Tait International Limited" },
    { 0x0890,   "NICHIEI INTEC CO., LTD." },
    { 0x0891,   "SmartWireless GmbH & Co. KG" },
    { 0x0892,   "Ingenieurbuero Birnfeld UG (haftungsbeschraenkt)" },
    { 0x0893,   "Maytronics Ltd" },
    { 0x0894,   "EPIFIT" },
    { 0x0895,   "Gimer medical" },
    { 0x0896,   "Nokian Renkaat Oyj" },
    { 0x0897,   "Current Lighting Solutions LLC" },
    { 0x0898,   "Sensibo, Inc." },
    { 0x0899,   "SFS unimarket AG" },
    { 0x089A,   "Private limited company \"Teltonika\"" },
    { 0x089B,   "Saucon Technologies" },
    { 0x089C,   "Embedded Devices Co. Company" },
    { 0x089D,   "J-J.A.D.E. Enterprise LLC" },
    { 0x089E,   "i-SENS, inc." },
    { 0x089F,   "Witschi Electronic Ltd" },
    { 0x08A0,   "Aclara Technologies LLC" },
    { 0x08A1,   "EXEO TECH CORPORATION" },
    { 0x08A2,   "Epic Systems Co., Ltd." },
    { 0x08A3,   "Hoffmann SE" },
    { 0x08A4,   "Realme Chongqing Mobile Telecommunications Corp., Ltd." },
    { 0x08A6,   "Intelligenceworks Inc." },
    { 0x08A7,   "TGR 1.618 Limited" },
    { 0x08A8,   "Shanghai Kfcube Inc" },
    { 0x08A9,   "Fraunhofer IIS" },
    { 0x08AA,   "SZ DJI TECHNOLOGY CO.,LTD" },
    { 0x08AB,   "Coburn Technology, LLC" },
    { 0x08AC,   "Topre Corporation" },
    { 0x08AD,   "Kayamatics Limited" },
    { 0x08AE,   "Moticon ReGo AG" },
    { 0x08AF,   "Polidea Sp. z o.o." },
    { 0x08B0,   "Trivedi Advanced Technologies LLC" },
    { 0x08B1,   "CORE|vision BV" },
    { 0x08B2,   "PF SCHWEISSTECHNOLOGIE GMBH" },
    { 0x08B3,   "IONIQ Skincare GmbH & Co. KG" },
    { 0x08B4,   "Sengled Co., Ltd." },
    { 0x08B5,   "TransferFi" },
    { 0x08B6,   "Boehringer Ingelheim Vetmedica GmbH" },
    { 0x08B7,   "ABB Inc" },
    { 0x08B8,   "Check Technology Solutions LLC" },
    { 0x08B9,   "U-Shin Ltd." },
    { 0x08BA,   "HYPER ICE, INC." },
    { 0x08BB,   "Tokai-rika co.,ltd." },
    { 0x08BC,   "Prevayl Limited" },
    { 0x08BD,   "bf1systems limited" },
    { 0x08BE,   "ubisys technologies GmbH" },
    { 0x08BF,   "SIRC Co., Ltd." },
    { 0x08C0,   "Accent Advanced Systems SLU" },
    { 0x08C1,   "Rayden.Earth LTD" },
    { 0x08C2,   "Lindinvent AB" },
    { 0x08C3,   "CHIPOLO d.o.o." },
    { 0x08C5,   "J. Wagner GmbH" },
    { 0x08C6,   "Integra Optics Inc" },
    { 0x08C7,   "Monadnock Systems Ltd." },
    { 0x08C8,   "Liteboxer Technologies Inc." },
    { 0x08C9,   "Noventa AG" },
    { 0x08CA,   "Nubia Technology Co.,Ltd." },
    { 0x08CB,   "JT INNOVATIONS LIMITED" },
    { 0x08CC,   "TGM TECHNOLOGY CO., LTD." },
    { 0x08CD,   "ifly" },
    { 0x08CE,   "ZIMI CORPORATION" },
    { 0x08CF,   "betternotstealmybike UG (with limited liability)" },
    { 0x08D0,   "ESTOM Infotech Kft." },
    { 0x08D1,   "Sensovium Inc." },
    { 0x08D2,   "Virscient Limited" },
    { 0x08D3,   "Novel Bits, LLC" },
    { 0x08D4,   "ADATA Technology Co., LTD." },
    { 0x08D5,   "KEYes" },
    { 0x08D7,   "Inovonics Corp" },
    { 0x08D8,   "WARES" },
    { 0x08D9,   "Pointr Labs Limited" },
    { 0x08DA,   "Miridia Technology Incorporated" },
    { 0x08DB,   "Tertium Technology" },
    { 0x08DC,   "SHENZHEN AUKEY E BUSINESS CO., LTD" },
    { 0x08DD,   "code-Q" },
    { 0x08DE,   "TE Connectivity Corporation" },
    { 0x08DF,   "IRIS OHYAMA CO.,LTD." },
    { 0x08E0,   "Philia Technology" },
    { 0x08E1,   "KOZO KEIKAKU ENGINEERING Inc." },
    { 0x08E2,   "Shenzhen Simo Technology co. LTD" },
    { 0x08E3,   "Republic Wireless, Inc." },
    { 0x08E4,   "Rashidov ltd" },
    { 0x08E5,   "Crowd Connected Ltd" },
    { 0x08E6,   "Eneso Tecnologia de Adaptacion S.L." },
    { 0x08E7,   "Barrot Technology Co.,Ltd." },
    { 0x08E8,   "Naonext" },
    { 0x08E9,   "Taiwan Intelligent Home Corp." },
    { 0x08EA,   "COWBELL ENGINEERING CO.,LTD." },
    { 0x08EB,   "Beijing Big Moment Technology Co., Ltd." },
    { 0x08EC,   "Denso Corporation" },
    { 0x08ED,   "IMI Hydronic Engineering International SA" },
    { 0x08EE,   "Askey Computer Corp." },
    { 0x08EF,   "Cumulus Digital Systems, Inc" },
    { 0x08F0,   "Joovv, Inc." },
    { 0x08F1,   "The L.S. Starrett Company" },
    { 0x08F2,   "Microoled" },
    { 0x08F3,   "PSP - Pauli Services & Products GmbH" },
    { 0x08F4,   "Kodimo Technologies Company Limited" },
    { 0x08F5,   "Tymtix Technologies Private Limited" },
    { 0x08F6,   "Dermal Photonics Corporation" },
    { 0x08F7,   "MTD Products Inc & Affiliates" },
    { 0x08F8,   "instagrid GmbH" },
    { 0x08F9,   "Spacelabs Medical Inc." },
    { 0x08FA,   "Troo Corporation" },
    { 0x08FB,   "Darkglass Electronics Oy" },
    { 0x08FC,   "Hill-Rom" },
    { 0x08FD,   "BioIntelliSense, Inc." },
    { 0x08FE,   "Ketronixs Sdn Bhd" },
    { 0x08FF,   "Plastimold Products, Inc" },
    { 0x0900,   "Beijing Zizai Technology Co., LTD." },
    { 0x0901,   "Lucimed" },
    { 0x0902,   "TSC Auto-ID Technology Co., Ltd." },
    { 0x0903,   "DATAMARS, Inc." },
    { 0x0904,   "SUNCORPORATION" },
    { 0x0905,   "Yandex Services AG" },
    { 0x0906,   "Scope Logistical Solutions" },
    { 0x0907,   "User Hello, LLC" },
    { 0x0908,   "Pinpoint Innovations Limited" },
    { 0x0909,   "70mai Co.,Ltd." },
    { 0x090A,   "Zhuhai Hoksi Technology CO.,LTD" },
    { 0x090B,   "EMBR labs, INC" },
    { 0x090C,   "Radiawave Technologies Co.,Ltd." },
    { 0x090D,   "IOT Invent GmbH" },
    { 0x090E,   "OPTIMUSIOT TECH LLP" },
    { 0x090F,   "VC Inc." },
    { 0x0910,   "ASR Microelectronics (Shanghai) Co., Ltd." },
    { 0x0911,   "Douglas Lighting Controls Inc." },
    { 0x0912,   "Nerbio Medical Software Platforms Inc" },
    { 0x0913,   "Braveheart Wireless, Inc." },
    { 0x0914,   "INEO-SENSE" },
    { 0x0915,   "Honda Motor Co., Ltd." },
    { 0x0916,   "Ambient Sensors LLC" },
    { 0x0917,   "ASR Microelectronics(ShenZhen)Co., Ltd." },
    { 0x0918,   "Technosphere Labs Pvt. Ltd." },
    { 0x0919,   "NO SMD LIMITED" },
    { 0x091A,   "Albertronic BV" },
    { 0x091B,   "Luminostics, Inc." },
    { 0x091C,   "Oblamatik AG" },
    { 0x091D,   "Innokind, Inc." },
    { 0x091E,   "Melbot Studios, Sociedad Limitada" },
    { 0x091F,   "Myzee Technology" },
    { 0x0921,   "KAHA PTE. LTD." },
    { 0x0922,   "Shanghai MXCHIP Information Technology Co., Ltd." },
    { 0x0923,   "JSB TECH PTE LTD" },
    { 0x0924,   "Fundacion Tecnalia Research and Innovation" },
    { 0x0925,   "Yukai Engineering Inc." },
    { 0x0926,   "Gooligum Technologies Pty Ltd" },
    { 0x0927,   "ROOQ GmbH" },
    { 0x0928,   "AiRISTA" },
    { 0x0929,   "Qingdao Haier Technology Co., Ltd." },
    { 0x092A,   "Sappl Verwaltungs- und Betriebs GmbH" },
    { 0x092B,   "TekHome" },
    { 0x092C,   "PCI Private Limited" },
    { 0x092D,   "Leggett & Platt, Incorporated" },
    { 0x092E,   "PS GmbH" },
    { 0x092F,   "C.O.B.O. SpA" },
    { 0x0930,   "James Walker RotaBolt Limited" },
    { 0x0931,   "BREATHINGS Co., Ltd." },
    { 0x0932,   "BarVision, LLC" },
    { 0x0933,   "SRAM" },
    { 0x0934,   "KiteSpring Inc." },
    { 0x0935,   "Reconnect, Inc." },
    { 0x0936,   "Elekon AG" },
    { 0x0937,   "RealThingks GmbH" },
    { 0x0938,   "Henway Technologies, LTD." },
    { 0x0939,   "ASTEM Co.,Ltd." },
    { 0x093A,   "LinkedSemi Microelectronics (Xiamen) Co., Ltd" },
    { 0x093B,   "ENSESO LLC" },
    { 0x093C,   "Xenoma Inc." },
    { 0x093D,   "Adolf Wuerth GmbH & Co KG" },
    { 0x093E,   "Catalyft Labs, Inc." },
    { 0x093F,   "JEPICO Corporation" },
    { 0x0940,   "Hero Workout GmbH" },
    { 0x0941,   "Rivian Automotive, LLC" },
    { 0x0942,   "TRANSSION HOLDINGS LIMITED" },
    { 0x0943,   "Inovonics Corp." },
    { 0x0944,   "Agitron d.o.o." },
    { 0x0945,   "Globe (Jiangsu) Co., Ltd" },
    { 0x0946,   "AMC International Alfa Metalcraft Corporation AG" },
    { 0x0947,   "First Light Technologies Ltd." },
    { 0x0948,   "Wearable Link Limited" },
    { 0x0949,   "Metronom Health Europe" },
    { 0x094A,   "Zwift, Inc." },
    { 0x094B,   "Kindeva Drug Delivery L.P." },
    { 0x094C,   "GimmiSys GmbH" },
    { 0x094D,   "tkLABS INC." },
    { 0x094E,   "PassiveBolt, Inc." },
    { 0x094F,   "Limited Liability Company \"Mikrotikls\"" },
    { 0x0950,   "Capetech" },
    { 0x0951,   "PPRS" },
    { 0x0952,   "Apptricity Corporation" },
    { 0x0953,   "LogiLube, LLC" },
    { 0x0954,   "Julbo" },
    { 0x0955,   "Breville Group" },
    { 0x0956,   "Kerlink" },
    { 0x0957,   "Ohsung Electronics" },
    { 0x0958,   "ZTE Corporation" },
    { 0x0959,   "HerdDogg, Inc" },
    { 0x095B,   "Lismore Instruments Limited" },
    { 0x095C,   "LogiLube, LLC" },
    { 0x095D,   "Electronic Theatre Controls" },
    { 0x095E,   "BioEchoNet inc." },
    { 0x095F,   "NUANCE HEARING LTD" },
    { 0x0960,   "Sena Technologies Inc." },
    { 0x0961,   "Linkura AB" },
    { 0x0962,   "GL Solutions K.K." },
    { 0x0963,   "Moonbird BV" },
    { 0x0964,   "Countrymate Technology Limited" },
    { 0x0965,   "Asahi Kasei Corporation" },
    { 0x0966,   "PointGuard, LLC" },
    { 0x0967,   "Neo Materials and Consulting Inc." },
    { 0x0968,   "Actev Motors, Inc." },
    { 0x0969,   "Woan Technology (Shenzhen) Co., Ltd." },
    { 0x096A,   "dricos, Inc." },
    { 0x096B,   "Guide ID B.V." },
    { 0x096C,   "9374-7319 Quebec inc" },
    { 0x096D,   "Gunwerks, LLC" },
    { 0x096E,   "Band Industries, inc." },
    { 0x096F,   "Lund Motion Products, Inc." },
    { 0x0970,   "IBA Dosimetry GmbH" },
    { 0x0971,   "GA" },
    { 0x0972,   "Closed Joint Stock Company \"Zavod Flometr\" (\"Zavod Flometr\" CJSC)" },
    { 0x0973,   "Popit Oy" },
    { 0x0974,   "ABEYE" },
    { 0x0975,   "BlueIOT(Beijing) Technology Co.,Ltd" },
    { 0x0976,   "Fauna Audio GmbH" },
    { 0x0977,   "TOYOTA motor corporation" },
    { 0x0978,   "ZifferEins GmbH & Co. KG" },
    { 0x0979,   "BIOTRONIK SE & Co. KG" },
    { 0x097A,   "CORE CORPORATION" },
    { 0x097B,   "CTEK Sweden AB" },
    { 0x097C,   "Thorley Industries, LLC" },
    { 0x097D,   "CLB B.V." },
    { 0x097E,   "SonicSensory Inc" },
    { 0x097F,   "ISEMAR S.R.L." },
    { 0x0980,   "DEKRA TESTING AND CERTIFICATION, S.A.U." },
    { 0x0981,   "Bernard Krone Holding SE & Co.KG" },
    { 0x0982,   "ELPRO-BUCHS AG" },
    { 0x0983,   "Feedback Sports LLC" },
    { 0x0984,   "TeraTron GmbH" },
    { 0x0985,   "Lumos Health Inc." },
    { 0x0986,   "Cello Hill, LLC" },
    { 0x0987,   "TSE BRAKES, INC." },
    { 0x0988,   "BHM-Tech Produktionsgesellschaft m.b.H" },
    { 0x0989,   "WIKA Alexander Wiegand SE & Co.KG" },
    { 0x098A,   "Biovigil" },
    { 0x098B,   "Mequonic Engineering, S.L." },
    { 0x098C,   "bGrid B.V." },
    { 0x098E,   "ADVEEZ" },
    { 0x098F,   "Aktiebolaget Regin" },
    { 0x0990,   "Anton Paar GmbH" },
    { 0x0991,   "Telenor ASA" },
    { 0x0992,   "Big Kaiser Precision Tooling Ltd" },
    { 0x0993,   "Absolute Audio Labs B.V." },
    { 0x0994,   "VT42 Pty Ltd" },
    { 0x0995,   "Bronkhorst High-Tech B.V." },
    { 0x0996,   "C. & E. Fein GmbH" },
    { 0x0997,   "NextMind" },
    { 0x0998,   "Pixie Dust Technologies, Inc." },
    { 0x0999,   "eTactica ehf" },
    { 0x099A,   "New Audio LLC" },
    { 0x099B,   "Sendum Wireless Corporation" },
    { 0x099C,   "deister electronic GmbH" },
    { 0x099D,   "YKK AP Inc." },
    { 0x099E,   "Step One Limited" },
    { 0x099F,   "Koya Medical, Inc." },
    { 0x09A0,   "Proof Diagnostics, Inc." },
    { 0x09A1,   "VOS Systems, LLC" },
    { 0x09A2,   "ENGAGENOW DATA SCIENCES PRIVATE LIMITED" },
    { 0x09A3,   "ARDUINO SA" },
    { 0x09A4,   "KUMHO ELECTRICS, INC" },
    { 0x09A5,   "Security Enhancement Systems, LLC" },
    { 0x09A6,   "BEIJING ELECTRIC VEHICLE CO.,LTD" },
    { 0x09A7,   "Paybuddy ApS" },
    { 0x09A8,   "KHN Solutions LLC" },
    { 0x09A9,   "Nippon Ceramic Co.,Ltd." },
    { 0x09AA,   "PHOTODYNAMIC INCORPORATED" },
    { 0x09AB,   "DashLogic, Inc." },
    { 0x09AC,   "Ambiq" },
    { 0x09AD,   "Narhwall Inc." },
    { 0x09AE,   "Pozyx NV" },
    { 0x09AF,   "ifLink Open Community" },
    { 0x09B0,   "Deublin Company, LLC" },
    { 0x09B1,   "BLINQY" },
    { 0x09B2,   "DYPHI" },
    { 0x09B3,   "BlueX Microelectronics Corp Ltd." },
    { 0x09B4,   "PentaLock Aps." },
    { 0x09B5,   "AUTEC Gesellschaft fuer Automationstechnik mbH" },
    { 0x09B6,   "Pegasus Technologies, Inc." },
    { 0x09B7,   "Bout Labs, LLC" },
    { 0x09B8,   "PlayerData Limited" },
    { 0x09B9,   "SAVOY ELECTRONIC LIGHTING" },
    { 0x09BA,   "Elimo Engineering Ltd" },
    { 0x09BB,   "SkyStream Corporation" },
    { 0x09BC,   "Aerosens LLC" },
    { 0x09BD,   "Centre Suisse d'Electronique et de Microtechnique SA" },
    { 0x09BE,   "Vessel Ltd." },
    { 0x09BF,   "Span.IO, Inc." },
    { 0x09C0,   "AnotherBrain inc." },
    { 0x09C1,   "Rosewill" },
    { 0x09C2,   "Universal Audio, Inc." },
    { 0x09C3,   "JAPAN TOBACCO INC." },
    { 0x09C4,   "UVISIO" },
    { 0x09C5,   "HungYi Microelectronics Co.,Ltd." },
    { 0x09C6,   "Honor Device Co., Ltd." },
    { 0x09C7,   "Combustion, LLC" },
    { 0x09C8,   "XUNTONG" },
    { 0x09C9,   "CrowdGlow Ltd" },
    { 0x09CA,   "Mobitrace" },
    { 0x09CB,   "Hx Engineering, LLC" },
    { 0x09CC,   "Senso4s d.o.o." },
    { 0x09CE,   "Julius Blum GmbH" },
    { 0x09CF,   "BlueStreak IoT, LLC" },
    { 0x09D0,   "Chess Wise B.V." },
    { 0x09D1,   "ABLEPAY TECHNOLOGIES AS" },
    { 0x09D2,   "Temperature Sensitive Solutions Systems Sweden AB" },
    { 0x09D4,   "ORBIS Inc." },
    { 0x09D5,   "GEAR RADIO ELECTRONICS CORP." },
    { 0x09D6,   "EAR TEKNIK ISITME VE ODIOMETRI CIHAZLARI SANAYI VE TICARET ANONIM SIRKETI" },
    { 0x09D7,   "Coyotta" },
    { 0x09D8,   "Synergy Tecnologia em Sistemas Ltda" },
    { 0x09D9,   "VivoSensMedical GmbH" },
    { 0x09DA,   "Nagravision SA" },
    { 0x09DB,   "Bionic Avionics Inc." },
    { 0x09DC,   "AON2 Ltd." },
    { 0x09DD,   "Innoware Development AB" },
    { 0x09DE,   "JLD Technology Solutions, LLC" },
    { 0x09DF,   "Magnus Technology Sdn Bhd" },
    { 0x09E1,   "Tag-N-Trac Inc" },
    { 0x09E2,   "Wuhan Linptech Co.,Ltd." },
    { 0x09E3,   "Friday Home Aps" },
    { 0x09E4,   "CPS AS" },
    { 0x09E5,   "Mobilogix" },
    { 0x09E6,   "Masonite Corporation" },
    { 0x09E7,   "Kabushikigaisha HANERON" },
    { 0x09E8,   "Melange Systems Pvt. Ltd." },
    { 0x09E9,   "LumenRadio AB" },
    { 0x09EA,   "Athlos Oy" },
    { 0x09EB,   "KEAN ELECTRONICS PTY LTD" },
    { 0x09EC,   "Yukon advanced optics worldwide, UAB" },
    { 0x09ED,   "Sibel Inc." },
    { 0x09EE,   "OJMAR SA" },
    { 0x09EF,   "Steinel Solutions AG" },
    { 0x09F0,   "WatchGas B.V." },
    { 0x09F1,   "OM Digital Solutions Corporation" },
    { 0x09F2,   "Audeara Pty Ltd" },
    { 0x09F3,   "Beijing Zero Zero Infinity Technology Co.,Ltd." },
    { 0x09F4,   "Spectrum Technologies, Inc." },
    { 0x09F5,   "OKI Electric Industry Co., Ltd" },
    { 0x09F6,   "Mobile Action Technology Inc." },
    { 0x09F7,   "SENSATEC Co., Ltd." },
    { 0x09F8,   "R.O. S.R.L." },
    { 0x09F9,   "Hangzhou Yaguan Technology Co. LTD" },
    { 0x09FA,   "Listen Technologies Corporation" },
    { 0x09FB,   "TOITU CO., LTD." },
    { 0x09FC,   "Confidex" },
    { 0x09FD,   "Keep Technologies, Inc." },
    { 0x09FE,   "Lichtvision Engineering GmbH" },
    { 0x09FF,   "AIRSTAR" },
    { 0x0A00,   "Ampler Bikes OU" },
    { 0x0A01,   "Cleveron AS" },
    { 0x0A02,   "Ayxon-Dynamics GmbH" },
    { 0x0A03,   "donutrobotics Co., Ltd." },
    { 0x0A04,   "Flosonics Medical" },
    { 0x0A05,   "Southwire Company, LLC" },
    { 0x0A06,   "Shanghai wuqi microelectronics Co.,Ltd" },
    { 0x0A07,   "Reflow Pty Ltd" },
    { 0x0A08,   "Oras Oy" },
    { 0x0A0A,   "Volan Technology Inc." },
    { 0x0A0B,   "SIANA Systems" },
    { 0x0A0C,   "Shanghai Yidian Intelligent Technology Co., Ltd." },
    { 0x0A0D,   "Blue Peacock GmbH" },
    { 0x0A0E,   "Roland Corporation" },
    { 0x0A0F,   "LIXIL Corporation" },
    { 0x0A10,   "SUBARU Corporation" },
    { 0x0A11,   "Sensolus" },
    { 0x0A12,   "Dyson Technology Limited" },
    { 0x0A13,   "Tec4med LifeScience GmbH" },
    { 0x0A14,   "CROXEL, INC." },
    { 0x0A15,   "Syng Inc" },
    { 0x0A16,   "RIDE VISION LTD" },
    { 0x0A17,   "Plume Design Inc" },
    { 0x0A18,   "Cambridge Animal Technologies Ltd" },
    { 0x0A19,   "Maxell, Ltd." },
    { 0x0A1A,   "Link Labs, Inc." },
    { 0x0A1B,   "Embrava Pty Ltd" },
    { 0x0A1C,   "INPEAK S.C." },
    { 0x0A1D,   "API-K" },
    { 0x0A1E,   "CombiQ AB" },
    { 0x0A1F,   "DeVilbiss Healthcare LLC" },
    { 0x0A20,   "Jiangxi Innotech Technology Co., Ltd" },
    { 0x0A21,   "Apollogic Sp. z o.o." },
    { 0x0A22,   "DAIICHIKOSHO CO., LTD." },
    { 0x0A23,   "BIXOLON CO.,LTD" },
    { 0x0A24,   "Atmosic Technologies, Inc." },
    { 0x0A25,   "Eran Financial Services LLC" },
    { 0x0A26,   "Louis Vuitton" },
    { 0x0A27,   "AYU DEVICES PRIVATE LIMITED" },
    { 0x0A28,   "NanoFlex Power Corporation" },
    { 0x0A29,   "Worthcloud Technology Co.,Ltd" },
    { 0x0A2A,   "Yamaha Corporation" },
    { 0x0A2B,   "PaceBait IVS" },
    { 0x0A2C,   "Shenzhen H&T Intelligent Control Co., Ltd" },
    { 0x0A2D,   "Shenzhen Feasycom Technology Co., Ltd." },
    { 0x0A2F,   "Instamic, Inc." },
    { 0x0A30,   "Air-Weigh" },
    { 0x0A31,   "Nevro Corp." },
    { 0x0A32,   "Pinnacle Technology, Inc." },
    { 0x0A33,   "WMF AG" },
    { 0x0A34,   "Luxer Corporation" },
    { 0x0A35,   "safectory GmbH" },
    { 0x0A36,   "NGK SPARK PLUG CO., LTD." },
    { 0x0A37,   "2587702 Ontario Inc." },
    { 0x0A38,   "Bouffalo Lab (Nanjing)., Ltd." },
    { 0x0A39,   "BLUETICKETING SRL" },
    { 0x0A3A,   "Incotex Co. Ltd." },
    { 0x0A3B,   "Galileo Technology Limited" },
    { 0x0A3C,   "Siteco GmbH" },
    { 0x0A3D,   "DELABIE" },
    { 0x0A3F,   "Shenzhen Yopeak Optoelectronics Technology Co., Ltd." },
    { 0x0A41,   "OPEX Corporation" },
    { 0x0A42,   "Motionalysis, Inc." },
    { 0x0A43,   "Busch Systems International Inc." },
    { 0x0A44,   "Novidan, Inc." },
    { 0x0A45,   "3SI Security Systems, Inc" },
    { 0x0A46,   "Beijing HC-Infinite Technology Limited" },
    { 0x0A47,   "The Wand Company Ltd" },
    { 0x0A48,   "JRC Mobility Inc." },
    { 0x0A49,   "Venture Research Inc." },
    { 0x0A4A,   "Map Large, Inc." },
    { 0x0A4B,   "MistyWest Energy and Transport Ltd." },
    { 0x0A4C,   "SiFli Technologies (shanghai) Inc." },
    { 0x0A4D,   "Lockn Technologies Private Limited" },
    { 0x0A4E,   "Toytec Corporation" },
    { 0x0A4F,   "VANMOOF Global Holding B.V." },
    { 0x0A50,   "Nextscape Inc." },
    { 0x0A51,   "CSIRO" },
    { 0x0A52,   "Follow Sense Europe B.V." },
    { 0x0A53,   "KKM COMPANY LIMITED" },
    { 0x0A54,   "SQL Technologies Corp." },
    { 0x0A55,   "Inugo Systems Limited" },
    { 0x0A56,   "ambie" },
    { 0x0A57,   "Meizhou Guo Wei Electronics Co., Ltd" },
    { 0x0A58,   "Indigo Diabetes" },
    { 0x0A59,   "TourBuilt, LLC" },
    { 0x0A5A,   "Sontheim Industrie Elektronik GmbH" },
    { 0x0A5B,   "LEGIC Identsystems AG" },
    { 0x0A5C,   "Innovative Design Labs Inc." },
    { 0x0A5D,   "MG Energy Systems B.V." },
    { 0x0A5F,   "stryker" },
    { 0x0A60,   "DATANG SEMICONDUCTOR TECHNOLOGY CO.,LTD" },
    { 0x0A61,   "Smart Parks B.V." },
    { 0x0A62,   "MOKO TECHNOLOGY Ltd" },
    { 0x0A64,   "Geopal system A/S" },
    { 0x0A65,   "Lytx, INC." },
    { 0x0A67,   "Beijing SuperHexa Century Technology CO. Ltd" },
    { 0x0A68,   "Focus Ingenieria SRL" },
    { 0x0A69,   "HAPPIEST BABY, INC." },
    { 0x0A6A,   "Scribble Design Inc." },
    { 0x0A6B,   "Olympic Ophthalmics, Inc." },
    { 0x0A6C,   "Pokkels" },
    { 0x0A6D,   "KUUKANJYOKIN Co.,Ltd." },
    { 0x0A6E,   "Pac Sane Limited" },
    { 0x0A6F,   "Warner Bros." },
    { 0x0A70,   "Ooma" },
    { 0x0A71,   "Senquip Pty Ltd" },
    { 0x0A72,   "Jumo GmbH & Co. KG" },
    { 0x0A73,   "Innohome Oy" },
    { 0x0A74,   "MICROSON S.A." },
    { 0x0A75,   "Delta Cycle Corporation" },
    { 0x0A76,   "Synaptics Incorporated" },
    { 0x0A77,   "AXTRO PTE. LTD." },
    { 0x0A78,   "Shenzhen Sunricher Technology Limited" },
    { 0x0A79,   "Webasto SE" },
    { 0x0A7A,   "Emlid Limited" },
    { 0x0A7B,   "UniqAir Oy" },
    { 0x0A7C,   "WAFERLOCK" },
    { 0x0A7D,   "Freedman Electronics Pty Ltd" },
    { 0x0A7E,   "KEBA Handover Automation GmbH" },
    { 0x0A7F,   "Intuity Medical" },
    { 0x0A80,   "Cleer Limited" },
    { 0x0A81,   "Universal Biosensors Pty Ltd" },
    { 0x0A82,   "Corsair" },
    { 0x0A83,   "Rivata, Inc." },
    { 0x0A84,   "Greennote Inc," },
    { 0x0A85,   "Snowball Technology Co., Ltd." },
    { 0x0A86,   "ALIZENT International" },
    { 0x0A87,   "Shanghai Smart System Technology Co., Ltd" },
    { 0x0A88,   "PSA Peugeot Citroen" },
    { 0x0A89,   "VusionGroup" },
    { 0x0A8A,   "HAINBUCH GMBH SPANNENDE TECHNIK" },
    { 0x0A8B,   "SANlight GmbH" },
    { 0x0A8C,   "DelpSys, s.r.o." },
    { 0x0A8D,   "JCM TECHNOLOGIES S.A." },
    { 0x0A8E,   "Perfect Company" },
    { 0x0A8F,   "TOTO LTD." },
    { 0x0A90,   "Shenzhen Grandsun Electronic Co.,Ltd." },
    { 0x0A91,   "Monarch International Inc." },
    { 0x0A92,   "Carestream Dental LLC" },
    { 0x0A93,   "GiPStech S.r.l." },
    { 0x0A94,   "OOBIK Inc." },
    { 0x0A95,   "Pamex Inc." },
    { 0x0A97,   "SensTek" },
    { 0x0A98,   "Foil, Inc." },
    { 0x0A99,   "Shanghai high-flying electronics technology Co.,Ltd" },
    { 0x0A9A,   "TEMKIN ASSOCIATES, LLC" },
    { 0x0A9B,   "Eello LLC" },
    { 0x0A9C,   "Xi'an Fengyu Information Technology Co., Ltd." },
    { 0x0A9D,   "Canon Finetech Nisca Inc." },
    { 0x0A9F,   "ista International GmbH" },
    { 0x0AA0,   "Loy Tec electronics GmbH" },
    { 0x0AA1,   "LINCOGN TECHNOLOGY CO. LIMITED" },
    { 0x0AA2,   "Care Bloom, LLC" },
    { 0x0AA3,   "DIC Corporation" },
    { 0x0AA4,   "FAZEPRO LLC" },
    { 0x0AA5,   "Shenzhen Uascent Technology Co., Ltd" },
    { 0x0AA6,   "Realityworks, inc." },
    { 0x0AA7,   "Urbanista AB" },
    { 0x0AA8,   "Zencontrol Pty Ltd" },
    { 0x0AA9,   "Spintly, Inc." },
    { 0x0AAA,   "Computime International Ltd" },
    { 0x0AAB,   "Anhui Listenai Co" },
    { 0x0AAC,   "OSM HK Limited" },
    { 0x0AAD,   "Adevo Consulting AB" },
    { 0x0AAE,   "PS Engineering, Inc." },
    { 0x0AAF,   "AIAIAI ApS" },
    { 0x0AB0,   "Visiontronic s.r.o." },
    { 0x0AB1,   "InVue Security Products Inc" },
    { 0x0AB2,   "TouchTronics, Inc." },
    { 0x0AB3,   "INNER RANGE PTY. LTD." },
    { 0x0AB4,   "Ellenby Technologies, Inc." },
    { 0x0AB5,   "Elstat Electronics Ltd." },
    { 0x0AB6,   "Xenter, Inc." },
    { 0x0AB7,   "LogTag North America Inc." },
    { 0x0AB8,   "Sens.ai Incorporated" },
    { 0x0AB9,   "STL" },
    { 0x0ABA,   "Open Bionics Ltd." },
    { 0x0ABB,   "R-DAS, s.r.o." },
    { 0x0ABC,   "KCCS Mobile Engineering Co., Ltd." },
    { 0x0ABD,   "Inventas AS" },
    { 0x0ABE,   "Robkoo Information & Technologies Co., Ltd." },
    { 0x0ABF,   "PAUL HARTMANN AG" },
    { 0x0AC0,   "Omni-ID USA, INC." },
    { 0x0AC1,   "Shenzhen Jingxun Technology Co., Ltd." },
    { 0x0AC2,   "RealMega Microelectronics technology (Shanghai) Co. Ltd." },
    { 0x0AC3,   "Kenzen, Inc." },
    { 0x0AC4,   "CODIUM" },
    { 0x0AC5,   "Flexoptix GmbH" },
    { 0x0AC6,   "Barnes Group Inc." },
    { 0x0AC7,   "Chengdu Aich Technology Co.,Ltd" },
    { 0x0AC8,   "Keepin Co., Ltd." },
    { 0x0AC9,   "Swedlock AB" },
    { 0x0ACA,   "Shenzhen CoolKit Technology Co., Ltd" },
    { 0x0ACB,   "ise Individuelle Software und Elektronik GmbH" },
    { 0x0ACC,   "Nuvoton" },
    { 0x0ACD,   "Visuallex Sport International Limited" },
    { 0x0ACE,   "KOBATA GAUGE MFG. CO., LTD." },
    { 0x0ACF,   "CACI Technologies" },
    { 0x0AD0,   "Nordic Strong ApS" },
    { 0x0AD1,   "EAGLE KINGDOM TECHNOLOGIES LIMITED" },
    { 0x0AD2,   "Lautsprecher Teufel GmbH" },
    { 0x0AD3,   "SSV Software Systems GmbH" },
    { 0x0AD4,   "Zhuhai Pantum Electronisc Co., Ltd" },
    { 0x0AD5,   "Streamit B.V." },
    { 0x0AD6,   "nymea GmbH" },
    { 0x0AD7,   "AL-KO Geraete GmbH" },
    { 0x0AD8,   "Franz Kaldewei GmbH&Co KG" },
    { 0x0AD9,   "Shenzhen Aimore. Co.,Ltd" },
    { 0x0ADA,   "Codefabrik GmbH" },
    { 0x0ADB,   "Reelables, Inc." },
    { 0x0ADC,   "Duravit AG" },
    { 0x0ADD,   "Boss Audio" },
    { 0x0ADE,   "Vocera Communications, Inc." },
    { 0x0ADF,   "Douglas Dynamics L.L.C." },
    { 0x0AE3,   "GlobalMed" },
    { 0x0AE4,   "DALI Alliance" },
    { 0x0AE5,   "unu GmbH" },
    { 0x0AE6,   "Hexology" },
    { 0x0AE7,   "Sunplus Technology Co., Ltd." },
    { 0x0AE8,   "LEVEL, s.r.o." },
    { 0x0AE9,   "FLIR Systems AB" },
    { 0x0AEA,   "Borda Technology" },
    { 0x0AEB,   "Square, Inc." },
    { 0x0AEC,   "FUTEK ADVANCED SENSOR TECHNOLOGY, INC" },
    { 0x0AED,   "Saxonar GmbH" },
    { 0x0AEE,   "Velentium, LLC" },
    { 0x0AEF,   "GLP German Light Products GmbH" },
    { 0x0AF0,   "Leupold & Stevens, Inc." },
    { 0x0AF1,   "CRADERS,CO.,LTD" },
    { 0x0AF2,   "Shanghai All Link Microelectronics Co.,Ltd" },
    { 0x0AF3,   "701x Inc." },
    { 0x0AF4,   "Radioworks Microelectronics PTY LTD" },
    { 0x0AF5,   "Unitech Electronic Inc." },
    { 0x0AF6,   "AMETEK, Inc." },
    { 0x0AF7,   "Irdeto" },
    { 0x0AF8,   "First Design System Inc." },
    { 0x0AF9,   "Unisto AG" },
    { 0x0AFA,   "Chengdu Ambit Technology Co., Ltd." },
    { 0x0AFB,   "SMT ELEKTRONIK GmbH" },
    { 0x0AFC,   "Cerebrum Sensor Technologies Inc." },
    { 0x0AFD,   "Weber Sensors, LLC" },
    { 0x0AFE,   "Earda Technologies Co.,Ltd" },
    { 0x0AFF,   "FUSEAWARE LIMITED" },
    { 0x0B00,   "Flaircomm Microelectronics Inc." },
    { 0x0B01,   "RESIDEO TECHNOLOGIES, INC." },
    { 0x0B02,   "IORA Technology Development Ltd. Sti." },
    { 0x0B03,   "Precision Triathlon Systems Limited" },
    { 0x0B05,   "Marquardt GmbH" },
    { 0x0B06,   "FAZUA GmbH" },
    { 0x0B07,   "Workaround Gmbh" },
    { 0x0B08,   "Shenzhen Qianfenyi Intelligent Technology Co., LTD" },
    { 0x0B09,   "soonisys" },
    { 0x0B0A,   "Belun Technology Company Limited" },
    { 0x0B0B,   "Sanistaal A/S" },
    { 0x0B0C,   "BluPeak" },
    { 0x0B0D,   "SANYO DENKO Co.,Ltd." },
    { 0x0B0E,   "Minebea Access Solutions Inc." },
    { 0x0B0F,   "B.E.A. S.A." },
    { 0x0B10,   "Alfa Laval Corporate AB" },
    { 0x0B11,   "ThermoWorks, Inc." },
    { 0x0B12,   "ToughBuilt Industries LLC" },
    { 0x0B13,   "IOTOOLS" },
    { 0x0B14,   "Olumee" },
    { 0x0B15,   "NAOS JAPAN K.K." },
    { 0x0B16,   "Guard RFID Solutions Inc." },
    { 0x0B17,   "SIG SAUER, INC." },
    { 0x0B18,   "DECATHLON SE" },
    { 0x0B19,   "WBS PROJECT H PTY LTD" },
    { 0x0B1A,   "Roca Sanitario, S.A." },
    { 0x0B1B,   "Enerpac Tool Group Corp." },
    { 0x0B1C,   "Nanoleq AG" },
    { 0x0B1D,   "Accelerated Systems" },
    { 0x0B1E,   "PB INC." },
    { 0x0B1F,   "Beijing ESWIN Computing Technology Co., Ltd." },
    { 0x0B20,   "TKH Security B.V." },
    { 0x0B22,   "Hygiene IQ, LLC." },
    { 0x0B23,   "iRhythm Technologies, Inc." },
    { 0x0B24,   "BeiJing ZiJie TiaoDong KeJi Co.,Ltd." },
    { 0x0B25,   "NIBROTECH LTD" },
    { 0x0B26,   "Baracoda Daily Healthtech." },
    { 0x0B27,   "Lumi United Technology Co., Ltd" },
    { 0x0B28,   "CHACON" },
    { 0x0B29,   "Tech-Venom Entertainment Private Limited" },
    { 0x0B2B,   "MAINBOT" },
    { 0x0B2C,   "ILLUMAGEAR, Inc." },
    { 0x0B2D,   "REDARC ELECTRONICS PTY LTD" },
    { 0x0B2E,   "MOCA System Inc." },
    { 0x0B2F,   "Duke Manufacturing Co" },
    { 0x0B30,   "ART SPA" },
    { 0x0B31,   "Silver Wolf Vehicles Inc." },
    { 0x0B32,   "Hala Systems, Inc." },
    { 0x0B33,   "ARMATURA LLC" },
    { 0x0B34,   "CONZUMEX INDUSTRIES PRIVATE LIMITED" },
    { 0x0B35,   "BH SENS" },
    { 0x0B36,   "SINTEF" },
    { 0x0B37,   "Omnivoltaic Energy Solutions Limited Company" },
    { 0x0B38,   "WISYCOM S.R.L." },
    { 0x0B39,   "Red 100 Lighting Co., ltd." },
    { 0x0B3A,   "Impact Biosystems, Inc." },
    { 0x0B3B,   "AIC semiconductor (Shanghai) Co., Ltd." },
    { 0x0B3C,   "Dodge Industrial, Inc." },
    { 0x0B3D,   "REALTIMEID AS" },
    { 0x0B3E,   "ISEO Serrature S.p.a." },
    { 0x0B3F,   "MindRhythm, Inc." },
    { 0x0B40,   "Havells India Limited" },
    { 0x0B41,   "Sentrax GmbH" },
    { 0x0B42,   "TSI" },
    { 0x0B43,   "INCITAT ENVIRONNEMENT" },
    { 0x0B44,   "nFore Technology Co., Ltd." },
    { 0x0B45,   "Electronic Sensors, Inc." },
    { 0x0B47,   "Gentex Corporation" },
    { 0x0B48,   "NIO USA, Inc." },
    { 0x0B49,   "SkyHawke Technologies" },
    { 0x0B4A,   "Nomono AS" },
    { 0x0B4B,   "EMS Integrators, LLC" },
    { 0x0B4C,   "BiosBob.Biz" },
    { 0x0B4D,   "Adam Hall GmbH" },
    { 0x0B4E,   "ICP Systems B.V." },
    { 0x0B4F,   "Breezi.io, Inc." },
    { 0x0B50,   "Mesh Systems LLC" },
    { 0x0B51,   "FUN FACTORY GmbH" },
    { 0x0B52,   "ZIIP Inc" },
    { 0x0B53,   "SHENZHEN KAADAS INTELLIGENT TECHNOLOGY CO.,Ltd" },
    { 0x0B54,   "Emotion Fitness GmbH & Co. KG" },
    { 0x0B55,   "H G M Automotive Electronics, Inc." },
    { 0x0B56,   "BORA - Vertriebs GmbH & Co KG" },
    { 0x0B57,   "CONVERTRONIX TECHNOLOGIES AND SERVICES LLP" },
    { 0x0B58,   "TOKAI-DENSHI INC" },
    { 0x0B5B,   "Shenzhen ImagineVision Technology Limited" },
    { 0x0B5D,   "Fujian Newland Auto-ID Tech. Co., Ltd." },
    { 0x0B5E,   "CELLCONTROL, INC." },
    { 0x0B5F,   "Rivieh, Inc." },
    { 0x0B60,   "RATOC Systems, Inc." },
    { 0x0B61,   "Sentek Pty Ltd" },
    { 0x0B62,   "NOVEA ENERGIES" },
    { 0x0B63,   "Innolux Corporation" },
    { 0x0B64,   "NingBo klite Electric Manufacture Co.,LTD" },
    { 0x0B65,   "The Apache Software Foundation" },
    { 0x0B66,   "MITSUBISHI ELECTRIC AUTOMATION (THAILAND) COMPANY LIMITED" },
    { 0x0B67,   "CleanSpace Technology Pty Ltd" },
    { 0x0B68,   "Quha oy" },
    { 0x0B69,   "Addaday" },
    { 0x0B6A,   "Dymo" },
    { 0x0B6B,   "Samsara Networks, Inc" },
    { 0x0B6C,   "Sensitech, Inc." },
    { 0x0B6D,   "SOLUM CO., LTD" },
    { 0x0B6E,   "React Mobile" },
    { 0x0B70,   "JDRF Electromag Engineering Inc" },
    { 0x0B71,   "lilbit ODM AS" },
    { 0x0B72,   "Geeknet, Inc." },
    { 0x0B73,   "HARADA INDUSTRY CO., LTD." },
    { 0x0B74,   "BQN" },
    { 0x0B75,   "Triple W Japan Inc." },
    { 0x0B76,   "MAX-co., ltd" },
    { 0x0B77,   "Aixlink(Chengdu) Co., Ltd." },
    { 0x0B78,   "FIELD DESIGN INC." },
    { 0x0B79,   "Sankyo Air Tech Co.,Ltd." },
    { 0x0B7A,   "Shenzhen KTC Technology Co.,Ltd." },
    { 0x0B7B,   "Hardcoder Oy" },
    { 0x0B7C,   "Scangrip A/S" },
    { 0x0B7D,   "FoundersLane GmbH" },
    { 0x0B7E,   "Offcode Oy" },
    { 0x0B7F,   "ICU tech GmbH" },
    { 0x0B80,   "AXELIFE" },
    { 0x0B81,   "SCM Group" },
    { 0x0B82,   "Mammut Sports Group AG" },
    { 0x0B83,   "Taiga Motors Inc." },
    { 0x0B84,   "Presidio Medical, Inc." },
    { 0x0B85,   "VIMANA TECH PTY LTD" },
    { 0x0B86,   "Trek Bicycle" },
    { 0x0B87,   "Ampetronic Ltd" },
    { 0x0B88,   "Muguang (Guangdong) Intelligent Lighting Technology Co., Ltd" },
    { 0x0B89,   "Rotronic AG" },
    { 0x0B8A,   "Seiko Instruments Inc." },
    { 0x0B8B,   "American Technology Components, Incorporated" },
    { 0x0B8C,   "MOTREX" },
    { 0x0B8D,   "Pertech Industries Inc" },
    { 0x0B8E,   "Gentle Energy Corp." },
    { 0x0B8F,   "Senscomm Semiconductor Co., Ltd." },
    { 0x0B90,   "Ineos Automotive Limited" },
    { 0x0B91,   "Alfen ICU B.V." },
    { 0x0B92,   "Citisend Solutions, SL" },
    { 0x0B93,   "Hangzhou BroadLink Technology Co., Ltd." },
    { 0x0B94,   "Dreem SAS" },
    { 0x0B96,   "Telecom Design" },
    { 0x0B97,   "SILVER TREE LABS, INC." },
    { 0x0B98,   "Gymstory B.V." },
    { 0x0B99,   "The Goodyear Tire & Rubber Company" },
    { 0x0B9A,   "Beijing Wisepool Infinite Intelligence Technology Co.,Ltd" },
    { 0x0B9C,   "Komatsu Ltd." },
    { 0x0B9D,   "Sensoria Holdings LTD" },
    { 0x0B9E,   "Audio Partnership Plc" },
    { 0x0B9F,   "Group Lotus Limited" },
    { 0x0BA0,   "Data Sciences International" },
    { 0x0BA1,   "Bunn-O-Matic Corporation" },
    { 0x0BA2,   "TireCheck GmbH" },
    { 0x0BA3,   "Sonova Consumer Hearing GmbH" },
    { 0x0BA4,   "Vervent Audio Group" },
    { 0x0BA5,   "SONICOS ENTERPRISES, LLC" },
    { 0x0BA6,   "Nissan Motor Co., Ltd." },
    { 0x0BA7,   "hearX Group (Pty) Ltd" },
    { 0x0BA8,   "GLOWFORGE INC." },
    { 0x0BA9,   "Allterco Robotics ltd" },
    { 0x0BAA,   "Infinitegra, Inc." },
    { 0x0BAB,   "Grandex International Corporation" },
    { 0x0BAC,   "Machfu Inc." },
    { 0x0BAD,   "Roambotics, Inc." },
    { 0x0BAE,   "Soma Labs LLC" },
    { 0x0BAF,   "NITTO KOGYO CORPORATION" },
    { 0x0BB0,   "Ecolab Inc." },
    { 0x0BB1,   "Beijing ranxin intelligence technology Co.,LTD" },
    { 0x0BB2,   "Fjorden Electra AS" },
    { 0x0BB3,   "Flender GmbH" },
    { 0x0BB4,   "New Cosmos USA, Inc." },
    { 0x0BB5,   "Xirgo Technologies, LLC" },
    { 0x0BB6,   "Build With Robots Inc." },
    { 0x0BB7,   "IONA Tech LLC" },
    { 0x0BB8,   "INNOVAG PTY. LTD." },
    { 0x0BB9,   "SaluStim Group Oy" },
    { 0x0BBA,   "Huso, INC" },
    { 0x0BBB,   "SWISSINNO SOLUTIONS AG" },
    { 0x0BBC,   "T2REALITY SOLUTIONS PRIVATE LIMITED" },
    { 0x0BBE,   "SAAB Aktiebolag" },
    { 0x0BBF,   "HIMSA II K/S" },
    { 0x0BC0,   "READY FOR SKY LLP" },
    { 0x0BC1,   "Miele & Cie. KG" },
    { 0x0BC2,   "EntWick Co." },
    { 0x0BC3,   "MCOT INC." },
    { 0x0BC4,   "TECHTICS ENGINEERING B.V." },
    { 0x0BC5,   "Aperia Technologies, Inc." },
    { 0x0BC6,   "TCL COMMUNICATION EQUIPMENT CO.,LTD." },
    { 0x0BC7,   "Signtle Inc." },
    { 0x0BC8,   "OTF Distribution, LLC" },
    { 0x0BC9,   "Neuvatek Inc." },
    { 0x0BCA,   "Perimeter Technologies, Inc." },
    { 0x0BCB,   "Divesoft s.r.o." },
    { 0x0BCC,   "Sylvac sa" },
    { 0x0BCD,   "Amiko srl" },
    { 0x0BCE,   "Neurosity, Inc." },
    { 0x0BCF,   "LL Tec Group LLC" },
    { 0x0BD0,   "Durag GmbH" },
    { 0x0BD1,   "Hubei Yuan Times Technology Co., Ltd." },
    { 0x0BD2,   "IDEC" },
    { 0x0BD3,   "Procon Analytics, LLC" },
    { 0x0BD4,   "ndd Medizintechnik AG" },
    { 0x0BD5,   "Super B Lithium Power B.V." },
    { 0x0BD6,   "Shenzhen Injoinic Technology Co., Ltd." },
    { 0x0BD7,   "VINFAST TRADING AND PRODUCTION JOINT STOCK COMPANY" },
    { 0x0BD8,   "PURA SCENTS, INC." },
    { 0x0BDA,   "Aardex Ltd." },
    { 0x0BDB,   "CHAR-BROIL, LLC" },
    { 0x0BDC,   "Ledworks S.r.l." },
    { 0x0BDD,   "Coroflo Limited" },
    { 0x0BDE,   "Yale" },
    { 0x0BDF,   "WINKEY ENTERPRISE (HONG KONG) LIMITED" },
    { 0x0BE0,   "Koizumi Lighting Technology corp." },
    { 0x0BE2,   "OTC engineering" },
    { 0x0BE3,   "Comtel Systems Ltd." },
    { 0x0BE4,   "Deepfield Connect GmbH" },
    { 0x0BE5,   "ZWILLING J.A. Henckels Aktiengesellschaft" },
    { 0x0BE6,   "Puratap Pty Ltd" },
    { 0x0BE7,   "Fresnel Technologies, Inc." },
    { 0x0BE8,   "Sensormate AG" },
    { 0x0BE9,   "Shindengen Electric Manufacturing Co., Ltd." },
    { 0x0BEA,   "Twenty Five Seven, prodaja in storitve, d.o.o." },
    { 0x0BEB,   "Luna Health, Inc." },
    { 0x0BEC,   "Miracle-Ear, Inc." },
    { 0x0BED,   "CORAL-TAIYI Co. Ltd." },
    { 0x0BEE,   "LINKSYS USA, INC." },
    { 0x0BEF,   "Safetytest GmbH" },
    { 0x0BF0,   "KIDO SPORTS CO., LTD." },
    { 0x0BF1,   "Site IQ LLC" },
    { 0x0BF2,   "Angel Medical Systems, Inc." },
    { 0x0BF3,   "PONE BIOMETRICS AS" },
    { 0x0BF5,   "T5 tek, Inc." },
    { 0x0BF6,   "greenTEG AG" },
    { 0x0BF7,   "Wacker Neuson SE" },
    { 0x0BF8,   "Innovacionnye Resheniya" },
    { 0x0BFA,   "CleanBands Systems Ltd." },
    { 0x0BFB,   "Dodam Enersys Co., Ltd" },
    { 0x0BFC,   "T+A elektroakustik GmbH & Co.KG" },
    { 0x0BFD,   "Esmé Solutions" },
    { 0x0BFE,   "Media-Cartec GmbH" },
    { 0x0BFF,   "Ratio Electric BV" },
    { 0x0C00,   "MQA Limited" },
    { 0x0C01,   "NEOWRK SISTEMAS INTELIGENTES S.A." },
    { 0x0C02,   "Loomanet, Inc." },
    { 0x0C03,   "Puff Corp" },
    { 0x0C04,   "Happy Health, Inc." },
    { 0x0C05,   "Montage Connect, Inc." },
    { 0x0C06,   "LED Smart Inc." },
    { 0x0C07,   "CONSTRUKTS, INC." },
    { 0x0C08,   "limited liability company \"Red\"" },
    { 0x0C09,   "Senic Inc." },
    { 0x0C0A,   "Automated Pet Care Products, LLC" },
    { 0x0C0B,   "aconno GmbH" },
    { 0x0C0C,   "Mendeltron, Inc." },
    { 0x0C0D,   "Mereltron bv" },
    { 0x0C0E,   "ALEX DENKO CO.,LTD." },
    { 0x0C0F,   "AETERLINK" },
    { 0x0C10,   "Cosmed s.r.l." },
    { 0x0C11,   "Gordon Murray Design Limited" },
    { 0x0C12,   "IoSA" },
    { 0x0C13,   "Scandinavian Health Limited" },
    { 0x0C14,   "Fasetto, Inc." },
    { 0x0C15,   "Geva Sol B.V." },
    { 0x0C16,   "TYKEE PTY. LTD." },
    { 0x0C17,   "SomnoMed Limited" },
    { 0x0C18,   "CORROHM" },
    { 0x0C19,   "Arlo Technologies, Inc." },
    { 0x0C1A,   "Catapult Group International Ltd" },
    { 0x0C1B,   "Rockchip Electronics Co., Ltd." },
    { 0x0C1C,   "GEMU" },
    { 0x0C1D,   "OFF Line Japan Co., Ltd." },
    { 0x0C1E,   "EC sense co., Ltd" },
    { 0x0C1F,   "LVI Co." },
    { 0x0C20,   "COMELIT GROUP S.P.A." },
    { 0x0C21,   "Foshan Viomi Electrical Technology Co., Ltd" },
    { 0x0C22,   "Glamo Inc." },
    { 0x0C23,   "KEYTEC,Inc." },
    { 0x0C24,   "SMARTD TECHNOLOGIES INC." },
    { 0x0C25,   "JURA Elektroapparate AG" },
    { 0x0C26,   "Performance Electronics, Ltd." },
    { 0x0C27,   "Pal Electronics" },
    { 0x0C28,   "Embecta Corp." },
    { 0x0C29,   "DENSO AIRCOOL CORPORATION" },
    { 0x0C2A,   "Caresix Inc." },
    { 0x0C2B,   "GigaDevice Semiconductor Inc." },
    { 0x0C2C,   "Zeku Technology (Shanghai) Corp., Ltd." },
    { 0x0C2D,   "OTF Product Sourcing, LLC" },
    { 0x0C2E,   "Easee AS" },
    { 0x0C2F,   "BEEHERO, INC." },
    { 0x0C30,   "McIntosh Group Inc" },
    { 0x0C31,   "KINDOO LLP" },
    { 0x0C32,   "Xian Yisuobao Electronic Technology Co., Ltd." },
    { 0x0C33,   "Exeger Operations AB" },
    { 0x0C34,   "BYD Company Limited" },
    { 0x0C35,   "Thermokon-Sensortechnik GmbH" },
    { 0x0C37,   "SignalQuest, LLC" },
    { 0x0C38,   "Noritz Corporation." },
    { 0x0C39,   "TIGER CORPORATION" },
    { 0x0C3B,   "ORB Innovations Ltd" },
    { 0x0C3C,   "Classified Cycling" },
    { 0x0C3D,   "Wrmth Corp." },
    { 0x0C3E,   "BELLDESIGN Inc." },
    { 0x0C3F,   "Stinger Equipment, Inc." },
    { 0x0C40,   "HORIBA, Ltd." },
    { 0x0C41,   "Control Solutions LLC" },
    { 0x0C42,   "Heath Consultants Inc." },
    { 0x0C43,   "Berlinger & Co. AG" },
    { 0x0C44,   "ONCELABS LLC" },
    { 0x0C45,   "Brose Verwaltung SE, Bamberg" },
    { 0x0C46,   "Granwin IoT Technology (Guangzhou) Co.,Ltd" },
    { 0x0C47,   "Epsilon Electronics,lnc" },
    { 0x0C48,   "VALEO MANAGEMENT SERVICES" },
    { 0x0C49,   "twopounds gmbh" },
    { 0x0C4A,   "atSpiro ApS" },
    { 0x0C4B,   "ADTRAN, Inc." },
    { 0x0C4C,   "Orpyx Medical Technologies Inc." },
    { 0x0C4D,   "Seekwave Technology Co.,ltd." },
    { 0x0C4E,   "Tactile Engineering, Inc." },
    { 0x0C4F,   "SharkNinja Operating LLC" },
    { 0x0C50,   "Imostar Technologies Inc." },
    { 0x0C51,   "INNOVA S.R.L." },
    { 0x0C52,   "ESCEA LIMITED" },
    { 0x0C53,   "Taco, Inc." },
    { 0x0C54,   "HiViz Lighting, Inc." },
    { 0x0C55,   "Zintouch B.V." },
    { 0x0C56,   "Rheem Sales Company, Inc." },
    { 0x0C57,   "UNEEG medical A/S" },
    { 0x0C58,   "Hykso Inc." },
    { 0x0C59,   "CYBERDYNE Inc." },
    { 0x0C5A,   "Lockswitch Sdn Bhd" },
    { 0x0C5B,   "Alban Giacomo S.P.A." },
    { 0x0C5C,   "MGM WIRELESSS HOLDINGS PTY LTD" },
    { 0x0C5D,   "StepUp Solutions ApS" },
    { 0x0C5E,   "BlueID GmbH" },
    { 0x0C5F,   "Wuxi Linkpower Microelectronics Co.,Ltd" },
    { 0x0C60,   "KEBA Energy Automation GmbH" },
    { 0x0C61,   "NNOXX, Inc" },
    { 0x0C62,   "Phiaton Corporation" },
    { 0x0C63,   "phg Peter Hengstler GmbH + Co. KG" },
    { 0x0C64,   "dormakaba Holding AG" },
    { 0x0C65,   "WAKO CO,.LTD" },
    { 0x0C67,   "TRACKTING S.R.L." },
    { 0x0C68,   "Emerja Corporation" },
    { 0x0C69,   "BLITZ electric motors. LTD" },
    { 0x0C6A,   "CONSORCIO TRUST CONTROL - NETTEL" },
    { 0x0C6B,   "GILSON SAS" },
    { 0x0C6C,   "SNIFF LOGIC LTD" },
    { 0x0C6D,   "Fidure Corp." },
    { 0x0C6E,   "Sensa LLC" },
    { 0x0C6F,   "Parakey AB" },
    { 0x0C70,   "SCARAB SOLUTIONS LTD" },
    { 0x0C71,   "BitGreen Technolabz (OPC) Private Limited" },
    { 0x0C72,   "StreetCar ORV, LLC" },
    { 0x0C73,   "Truma Gerätetechnik GmbH & Co. KG" },
    { 0x0C74,   "yupiteru" },
    { 0x0C75,   "Embedded Engineering Solutions LLC" },
    { 0x0C77,   "TEAC Corporation" },
    { 0x0C78,   "CHARGTRON IOT PRIVATE LIMITED" },
    { 0x0C79,   "Zhuhai Smartlink Technology Co., Ltd" },
    { 0x0C7A,   "Triductor Technology (Suzhou), Inc." },
    { 0x0C7B,   "PT SADAMAYA GRAHA TEKNOLOGI" },
    { 0x0C7C,   "Mopeka Products LLC" },
    { 0x0C7D,   "3ALogics, Inc." },
    { 0x0C7F,   "Rochester Sensors, LLC" },
    { 0x0C80,   "CARDIOID - TECHNOLOGIES, LDA" },
    { 0x0C81,   "Carrier Corporation" },
    { 0x0C82,   "NACON" },
    { 0x0C83,   "Watchdog Systems LLC" },
    { 0x0C84,   "MAXON INDUSTRIES, INC." },
    { 0x0C85,   "Amlogic, Inc." },
    { 0x0C86,   "Qingdao Eastsoft Communication Technology Co.,Ltd" },
    { 0x0C87,   "Weltek Technologies Company Limited" },
    { 0x0C88,   "Nextivity Inc." },
    { 0x0C89,   "AGZZX OPTOELECTRONICS TECHNOLOGY CO., LTD" },
    { 0x0C8A,   "A.GLOBAL co.,Ltd." },
    { 0x0C8B,   "Heavys Inc" },
    { 0x0C8C,   "T-Mobile USA" },
    { 0x0C8D,   "tonies GmbH" },
    { 0x0C8E,   "Technocon Engineering Ltd." },
    { 0x0C8F,   "Radar Automobile Sales(Shandong)Co.,Ltd." },
    { 0x0C90,   "WESCO AG" },
    { 0x0C91,   "Yashu Systems" },
    { 0x0C92,   "Kesseböhmer Ergonomietechnik GmbH" },
    { 0x0C93,   "Movesense Oy" },
    { 0x0C94,   "Baxter Healthcare Corporation" },
    { 0x0C95,   "Gemstone Lights Canada Ltd." },
    { 0x0C96,   "H+B Hightech GmbH" },
    { 0x0C97,   "Deako" },
    { 0x0C98,   "MiX Telematics International (PTY) LTD" },
    { 0x0C99,   "Vire Health Oy" },
    { 0x0C9A,   "ALF Inc." },
    { 0x0C9B,   "NTT sonority, Inc." },
    { 0x0C9C,   "Sunstone-RTLS Ipari Szolgaltato Korlatolt Felelossegu Tarsasag" },
    { 0x0C9D,   "Ribbiot, INC." },
    { 0x0C9E,   "ECCEL CORPORATION SAS" },
    { 0x0C9F,   "Dragonfly Energy Corp." },
    { 0x0CA0,   "BIGBEN" },
    { 0x0CA1,   "YAMAHA MOTOR CO.,LTD." },
    { 0x0CA2,   "XSENSE LTD" },
    { 0x0CA3,   "MAQUET GmbH" },
    { 0x0CA4,   "MITSUBISHI ELECTRIC LIGHTING CO, LTD" },
    { 0x0CA5,   "Princess Cruise Lines, Ltd." },
    { 0x0CA6,   "Megger Ltd" },
    { 0x0CA7,   "Verve InfoTec Pty Ltd" },
    { 0x0CA8,   "Sonas, Inc." },
    { 0x0CA9,   "Mievo Technologies Private Limited" },
    { 0x0CAA,   "Shenzhen Poseidon Network Technology Co., Ltd" },
    { 0x0CAB,   "HERUTU ELECTRONICS CORPORATION" },
    { 0x0CAC,   "Shenzhen Shokz Co.,Ltd." },
    { 0x0CAD,   "Shenzhen Openhearing Tech CO., LTD ." },
    { 0x0CAE,   "Evident Corporation" },
    { 0x0CAF,   "NEURINNOV" },
    { 0x0CB0,   "SwipeSense, Inc." },
    { 0x0CB1,   "RF Creations" },
    { 0x0CB2,   "SHINKAWA Sensor Technology, Inc." },
    { 0x0CB3,   "janova GmbH" },
    { 0x0CB4,   "Eberspaecher Climate Control Systems GmbH" },
    { 0x0CB5,   "Racketry, d. o. o." },
    { 0x0CB6,   "THE EELECTRIC MACARON LLC" },
    { 0x0CB7,   "Cucumber Lighting Controls Limited" },
    { 0x0CB9,   "seca GmbH & Co. KG" },
    { 0x0CBA,   "Ameso Tech (OPC) Private Limited" },
    { 0x0CBB,   "Emlid Tech Kft." },
    { 0x0CBC,   "TROX GmbH" },
    { 0x0CBD,   "Pricer AB" },
    { 0x0CBF,   "Forward Thinking Systems LLC." },
    { 0x0CC0,   "Garnet Instruments Ltd." },
    { 0x0CC1,   "CLEIO Inc." },
    { 0x0CC2,   "Anker Innovations Limited" },
    { 0x0CC3,   "HMD Global Oy" },
    { 0x0CC4,   "ABUS August Bremicker Soehne Kommanditgesellschaft" },
    { 0x0CC5,   "Open Road Solutions, Inc." },
    { 0x0CC6,   "Serial Technology Corporation" },
    { 0x0CC7,   "SB C&S Corp." },
    { 0x0CC8,   "TrikThom" },
    { 0x0CC9,   "Innocent Technology Co., Ltd." },
    { 0x0CCA,   "Cyclops Marine Ltd" },
    { 0x0CCB,   "NOTHING TECHNOLOGY LIMITED" },
    { 0x0CCC,   "Kord Defence Pty Ltd" },
    { 0x0CCD,   "YanFeng Visteon(Chongqing) Automotive Electronic Co.,Ltd" },
    { 0x0CCE,   "SENOSPACE LLC" },
    { 0x0CCF,   "Shenzhen CESI Information Technology Co., Ltd." },
    { 0x0CD0,   "MooreSilicon Semiconductor Technology (Shanghai) Co., LTD." },
    { 0x0CD1,   "Imagine Marketing Limited" },
    { 0x0CD2,   "EQOM SSC B.V." },
    { 0x0CD3,   "TechSwipe" },
    { 0x0CD4,   "Reoqoo IoT Technology Co., Ltd." },
    { 0x0CD5,   "Numa Products, LLC" },
    { 0x0CD6,   "HHO (Hangzhou) Digital Technology Co., Ltd." },
    { 0x0CD7,   "Maztech Industries, LLC" },
    { 0x0CD8,   "SIA Mesh Group" },
    { 0x0CD9,   "Minami acoustics Limited" },
    { 0x0CDA,   "Wolf Steel ltd" },
    { 0x0CDB,   "Circus World Displays Limited" },
    { 0x0CDC,   "Ypsomed AG" },
    { 0x0CDD,   "Alif Semiconductor, Inc." },
    { 0x0CDF,   "SHENZHEN CHENYUN ELECTRONICS  CO., LTD" },
    { 0x0CE0,   "VODALOGIC PTY LTD" },
    { 0x0CE1,   "Regal Beloit America, Inc." },
    { 0x0CE2,   "CORVENT MEDICAL, INC." },
    { 0x0CE3,   "Taiwan Fuhsing" },
    { 0x0CE4,   "Off-Highway Powertrain Services Germany GmbH" },
    { 0x0CE5,   "Amina Distribution AS" },
    { 0x0CE6,   "McWong International, Inc." },
    { 0x0CE7,   "TAG HEUER SA" },
    { 0x0CE8,   "Dongguan Yougo Electronics Co.,Ltd." },
    { 0x0CE9,   "PEAG, LLC dba JLab Audio" },
    { 0x0CEA,   "HAYWARD INDUSTRIES, INC." },
    { 0x0CEB,   "Shenzhen Tingting Technology Co. LTD" },
    { 0x0CEC,   "Pacific Coast Fishery Services (2003) Inc." },
    { 0x0CED,   "CV. NURI TEKNIK" },
    { 0x0CEE,   "MadgeTech, Inc" },
    { 0x0CEF,   "POGS B.V." },
    { 0x0CF0,   "THOTAKA TEKHNOLOGIES INDIA PRIVATE LIMITED" },
    { 0x0CF1,   "Midmark" },
    { 0x0CF3,   "Radio Sound" },
    { 0x0CF4,   "SOLUX PTY LTD" },
    { 0x0CF5,   "BOS Balance of Storage Systems AG" },
    { 0x0CF6,   "OJ Electronics A/S" },
    { 0x0CF7,   "TVS Motor Company Ltd." },
    { 0x0CF8,   "core sensing GmbH" },
    { 0x0CF9,   "Tamblue Oy" },
    { 0x0CFA,   "Protect Animals With Satellites LLC" },
    { 0x0CFB,   "Tyromotion GmbH" },
    { 0x0CFC,   "ElectronX design" },
    { 0x0CFE,   "Thule Group AB" },
    { 0x0CFF,   "Ergodriven Inc" },
    { 0x0D00,   "Sparkpark AS" },
    { 0x0D01,   "KEEPEN" },
    { 0x0D02,   "Rocky Mountain ATV/MC Jake Wilson" },
    { 0x0D03,   "MakuSafe Corp" },
    { 0x0D04,   "Bartec Auto Id Ltd" },
    { 0x0D05,   "Energy Technology and Control Limited" },
    { 0x0D06,   "doubleO Co., Ltd." },
    { 0x0D07,   "Datalogic S.r.l." },
    { 0x0D08,   "Datalogic USA, Inc." },
    { 0x0D09,   "Leica Geosystems AG" },
    { 0x0D0A,   "CATEYE Co., Ltd." },
    { 0x0D0B,   "Research Products Corporation" },
    { 0x0D0C,   "Planmeca Oy" },
    { 0x0D0D,   "C.Ed. Schulte GmbH Zylinderschlossfabrik" },
    { 0x0D0E,   "PetVoice Co., Ltd." },
    { 0x0D0F,   "Timebirds Australia Pty Ltd" },
    { 0x0D10,   "JVC KENWOOD Corporation" },
    { 0x0D12,   "Spartek Systems Inc." },
    { 0x0D13,   "MERRY ELECTRONICS CO., LTD." },
    { 0x0D14,   "Merry Electronics (S) Pte Ltd" },
    { 0x0D15,   "Spark" },
    { 0x0D16,   "Nations Technologies Inc." },
    { 0x0D17,   "Akix S.r.l." },
    { 0x0D18,   "Bioliberty Ltd" },
    { 0x0D19,   "C.G. Air Systemes Inc." },
    { 0x0D1A,   "Maturix ApS" },
    { 0x0D1B,   "RACHIO, INC." },
    { 0x0D1C,   "LIMBOID LLC" },
    { 0x0D1D,   "Electronics4All Inc." },
    { 0x0D1E,   "FESTINA LOTUS SA" },
    { 0x0D1F,   "Synkopi, Inc." },
    { 0x0D20,   "SCIENTERRA LIMITED" },
    { 0x0D21,   "Cennox Group Limited" },
    { 0x0D22,   "Cedarware, Corp." },
    { 0x0D23,   "GREE Electric Appliances, Inc. of Zhuhai" },
    { 0x0D24,   "Japan Display Inc." },
    { 0x0D25,   "System Elite Holdings Group Limited" },
    { 0x0D26,   "Burkert Werke GmbH & Co. KG" },
    { 0x0D27,   "velocitux" },
    { 0x0D28,   "FUJITSU COMPONENT LIMITED" },
    { 0x0D29,   "MIYAKAWA ELECTRIC WORKS LTD." },
    { 0x0D2A,   "PhysioLogic Devices, Inc." },
    { 0x0D2B,   "Sensoryx AG" },
    { 0x0D2C,   "SIL System Integration Laboratory GmbH" },
    { 0x0D2D,   "Cooler Pro, LLC" },
    { 0x0D2E,   "Advanced Electronic Applications, Inc" },
    { 0x0D2F,   "Delta Development Team, Inc" },
    { 0x0D30,   "Laxmi Therapeutic Devices, Inc." },
    { 0x0D31,   "SYNCHRON, INC." },
    { 0x0D32,   "Badger Meter" },
    { 0x0D33,   "Micropower Group AB" },
    { 0x0D34,   "ZILLIOT TECHNOLOGIES PRIVATE LIMITED" },
    { 0x0D35,   "Universidad Politecnica de Madrid" },
    { 0x0D36,   "XIHAO INTELLIGENGT TECHNOLOGY CO., LTD" },
    { 0x0D37,   "Zerene Inc." },
    { 0x0D38,   "CycLock" },
    { 0x0D39,   "Systemic Games, LLC" },
    { 0x0D3A,   "Frost Solutions, LLC" },
    { 0x0D3B,   "Lone Star Marine Pty Ltd" },
    { 0x0D3C,   "SIRONA Dental Systems GmbH" },
    { 0x0D3D,   "bHaptics Inc." },
    { 0x0D3E,   "LUMINOAH, INC." },
    { 0x0D3F,   "Vogels Products B.V." },
    { 0x0D40,   "SignalFire Telemetry, Inc." },
    { 0x0D41,   "CPAC Systems AB" },
    { 0x0D42,   "TEKTRO TECHNOLOGY CORPORATION" },
    { 0x0D43,   "Gosuncn Technology Group Co., Ltd." },
    { 0x0D44,   "Ex Makhina Inc." },
    { 0x0D45,   "Odeon, Inc." },
    { 0x0D46,   "Thales Simulation & Training AG" },
    { 0x0D47,   "Shenzhen DOKE Electronic Co., Ltd" },
    { 0x0D48,   "Vemcon GmbH" },
    { 0x0D49,   "Refrigerated Transport Electronics, Inc." },
    { 0x0D4A,   "Rockpile Solutions, LLC" },
    { 0x0D4B,   "Soundwave Hearing, LLC" },
    { 0x0D4D,   "Optec, LLC" },
    { 0x0D4E,   "NIKAT SOLUTIONS PRIVATE LIMITED" },
    { 0x0D4F,   "Movano Inc." },
    { 0x0D50,   "NINGBO FOTILE KITCHENWARE CO., LTD." },
    { 0x0D51,   "Genetus inc." },
    { 0x0D52,   "DIVAN TRADING CO., LTD." },
    { 0x0D53,   "Luxottica Group S.p.A" },
    { 0x0D54,   "ISEKI FRANCE S.A.S" },
    { 0x0D55,   "NO CLIMB PRODUCTS LTD" },
    { 0x0D56,   "Wellang.Co,.Ltd" },
    { 0x0D57,   "Nanjing Xinxiangyuan Microelectronics Co., Ltd." },
    { 0x0D58,   "ifm electronic gmbh" },
    { 0x0D59,   "HYUPSUNG MACHINERY ELECTRIC CO., LTD." },
    { 0x0D5A,   "Gunnebo Aktiebolag" },
    { 0x0D5B,   "Axis Communications AB" },
    { 0x0D5D,   "Stogger B.V." },
    { 0x0D5E,   "Pella Corp" },
    { 0x0D5F,   "SiChuan Homme Intelligent Technology co.,Ltd." },
    { 0x0D60,   "Smart Products Connection, S.A." },
    { 0x0D61,   "F.I.P. FORMATURA INIEZIONE POLIMERI - S.P.A." },
    { 0x0D62,   "MEBSTER s.r.o." },
    { 0x0D63,   "SKF France" },
    { 0x0D64,   "Southco" },
    { 0x0D65,   "Molnlycke Health Care AB" },
    { 0x0D66,   "Hendrickson USA , L.L.C" },
    { 0x0D67,   "BLACK BOX NETWORK SERVICES INDIA PRIVATE LIMITED" },
    { 0x0D68,   "Status Audio LLC" },
    { 0x0D69,   "AIR AROMA INTERNATIONAL PTY LTD" },
    { 0x0D6A,   "Helge Kaiser GmbH" },
    { 0x0D6B,   "Crane Payment Innovations, Inc." },
    { 0x0D6C,   "Ambient IoT Pty Ltd" },
    { 0x0D6D,   "DYNAMOX S/A" },
    { 0x0D6E,   "Look Cycle International" },
    { 0x0D6F,   "Closed Joint Stock Company NVP BOLID" },
    { 0x0D70,   "Kindhome" },
    { 0x0D71,   "Kiteras Inc." },
    { 0x0D72,   "Earfun Technology (HK) Limited" },
    { 0x0D73,   "iota Biosciences, Inc." },
    { 0x0D74,   "ANUME s.r.o." },
    { 0x0D75,   "Indistinguishable From Magic, Inc." },
    { 0x0D76,   "i-focus Co.,Ltd" },
    { 0x0D77,   "DualNetworks SA" },
    { 0x0D78,   "MITACHI CO.,LTD." },
    { 0x0D79,   "VIVIWARE JAPAN, Inc." },
    { 0x0D7A,   "Xiamen Intretech Inc." },
    { 0x0D7B,   "MindMaze SA" },
    { 0x0D7C,   "BeiJing SmartChip Microelectronics Technology Co.,Ltd" },
    { 0x0D7D,   "Taiko Audio B.V." },
    { 0x0D7E,   "Daihatsu Motor Co., Ltd." },
    { 0x0D7F,   "Konova" },
    { 0x0D80,   "Gravaa B.V." },
    { 0x0D81,   "Beyerdynamic GmbH & Co. KG" },
    { 0x0D82,   "VELCO" },
    { 0x0D83,   "ATLANTIC SOCIETE FRANCAISE DE DEVELOPPEMENT THERMIQUE" },
    { 0x0D84,   "Testo SE & Co. KGaA" },
    { 0x0D85,   "SEW-EURODRIVE GmbH & Co KG" },
    { 0x0D86,   "ROCKWELL AUTOMATION, INC." },
    { 0x0D87,   "Quectel Wireless Solutions Co., Ltd." },
    { 0x0D89,   "Nanohex Corp" },
    { 0x0D8A,   "Simply Embedded Inc." },
    { 0x0D8B,   "Software Development, LLC" },
    { 0x0D8C,   "Ultimea Technology (Shenzhen) Limited" },
    { 0x0D8D,   "RF Electronics Limited" },
    { 0x0D8E,   "Optivolt Labs, Inc." },
    { 0x0D8F,   "Canon Electronics Inc." },
    { 0x0D90,   "LAAS ApS" },
    { 0x0D91,   "Beamex Oy Ab" },
    { 0x0D92,   "TACHIKAWA CORPORATION" },
    { 0x0D93,   "HagerEnergy GmbH" },
    { 0x0D95,   "Hunter Industries Incorporated" },
    { 0x0D96,   "NEOKOHM SISTEMAS ELETRONICOS LTDA" },
    { 0x0D97,   "Zhejiang Huanfu Technology Co., LTD" },
    { 0x0D98,   "E.F. Johnson Company" },
    { 0x0D99,   "Caire Inc." },
    { 0x0D9A,   "Yeasound (Xiamen) Hearing Technology Co., Ltd" },
    { 0x0D9B,   "Boxyz, Inc." },
    { 0x0D9C,   "Skytech Creations Limited" },
    { 0x0D9D,   "Cear, Inc." },
    { 0x0D9E,   "Impulse Wellness LLC" },
    { 0x0D9F,   "MML US, Inc" },
    { 0x0DA0,   "SICK AG" },
    { 0x0DA1,   "Fen Systems Ltd." },
    { 0x0DA2,   "KIWI.KI GmbH" },
    { 0x0DA3,   "Airgraft Inc." },
    { 0x0DA4,   "HP Tuners" },
    { 0x0DA5,   "PIXELA CORPORATION" },
    { 0x0DA6,   "Generac Corporation" },
    { 0x0DA7,   "Novoferm tormatic GmbH" },
    { 0x0DA8,   "Airwallet ApS" },
    { 0x0DA9,   "Inventronics GmbH" },
    { 0x0DAA,   "Shenzhen EBELONG Technology Co., Ltd." },
    { 0x0DAB,   "Efento" },
    { 0x0DAC,   "ITALTRACTOR ITM S.P.A." },
    { 0x0DAE,   "TITUM AUDIO, INC." },
    { 0x0DAF,   "Hexagon Aura Reality AG" },
    { 0x0DB0,   "Invisalert Solutions, Inc." },
    { 0x0DB1,   "TELE System Communications Pte. Ltd." },
    { 0x0DB2,   "Whirlpool" },
    { 0x0DB3,   "SHENZHEN REFLYING ELECTRONIC CO., LTD" },
    { 0x0DB4,   "Franklin Control Systems" },
    { 0x0DB5,   "Djup AB" },
    { 0x0DB6,   "SAFEGUARD EQUIPMENT, INC." },
    { 0x0DB7,   "Morningstar Corporation" },
    { 0x0DB8,   "Shenzhen Chuangyuan Digital Technology Co., Ltd" },
    { 0x0DB9,   "CompanyDeep Ltd" },
    { 0x0DBA,   "Veo Technologies ApS" },
    { 0x0DBB,   "Nexis Link Technology Co., Ltd." },
    { 0x0DBC,   "Felion Technologies Company Limited" },
    { 0x0DBD,   "MAATEL" },
    { 0x0DBE,   "HELLA GmbH & Co. KGaA" },
    { 0x0DBF,   "HWM-Water Limited" },
    { 0x0DC0,   "Shenzhen Jahport Electronic Technology Co., Ltd." },
    { 0x0DC1,   "NACHI-FUJIKOSHI CORP." },
    { 0x0DC2,   "Cirrus Research plc" },
    { 0x0DC3,   "GEARBAC TECHNOLOGIES INC." },
    { 0x0DC4,   "Hangzhou NationalChip Science & Technology Co.,Ltd" },
    { 0x0DC5,   "DHL" },
    { 0x0DC6,   "Levita" },
    { 0x0DC7,   "MORNINGSTAR FX PTE. LTD." },
    { 0x0DC8,   "ETO GRUPPE TECHNOLOGIES GmbH" },
    { 0x0DC9,   "farmunited GmbH" },
    { 0x0DCA,   "Aptener Mechatronics Private Limited" },
    { 0x0DCB,   "GEOPH, LLC" },
    { 0x0DCC,   "Trotec GmbH" },
    { 0x0DCD,   "Astra LED AG" },
    { 0x0DCE,   "NOVAFON - Electromedical devices limited liability company" },
    { 0x0DCF,   "KUBU SMART LIMITED" },
    { 0x0DD0,   "ESNAH" },
    { 0x0DD1,   "OrangeMicro Limited" },
    { 0x0DD2,   "Fresh n Rebel B.V." },
    { 0x0DD3,   "Global Satellite Engineering" },
    { 0x0DD4,   "KOQOON GmbH & Co.KG" },
    { 0x0DD5,   "BEEPINGS" },
    { 0x0DD6,   "MODULAR MEDICAL, INC." },
    { 0x0DD7,   "Xiant Technologies, Inc." },
    { 0x0DD9,   "SCHELL GmbH & Co. KG" },
    { 0x0DDA,   "Minebea Intec GmbH" },
    { 0x0DDB,   "KAGA FEI Co., Ltd." },
    { 0x0DDC,   "AUTHOR-ALARM, razvoj in prodaja avtomobilskih sistemov proti kraji, d.o.o." },
    { 0x0DDD,   "Tozoa LLC" },
    { 0x0DDE,   "SHENZHEN DNS INDUSTRIES CO., LTD." },
    { 0x0DDF,   "Shenzhen Lunci Technology Co., Ltd" },
    { 0x0DE0,   "KNOG PTY. LTD." },
    { 0x0DE1,   "Outshiny India Private Limited" },
    { 0x0DE2,   "TAMADIC Co., Ltd." },
    { 0x0DE3,   "Shenzhen MODSEMI Co., Ltd" },
    { 0x0DE4,   "EMBEINT INC" },
    { 0x0DE5,   "Ehong Technology Co.,Ltd" },
    { 0x0DE6,   "DEXATEK Technology LTD" },
    { 0x0DE7,   "Dendro Technologies, Inc." },
    { 0x0DE8,   "Vivint, Inc." },
    { 0x0DE9,   "General Laser GmbH" },
    { 0x0DEA,   "Kathrein Solutions GmbH" },
    { 0x0DEB,   "Fitz Inc." },
    { 0x0DEC,   "ATEGENOS PHARMACEUTICALS INC" },
    { 0x0DED,   "Flextronic GmbH" },
    { 0x0DEE,   "Safety Swim LLC" },
    { 0x0DEF,   "SING SUN TECHNOLOGY (INTERNATIONAL) LIMITED" },
    { 0x0DF0,   "Woncan (Hong Kong) Limited" },
    { 0x0DF1,   "iFLYTEK (Suzhou) Technology Co., Ltd." },
    { 0x0DF2,   "Weber-Stephen Products LLC" },
    { 0x0DF3,   "hDrop Technologies Inc." },
    { 0x0DF4,   "REEKON TOOLS INC." },
    { 0x0DF5,   "Delta Faucet Company" },
    { 0x0DF6,   "Mutrack Co., Ltd" },
    { 0x0DF7,   "Hangzhou Zhaotong Microelectronics Co., Ltd." },
    { 0x0DF8,   "Chengdu CSCT Microelectronics Co., Ltd." },
    { 0x0DF9,   "Belusun Technology Ltd." },
    { 0x0DFA,   "Shenzhen Matches IoT Technology Co., Ltd." },
    { 0x0DFB,   "Beidou Intelligent Connected Vehicle Technology Co., Ltd." },
    { 0x0DFC,   "SOJI ELECTRONICS JOINT STOCK COMPANY" },
    { 0x0DFD,   "BH Technologies" },
    { 0x0DFE,   "Haptech, Inc." },
    { 0x0DFF,   "WaveRF, Corp." },
    { 0x0E00,   "SHENZHEN SOUNDSOUL INFORMATION TECHNOLOGY CO.,LTD" },
    { 0x0E01,   "Wuhu Mengbo Technology Co., Ltd." },
    { 0x0E02,   "PROSYS DEV LIMITED" },
    { 0x0E03,   "Shenzhen eMeet technology Co.,Ltd" },
    { 0x0E04,   "Doro AB" },
    { 0x0E05,   "SUREPULSE MEDICAL LIMITED" },
    { 0x0E06,   "iodyne, LLC" },
    { 0x0E07,   "Pinpoint GmbH" },
    { 0x0E08,   "Heinrich Kopp GmbH" },
    { 0x0E09,   "Evolutive Systems SL" },
    { 0x0E0B,   "Sounding Audio Industrial Ltd." },
    { 0x0E0C,   "Yuanfeng Technology Co., Ltd." },
    { 0x0E0D,   "FrontAct Co., Ltd." },
    { 0x0E0F,   "SenseWorks Tecnologia Ltda." },
    { 0x0E10,   "Eko Health, Inc." },
    { 0x0E11,   "Wanzl GmbH & Co. KGaA" },
    { 0x0E12,   "CLEVER LOGGER TECHNOLOGIES PTY LIMITED" },
    { 0x0E13,   "ASYSTOM" },
    { 0x0E14,   "Heilongjiang Tianyouwei Electronics Co.,Ltd." },
    { 0x0E15,   "Eastern Partner Limited" },
    { 0x0E16,   "Xiamen RUI YI Da Electronic Technology Co.,Ltd" },
    { 0x0E17,   "Ad Hoc Electronics, llc." },
    { 0x0E18,   "Hangzhou Microimage Software Co.,Ltd." },
    { 0x0E19,   "Hive-Zox International SA" },
    { 0x0E1A,   "Sensovo GmbH" },
    { 0x0E1B,   "Time Location Systems AS" },
    { 0x0E1C,   "SHENZHEN DIGITECH CO., LTD" },
    { 0x0E1D,   "Capte B.V." },
    { 0x0E1E,   "9512-5837 QUEBEC INC." },
    { 0x0E1F,   "Blecon Ltd" },
    { 0x0E20,   "CFLAB TEKNOLOJI TICARET LIMITED SIRKETI" },
    { 0x0E21,   "FOGO" },
    { 0x0E22,   "HITO INC" },
    { 0x0E23,   "MS kajak7 UG (limited liability)" },
    { 0x0E24,   "Avedis Zildjian Co." },
    { 0x0E25,   "Hangzhou Hikvision Digital Technology Co., Ltd." },
    { 0x0E26,   "LIHJOEN SPEED METER CO., LTD." },
    { 0x0E27,   "NextSense, Inc." },
    { 0x0E28,   "PatchRx, Inc." },
    { 0x0E29,   "Flipper Devices Inc." },
    { 0x0E2A,   "Huizhou Foryou General Electronics Co., Ltd." },
    { 0x0E2B,   "JE electronic a/s" },
    { 0x0E2C,   "9313-7263 Quebec inc." },
    { 0x0E2D,   "ECARX (Hubei) Tech Co.,Ltd." },
    { 0x0E2E,   "NIHON KOHDEN CORPORATION" },
    { 0x0E2F,   "ONWI" },
    { 0x0E30,   "Primax Electronics Ltd." },
    { 0x0E31,   "AlphaTheta Corporation" },
    { 0x0E32,   "PACIFIC INDUSTRIAL CO., LTD." },
    { 0x0E33,   "Crescent NV" },
    { 0x0E34,   "Vermis, software solutions llc" },
    { 0x0E35,   "SNAPPWISH LLC" },
    { 0x0E36,   "Cousins and Sears LLC" },
    { 0x0E37,   "CESYS Gesellschaft für angewandte Mikroelektronik mbH" },
    { 0x0E38,   "SLOC GmbH" },
    { 0x0E39,   "IRES Infrarot Energie Systeme GmbH" },
    { 0x0E3A,   "OFIVE LIMITED" },
    { 0x0E3B,   "Swift IOT Tech (Shenzhen) Co., LTD." },
    { 0x0E3C,   "Viselabs" },
    { 0x0E3D,   "Walmart Inc." },
    { 0x0E3E,   "VANBOX" },
    { 0x0E3F,   "Wiser Devices, LLC" },
    { 0x0E40,   "WKD Labs Ltd" },
    { 0x0E41,   "Asustek Computer Inc." },
    { 0x0E42,   "Z-ONE Technology Co., Ltd." },
    { 0x0E43,   "InnoVision Medical Technologies, LLC" },
    { 0x0E44,   "QUANTATEC" },
    { 0x0E45,   "Filo Srl" },
    { 0x0E46,   "SOUNDUCT" },
    { 0x0E47,   "Hosiden Besson Limited" },
    { 0x0E48,   "KARLUNA MUHENDISLIK SANAYI VE TICARET ANONIM SIRKETI" },
    { 0x0E49,   "Deone (Shanghai) Communication & Technology Co., Ltd" },
    { 0x0E4A,   "Nitto Denko Corporation" },
    { 0x0E4B,   "PUDSEY DIAMOND ENGINEERING LIMITED" },
    { 0x0E4C,   "Luxshare Precision Industry Co., Ltd." },
    { 0x0E4D,   "Brooksee, Inc." },
    { 0x0E4E,   "QSC, LLC" },
    { 0x0E4F,   "eBet Gaming Sytems Pty Limited" },
    { 0x0E50,   "Zhejiang Desman Intelligent Technology Co., Ltd." },
    { 0x0E51,   "Dyaco International Inc." },
    { 0x0E52,   "Aquana, LLC" },
    { 0x0E53,   "MINIRIG" },
    { 0x0E54,   "Relief Technologies AS" },
    { 0x0E55,   "New Cosmos Electric Co., Ltd." },
    { 0x0E56,   "INEPRO Metering B.V." },
    { 0x0E57,   "Altina Inc." },
    { 0x0E58,   "Urban Armor Gear, LLC" },
    { 0x0E59,   "Loewe Technology GmbH" },
    { 0x0E5A,   "OmniWave Microelectronics Shanghai Co., Ltd" },
    { 0x0E5B,   "Wuhu Hongjing Electronic Co.,Ltd" },
    { 0x0E5C,   "Amimon Ltd." },
    { 0x0E5D,   "L.T.H. Electronics Limited" },
    { 0x0E5E,   "SHAPER TOOLS, INC." },
    { 0x0E5F,   "Ruptela" },
    { 0x0E60,   "Ant Group Co., Ltd." },
    { 0x0E61,   "Queclink Wireless Solutions Co., Ltd." },
    { 0x0E62,   "GOKI PTY LTD" },
    { 0x0E63,   "LAST LOCK INC." },
    { 0x0E64,   "HuiTong intelligence Company Limited" },
    { 0x0E65,   "Daikin Industries, LTD" },
    { 0x0E66,   "Shenzhen Baseus Technology Co., Ltd." },
    { 0x0E67,   "NEXT DEVICES LTDA" },
    { 0x0E68,   "EarTex Ltd" },
    { 0x0E69,   "Megatronix (Beijing) Technology Co., Ltd" },
    { 0x0E6A,   "Hyena Inc." },
    { 0x0E6B,   "Shenzhen Goodocom Information Technology Co., Ltd." },
    { 0x0E6C,   "RIGH, INC." },
    { 0x0E6D,   "FEVOS LIMITED" },
    { 0x0E6F,   "OpConnect, Inc." },
    { 0x0E70,   "Powerstick.com" },
    { 0x0E71,   "ENABLEWEAR LLC" },
    { 0x0E72,   "TOR.AI LIMITED" },
    { 0x0E73,   "Adventures of the Persistently Impaired (and other tales) Limited" },
    { 0x0E74,   "Rocky Radios LLC" },
    { 0x0E75,   "Le Touch (Shenzhen) Electronics Co., Ltd." },
    { 0x0E76,   "Guangdong Nanguang Photo&Video Systems Co., Ltd." },
    { 0x0E77,   "MOBILE TECH, INC." },
    { 0x0E78,   "HONG KONG COMMUNICATIONS COMPANY LIMITED" },
    { 0x0E79,   "Neptune First OU" },
    { 0x0E7A,   "Vivago Oy" },
    { 0x0E7B,   "Circular" },
    { 0x0E7C,   "final Inc." },
    { 0x0E7D,   "Jiangsu XinTongda Electric Technology Co.,Ltd." },
    { 0x0E7E,   "Archon Controls LLC" },
    { 0x0E7F,   "SZR-Dev UG" },
    { 0x0E80,   "IQNEXXT Solutions GmbH" },
    { 0x0E81,   "Guangdong Hengqin Xingtong Technology Co.,ltd." },
    { 0x0E82,   "CHEVALIER TECH LIMITED" },
    { 0x0E83,   "SPRiNTUS GmbH" },
    { 0x0E84,   "Tymphany HK Ltd" },
    { 0x0E85,   "TigerLight, Inc." },
    { 0x0E86,   "Mercury Marine, a division of Brunswick Corporation" },
    { 0x0E87,   "OpenTech Alliance, Inc." },
    { 0x0E88,   "Skewered Fencing, LLC" },
    { 0x0E89,   "Brudden" },
    { 0x0E8A,   "Tele-Radio i Lysekil AB" },
    { 0x0E8B,   "Allgon AB" },
    { 0x0E8C,   "Gopod Group Holding Limited" },
    { 0x0E8D,   "Celebrities Management Private Limited" },
    { 0x0E8E,   "Nobest Inc" },
    { 0x0E8F,   "Avetos Design LLC" },
    { 0x0E90,   "RainMaker Solutions, Inc." },
    { 0x0E91,   "Identita Inc." },
    { 0x0E92,   "Glutz AG" },
    { 0x0E93,   "MIV ELECTRONICS, LTD" },
    { 0x0E94,   "Tactrix" },
    { 0x0E95,   "Viaanix, Inc." },
    { 0x0E96,   "Skeed,co,Ltd." },
    { 0x0E97,   "kokoromil Inc." },
    { 0x0E98,   "Chromatic Inc." },
    { 0x0E99,   "Medibound, Inc." },
    { 0x0E9A,   "Scanbro OU" },
    { 0x0E9B,   "Panasonic Automotive Systems Co., Ltd." },
    { 0x0E9C,   "Andrews & Arnold Ltd" },
    { 0x0E9D,   "Audinor ApS" },
    { 0x0E9E,   "Travelxp India Private Limited" },
    { 0x0E9F,   "Owlet Baby Care Inc." },
    { 0x0EA0,   "ENLESS WIRELESS" },
    { 0x0EA1,   "Culligan International Company" },
    { 0x0EA2,   "QIKCONNEX LLC" },
    { 0x0EA3,   "OLIS ELECTRONICS, LLC" },
    { 0x0EA4,   "BiTECH Automotive (Wuhu) Co.,Ltd" },
    { 0x0EA5,   "EasyReach Solutions Private Limited" },
    { 0x0EA6,   "AMG Lab LLC" },
    { 0x0EA7,   "BrickXter GmbH" },
    { 0x0EA8,   "Dongguan Trangjan Industrial Co., Ltd" },
    { 0x0EA9,   "Makichie Co., Ltd." },
    { 0x0EAA,   "Hive Soundz inc." },
    { 0x0EAB,   "STEYR Sport GmbH" },
    { 0x0EAC,   "Dynetrex Solutions Inc." },
    { 0x0EAD,   "OPTRON Co., Ltd." },
    { 0x0EAE,   "BHClears Microelectronics (Shanghai) Co., Ltd." },
    { 0x0EAF,   "Unfolded Circle ApS" },
    { 0x0EB0,   "FactorySense" },
    { 0x0EB1,   "WearNex Limited" },
    { 0x0EB2,   "PRADCO Outdoor Brands" },
    { 0x0EB3,   "Zucchetti Axess" },
    { 0x0EB4,   "BLUEFIN DATA, LLC" },
    { 0x0EB5,   "Preseed Japan Corporation" },
    { 0x0EB6,   "Server Products, Inc." },
    { 0x0EB7,   "Embedded Solutions LLC" },
    { 0x0EB8,   "PARAGON ID" },
    { 0x0EB9,   "egojin co,.ltd" },
    { 0x0EBA,   "THERMY LTD" },
    { 0x0EBB,   "Asahi Denso Co.,Ltd." },
    { 0x0EBC,   "GP Acoustics International Limited" },
    { 0x0EBD,   "Tongfang Health Technology (Beijing) Co., Ltd." },
    { 0x0EBE,   "Deity Acoustic Technology Co." },
    { 0x0EBF,   "Schulte-Schlagbaum AG" },
    { 0x0EC0,   "WEST inx Ltd." },
    { 0x0EC1,   "Crossdoor" },
    { 0x0EC2,   "High Entropy, LLC" },
    { 0x0EC3,   "Herschel Infrared Ltd" },
    { 0x0EC4,   "PACIFIC MARINE BATTERIES PTY. LIMITED" },
    { 0x0EC5,   "Alibaba (China) Co., Ltd." },
    { 0x0EC6,   "AuthGate B.V." },
    { 0x0EC7,   "Canyon Bicycles GmbH" },
    { 0x0EC8,   "Codie LLC" },
    { 0x0EC9,   "NeuroPace Inc" },
    { 0x0ECA,   "NexRev LLC" },
    { 0x0ECB,   "Zhong Shan City Richsound Electronic Industrial Ltd." },
    { 0x0ECC,   "Shenzhen NEOECO Technology Co., Ltd." },
    { 0x0ECD,   "Nature Inc." },
    { 0x0ECE,   "Guangzhou Honor Microelectronic Co.,Ltd." },
    { 0x0ECF,   "GGEC America, Inc." },
    { 0x0ED0,   "Gibson, Inc." },
    { 0x0ED1,   "VINYL MATT MEDIA LIMITED" },
    { 0x0ED2,   "SHENZHEN BESTWAY ELECTRONICS CO.,LTD" },
    { 0x0ED3,   "Lichens Innovation inc." },
    { 0x0ED4,   "Goerdyna Group Co., Ltd" },
    { 0x0ED5,   "Relish Technologies Limited" },
    { 0x0ED6,   "Quintessential Design, Inc." },
    { 0x0ED7,   "CS INSTRUMENTS GmbH & Co.KG" },
    { 0x0ED8,   "DORAN MFG. LLC" },
    { 0x0ED9,   "Overhead Door Corporation" },
    { 0x0EDA,   "Kodira GmbH" },
    { 0x0EDB,   "ShenZhen BoYiChuangXin" },
    { 0x0EDC,   "Shenzhen Zoqin Technology Co., Ltd." },
    { 0x0EDD,   "Ceridwen Limited" },
    { 0x0EDE,   "Sony Honda Mobility Inc." },
    { 0x0EDF,   "Dynaudio A/S" },
    { 0x0EE0,   "MAERSK CONTAINER INDUSTRY A/S" },
    { 0x0EE1,   "MA MICRO LIMITED" },
    { 0x0EE2,   "shenzhen hongever technology Co,. Ltd" },
    { 0x0EE3,   "TAMRON Co., Ltd." },
    { 0x0EE4,   "CAPTEMP, LDA" },
    { 0x0EE5,   "Ambient Life Inc." },
    { 0x0EE6,   "NOCTRIX HEALTH, INC" },
    { 0x0EE7,   "RICKARD AIR DIFFUSION (PTY) LTD" },
    { 0x0EE8,   "SG Armaturen AS" },
    { 0x0EE9,   "PIXEL TI IND. E COM PROD ELETRONICOS" },
    { 0x0EEA,   "Core Devices LLC" },
    { 0x0EEB,   "Fujita Electric Works, Ltd" },
    { 0x0EEC,   "Willow Laboratories, Inc." },
    { 0x0EED,   "BBC Bircher AG" },
    { 0x0EEE,   "ELLEA INGEGNERIA SRL UNIPERSONALE" },
    { 0x0EEF,   "Q42 Internet B.V." },
    { 0x0EF0,   "Seaward Electronic" },
    { 0x0EF1,   "Wuxi Does IOT Co., Ltd" },
    { 0x0EF2,   "CAPTAIN BLINK" },
    { 0x0EF3,   "Monil AS" },
    { 0x0EF5,   "LS ELECTRIC Co., Ltd." },
    { 0x0EF6,   "Shenzhen Cyber Innovation Technology Co., Ltd." },
    { 0x0EF7,   "Trackonomy Systems, Inc." },
    { 0x0EF8,   "IoT Solutions Malta Limited" },
    { 0x0EF9,   "Aseptico, Inc." },
    { 0x0EFA,   "Sensear Pty Ltd" },
    { 0x0EFB,   "BLUEPROVIDERZ LLC" },
    { 0x0EFC,   "Jano Life Inc." },
    { 0x0EFD,   "PRIMES GmbH" },
    { 0x0EFE,   "Teledyne Instruments, Inc." },
    { 0x0EFF,   "Healthcare Technology Limited" },
    { 0x0F00,   "TRACERCO LIMITED" },
    { 0x0F01,   "HAPPLABS SOFTWARE PRIVATE LIMITED" },
    { 0x0F02,   "GE HEALTHCARE TECHNOLOGIES INC." },
    { 0x0F03,   "Olibra LLC" },
    { 0x0F04,   "Lumen Labs (HK) Ltd" },
    { 0x0F05,   "SHENZHEN GWSTAI TECHNOLOGY CO.,LTD" },
    { 0x0F06,   "SHENZHEN POWEROAK NEWENER CO., LTD" },
    { 0x0F07,   "Tech OVN Private Limited" },
    { 0x0F08,   "Lezyne USA Inc." },
    { 0x0F09,   "ANC CHINA LIMITED" },
    { 0x0F0A,   "LION GROUP, INC." },
    { 0x0F0B,   "Brightway Innovation Intelligent Technology (Suzhou) Co., Ltd." },
    { 0x0F0C,   "Hitachi Industrial Equipment Systems Co.,Ltd." },
    { 0x0F0D,   "Maennl Elektronik GmbH" },
    { 0x0F0E,   "IDEATRONIK Limited Liability Company" },
    { 0x0F0F,   "caive Inc." },
    { 0x0F10,   "ShenZhen Doctors of Intelligence & Technology Co.,Ltd" },
    { 0x0F11,   "Deep and Steep LLC" },
    { 0x0F12,   "Endur ID, Inc." },
    { 0x0F13,   "Freshape SA" },
    { 0x0F14,   "PreEvnt, LLC" },
    { 0x0F15,   "Oval Corporation" },
    { 0x0F16,   "ADHD Friendly co.Ltd" },
    { 0x0F17,   "RORENTECH Co., Ltd." },
    { 0x0F18,   "iKeyless, LLC" },
    { 0x0F19,   "Shenzhen SuperSound Technology Co.,Ltd" },
    { 0x0F1A,   "FLO SCIENCES, LLC" },
    { 0x0F1B,   "PalatiumCare LLC" },
    { 0x0F1C,   "Edge Semiconductors Inc." },
    { 0x0F1D,   "ZIMMERMANN PV-Steel Group GmbH & Co. KG" },
    { 0x0F1E,   "Yolni Inc." },
    { 0x0F1F,   "Ninebot (Changzhou) Tech Co., Ltd." },
    { 0x0F20,   "Beijing Spring Creation Technology Co., Ltd." },
    { 0x0F21,   "Rokk Limited" },
    { 0x0F22,   "ONESPACE TECHNOLOGIES (PTY) LTD" },
    { 0x0F23,   "Yuquan Semiconductor (Xiamen) Co., Ltd." },
    { 0x0F24,   "Easy Measure Co., Ltd." },
    { 0x0F25,   "Sichuan Changhong Neonet Technologies Co.,Ltd." },
    { 0x0F26,   "Centromere Holding B.V." },
    { 0x0F27,   "Global Link Distribution Corp." },
    { 0x0F28,   "Amp Fit Israel LTD" },
    { 0x0F29,   "Trezor Company s.r.o." },
    { 0x0F2A,   "KELLER Druckmesstechnik AG" },
    { 0x0F2B,   "ElitEngineering LLC" },
    { 0x0F2C,   "Vision Group Inc." },
    { 0x0F2D,   "ClipsClips LLC" },
    { 0x0F2E,   "BRITZ INTERNATIONAL CO.,LTD" },
    { 0x0F2F,   "ThingCo Limited" },
    { 0x0F30,   "Opal Camera, Inc." },
    { 0x0F31,   "TECHNOLOGIES FOR FREERIDE s.r.o" },
    { 0x0F32,   "FLINTEC UK LIMITED" },
    { 0x0F33,   "TETNET" },
    { 0x0F34,   "NINGBO SHARKWARD ELECTRONICS CO.,LTD" },
    { 0x0F35,   "Audeze LLC" },
    { 0x0F36,   "NODER Joint Stock Company" },
    { 0x0F37,   "Schueco International KG" },
    { 0x0F38,   "GILL INSTRUMENTS LIMITED" },
    { 0x0F39,   "Seitron Spa" },
    { 0x0F3A,   "Southern Audio Services, Inc" },
    { 0x0F3B,   "SANWA NEWTEC CO.,LTD." },
    { 0x0F3C,   "Mobile Technology Solutions LLC" },
    { 0x0F3D,   "Vitio Medical S.L." },
    { 0x0F3E,   "Salyx Medical Inc." },
    { 0x0F3F,   "Landig + Lava GmbH & Co. KG" },
    { 0x0F40,   "Health Data Insight C.I.C." },
    { 0x0F41,   "BONX INC." },
    { 0x0F42,   "LINKEDCHIP TECHNOLOGY INC" },
    { 0x0F43,   "12mm Health Technology (Hainan) Co., Ltd." },
    { 0x0F44,   "MAVERICK ENERGY SOLUTIONS INTERNATIONAL,INC" },
    { 0x0F45,   "Tactica Defense LLC" },
    { 0x0F46,   "Huizhou Meicanxin Electronics Technology Co.,Ltd" },
    { 0x0F47,   "Lodestar Technology Inc." },
    { 0x0F48,   "Shenzhen Xinfeiyi Technology Co., Ltd." },
    { 0x0F49,   "IYO INC." },
    { 0x0F4A,   "Mitsubishi Motors Corporation" },
    { 0x0F4B,   "desamisCo.,Ltd." },
    { 0x0F4C,   "JL WORLD CORPORATION LIMITED" },
    { 0x0F4D,   "Qulinda AB" },
    { 0x0F4E,   "Ningbo Dooya Mechanic & Electronic Technology Co., Ltd" },
    { 0x0F4F,   "G-Vision GmbH" },
    { 0x0F50,   "Lantern Innovations Incorporated" },
    { 0x0F51,   "ebm-papst Mulfingen GmbH & Co. KGaA & Co. KG" },
    { 0x0F52,   "Shenzhen Yunke Intelligent Co.Ltd" },
    { 0x0F53,   "Fledt & Meiton Marin AB" },
    { 0x0F54,   "ContiTech Deutschland GmbH" },
    { 0x0F55,   "Sensoteq Ltd" },
    { 0x0F56,   "Astute Access Group Limited" },
    { 0x0F57,   "Silverlake Technologies" },
    { 0x0F58,   "Shenzhen Guo-link Technology Co.,Ltd." },
    { 0x0F59,   "Silicon Vandals PTY LTD" },
    { 0x0F5A,   "Vibe Energy B.V." },
    { 0x0F5B,   "shanghai fudan electronics group company Co. Ltd" },
    { 0x0F5C,   "Micro Technology Services, Inc." },
    { 0x0F5D,   "Leapcraft ApS" },
    { 0x0F5E,   "WUXI WEIDA INTELLIGENT ELECTRONICS CO.,LTD." },
    { 0x0F5F,   "ROBSON SRL" },
    { 0x0F60,   "Quilt Systems, Inc." },
    { 0x0F61,   "HyolimXE Co., Ltd." },
    { 0x0F62,   "Kehwin Technologies Co. Ltd." },
    { 0x0F63,   "WATTER, Inc." },
    { 0x0F64,   "SafeNow GmbH" },
    { 0x0F65,   "CZV, Inc" },
    { 0x0F66,   "BIGREDBEE, LLC" },
    { 0x0F67,   "White Eagle Sonic Technologies, Inc." },
    { 0x0F68,   "Navico" },
    { 0x0F69,   "Ancoe Industry Corporation" },
    { 0x0F6A,   "Roam Devices LLC" },
    { 0x0F6B,   "Skywalk Inc." },
    { 0x0F6C,   "Biogents AG" },
    { 0x0F6D,   "MODRETRO, INC." },
    { 0x0F6E,   "iSi Wearable Safety GmbH" },
    { 0x0F6F,   "onanoff limited" },
    { 0x0F70,   "TECHFLITTER SOLUTIONS PRIVATE LIMITED" },
    { 0x0F71,   "PIRITIZ LLC" },
    { 0x0F72,   "FLORLINK, INC." },
    { 0x0F73,   "Keycafe Inc." },
    { 0x0F74,   "Sperry Labs LLC" },
    { 0x0F75,   "Senseonics, Incorporated" },
    { 0x0F76,   "simatec ag" },
    { 0x0F77,   "CROSS BRAIN CO.,Ltd." },
    { 0x0F78,   "Also, Inc." },
    { 0x0F79,   "Walter Mueller Inc. for Industrial Electronics" },
    { 0x0F7A,   "SHENZHEN GUANG QI GUO CHUANG TECHNOLOGY CO.,LTD" },
    { 0x0F7B,   "SKYROAM, INC." },
    { 0x0F7C,   "Polk Audio" },
    { 0x0F7D,   "eQ-3 AG" },
    { 0x0F7E,   "shenzhen Holyiot Technology Co.,Ltd" },
    { 0x0F7F,   "Badass eBikes GmbH" },
    { 0x0F80,   "Hydro Electronic Devices, Inc." },
    { 0x0F81,   "IN Phase International lTD" },
    { 0x0F82,   "Amon Co.Ltd." },
    { 0x0F83,   "Calpeda S.p.A." },
    { 0x0F84,   "KT Micro, Inc." },
    { 0x0F85,   "Hangzhou Sciener Smart Technology Co., Ltd." },
    { 0x0F86,   "Lakecrest Pty Ltd" },
    { 0x0F87,   "Anacove Inc." },
    { 0x0F88,   "Kohler Ventures, Inc." },
    { 0x0F89,   "STOREIO TECHNOLOGIES LTD" },
    { 0x0F8A,   "Innogando S.L." },
    { 0x0F8B,   "A.Y. McDonald Mfg. Co." },
    { 0x0F8C,   "ROYAL PARTS CO.,LTD" },
    { 0x0F8D,   "JUREN CO., LTD." },
    { 0x0F8E,   "Biceek Inc" },
    { 0x0F8F,   "SIGNUM INTELLIGENCE LTD" },
    { 0x0F90,   "MOBI7 TECNOLOGIA EM MOBILIDADE S.A." },
    { 0x0F91,   "Valostra Digital Ventures LLP" },
    { 0x0F92,   "Ethos Group, Inc." },
    { 0x0F93,   "Aktiebolaget Ebeco" },
    { 0x0F94,   "IDX Company, Ltd." },
    { 0x0F95,   "Dongguang Huasoo Automation Technology Company Limited" },
    { 0x0F96,   "SEIKOIST, INC" },
    { 0x0F97,   "SPX Aids to Navigation Oy" },
    { 0x0F98,   "Fitnexa Inc" },
    { 0x0F99,   "DEZINE GROUP LLC" },
    { 0x0F9A,   "Eiritsu Electronics Industry Co., Ltd." },
    { 0x0F9B,   "Hanshow Technology Co.,Ltd." },
    { 0x0F9C,   "WePower Technologies LLC" },
    { 0x0F9D,   "IRTrans GmbH" },
    { 0x0F9E,   "Hibino Corporation" },
    { 0x0F9F,   "Seiko Future Creation Inc." },
    { 0x0FA0,   "DP IOT" },
    { 0x0FA1,   "PALRED RETAIL PRIVATE LIMITED" },
    { 0x0FA2,   "BIA NEUROSCIENCE INC." },
    { 0x0FA3,   "B.E.G. Brueck Electronic GmbH" },
    { 0x0FA4,   "Nice Spa" },
    { 0x0FA5,   "Avanos Medical, Inc." },
    { 0x0FA6,   "Ugreen Group Limited" },
    { 0x0FA7,   "spheretek japan" },
    { 0x0FA8,   "Senti Technologies Private Limited" },
    { 0x0FA9,   "Ranch Systems, Inc." },
    { 0x0FAA,   "Suzhou Fanxi Technology Co., Ltd." },
    { 0x0FAB,   "Geo Radar AI Private Limited" },
    { 0x0FAC,   "Flitsmeister B.V." },
    { 0x0FAD,   "The AI Toy Company" },
    { 0x0FAE,   "Capacite" },
    { 0x0FAF,   "Terasite Technologies" },
    { 0x0FB0,   "General Resistance, LLC" },
    { 0x0FB1,   "Avivomed Inc." },
    { 0x0FB2,   "PLAUD Inc." },
    { 0x0FB3,   "Hooked Society Oy Ltd" },
    { 0x0FB4,   "StoneDevices" },
    { 0x0FB5,   "Hangzhou Nano IC Technologies Co,. Ltd" },
    { 0x0FB6,   "TQ-Systems GmbH" },
    { 0x0FB7,   "Hapn Holdings, LLC" },
    { 0x0FB8,   "SITERWELL ELECTRONICS CO.,LIMITED" },
    { 0x0FB9,   "Shenzhen Mutual Technology Co., Ltd" },
    { 0x0FBA,   "Cosonic Intelligent Technologies Co., Ltd." },
    { 0x0FBB,   "Rollease Acmeda, Inc." },
    { 0x0FBC,   "ATANS TECHNOLOGY INC." },
    { 0x0FBD,   "Locus Robotics Corp." },
    { 0x0FBE,   "TaigaIoT" },
    { 0x0FBF,   "Tridentify AB" },
    { 0x0FC0,   "Littlebird Connected Care, Inc." },
    { 0x0FC1,   "Air Automotive tracking Inc." },
    { 0x0FC2,   "ISSPRO, INC" },
    { 0x0FC3,   "Shenzhen Jimi loT Co.,Ltd" },
    { 0x0FC4,   "FulScience Automotive Electronics Co., Ltd." },
    { 0x0FC5,   "Hypershell Co., Ltd" },
    { 0x0FC6,   "ASD Lighting PLC" },
    { 0x0FC7,   "Pharox B.V." },
    { 0x0FC8,   "Eforthink Technology Co., Ltd." },
    { 0x0FC9,   "Zirbel Bike GmbH" },
    { 0x0FCA,   "Legato Audio, Inc." },
    { 0x0FCB,   "Biocorp Production" },
    { 0x0FCC,   "Neurotherapeutics Ltd" },
    { 0x0FCD,   "Wimate Technology Solutions Pvt Ltd" },
    { 0x0FCE,   "NOJA Power" },
    { 0xFFFF,   "For use in internal and interoperability tests" },
    {      0,   NULL }
};
value_string_ext bluetooth_company_id_vals_ext = VALUE_STRING_EXT_INIT(bluetooth_company_id_vals);

const btatt_handle_strings_t btatt_handle_strings[] = {
    /* Service - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/service_uuids.yaml */
    { 0x1800,   "Bluetooth GATT Attribute GAP (UUID 0x1800)", "BT GATT GAP (UUID 0x1800)", "btgatt.uuid0x1800" },
    { 0x1801,   "Bluetooth GATT Attribute GATT (UUID 0x1801)", "BT GATT GATT (UUID 0x1801)", "btgatt.uuid0x1801" },
    { 0x1802,   "Bluetooth GATT Attribute Immediate Alert (UUID 0x1802)", "BT GATT Immediate Alert (UUID 0x1802)", "btgatt.uuid0x1802" },
    { 0x1803,   "Bluetooth GATT Attribute Link Loss (UUID 0x1803)", "BT GATT Link Loss (UUID 0x1803)", "btgatt.uuid0x1803" },
    { 0x1804,   "Bluetooth GATT Attribute Tx Power (UUID 0x1804)", "BT GATT Tx Power (UUID 0x1804)", "btgatt.uuid0x1804" },
    { 0x1805,   "Bluetooth GATT Attribute Current Time (UUID 0x1805)", "BT GATT Current Time (UUID 0x1805)", "btgatt.uuid0x1805" },
    { 0x1806,   "Bluetooth GATT Attribute Reference Time Update (UUID 0x1806)", "BT GATT Reference Time Update (UUID 0x1806)", "btgatt.uuid0x1806" },
    { 0x1807,   "Bluetooth GATT Attribute Next DST Change (UUID 0x1807)", "BT GATT Next DST Change (UUID 0x1807)", "btgatt.uuid0x1807" },
    { 0x1808,   "Bluetooth GATT Attribute Glucose (UUID 0x1808)", "BT GATT Glucose (UUID 0x1808)", "btgatt.uuid0x1808" },
    { 0x1809,   "Bluetooth GATT Attribute Health Thermometer (UUID 0x1809)", "BT GATT Health Thermometer (UUID 0x1809)", "btgatt.uuid0x1809" },
    { 0x180a,   "Bluetooth GATT Attribute Device Information (UUID 0x180a)", "BT GATT Device Information (UUID 0x180a)", "btgatt.uuid0x180a" },
    { 0x180d,   "Bluetooth GATT Attribute Heart Rate (UUID 0x180d)", "BT GATT Heart Rate (UUID 0x180d)", "btgatt.uuid0x180d" },
    { 0x180e,   "Bluetooth GATT Attribute Phone Alert Status (UUID 0x180e)", "BT GATT Phone Alert Status (UUID 0x180e)", "btgatt.uuid0x180e" },
    { 0x180f,   "Bluetooth GATT Attribute Battery (UUID 0x180f)", "BT GATT Battery (UUID 0x180f)", "btgatt.uuid0x180f" },
    { 0x1810,   "Bluetooth GATT Attribute Blood Pressure (UUID 0x1810)", "BT GATT Blood Pressure (UUID 0x1810)", "btgatt.uuid0x1810" },
    { 0x1811,   "Bluetooth GATT Attribute Alert Notification (UUID 0x1811)", "BT GATT Alert Notification (UUID 0x1811)", "btgatt.uuid0x1811" },
    { 0x1812,   "Bluetooth GATT Attribute Human Interface Device (UUID 0x1812)", "BT GATT Human Interface Device (UUID 0x1812)", "btgatt.uuid0x1812" },
    { 0x1813,   "Bluetooth GATT Attribute Scan Parameters (UUID 0x1813)", "BT GATT Scan Parameters (UUID 0x1813)", "btgatt.uuid0x1813" },
    { 0x1814,   "Bluetooth GATT Attribute Running Speed and Cadence (UUID 0x1814)", "BT GATT Running Speed and Cadence (UUID 0x1814)", "btgatt.uuid0x1814" },
    { 0x1815,   "Bluetooth GATT Attribute Automation IO (UUID 0x1815)", "BT GATT Automation IO (UUID 0x1815)", "btgatt.uuid0x1815" },
    { 0x1816,   "Bluetooth GATT Attribute Cycling Speed and Cadence (UUID 0x1816)", "BT GATT Cycling Speed and Cadence (UUID 0x1816)", "btgatt.uuid0x1816" },
    { 0x1818,   "Bluetooth GATT Attribute Cycling Power (UUID 0x1818)", "BT GATT Cycling Power (UUID 0x1818)", "btgatt.uuid0x1818" },
    { 0x1819,   "Bluetooth GATT Attribute Location and Navigation (UUID 0x1819)", "BT GATT Location and Navigation (UUID 0x1819)", "btgatt.uuid0x1819" },
    { 0x181a,   "Bluetooth GATT Attribute Environmental Sensing (UUID 0x181a)", "BT GATT Environmental Sensing (UUID 0x181a)", "btgatt.uuid0x181a" },
    { 0x181b,   "Bluetooth GATT Attribute Body Composition (UUID 0x181b)", "BT GATT Body Composition (UUID 0x181b)", "btgatt.uuid0x181b" },
    { 0x181c,   "Bluetooth GATT Attribute User Data (UUID 0x181c)", "BT GATT User Data (UUID 0x181c)", "btgatt.uuid0x181c" },
    { 0x181d,   "Bluetooth GATT Attribute Weight Scale (UUID 0x181d)", "BT GATT Weight Scale (UUID 0x181d)", "btgatt.uuid0x181d" },
    { 0x181e,   "Bluetooth GATT Attribute Bond Management (UUID 0x181e)", "BT GATT Bond Management (UUID 0x181e)", "btgatt.uuid0x181e" },
    { 0x181f,   "Bluetooth GATT Attribute Continuous Glucose Monitoring (UUID 0x181f)", "BT GATT Continuous Glucose Monitoring (UUID 0x181f)", "btgatt.uuid0x181f" },
    { 0x1820,   "Bluetooth GATT Attribute Internet Protocol Support (UUID 0x1820)", "BT GATT Internet Protocol Support (UUID 0x1820)", "btgatt.uuid0x1820" },
    { 0x1821,   "Bluetooth GATT Attribute Indoor Positioning (UUID 0x1821)", "BT GATT Indoor Positioning (UUID 0x1821)", "btgatt.uuid0x1821" },
    { 0x1822,   "Bluetooth GATT Attribute Pulse Oximeter (UUID 0x1822)", "BT GATT Pulse Oximeter (UUID 0x1822)", "btgatt.uuid0x1822" },
    { 0x1823,   "Bluetooth GATT Attribute HTTP Proxy (UUID 0x1823)", "BT GATT HTTP Proxy (UUID 0x1823)", "btgatt.uuid0x1823" },
    { 0x1824,   "Bluetooth GATT Attribute Transport Discovery (UUID 0x1824)", "BT GATT Transport Discovery (UUID 0x1824)", "btgatt.uuid0x1824" },
    { 0x1825,   "Bluetooth GATT Attribute Object Transfer (UUID 0x1825)", "BT GATT Object Transfer (UUID 0x1825)", "btgatt.uuid0x1825" },
    { 0x1826,   "Bluetooth GATT Attribute Fitness Machine (UUID 0x1826)", "BT GATT Fitness Machine (UUID 0x1826)", "btgatt.uuid0x1826" },
    { 0x1827,   "Bluetooth GATT Attribute Mesh Provisioning (UUID 0x1827)", "BT GATT Mesh Provisioning (UUID 0x1827)", "btgatt.uuid0x1827" },
    { 0x1828,   "Bluetooth GATT Attribute Mesh Proxy (UUID 0x1828)", "BT GATT Mesh Proxy (UUID 0x1828)", "btgatt.uuid0x1828" },
    { 0x1829,   "Bluetooth GATT Attribute Reconnection Configuration (UUID 0x1829)", "BT GATT Reconnection Configuration (UUID 0x1829)", "btgatt.uuid0x1829" },
    { 0x183a,   "Bluetooth GATT Attribute Insulin Delivery (UUID 0x183a)", "BT GATT Insulin Delivery (UUID 0x183a)", "btgatt.uuid0x183a" },
    { 0x183b,   "Bluetooth GATT Attribute Binary Sensor (UUID 0x183b)", "BT GATT Binary Sensor (UUID 0x183b)", "btgatt.uuid0x183b" },
    { 0x183c,   "Bluetooth GATT Attribute Emergency Configuration (UUID 0x183c)", "BT GATT Emergency Configuration (UUID 0x183c)", "btgatt.uuid0x183c" },
    { 0x183d,   "Bluetooth GATT Attribute Authorization Control (UUID 0x183d)", "BT GATT Authorization Control (UUID 0x183d)", "btgatt.uuid0x183d" },
    { 0x183e,   "Bluetooth GATT Attribute Physical Activity Monitor (UUID 0x183e)", "BT GATT Physical Activity Monitor (UUID 0x183e)", "btgatt.uuid0x183e" },
    { 0x183f,   "Bluetooth GATT Attribute Elapsed Time (UUID 0x183f)", "BT GATT Elapsed Time (UUID 0x183f)", "btgatt.uuid0x183f" },
    { 0x1840,   "Bluetooth GATT Attribute Generic Health Sensor (UUID 0x1840)", "BT GATT Generic Health Sensor (UUID 0x1840)", "btgatt.uuid0x1840" },
    { 0x1843,   "Bluetooth GATT Attribute Audio Input Control (UUID 0x1843)", "BT GATT Audio Input Control (UUID 0x1843)", "btgatt.uuid0x1843" },
    { 0x1844,   "Bluetooth GATT Attribute Volume Control (UUID 0x1844)", "BT GATT Volume Control (UUID 0x1844)", "btgatt.uuid0x1844" },
    { 0x1845,   "Bluetooth GATT Attribute Volume Offset Control (UUID 0x1845)", "BT GATT Volume Offset Control (UUID 0x1845)", "btgatt.uuid0x1845" },
    { 0x1846,   "Bluetooth GATT Attribute Coordinated Set Identification (UUID 0x1846)", "BT GATT Coordinated Set Identification (UUID 0x1846)", "btgatt.uuid0x1846" },
    { 0x1847,   "Bluetooth GATT Attribute Device Time (UUID 0x1847)", "BT GATT Device Time (UUID 0x1847)", "btgatt.uuid0x1847" },
    { 0x1848,   "Bluetooth GATT Attribute Media Control (UUID 0x1848)", "BT GATT Media Control (UUID 0x1848)", "btgatt.uuid0x1848" },
    { 0x1849,   "Bluetooth GATT Attribute Generic Media Control (UUID 0x1849)", "BT GATT Generic Media Control (UUID 0x1849)", "btgatt.uuid0x1849" },
    { 0x184a,   "Bluetooth GATT Attribute Constant Tone Extension (UUID 0x184a)", "BT GATT Constant Tone Extension (UUID 0x184a)", "btgatt.uuid0x184a" },
    { 0x184b,   "Bluetooth GATT Attribute Telephone Bearer (UUID 0x184b)", "BT GATT Telephone Bearer (UUID 0x184b)", "btgatt.uuid0x184b" },
    { 0x184c,   "Bluetooth GATT Attribute Generic Telephone Bearer (UUID 0x184c)", "BT GATT Generic Telephone Bearer (UUID 0x184c)", "btgatt.uuid0x184c" },
    { 0x184d,   "Bluetooth GATT Attribute Microphone Control (UUID 0x184d)", "BT GATT Microphone Control (UUID 0x184d)", "btgatt.uuid0x184d" },
    { 0x184e,   "Bluetooth GATT Attribute Audio Stream Control (UUID 0x184e)", "BT GATT Audio Stream Control (UUID 0x184e)", "btgatt.uuid0x184e" },
    { 0x184f,   "Bluetooth GATT Attribute Broadcast Audio Scan (UUID 0x184f)", "BT GATT Broadcast Audio Scan (UUID 0x184f)", "btgatt.uuid0x184f" },
    { 0x1850,   "Bluetooth GATT Attribute Published Audio Capabilities (UUID 0x1850)", "BT GATT Published Audio Capabilities (UUID 0x1850)", "btgatt.uuid0x1850" },
    { 0x1851,   "Bluetooth GATT Attribute Basic Audio Announcement (UUID 0x1851)", "BT GATT Basic Audio Announcement (UUID 0x1851)", "btgatt.uuid0x1851" },
    { 0x1852,   "Bluetooth GATT Attribute Broadcast Audio Announcement (UUID 0x1852)", "BT GATT Broadcast Audio Announcement (UUID 0x1852)", "btgatt.uuid0x1852" },
    { 0x1853,   "Bluetooth GATT Attribute Common Audio (UUID 0x1853)", "BT GATT Common Audio (UUID 0x1853)", "btgatt.uuid0x1853" },
    { 0x1854,   "Bluetooth GATT Attribute Hearing Access (UUID 0x1854)", "BT GATT Hearing Access (UUID 0x1854)", "btgatt.uuid0x1854" },
    { 0x1855,   "Bluetooth GATT Attribute Telephony and Media Audio (UUID 0x1855)", "BT GATT Telephony and Media Audio (UUID 0x1855)", "btgatt.uuid0x1855" },
    { 0x1856,   "Bluetooth GATT Attribute Public Broadcast Announcement (UUID 0x1856)", "BT GATT Public Broadcast Announcement (UUID 0x1856)", "btgatt.uuid0x1856" },
    { 0x1857,   "Bluetooth GATT Attribute Electronic Shelf Label (UUID 0x1857)", "BT GATT Electronic Shelf Label (UUID 0x1857)", "btgatt.uuid0x1857" },
    { 0x1858,   "Bluetooth GATT Attribute Gaming Audio (UUID 0x1858)", "BT GATT Gaming Audio (UUID 0x1858)", "btgatt.uuid0x1858" },
    { 0x1859,   "Bluetooth GATT Attribute Mesh Proxy Solicitation (UUID 0x1859)", "BT GATT Mesh Proxy Solicitation (UUID 0x1859)", "btgatt.uuid0x1859" },
    { 0x185a,   "Bluetooth GATT Attribute Industrial Measurement Device (UUID 0x185a)", "BT GATT Industrial Measurement Device (UUID 0x185a)", "btgatt.uuid0x185a" },
    { 0x185b,   "Bluetooth GATT Attribute Ranging (UUID 0x185b)", "BT GATT Ranging (UUID 0x185b)", "btgatt.uuid0x185b" },
    { 0x185c,   "Bluetooth GATT Attribute HID ISO (UUID 0x185c)", "BT GATT HID ISO (UUID 0x185c)", "btgatt.uuid0x185c" },
    { 0x185d,   "Bluetooth GATT Attribute Cookware (UUID 0x185d)", "BT GATT Cookware (UUID 0x185d)", "btgatt.uuid0x185d" },
    /* Units - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/units.yaml */
    { 0x2700,   "Bluetooth GATT Attribute unitless (UUID 0x2700)", "BT GATT unitless (UUID 0x2700)", "btgatt.uuid0x2700" },
    { 0x2701,   "Bluetooth GATT Attribute length (metre) (UUID 0x2701)", "BT GATT length (metre) (UUID 0x2701)", "btgatt.uuid0x2701" },
    { 0x2702,   "Bluetooth GATT Attribute mass (kilogram) (UUID 0x2702)", "BT GATT mass (kilogram) (UUID 0x2702)", "btgatt.uuid0x2702" },
    { 0x2703,   "Bluetooth GATT Attribute time (second) (UUID 0x2703)", "BT GATT time (second) (UUID 0x2703)", "btgatt.uuid0x2703" },
    { 0x2704,   "Bluetooth GATT Attribute electric current (ampere) (UUID 0x2704)", "BT GATT electric current (ampere) (UUID 0x2704)", "btgatt.uuid0x2704" },
    { 0x2705,   "Bluetooth GATT Attribute thermodynamic temperature (kelvin) (UUID 0x2705)", "BT GATT thermodynamic temperature (kelvin) (UUID 0x2705)", "btgatt.uuid0x2705" },
    { 0x2706,   "Bluetooth GATT Attribute amount of substance (mole) (UUID 0x2706)", "BT GATT amount of substance (mole) (UUID 0x2706)", "btgatt.uuid0x2706" },
    { 0x2707,   "Bluetooth GATT Attribute luminous intensity (candela) (UUID 0x2707)", "BT GATT luminous intensity (candela) (UUID 0x2707)", "btgatt.uuid0x2707" },
    { 0x2710,   "Bluetooth GATT Attribute area (square metres) (UUID 0x2710)", "BT GATT area (square metres) (UUID 0x2710)", "btgatt.uuid0x2710" },
    { 0x2711,   "Bluetooth GATT Attribute volume (cubic metres) (UUID 0x2711)", "BT GATT volume (cubic metres) (UUID 0x2711)", "btgatt.uuid0x2711" },
    { 0x2712,   "Bluetooth GATT Attribute velocity (metres per second) (UUID 0x2712)", "BT GATT velocity (metres per second) (UUID 0x2712)", "btgatt.uuid0x2712" },
    { 0x2713,   "Bluetooth GATT Attribute acceleration (metres per second squared) (UUID 0x2713)", "BT GATT acceleration (metres per second squared) (UUID 0x2713)", "btgatt.uuid0x2713" },
    { 0x2714,   "Bluetooth GATT Attribute wavenumber (reciprocal metre) (UUID 0x2714)", "BT GATT wavenumber (reciprocal metre) (UUID 0x2714)", "btgatt.uuid0x2714" },
    { 0x2715,   "Bluetooth GATT Attribute density (kilogram per cubic metre) (UUID 0x2715)", "BT GATT density (kilogram per cubic metre) (UUID 0x2715)", "btgatt.uuid0x2715" },
    { 0x2716,   "Bluetooth GATT Attribute surface density (kilogram per square metre) (UUID 0x2716)", "BT GATT surface density (kilogram per square metre) (UUID 0x2716)", "btgatt.uuid0x2716" },
    { 0x2717,   "Bluetooth GATT Attribute specific volume (cubic metre per kilogram) (UUID 0x2717)", "BT GATT specific volume (cubic metre per kilogram) (UUID 0x2717)", "btgatt.uuid0x2717" },
    { 0x2718,   "Bluetooth GATT Attribute current density (ampere per square metre) (UUID 0x2718)", "BT GATT current density (ampere per square metre) (UUID 0x2718)", "btgatt.uuid0x2718" },
    { 0x2719,   "Bluetooth GATT Attribute magnetic field strength (ampere per metre) (UUID 0x2719)", "BT GATT magnetic field strength (ampere per metre) (UUID 0x2719)", "btgatt.uuid0x2719" },
    { 0x271a,   "Bluetooth GATT Attribute amount concentration (mole per cubic metre) (UUID 0x271a)", "BT GATT amount concentration (mole per cubic metre) (UUID 0x271a)", "btgatt.uuid0x271a" },
    { 0x271b,   "Bluetooth GATT Attribute mass concentration (kilogram per cubic metre) (UUID 0x271b)", "BT GATT mass concentration (kilogram per cubic metre) (UUID 0x271b)", "btgatt.uuid0x271b" },
    { 0x271c,   "Bluetooth GATT Attribute luminance (candela per square metre) (UUID 0x271c)", "BT GATT luminance (candela per square metre) (UUID 0x271c)", "btgatt.uuid0x271c" },
    { 0x271d,   "Bluetooth GATT Attribute refractive index (UUID 0x271d)", "BT GATT refractive index (UUID 0x271d)", "btgatt.uuid0x271d" },
    { 0x271e,   "Bluetooth GATT Attribute relative permeability (UUID 0x271e)", "BT GATT relative permeability (UUID 0x271e)", "btgatt.uuid0x271e" },
    { 0x2720,   "Bluetooth GATT Attribute plane angle (radian) (UUID 0x2720)", "BT GATT plane angle (radian) (UUID 0x2720)", "btgatt.uuid0x2720" },
    { 0x2721,   "Bluetooth GATT Attribute solid angle (steradian) (UUID 0x2721)", "BT GATT solid angle (steradian) (UUID 0x2721)", "btgatt.uuid0x2721" },
    { 0x2722,   "Bluetooth GATT Attribute frequency (hertz) (UUID 0x2722)", "BT GATT frequency (hertz) (UUID 0x2722)", "btgatt.uuid0x2722" },
    { 0x2723,   "Bluetooth GATT Attribute force (newton) (UUID 0x2723)", "BT GATT force (newton) (UUID 0x2723)", "btgatt.uuid0x2723" },
    { 0x2724,   "Bluetooth GATT Attribute pressure (pascal) (UUID 0x2724)", "BT GATT pressure (pascal) (UUID 0x2724)", "btgatt.uuid0x2724" },
    { 0x2725,   "Bluetooth GATT Attribute energy (joule) (UUID 0x2725)", "BT GATT energy (joule) (UUID 0x2725)", "btgatt.uuid0x2725" },
    { 0x2726,   "Bluetooth GATT Attribute power (watt) (UUID 0x2726)", "BT GATT power (watt) (UUID 0x2726)", "btgatt.uuid0x2726" },
    { 0x2727,   "Bluetooth GATT Attribute electric charge (coulomb) (UUID 0x2727)", "BT GATT electric charge (coulomb) (UUID 0x2727)", "btgatt.uuid0x2727" },
    { 0x2728,   "Bluetooth GATT Attribute electric potential difference (volt) (UUID 0x2728)", "BT GATT electric potential difference (volt) (UUID 0x2728)", "btgatt.uuid0x2728" },
    { 0x2729,   "Bluetooth GATT Attribute capacitance (farad) (UUID 0x2729)", "BT GATT capacitance (farad) (UUID 0x2729)", "btgatt.uuid0x2729" },
    { 0x272a,   "Bluetooth GATT Attribute electric resistance (ohm) (UUID 0x272a)", "BT GATT electric resistance (ohm) (UUID 0x272a)", "btgatt.uuid0x272a" },
    { 0x272b,   "Bluetooth GATT Attribute electric conductance (siemens) (UUID 0x272b)", "BT GATT electric conductance (siemens) (UUID 0x272b)", "btgatt.uuid0x272b" },
    { 0x272c,   "Bluetooth GATT Attribute magnetic flux (weber) (UUID 0x272c)", "BT GATT magnetic flux (weber) (UUID 0x272c)", "btgatt.uuid0x272c" },
    { 0x272d,   "Bluetooth GATT Attribute magnetic flux density (tesla) (UUID 0x272d)", "BT GATT magnetic flux density (tesla) (UUID 0x272d)", "btgatt.uuid0x272d" },
    { 0x272e,   "Bluetooth GATT Attribute inductance (henry) (UUID 0x272e)", "BT GATT inductance (henry) (UUID 0x272e)", "btgatt.uuid0x272e" },
    { 0x272f,   "Bluetooth GATT Attribute Celsius temperature (degree Celsius) (UUID 0x272f)", "BT GATT Celsius temperature (degree Celsius) (UUID 0x272f)", "btgatt.uuid0x272f" },
    { 0x2730,   "Bluetooth GATT Attribute luminous flux (lumen) (UUID 0x2730)", "BT GATT luminous flux (lumen) (UUID 0x2730)", "btgatt.uuid0x2730" },
    { 0x2731,   "Bluetooth GATT Attribute illuminance (lux) (UUID 0x2731)", "BT GATT illuminance (lux) (UUID 0x2731)", "btgatt.uuid0x2731" },
    { 0x2732,   "Bluetooth GATT Attribute activity referred to a radionuclide (becquerel) (UUID 0x2732)", "BT GATT activity referred to a radionuclide (becquerel) (UUID 0x2732)", "btgatt.uuid0x2732" },
    { 0x2733,   "Bluetooth GATT Attribute absorbed dose (gray) (UUID 0x2733)", "BT GATT absorbed dose (gray) (UUID 0x2733)", "btgatt.uuid0x2733" },
    { 0x2734,   "Bluetooth GATT Attribute dose equivalent (sievert) (UUID 0x2734)", "BT GATT dose equivalent (sievert) (UUID 0x2734)", "btgatt.uuid0x2734" },
    { 0x2735,   "Bluetooth GATT Attribute catalytic activity (katal) (UUID 0x2735)", "BT GATT catalytic activity (katal) (UUID 0x2735)", "btgatt.uuid0x2735" },
    { 0x2740,   "Bluetooth GATT Attribute dynamic viscosity (pascal second) (UUID 0x2740)", "BT GATT dynamic viscosity (pascal second) (UUID 0x2740)", "btgatt.uuid0x2740" },
    { 0x2741,   "Bluetooth GATT Attribute moment of force (newton metre) (UUID 0x2741)", "BT GATT moment of force (newton metre) (UUID 0x2741)", "btgatt.uuid0x2741" },
    { 0x2742,   "Bluetooth GATT Attribute surface tension (newton per metre) (UUID 0x2742)", "BT GATT surface tension (newton per metre) (UUID 0x2742)", "btgatt.uuid0x2742" },
    { 0x2743,   "Bluetooth GATT Attribute angular velocity (radian per second) (UUID 0x2743)", "BT GATT angular velocity (radian per second) (UUID 0x2743)", "btgatt.uuid0x2743" },
    { 0x2744,   "Bluetooth GATT Attribute angular acceleration (radian per second squared) (UUID 0x2744)", "BT GATT angular acceleration (radian per second squared) (UUID 0x2744)", "btgatt.uuid0x2744" },
    { 0x2745,   "Bluetooth GATT Attribute heat flux density (watt per square metre) (UUID 0x2745)", "BT GATT heat flux density (watt per square metre) (UUID 0x2745)", "btgatt.uuid0x2745" },
    { 0x2746,   "Bluetooth GATT Attribute heat capacity (joule per kelvin) (UUID 0x2746)", "BT GATT heat capacity (joule per kelvin) (UUID 0x2746)", "btgatt.uuid0x2746" },
    { 0x2747,   "Bluetooth GATT Attribute specific heat capacity (joule per kilogram kelvin) (UUID 0x2747)", "BT GATT specific heat capacity (joule per kilogram kelvin) (UUID 0x2747)", "btgatt.uuid0x2747" },
    { 0x2748,   "Bluetooth GATT Attribute specific energy (joule per kilogram) (UUID 0x2748)", "BT GATT specific energy (joule per kilogram) (UUID 0x2748)", "btgatt.uuid0x2748" },
    { 0x2749,   "Bluetooth GATT Attribute thermal conductivity (watt per metre kelvin) (UUID 0x2749)", "BT GATT thermal conductivity (watt per metre kelvin) (UUID 0x2749)", "btgatt.uuid0x2749" },
    { 0x274a,   "Bluetooth GATT Attribute energy density (joule per cubic metre) (UUID 0x274a)", "BT GATT energy density (joule per cubic metre) (UUID 0x274a)", "btgatt.uuid0x274a" },
    { 0x274b,   "Bluetooth GATT Attribute electric field strength (volt per metre) (UUID 0x274b)", "BT GATT electric field strength (volt per metre) (UUID 0x274b)", "btgatt.uuid0x274b" },
    { 0x274c,   "Bluetooth GATT Attribute electric charge density (coulomb per cubic metre) (UUID 0x274c)", "BT GATT electric charge density (coulomb per cubic metre) (UUID 0x274c)", "btgatt.uuid0x274c" },
    { 0x274d,   "Bluetooth GATT Attribute surface charge density (coulomb per square metre) (UUID 0x274d)", "BT GATT surface charge density (coulomb per square metre) (UUID 0x274d)", "btgatt.uuid0x274d" },
    { 0x274e,   "Bluetooth GATT Attribute electric flux density (coulomb per square metre) (UUID 0x274e)", "BT GATT electric flux density (coulomb per square metre) (UUID 0x274e)", "btgatt.uuid0x274e" },
    { 0x274f,   "Bluetooth GATT Attribute permittivity (farad per metre) (UUID 0x274f)", "BT GATT permittivity (farad per metre) (UUID 0x274f)", "btgatt.uuid0x274f" },
    { 0x2750,   "Bluetooth GATT Attribute permeability (henry per metre) (UUID 0x2750)", "BT GATT permeability (henry per metre) (UUID 0x2750)", "btgatt.uuid0x2750" },
    { 0x2751,   "Bluetooth GATT Attribute molar energy (joule per mole) (UUID 0x2751)", "BT GATT molar energy (joule per mole) (UUID 0x2751)", "btgatt.uuid0x2751" },
    { 0x2752,   "Bluetooth GATT Attribute molar entropy (joule per mole kelvin) (UUID 0x2752)", "BT GATT molar entropy (joule per mole kelvin) (UUID 0x2752)", "btgatt.uuid0x2752" },
    { 0x2753,   "Bluetooth GATT Attribute exposure (coulomb per kilogram) (UUID 0x2753)", "BT GATT exposure (coulomb per kilogram) (UUID 0x2753)", "btgatt.uuid0x2753" },
    { 0x2754,   "Bluetooth GATT Attribute absorbed dose rate (gray per second) (UUID 0x2754)", "BT GATT absorbed dose rate (gray per second) (UUID 0x2754)", "btgatt.uuid0x2754" },
    { 0x2755,   "Bluetooth GATT Attribute radiant intensity (watt per steradian) (UUID 0x2755)", "BT GATT radiant intensity (watt per steradian) (UUID 0x2755)", "btgatt.uuid0x2755" },
    { 0x2756,   "Bluetooth GATT Attribute radiance (watt per square metre steradian) (UUID 0x2756)", "BT GATT radiance (watt per square metre steradian) (UUID 0x2756)", "btgatt.uuid0x2756" },
    { 0x2757,   "Bluetooth GATT Attribute catalytic activity concentration (katal per cubic metre) (UUID 0x2757)", "BT GATT catalytic activity concentration (katal per cubic metre) (UUID 0x2757)", "btgatt.uuid0x2757" },
    { 0x2760,   "Bluetooth GATT Attribute time (minute) (UUID 0x2760)", "BT GATT time (minute) (UUID 0x2760)", "btgatt.uuid0x2760" },
    { 0x2761,   "Bluetooth GATT Attribute time (hour) (UUID 0x2761)", "BT GATT time (hour) (UUID 0x2761)", "btgatt.uuid0x2761" },
    { 0x2762,   "Bluetooth GATT Attribute time (day) (UUID 0x2762)", "BT GATT time (day) (UUID 0x2762)", "btgatt.uuid0x2762" },
    { 0x2763,   "Bluetooth GATT Attribute plane angle (degree) (UUID 0x2763)", "BT GATT plane angle (degree) (UUID 0x2763)", "btgatt.uuid0x2763" },
    { 0x2764,   "Bluetooth GATT Attribute plane angle (minute) (UUID 0x2764)", "BT GATT plane angle (minute) (UUID 0x2764)", "btgatt.uuid0x2764" },
    { 0x2765,   "Bluetooth GATT Attribute plane angle (second) (UUID 0x2765)", "BT GATT plane angle (second) (UUID 0x2765)", "btgatt.uuid0x2765" },
    { 0x2766,   "Bluetooth GATT Attribute area (hectare) (UUID 0x2766)", "BT GATT area (hectare) (UUID 0x2766)", "btgatt.uuid0x2766" },
    { 0x2767,   "Bluetooth GATT Attribute volume (litre) (UUID 0x2767)", "BT GATT volume (litre) (UUID 0x2767)", "btgatt.uuid0x2767" },
    { 0x2768,   "Bluetooth GATT Attribute mass (tonne) (UUID 0x2768)", "BT GATT mass (tonne) (UUID 0x2768)", "btgatt.uuid0x2768" },
    { 0x2780,   "Bluetooth GATT Attribute pressure (bar) (UUID 0x2780)", "BT GATT pressure (bar) (UUID 0x2780)", "btgatt.uuid0x2780" },
    { 0x2781,   "Bluetooth GATT Attribute pressure (millimetre of mercury) (UUID 0x2781)", "BT GATT pressure (millimetre of mercury) (UUID 0x2781)", "btgatt.uuid0x2781" },
    { 0x2782,   "Bluetooth GATT Attribute length (ångström) (UUID 0x2782)", "BT GATT length (ångström) (UUID 0x2782)", "btgatt.uuid0x2782" },
    { 0x2783,   "Bluetooth GATT Attribute length (nautical mile) (UUID 0x2783)", "BT GATT length (nautical mile) (UUID 0x2783)", "btgatt.uuid0x2783" },
    { 0x2784,   "Bluetooth GATT Attribute area (barn) (UUID 0x2784)", "BT GATT area (barn) (UUID 0x2784)", "btgatt.uuid0x2784" },
    { 0x2785,   "Bluetooth GATT Attribute velocity (knot) (UUID 0x2785)", "BT GATT velocity (knot) (UUID 0x2785)", "btgatt.uuid0x2785" },
    { 0x2786,   "Bluetooth GATT Attribute logarithmic radio quantity (neper) (UUID 0x2786)", "BT GATT logarithmic radio quantity (neper) (UUID 0x2786)", "btgatt.uuid0x2786" },
    { 0x2787,   "Bluetooth GATT Attribute logarithmic radio quantity (bel) (UUID 0x2787)", "BT GATT logarithmic radio quantity (bel) (UUID 0x2787)", "btgatt.uuid0x2787" },
    { 0x27a0,   "Bluetooth GATT Attribute length (yard) (UUID 0x27a0)", "BT GATT length (yard) (UUID 0x27a0)", "btgatt.uuid0x27a0" },
    { 0x27a1,   "Bluetooth GATT Attribute length (parsec) (UUID 0x27a1)", "BT GATT length (parsec) (UUID 0x27a1)", "btgatt.uuid0x27a1" },
    { 0x27a2,   "Bluetooth GATT Attribute length (inch) (UUID 0x27a2)", "BT GATT length (inch) (UUID 0x27a2)", "btgatt.uuid0x27a2" },
    { 0x27a3,   "Bluetooth GATT Attribute length (foot) (UUID 0x27a3)", "BT GATT length (foot) (UUID 0x27a3)", "btgatt.uuid0x27a3" },
    { 0x27a4,   "Bluetooth GATT Attribute length (mile) (UUID 0x27a4)", "BT GATT length (mile) (UUID 0x27a4)", "btgatt.uuid0x27a4" },
    { 0x27a5,   "Bluetooth GATT Attribute pressure (pound-force per square inch) (UUID 0x27a5)", "BT GATT pressure (pound-force per square inch) (UUID 0x27a5)", "btgatt.uuid0x27a5" },
    { 0x27a6,   "Bluetooth GATT Attribute velocity (kilometre per hour) (UUID 0x27a6)", "BT GATT velocity (kilometre per hour) (UUID 0x27a6)", "btgatt.uuid0x27a6" },
    { 0x27a7,   "Bluetooth GATT Attribute velocity (mile per hour) (UUID 0x27a7)", "BT GATT velocity (mile per hour) (UUID 0x27a7)", "btgatt.uuid0x27a7" },
    { 0x27a8,   "Bluetooth GATT Attribute angular velocity (revolution per minute) (UUID 0x27a8)", "BT GATT angular velocity (revolution per minute) (UUID 0x27a8)", "btgatt.uuid0x27a8" },
    { 0x27a9,   "Bluetooth GATT Attribute energy (gram calorie) (UUID 0x27a9)", "BT GATT energy (gram calorie) (UUID 0x27a9)", "btgatt.uuid0x27a9" },
    { 0x27aa,   "Bluetooth GATT Attribute energy (kilogram calorie) (UUID 0x27aa)", "BT GATT energy (kilogram calorie) (UUID 0x27aa)", "btgatt.uuid0x27aa" },
    { 0x27ab,   "Bluetooth GATT Attribute energy (kilowatt hour) (UUID 0x27ab)", "BT GATT energy (kilowatt hour) (UUID 0x27ab)", "btgatt.uuid0x27ab" },
    { 0x27ac,   "Bluetooth GATT Attribute thermodynamic temperature (degree Fahrenheit) (UUID 0x27ac)", "BT GATT thermodynamic temperature (degree Fahrenheit) (UUID 0x27ac)", "btgatt.uuid0x27ac" },
    { 0x27ad,   "Bluetooth GATT Attribute percentage (UUID 0x27ad)", "BT GATT percentage (UUID 0x27ad)", "btgatt.uuid0x27ad" },
    { 0x27ae,   "Bluetooth GATT Attribute per mille (UUID 0x27ae)", "BT GATT per mille (UUID 0x27ae)", "btgatt.uuid0x27ae" },
    { 0x27af,   "Bluetooth GATT Attribute period (beats per minute) (UUID 0x27af)", "BT GATT period (beats per minute) (UUID 0x27af)", "btgatt.uuid0x27af" },
    { 0x27b0,   "Bluetooth GATT Attribute electric charge (ampere hours) (UUID 0x27b0)", "BT GATT electric charge (ampere hours) (UUID 0x27b0)", "btgatt.uuid0x27b0" },
    { 0x27b1,   "Bluetooth GATT Attribute mass density (milligram per decilitre) (UUID 0x27b1)", "BT GATT mass density (milligram per decilitre) (UUID 0x27b1)", "btgatt.uuid0x27b1" },
    { 0x27b2,   "Bluetooth GATT Attribute mass density (millimole per litre) (UUID 0x27b2)", "BT GATT mass density (millimole per litre) (UUID 0x27b2)", "btgatt.uuid0x27b2" },
    { 0x27b3,   "Bluetooth GATT Attribute time (year) (UUID 0x27b3)", "BT GATT time (year) (UUID 0x27b3)", "btgatt.uuid0x27b3" },
    { 0x27b4,   "Bluetooth GATT Attribute time (month) (UUID 0x27b4)", "BT GATT time (month) (UUID 0x27b4)", "btgatt.uuid0x27b4" },
    { 0x27b5,   "Bluetooth GATT Attribute concentration (count per cubic metre) (UUID 0x27b5)", "BT GATT concentration (count per cubic metre) (UUID 0x27b5)", "btgatt.uuid0x27b5" },
    { 0x27b6,   "Bluetooth GATT Attribute irradiance (watt per square metre) (UUID 0x27b6)", "BT GATT irradiance (watt per square metre) (UUID 0x27b6)", "btgatt.uuid0x27b6" },
    { 0x27b7,   "Bluetooth GATT Attribute milliliter (per kilogram per minute) (UUID 0x27b7)", "BT GATT milliliter (per kilogram per minute) (UUID 0x27b7)", "btgatt.uuid0x27b7" },
    { 0x27b8,   "Bluetooth GATT Attribute mass (pound) (UUID 0x27b8)", "BT GATT mass (pound) (UUID 0x27b8)", "btgatt.uuid0x27b8" },
    { 0x27b9,   "Bluetooth GATT Attribute metabolic equivalent (UUID 0x27b9)", "BT GATT metabolic equivalent (UUID 0x27b9)", "btgatt.uuid0x27b9" },
    { 0x27ba,   "Bluetooth GATT Attribute step (per minute) (UUID 0x27ba)", "BT GATT step (per minute) (UUID 0x27ba)", "btgatt.uuid0x27ba" },
    { 0x27bc,   "Bluetooth GATT Attribute stroke (per minute) (UUID 0x27bc)", "BT GATT stroke (per minute) (UUID 0x27bc)", "btgatt.uuid0x27bc" },
    { 0x27bd,   "Bluetooth GATT Attribute pace (kilometre per minute) (UUID 0x27bd)", "BT GATT pace (kilometre per minute) (UUID 0x27bd)", "btgatt.uuid0x27bd" },
    { 0x27be,   "Bluetooth GATT Attribute luminous efficacy (lumen per watt) (UUID 0x27be)", "BT GATT luminous efficacy (lumen per watt) (UUID 0x27be)", "btgatt.uuid0x27be" },
    { 0x27bf,   "Bluetooth GATT Attribute luminous energy (lumen hour) (UUID 0x27bf)", "BT GATT luminous energy (lumen hour) (UUID 0x27bf)", "btgatt.uuid0x27bf" },
    { 0x27c0,   "Bluetooth GATT Attribute luminous exposure (lux hour) (UUID 0x27c0)", "BT GATT luminous exposure (lux hour) (UUID 0x27c0)", "btgatt.uuid0x27c0" },
    { 0x27c1,   "Bluetooth GATT Attribute mass flow (gram per second) (UUID 0x27c1)", "BT GATT mass flow (gram per second) (UUID 0x27c1)", "btgatt.uuid0x27c1" },
    { 0x27c2,   "Bluetooth GATT Attribute volume flow (litre per second) (UUID 0x27c2)", "BT GATT volume flow (litre per second) (UUID 0x27c2)", "btgatt.uuid0x27c2" },
    { 0x27c3,   "Bluetooth GATT Attribute sound pressure (decibel) (UUID 0x27c3)", "BT GATT sound pressure (decibel) (UUID 0x27c3)", "btgatt.uuid0x27c3" },
    { 0x27c4,   "Bluetooth GATT Attribute parts per million (UUID 0x27c4)", "BT GATT parts per million (UUID 0x27c4)", "btgatt.uuid0x27c4" },
    { 0x27c5,   "Bluetooth GATT Attribute parts per billion (UUID 0x27c5)", "BT GATT parts per billion (UUID 0x27c5)", "btgatt.uuid0x27c5" },
    { 0x27c6,   "Bluetooth GATT Attribute mass density rate ((milligram per decilitre) per minute) (UUID 0x27c6)", "BT GATT mass density rate ((milligram per decilitre) per minute) (UUID 0x27c6)", "btgatt.uuid0x27c6" },
    { 0x27c7,   "Bluetooth GATT Attribute Electrical Apparent Energy (kilovolt ampere hour) (UUID 0x27c7)", "BT GATT Electrical Apparent Energy (kilovolt ampere hour) (UUID 0x27c7)", "btgatt.uuid0x27c7" },
    { 0x27c8,   "Bluetooth GATT Attribute Electrical Apparent Power (volt ampere) (UUID 0x27c8)", "BT GATT Electrical Apparent Power (volt ampere) (UUID 0x27c8)", "btgatt.uuid0x27c8" },
    { 0x27c9,   "Bluetooth GATT Attribute Gravity (g\textsubscript{n}) (UUID 0x27c9)", "BT GATT Gravity (g\textsubscript{n}) (UUID 0x27c9)", "btgatt.uuid0x27c9" },
    /* Declarations - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/declarations.yaml */
    { 0x2800,   "Bluetooth GATT Attribute Primary Service (UUID 0x2800)", "BT GATT Primary Service (UUID 0x2800)", "btgatt.uuid0x2800" },
    { 0x2801,   "Bluetooth GATT Attribute Secondary Service (UUID 0x2801)", "BT GATT Secondary Service (UUID 0x2801)", "btgatt.uuid0x2801" },
    { 0x2802,   "Bluetooth GATT Attribute Include (UUID 0x2802)", "BT GATT Include (UUID 0x2802)", "btgatt.uuid0x2802" },
    { 0x2803,   "Bluetooth GATT Attribute Characteristic (UUID 0x2803)", "BT GATT Characteristic (UUID 0x2803)", "btgatt.uuid0x2803" },
    /* Descriptors - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/descriptors.yaml */
    { 0x2900,   "Bluetooth GATT Attribute Characteristic Extended Properties (UUID 0x2900)", "BT GATT Characteristic Extended Properties (UUID 0x2900)", "btgatt.uuid0x2900" },
    { 0x2901,   "Bluetooth GATT Attribute Characteristic User Description (UUID 0x2901)", "BT GATT Characteristic User Description (UUID 0x2901)", "btgatt.uuid0x2901" },
    { 0x2902,   "Bluetooth GATT Attribute Client Characteristic Configuration (UUID 0x2902)", "BT GATT Client Characteristic Configuration (UUID 0x2902)", "btgatt.uuid0x2902" },
    { 0x2903,   "Bluetooth GATT Attribute Server Characteristic Configuration (UUID 0x2903)", "BT GATT Server Characteristic Configuration (UUID 0x2903)", "btgatt.uuid0x2903" },
    { 0x2904,   "Bluetooth GATT Attribute Characteristic Presentation Format (UUID 0x2904)", "BT GATT Characteristic Presentation Format (UUID 0x2904)", "btgatt.uuid0x2904" },
    { 0x2905,   "Bluetooth GATT Attribute Characteristic Aggregate Format (UUID 0x2905)", "BT GATT Characteristic Aggregate Format (UUID 0x2905)", "btgatt.uuid0x2905" },
    { 0x2906,   "Bluetooth GATT Attribute Valid Range (UUID 0x2906)", "BT GATT Valid Range (UUID 0x2906)", "btgatt.uuid0x2906" },
    { 0x2907,   "Bluetooth GATT Attribute External Report Reference (UUID 0x2907)", "BT GATT External Report Reference (UUID 0x2907)", "btgatt.uuid0x2907" },
    { 0x2908,   "Bluetooth GATT Attribute Report Reference (UUID 0x2908)", "BT GATT Report Reference (UUID 0x2908)", "btgatt.uuid0x2908" },
    { 0x2909,   "Bluetooth GATT Attribute Number of Digitals (UUID 0x2909)", "BT GATT Number of Digitals (UUID 0x2909)", "btgatt.uuid0x2909" },
    { 0x290a,   "Bluetooth GATT Attribute Value Trigger Setting (UUID 0x290a)", "BT GATT Value Trigger Setting (UUID 0x290a)", "btgatt.uuid0x290a" },
    { 0x290b,   "Bluetooth GATT Attribute Environmental Sensing Configuration (UUID 0x290b)", "BT GATT Environmental Sensing Configuration (UUID 0x290b)", "btgatt.uuid0x290b" },
    { 0x290c,   "Bluetooth GATT Attribute Environmental Sensing Measurement (UUID 0x290c)", "BT GATT Environmental Sensing Measurement (UUID 0x290c)", "btgatt.uuid0x290c" },
    { 0x290d,   "Bluetooth GATT Attribute Environmental Sensing Trigger Setting (UUID 0x290d)", "BT GATT Environmental Sensing Trigger Setting (UUID 0x290d)", "btgatt.uuid0x290d" },
    { 0x290e,   "Bluetooth GATT Attribute Time Trigger Setting (UUID 0x290e)", "BT GATT Time Trigger Setting (UUID 0x290e)", "btgatt.uuid0x290e" },
    { 0x290f,   "Bluetooth GATT Attribute Complete BR-EDR Transport Block Data (UUID 0x290f)", "BT GATT Complete BR-EDR Transport Block Data (UUID 0x290f)", "btgatt.uuid0x290f" },
    { 0x2910,   "Bluetooth GATT Attribute Observation Schedule (UUID 0x2910)", "BT GATT Observation Schedule (UUID 0x2910)", "btgatt.uuid0x2910" },
    { 0x2911,   "Bluetooth GATT Attribute Valid Range and Accuracy (UUID 0x2911)", "BT GATT Valid Range and Accuracy (UUID 0x2911)", "btgatt.uuid0x2911" },
    { 0x2912,   "Bluetooth GATT Attribute Measurement Description (UUID 0x2912)", "BT GATT Measurement Description (UUID 0x2912)", "btgatt.uuid0x2912" },
    { 0x2913,   "Bluetooth GATT Attribute Manufacturer Limits (UUID 0x2913)", "BT GATT Manufacturer Limits (UUID 0x2913)", "btgatt.uuid0x2913" },
    { 0x2914,   "Bluetooth GATT Attribute Process Tolerances (UUID 0x2914)", "BT GATT Process Tolerances (UUID 0x2914)", "btgatt.uuid0x2914" },
    { 0x2915,   "Bluetooth GATT Attribute IMD Trigger Setting (UUID 0x2915)", "BT GATT IMD Trigger Setting (UUID 0x2915)", "btgatt.uuid0x2915" },
    { 0x2916,   "Bluetooth GATT Attribute Cooking Sensor Info (UUID 0x2916)", "BT GATT Cooking Sensor Info (UUID 0x2916)", "btgatt.uuid0x2916" },
    { 0x2917,   "Bluetooth GATT Attribute Cooking Trigger Setting (UUID 0x2917)", "BT GATT Cooking Trigger Setting (UUID 0x2917)", "btgatt.uuid0x2917" },
    /* Characteristics - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/characteristic_uuids.yaml */
    { 0x2a00,   "Bluetooth GATT Attribute Device Name (UUID 0x2a00)", "BT GATT Device Name (UUID 0x2a00)", "btgatt.uuid0x2a00" },
    { 0x2a01,   "Bluetooth GATT Attribute Appearance (UUID 0x2a01)", "BT GATT Appearance (UUID 0x2a01)", "btgatt.uuid0x2a01" },
    { 0x2a02,   "Bluetooth GATT Attribute Peripheral Privacy Flag (UUID 0x2a02)", "BT GATT Peripheral Privacy Flag (UUID 0x2a02)", "btgatt.uuid0x2a02" },
    { 0x2a03,   "Bluetooth GATT Attribute Reconnection Address (UUID 0x2a03)", "BT GATT Reconnection Address (UUID 0x2a03)", "btgatt.uuid0x2a03" },
    { 0x2a04,   "Bluetooth GATT Attribute Peripheral Preferred Connection Parameters (UUID 0x2a04)", "BT GATT Peripheral Preferred Connection Parameters (UUID 0x2a04)", "btgatt.uuid0x2a04" },
    { 0x2a05,   "Bluetooth GATT Attribute Service Changed (UUID 0x2a05)", "BT GATT Service Changed (UUID 0x2a05)", "btgatt.uuid0x2a05" },
    { 0x2a06,   "Bluetooth GATT Attribute Alert Level (UUID 0x2a06)", "BT GATT Alert Level (UUID 0x2a06)", "btgatt.uuid0x2a06" },
    { 0x2a07,   "Bluetooth GATT Attribute Tx Power Level (UUID 0x2a07)", "BT GATT Tx Power Level (UUID 0x2a07)", "btgatt.uuid0x2a07" },
    { 0x2a08,   "Bluetooth GATT Attribute Date Time (UUID 0x2a08)", "BT GATT Date Time (UUID 0x2a08)", "btgatt.uuid0x2a08" },
    { 0x2a09,   "Bluetooth GATT Attribute Day of Week (UUID 0x2a09)", "BT GATT Day of Week (UUID 0x2a09)", "btgatt.uuid0x2a09" },
    { 0x2a0a,   "Bluetooth GATT Attribute Day Date Time (UUID 0x2a0a)", "BT GATT Day Date Time (UUID 0x2a0a)", "btgatt.uuid0x2a0a" },
    { 0x2a0b,   "Bluetooth GATT Attribute Exact Time 100 (UUID 0x2a0b)", "BT GATT Exact Time 100 (UUID 0x2a0b)", "btgatt.uuid0x2a0b" },
    { 0x2a0c,   "Bluetooth GATT Attribute Exact Time 256 (UUID 0x2a0c)", "BT GATT Exact Time 256 (UUID 0x2a0c)", "btgatt.uuid0x2a0c" },
    { 0x2a0d,   "Bluetooth GATT Attribute DST Offset (UUID 0x2a0d)", "BT GATT DST Offset (UUID 0x2a0d)", "btgatt.uuid0x2a0d" },
    { 0x2a0e,   "Bluetooth GATT Attribute Time Zone (UUID 0x2a0e)", "BT GATT Time Zone (UUID 0x2a0e)", "btgatt.uuid0x2a0e" },
    { 0x2a0f,   "Bluetooth GATT Attribute Local Time Information (UUID 0x2a0f)", "BT GATT Local Time Information (UUID 0x2a0f)", "btgatt.uuid0x2a0f" },
    { 0x2a10,   "Bluetooth GATT Attribute Secondary Time Zone (UUID 0x2a10)", "BT GATT Secondary Time Zone (UUID 0x2a10)", "btgatt.uuid0x2a10" },
    { 0x2a11,   "Bluetooth GATT Attribute Time with DST (UUID 0x2a11)", "BT GATT Time with DST (UUID 0x2a11)", "btgatt.uuid0x2a11" },
    { 0x2a12,   "Bluetooth GATT Attribute Time Accuracy (UUID 0x2a12)", "BT GATT Time Accuracy (UUID 0x2a12)", "btgatt.uuid0x2a12" },
    { 0x2a13,   "Bluetooth GATT Attribute Time Source (UUID 0x2a13)", "BT GATT Time Source (UUID 0x2a13)", "btgatt.uuid0x2a13" },
    { 0x2a14,   "Bluetooth GATT Attribute Reference Time Information (UUID 0x2a14)", "BT GATT Reference Time Information (UUID 0x2a14)", "btgatt.uuid0x2a14" },
    { 0x2a15,   "Bluetooth GATT Attribute Time Broadcast (UUID 0x2a15)", "BT GATT Time Broadcast (UUID 0x2a15)", "btgatt.uuid0x2a15" },
    { 0x2a16,   "Bluetooth GATT Attribute Time Update Control Point (UUID 0x2a16)", "BT GATT Time Update Control Point (UUID 0x2a16)", "btgatt.uuid0x2a16" },
    { 0x2a17,   "Bluetooth GATT Attribute Time Update State (UUID 0x2a17)", "BT GATT Time Update State (UUID 0x2a17)", "btgatt.uuid0x2a17" },
    { 0x2a18,   "Bluetooth GATT Attribute Glucose Measurement (UUID 0x2a18)", "BT GATT Glucose Measurement (UUID 0x2a18)", "btgatt.uuid0x2a18" },
    { 0x2a19,   "Bluetooth GATT Attribute Battery Level (UUID 0x2a19)", "BT GATT Battery Level (UUID 0x2a19)", "btgatt.uuid0x2a19" },
    { 0x2a1a,   "Bluetooth GATT Attribute Battery Power State (UUID 0x2a1a)", "BT GATT Battery Power State (UUID 0x2a1a)", "btgatt.uuid0x2a1a" },
    { 0x2a1b,   "Bluetooth GATT Attribute Battery Level State (UUID 0x2a1b)", "BT GATT Battery Level State (UUID 0x2a1b)", "btgatt.uuid0x2a1b" },
    { 0x2a1c,   "Bluetooth GATT Attribute Temperature Measurement (UUID 0x2a1c)", "BT GATT Temperature Measurement (UUID 0x2a1c)", "btgatt.uuid0x2a1c" },
    { 0x2a1d,   "Bluetooth GATT Attribute Temperature Type (UUID 0x2a1d)", "BT GATT Temperature Type (UUID 0x2a1d)", "btgatt.uuid0x2a1d" },
    { 0x2a1e,   "Bluetooth GATT Attribute Intermediate Temperature (UUID 0x2a1e)", "BT GATT Intermediate Temperature (UUID 0x2a1e)", "btgatt.uuid0x2a1e" },
    { 0x2a1f,   "Bluetooth GATT Attribute Temperature Celsius (UUID 0x2a1f)", "BT GATT Temperature Celsius (UUID 0x2a1f)", "btgatt.uuid0x2a1f" },
    { 0x2a20,   "Bluetooth GATT Attribute Temperature Fahrenheit (UUID 0x2a20)", "BT GATT Temperature Fahrenheit (UUID 0x2a20)", "btgatt.uuid0x2a20" },
    { 0x2a21,   "Bluetooth GATT Attribute Measurement Interval (UUID 0x2a21)", "BT GATT Measurement Interval (UUID 0x2a21)", "btgatt.uuid0x2a21" },
    { 0x2a22,   "Bluetooth GATT Attribute Boot Keyboard Input Report (UUID 0x2a22)", "BT GATT Boot Keyboard Input Report (UUID 0x2a22)", "btgatt.uuid0x2a22" },
    { 0x2a23,   "Bluetooth GATT Attribute System ID (UUID 0x2a23)", "BT GATT System ID (UUID 0x2a23)", "btgatt.uuid0x2a23" },
    { 0x2a24,   "Bluetooth GATT Attribute Model Number String (UUID 0x2a24)", "BT GATT Model Number String (UUID 0x2a24)", "btgatt.uuid0x2a24" },
    { 0x2a25,   "Bluetooth GATT Attribute Serial Number String (UUID 0x2a25)", "BT GATT Serial Number String (UUID 0x2a25)", "btgatt.uuid0x2a25" },
    { 0x2a26,   "Bluetooth GATT Attribute Firmware Revision String (UUID 0x2a26)", "BT GATT Firmware Revision String (UUID 0x2a26)", "btgatt.uuid0x2a26" },
    { 0x2a27,   "Bluetooth GATT Attribute Hardware Revision String (UUID 0x2a27)", "BT GATT Hardware Revision String (UUID 0x2a27)", "btgatt.uuid0x2a27" },
    { 0x2a28,   "Bluetooth GATT Attribute Software Revision String (UUID 0x2a28)", "BT GATT Software Revision String (UUID 0x2a28)", "btgatt.uuid0x2a28" },
    { 0x2a29,   "Bluetooth GATT Attribute Manufacturer Name String (UUID 0x2a29)", "BT GATT Manufacturer Name String (UUID 0x2a29)", "btgatt.uuid0x2a29" },
    { 0x2a2a,   "Bluetooth GATT Attribute IEEE 11073-20601 Regulatory Certification Data List (UUID 0x2a2a)", "BT GATT IEEE 11073-20601 Regulatory Certification Data List (UUID 0x2a2a)", "btgatt.uuid0x2a2a" },
    { 0x2a2b,   "Bluetooth GATT Attribute Current Time (UUID 0x2a2b)", "BT GATT Current Time (UUID 0x2a2b)", "btgatt.uuid0x2a2b" },
    { 0x2a2c,   "Bluetooth GATT Attribute Magnetic Declination (UUID 0x2a2c)", "BT GATT Magnetic Declination (UUID 0x2a2c)", "btgatt.uuid0x2a2c" },
    { 0x2a2f,   "Bluetooth GATT Attribute Position 2D (UUID 0x2a2f)", "BT GATT Position 2D (UUID 0x2a2f)", "btgatt.uuid0x2a2f" },
    { 0x2a30,   "Bluetooth GATT Attribute Position 3D (UUID 0x2a30)", "BT GATT Position 3D (UUID 0x2a30)", "btgatt.uuid0x2a30" },
    { 0x2a31,   "Bluetooth GATT Attribute Scan Refresh (UUID 0x2a31)", "BT GATT Scan Refresh (UUID 0x2a31)", "btgatt.uuid0x2a31" },
    { 0x2a32,   "Bluetooth GATT Attribute Boot Keyboard Output Report (UUID 0x2a32)", "BT GATT Boot Keyboard Output Report (UUID 0x2a32)", "btgatt.uuid0x2a32" },
    { 0x2a33,   "Bluetooth GATT Attribute Boot Mouse Input Report (UUID 0x2a33)", "BT GATT Boot Mouse Input Report (UUID 0x2a33)", "btgatt.uuid0x2a33" },
    { 0x2a34,   "Bluetooth GATT Attribute Glucose Measurement Context (UUID 0x2a34)", "BT GATT Glucose Measurement Context (UUID 0x2a34)", "btgatt.uuid0x2a34" },
    { 0x2a35,   "Bluetooth GATT Attribute Blood Pressure Measurement (UUID 0x2a35)", "BT GATT Blood Pressure Measurement (UUID 0x2a35)", "btgatt.uuid0x2a35" },
    { 0x2a36,   "Bluetooth GATT Attribute Intermediate Cuff Pressure (UUID 0x2a36)", "BT GATT Intermediate Cuff Pressure (UUID 0x2a36)", "btgatt.uuid0x2a36" },
    { 0x2a37,   "Bluetooth GATT Attribute Heart Rate Measurement (UUID 0x2a37)", "BT GATT Heart Rate Measurement (UUID 0x2a37)", "btgatt.uuid0x2a37" },
    { 0x2a38,   "Bluetooth GATT Attribute Body Sensor Location (UUID 0x2a38)", "BT GATT Body Sensor Location (UUID 0x2a38)", "btgatt.uuid0x2a38" },
    { 0x2a39,   "Bluetooth GATT Attribute Heart Rate Control Point (UUID 0x2a39)", "BT GATT Heart Rate Control Point (UUID 0x2a39)", "btgatt.uuid0x2a39" },
    { 0x2a3a,   "Bluetooth GATT Attribute Removable (UUID 0x2a3a)", "BT GATT Removable (UUID 0x2a3a)", "btgatt.uuid0x2a3a" },
    { 0x2a3b,   "Bluetooth GATT Attribute Service Required (UUID 0x2a3b)", "BT GATT Service Required (UUID 0x2a3b)", "btgatt.uuid0x2a3b" },
    { 0x2a3c,   "Bluetooth GATT Attribute Scientific Temperature Celsius (UUID 0x2a3c)", "BT GATT Scientific Temperature Celsius (UUID 0x2a3c)", "btgatt.uuid0x2a3c" },
    { 0x2a3d,   "Bluetooth GATT Attribute String (UUID 0x2a3d)", "BT GATT String (UUID 0x2a3d)", "btgatt.uuid0x2a3d" },
    { 0x2a3e,   "Bluetooth GATT Attribute Network Availability (UUID 0x2a3e)", "BT GATT Network Availability (UUID 0x2a3e)", "btgatt.uuid0x2a3e" },
    { 0x2a3f,   "Bluetooth GATT Attribute Alert Status (UUID 0x2a3f)", "BT GATT Alert Status (UUID 0x2a3f)", "btgatt.uuid0x2a3f" },
    { 0x2a40,   "Bluetooth GATT Attribute Ringer Control Point (UUID 0x2a40)", "BT GATT Ringer Control Point (UUID 0x2a40)", "btgatt.uuid0x2a40" },
    { 0x2a41,   "Bluetooth GATT Attribute Ringer Setting (UUID 0x2a41)", "BT GATT Ringer Setting (UUID 0x2a41)", "btgatt.uuid0x2a41" },
    { 0x2a42,   "Bluetooth GATT Attribute Alert Category ID Bit Mask (UUID 0x2a42)", "BT GATT Alert Category ID Bit Mask (UUID 0x2a42)", "btgatt.uuid0x2a42" },
    { 0x2a43,   "Bluetooth GATT Attribute Alert Category ID (UUID 0x2a43)", "BT GATT Alert Category ID (UUID 0x2a43)", "btgatt.uuid0x2a43" },
    { 0x2a44,   "Bluetooth GATT Attribute Alert Notification Control Point (UUID 0x2a44)", "BT GATT Alert Notification Control Point (UUID 0x2a44)", "btgatt.uuid0x2a44" },
    { 0x2a45,   "Bluetooth GATT Attribute Unread Alert Status (UUID 0x2a45)", "BT GATT Unread Alert Status (UUID 0x2a45)", "btgatt.uuid0x2a45" },
    { 0x2a46,   "Bluetooth GATT Attribute New Alert (UUID 0x2a46)", "BT GATT New Alert (UUID 0x2a46)", "btgatt.uuid0x2a46" },
    { 0x2a47,   "Bluetooth GATT Attribute Supported New Alert Category (UUID 0x2a47)", "BT GATT Supported New Alert Category (UUID 0x2a47)", "btgatt.uuid0x2a47" },
    { 0x2a48,   "Bluetooth GATT Attribute Supported Unread Alert Category (UUID 0x2a48)", "BT GATT Supported Unread Alert Category (UUID 0x2a48)", "btgatt.uuid0x2a48" },
    { 0x2a49,   "Bluetooth GATT Attribute Blood Pressure Feature (UUID 0x2a49)", "BT GATT Blood Pressure Feature (UUID 0x2a49)", "btgatt.uuid0x2a49" },
    { 0x2a4a,   "Bluetooth GATT Attribute HID Information (UUID 0x2a4a)", "BT GATT HID Information (UUID 0x2a4a)", "btgatt.uuid0x2a4a" },
    { 0x2a4b,   "Bluetooth GATT Attribute Report Map (UUID 0x2a4b)", "BT GATT Report Map (UUID 0x2a4b)", "btgatt.uuid0x2a4b" },
    { 0x2a4c,   "Bluetooth GATT Attribute HID Control Point (UUID 0x2a4c)", "BT GATT HID Control Point (UUID 0x2a4c)", "btgatt.uuid0x2a4c" },
    { 0x2a4d,   "Bluetooth GATT Attribute Report (UUID 0x2a4d)", "BT GATT Report (UUID 0x2a4d)", "btgatt.uuid0x2a4d" },
    { 0x2a4e,   "Bluetooth GATT Attribute Protocol Mode (UUID 0x2a4e)", "BT GATT Protocol Mode (UUID 0x2a4e)", "btgatt.uuid0x2a4e" },
    { 0x2a4f,   "Bluetooth GATT Attribute Scan Interval Window (UUID 0x2a4f)", "BT GATT Scan Interval Window (UUID 0x2a4f)", "btgatt.uuid0x2a4f" },
    { 0x2a50,   "Bluetooth GATT Attribute PnP ID (UUID 0x2a50)", "BT GATT PnP ID (UUID 0x2a50)", "btgatt.uuid0x2a50" },
    { 0x2a51,   "Bluetooth GATT Attribute Glucose Feature (UUID 0x2a51)", "BT GATT Glucose Feature (UUID 0x2a51)", "btgatt.uuid0x2a51" },
    { 0x2a52,   "Bluetooth GATT Attribute Record Access Control Point (UUID 0x2a52)", "BT GATT Record Access Control Point (UUID 0x2a52)", "btgatt.uuid0x2a52" },
    { 0x2a53,   "Bluetooth GATT Attribute RSC Measurement (UUID 0x2a53)", "BT GATT RSC Measurement (UUID 0x2a53)", "btgatt.uuid0x2a53" },
    { 0x2a54,   "Bluetooth GATT Attribute RSC Feature (UUID 0x2a54)", "BT GATT RSC Feature (UUID 0x2a54)", "btgatt.uuid0x2a54" },
    { 0x2a55,   "Bluetooth GATT Attribute SC Control Point (UUID 0x2a55)", "BT GATT SC Control Point (UUID 0x2a55)", "btgatt.uuid0x2a55" },
    { 0x2a56,   "Bluetooth GATT Attribute Digital (UUID 0x2a56)", "BT GATT Digital (UUID 0x2a56)", "btgatt.uuid0x2a56" },
    { 0x2a57,   "Bluetooth GATT Attribute Digital Output (UUID 0x2a57)", "BT GATT Digital Output (UUID 0x2a57)", "btgatt.uuid0x2a57" },
    { 0x2a58,   "Bluetooth GATT Attribute Analog (UUID 0x2a58)", "BT GATT Analog (UUID 0x2a58)", "btgatt.uuid0x2a58" },
    { 0x2a59,   "Bluetooth GATT Attribute Analog Output (UUID 0x2a59)", "BT GATT Analog Output (UUID 0x2a59)", "btgatt.uuid0x2a59" },
    { 0x2a5a,   "Bluetooth GATT Attribute Aggregate (UUID 0x2a5a)", "BT GATT Aggregate (UUID 0x2a5a)", "btgatt.uuid0x2a5a" },
    { 0x2a5b,   "Bluetooth GATT Attribute CSC Measurement (UUID 0x2a5b)", "BT GATT CSC Measurement (UUID 0x2a5b)", "btgatt.uuid0x2a5b" },
    { 0x2a5c,   "Bluetooth GATT Attribute CSC Feature (UUID 0x2a5c)", "BT GATT CSC Feature (UUID 0x2a5c)", "btgatt.uuid0x2a5c" },
    { 0x2a5d,   "Bluetooth GATT Attribute Sensor Location (UUID 0x2a5d)", "BT GATT Sensor Location (UUID 0x2a5d)", "btgatt.uuid0x2a5d" },
    { 0x2a5e,   "Bluetooth GATT Attribute PLX Spot-Check Measurement (UUID 0x2a5e)", "BT GATT PLX Spot-Check Measurement (UUID 0x2a5e)", "btgatt.uuid0x2a5e" },
    { 0x2a5f,   "Bluetooth GATT Attribute PLX Continuous Measurement (UUID 0x2a5f)", "BT GATT PLX Continuous Measurement (UUID 0x2a5f)", "btgatt.uuid0x2a5f" },
    { 0x2a60,   "Bluetooth GATT Attribute PLX Features (UUID 0x2a60)", "BT GATT PLX Features (UUID 0x2a60)", "btgatt.uuid0x2a60" },
    { 0x2a62,   "Bluetooth GATT Attribute Pulse Oximetry Control Point (UUID 0x2a62)", "BT GATT Pulse Oximetry Control Point (UUID 0x2a62)", "btgatt.uuid0x2a62" },
    { 0x2a63,   "Bluetooth GATT Attribute Cycling Power Measurement (UUID 0x2a63)", "BT GATT Cycling Power Measurement (UUID 0x2a63)", "btgatt.uuid0x2a63" },
    { 0x2a64,   "Bluetooth GATT Attribute Cycling Power Vector (UUID 0x2a64)", "BT GATT Cycling Power Vector (UUID 0x2a64)", "btgatt.uuid0x2a64" },
    { 0x2a65,   "Bluetooth GATT Attribute Cycling Power Feature (UUID 0x2a65)", "BT GATT Cycling Power Feature (UUID 0x2a65)", "btgatt.uuid0x2a65" },
    { 0x2a66,   "Bluetooth GATT Attribute Cycling Power Control Point (UUID 0x2a66)", "BT GATT Cycling Power Control Point (UUID 0x2a66)", "btgatt.uuid0x2a66" },
    { 0x2a67,   "Bluetooth GATT Attribute Location and Speed (UUID 0x2a67)", "BT GATT Location and Speed (UUID 0x2a67)", "btgatt.uuid0x2a67" },
    { 0x2a68,   "Bluetooth GATT Attribute Navigation (UUID 0x2a68)", "BT GATT Navigation (UUID 0x2a68)", "btgatt.uuid0x2a68" },
    { 0x2a69,   "Bluetooth GATT Attribute Position Quality (UUID 0x2a69)", "BT GATT Position Quality (UUID 0x2a69)", "btgatt.uuid0x2a69" },
    { 0x2a6a,   "Bluetooth GATT Attribute LN Feature (UUID 0x2a6a)", "BT GATT LN Feature (UUID 0x2a6a)", "btgatt.uuid0x2a6a" },
    { 0x2a6b,   "Bluetooth GATT Attribute LN Control Point (UUID 0x2a6b)", "BT GATT LN Control Point (UUID 0x2a6b)", "btgatt.uuid0x2a6b" },
    { 0x2a6c,   "Bluetooth GATT Attribute Elevation (UUID 0x2a6c)", "BT GATT Elevation (UUID 0x2a6c)", "btgatt.uuid0x2a6c" },
    { 0x2a6d,   "Bluetooth GATT Attribute Pressure (UUID 0x2a6d)", "BT GATT Pressure (UUID 0x2a6d)", "btgatt.uuid0x2a6d" },
    { 0x2a6e,   "Bluetooth GATT Attribute Temperature (UUID 0x2a6e)", "BT GATT Temperature (UUID 0x2a6e)", "btgatt.uuid0x2a6e" },
    { 0x2a6f,   "Bluetooth GATT Attribute Humidity (UUID 0x2a6f)", "BT GATT Humidity (UUID 0x2a6f)", "btgatt.uuid0x2a6f" },
    { 0x2a70,   "Bluetooth GATT Attribute True Wind Speed (UUID 0x2a70)", "BT GATT True Wind Speed (UUID 0x2a70)", "btgatt.uuid0x2a70" },
    { 0x2a71,   "Bluetooth GATT Attribute True Wind Direction (UUID 0x2a71)", "BT GATT True Wind Direction (UUID 0x2a71)", "btgatt.uuid0x2a71" },
    { 0x2a72,   "Bluetooth GATT Attribute Apparent Wind Speed (UUID 0x2a72)", "BT GATT Apparent Wind Speed (UUID 0x2a72)", "btgatt.uuid0x2a72" },
    { 0x2a73,   "Bluetooth GATT Attribute Apparent Wind Direction (UUID 0x2a73)", "BT GATT Apparent Wind Direction (UUID 0x2a73)", "btgatt.uuid0x2a73" },
    { 0x2a74,   "Bluetooth GATT Attribute Gust Factor (UUID 0x2a74)", "BT GATT Gust Factor (UUID 0x2a74)", "btgatt.uuid0x2a74" },
    { 0x2a75,   "Bluetooth GATT Attribute Pollen Concentration (UUID 0x2a75)", "BT GATT Pollen Concentration (UUID 0x2a75)", "btgatt.uuid0x2a75" },
    { 0x2a76,   "Bluetooth GATT Attribute UV Index (UUID 0x2a76)", "BT GATT UV Index (UUID 0x2a76)", "btgatt.uuid0x2a76" },
    { 0x2a77,   "Bluetooth GATT Attribute Irradiance (UUID 0x2a77)", "BT GATT Irradiance (UUID 0x2a77)", "btgatt.uuid0x2a77" },
    { 0x2a78,   "Bluetooth GATT Attribute Rainfall (UUID 0x2a78)", "BT GATT Rainfall (UUID 0x2a78)", "btgatt.uuid0x2a78" },
    { 0x2a79,   "Bluetooth GATT Attribute Wind Chill (UUID 0x2a79)", "BT GATT Wind Chill (UUID 0x2a79)", "btgatt.uuid0x2a79" },
    { 0x2a7a,   "Bluetooth GATT Attribute Heat Index (UUID 0x2a7a)", "BT GATT Heat Index (UUID 0x2a7a)", "btgatt.uuid0x2a7a" },
    { 0x2a7b,   "Bluetooth GATT Attribute Dew Point (UUID 0x2a7b)", "BT GATT Dew Point (UUID 0x2a7b)", "btgatt.uuid0x2a7b" },
    { 0x2a7d,   "Bluetooth GATT Attribute Descriptor Value Changed (UUID 0x2a7d)", "BT GATT Descriptor Value Changed (UUID 0x2a7d)", "btgatt.uuid0x2a7d" },
    { 0x2a7e,   "Bluetooth GATT Attribute Aerobic Heart Rate Lower Limit (UUID 0x2a7e)", "BT GATT Aerobic Heart Rate Lower Limit (UUID 0x2a7e)", "btgatt.uuid0x2a7e" },
    { 0x2a7f,   "Bluetooth GATT Attribute Aerobic Threshold (UUID 0x2a7f)", "BT GATT Aerobic Threshold (UUID 0x2a7f)", "btgatt.uuid0x2a7f" },
    { 0x2a80,   "Bluetooth GATT Attribute Age (UUID 0x2a80)", "BT GATT Age (UUID 0x2a80)", "btgatt.uuid0x2a80" },
    { 0x2a81,   "Bluetooth GATT Attribute Anaerobic Heart Rate Lower Limit (UUID 0x2a81)", "BT GATT Anaerobic Heart Rate Lower Limit (UUID 0x2a81)", "btgatt.uuid0x2a81" },
    { 0x2a82,   "Bluetooth GATT Attribute Anaerobic Heart Rate Upper Limit (UUID 0x2a82)", "BT GATT Anaerobic Heart Rate Upper Limit (UUID 0x2a82)", "btgatt.uuid0x2a82" },
    { 0x2a83,   "Bluetooth GATT Attribute Anaerobic Threshold (UUID 0x2a83)", "BT GATT Anaerobic Threshold (UUID 0x2a83)", "btgatt.uuid0x2a83" },
    { 0x2a84,   "Bluetooth GATT Attribute Aerobic Heart Rate Upper Limit (UUID 0x2a84)", "BT GATT Aerobic Heart Rate Upper Limit (UUID 0x2a84)", "btgatt.uuid0x2a84" },
    { 0x2a85,   "Bluetooth GATT Attribute Date of Birth (UUID 0x2a85)", "BT GATT Date of Birth (UUID 0x2a85)", "btgatt.uuid0x2a85" },
    { 0x2a86,   "Bluetooth GATT Attribute Date of Threshold Assessment (UUID 0x2a86)", "BT GATT Date of Threshold Assessment (UUID 0x2a86)", "btgatt.uuid0x2a86" },
    { 0x2a87,   "Bluetooth GATT Attribute Email Address (UUID 0x2a87)", "BT GATT Email Address (UUID 0x2a87)", "btgatt.uuid0x2a87" },
    { 0x2a88,   "Bluetooth GATT Attribute Fat Burn Heart Rate Lower Limit (UUID 0x2a88)", "BT GATT Fat Burn Heart Rate Lower Limit (UUID 0x2a88)", "btgatt.uuid0x2a88" },
    { 0x2a89,   "Bluetooth GATT Attribute Fat Burn Heart Rate Upper Limit (UUID 0x2a89)", "BT GATT Fat Burn Heart Rate Upper Limit (UUID 0x2a89)", "btgatt.uuid0x2a89" },
    { 0x2a8a,   "Bluetooth GATT Attribute First Name (UUID 0x2a8a)", "BT GATT First Name (UUID 0x2a8a)", "btgatt.uuid0x2a8a" },
    { 0x2a8b,   "Bluetooth GATT Attribute Five Zone Heart Rate Limits (UUID 0x2a8b)", "BT GATT Five Zone Heart Rate Limits (UUID 0x2a8b)", "btgatt.uuid0x2a8b" },
    { 0x2a8c,   "Bluetooth GATT Attribute Gender (UUID 0x2a8c)", "BT GATT Gender (UUID 0x2a8c)", "btgatt.uuid0x2a8c" },
    { 0x2a8d,   "Bluetooth GATT Attribute Heart Rate Max (UUID 0x2a8d)", "BT GATT Heart Rate Max (UUID 0x2a8d)", "btgatt.uuid0x2a8d" },
    { 0x2a8e,   "Bluetooth GATT Attribute Height (UUID 0x2a8e)", "BT GATT Height (UUID 0x2a8e)", "btgatt.uuid0x2a8e" },
    { 0x2a8f,   "Bluetooth GATT Attribute Hip Circumference (UUID 0x2a8f)", "BT GATT Hip Circumference (UUID 0x2a8f)", "btgatt.uuid0x2a8f" },
    { 0x2a90,   "Bluetooth GATT Attribute Last Name (UUID 0x2a90)", "BT GATT Last Name (UUID 0x2a90)", "btgatt.uuid0x2a90" },
    { 0x2a91,   "Bluetooth GATT Attribute Maximum Recommended Heart Rate (UUID 0x2a91)", "BT GATT Maximum Recommended Heart Rate (UUID 0x2a91)", "btgatt.uuid0x2a91" },
    { 0x2a92,   "Bluetooth GATT Attribute Resting Heart Rate (UUID 0x2a92)", "BT GATT Resting Heart Rate (UUID 0x2a92)", "btgatt.uuid0x2a92" },
    { 0x2a93,   "Bluetooth GATT Attribute Sport Type for Aerobic and Anaerobic Thresholds (UUID 0x2a93)", "BT GATT Sport Type for Aerobic and Anaerobic Thresholds (UUID 0x2a93)", "btgatt.uuid0x2a93" },
    { 0x2a94,   "Bluetooth GATT Attribute Three Zone Heart Rate Limits (UUID 0x2a94)", "BT GATT Three Zone Heart Rate Limits (UUID 0x2a94)", "btgatt.uuid0x2a94" },
    { 0x2a95,   "Bluetooth GATT Attribute Two Zone Heart Rate Limits (UUID 0x2a95)", "BT GATT Two Zone Heart Rate Limits (UUID 0x2a95)", "btgatt.uuid0x2a95" },
    { 0x2a96,   "Bluetooth GATT Attribute VO2 Max (UUID 0x2a96)", "BT GATT VO2 Max (UUID 0x2a96)", "btgatt.uuid0x2a96" },
    { 0x2a97,   "Bluetooth GATT Attribute Waist Circumference (UUID 0x2a97)", "BT GATT Waist Circumference (UUID 0x2a97)", "btgatt.uuid0x2a97" },
    { 0x2a98,   "Bluetooth GATT Attribute Weight (UUID 0x2a98)", "BT GATT Weight (UUID 0x2a98)", "btgatt.uuid0x2a98" },
    { 0x2a99,   "Bluetooth GATT Attribute Database Change Increment (UUID 0x2a99)", "BT GATT Database Change Increment (UUID 0x2a99)", "btgatt.uuid0x2a99" },
    { 0x2a9a,   "Bluetooth GATT Attribute User Index (UUID 0x2a9a)", "BT GATT User Index (UUID 0x2a9a)", "btgatt.uuid0x2a9a" },
    { 0x2a9b,   "Bluetooth GATT Attribute Body Composition Feature (UUID 0x2a9b)", "BT GATT Body Composition Feature (UUID 0x2a9b)", "btgatt.uuid0x2a9b" },
    { 0x2a9c,   "Bluetooth GATT Attribute Body Composition Measurement (UUID 0x2a9c)", "BT GATT Body Composition Measurement (UUID 0x2a9c)", "btgatt.uuid0x2a9c" },
    { 0x2a9d,   "Bluetooth GATT Attribute Weight Measurement (UUID 0x2a9d)", "BT GATT Weight Measurement (UUID 0x2a9d)", "btgatt.uuid0x2a9d" },
    { 0x2a9e,   "Bluetooth GATT Attribute Weight Scale Feature (UUID 0x2a9e)", "BT GATT Weight Scale Feature (UUID 0x2a9e)", "btgatt.uuid0x2a9e" },
    { 0x2a9f,   "Bluetooth GATT Attribute User Control Point (UUID 0x2a9f)", "BT GATT User Control Point (UUID 0x2a9f)", "btgatt.uuid0x2a9f" },
    { 0x2aa0,   "Bluetooth GATT Attribute Magnetic Flux Density - 2D (UUID 0x2aa0)", "BT GATT Magnetic Flux Density - 2D (UUID 0x2aa0)", "btgatt.uuid0x2aa0" },
    { 0x2aa1,   "Bluetooth GATT Attribute Magnetic Flux Density - 3D (UUID 0x2aa1)", "BT GATT Magnetic Flux Density - 3D (UUID 0x2aa1)", "btgatt.uuid0x2aa1" },
    { 0x2aa2,   "Bluetooth GATT Attribute Language (UUID 0x2aa2)", "BT GATT Language (UUID 0x2aa2)", "btgatt.uuid0x2aa2" },
    { 0x2aa3,   "Bluetooth GATT Attribute Barometric Pressure Trend (UUID 0x2aa3)", "BT GATT Barometric Pressure Trend (UUID 0x2aa3)", "btgatt.uuid0x2aa3" },
    { 0x2aa4,   "Bluetooth GATT Attribute Bond Management Control Point (UUID 0x2aa4)", "BT GATT Bond Management Control Point (UUID 0x2aa4)", "btgatt.uuid0x2aa4" },
    { 0x2aa5,   "Bluetooth GATT Attribute Bond Management Feature (UUID 0x2aa5)", "BT GATT Bond Management Feature (UUID 0x2aa5)", "btgatt.uuid0x2aa5" },
    { 0x2aa6,   "Bluetooth GATT Attribute Central Address Resolution (UUID 0x2aa6)", "BT GATT Central Address Resolution (UUID 0x2aa6)", "btgatt.uuid0x2aa6" },
    { 0x2aa7,   "Bluetooth GATT Attribute CGM Measurement (UUID 0x2aa7)", "BT GATT CGM Measurement (UUID 0x2aa7)", "btgatt.uuid0x2aa7" },
    { 0x2aa8,   "Bluetooth GATT Attribute CGM Feature (UUID 0x2aa8)", "BT GATT CGM Feature (UUID 0x2aa8)", "btgatt.uuid0x2aa8" },
    { 0x2aa9,   "Bluetooth GATT Attribute CGM Status (UUID 0x2aa9)", "BT GATT CGM Status (UUID 0x2aa9)", "btgatt.uuid0x2aa9" },
    { 0x2aaa,   "Bluetooth GATT Attribute CGM Session Start Time (UUID 0x2aaa)", "BT GATT CGM Session Start Time (UUID 0x2aaa)", "btgatt.uuid0x2aaa" },
    { 0x2aab,   "Bluetooth GATT Attribute CGM Session Run Time (UUID 0x2aab)", "BT GATT CGM Session Run Time (UUID 0x2aab)", "btgatt.uuid0x2aab" },
    { 0x2aac,   "Bluetooth GATT Attribute CGM Specific Ops Control Point (UUID 0x2aac)", "BT GATT CGM Specific Ops Control Point (UUID 0x2aac)", "btgatt.uuid0x2aac" },
    { 0x2aad,   "Bluetooth GATT Attribute Indoor Positioning Configuration (UUID 0x2aad)", "BT GATT Indoor Positioning Configuration (UUID 0x2aad)", "btgatt.uuid0x2aad" },
    { 0x2aae,   "Bluetooth GATT Attribute Latitude (UUID 0x2aae)", "BT GATT Latitude (UUID 0x2aae)", "btgatt.uuid0x2aae" },
    { 0x2aaf,   "Bluetooth GATT Attribute Longitude (UUID 0x2aaf)", "BT GATT Longitude (UUID 0x2aaf)", "btgatt.uuid0x2aaf" },
    { 0x2ab0,   "Bluetooth GATT Attribute Local North Coordinate (UUID 0x2ab0)", "BT GATT Local North Coordinate (UUID 0x2ab0)", "btgatt.uuid0x2ab0" },
    { 0x2ab1,   "Bluetooth GATT Attribute Local East Coordinate (UUID 0x2ab1)", "BT GATT Local East Coordinate (UUID 0x2ab1)", "btgatt.uuid0x2ab1" },
    { 0x2ab2,   "Bluetooth GATT Attribute Floor Number (UUID 0x2ab2)", "BT GATT Floor Number (UUID 0x2ab2)", "btgatt.uuid0x2ab2" },
    { 0x2ab3,   "Bluetooth GATT Attribute Altitude (UUID 0x2ab3)", "BT GATT Altitude (UUID 0x2ab3)", "btgatt.uuid0x2ab3" },
    { 0x2ab4,   "Bluetooth GATT Attribute Uncertainty (UUID 0x2ab4)", "BT GATT Uncertainty (UUID 0x2ab4)", "btgatt.uuid0x2ab4" },
    { 0x2ab5,   "Bluetooth GATT Attribute Location Name (UUID 0x2ab5)", "BT GATT Location Name (UUID 0x2ab5)", "btgatt.uuid0x2ab5" },
    { 0x2ab6,   "Bluetooth GATT Attribute URI (UUID 0x2ab6)", "BT GATT URI (UUID 0x2ab6)", "btgatt.uuid0x2ab6" },
    { 0x2ab7,   "Bluetooth GATT Attribute HTTP Headers (UUID 0x2ab7)", "BT GATT HTTP Headers (UUID 0x2ab7)", "btgatt.uuid0x2ab7" },
    { 0x2ab8,   "Bluetooth GATT Attribute HTTP Status Code (UUID 0x2ab8)", "BT GATT HTTP Status Code (UUID 0x2ab8)", "btgatt.uuid0x2ab8" },
    { 0x2ab9,   "Bluetooth GATT Attribute HTTP Entity Body (UUID 0x2ab9)", "BT GATT HTTP Entity Body (UUID 0x2ab9)", "btgatt.uuid0x2ab9" },
    { 0x2aba,   "Bluetooth GATT Attribute HTTP Control Point (UUID 0x2aba)", "BT GATT HTTP Control Point (UUID 0x2aba)", "btgatt.uuid0x2aba" },
    { 0x2abb,   "Bluetooth GATT Attribute HTTPS Security (UUID 0x2abb)", "BT GATT HTTPS Security (UUID 0x2abb)", "btgatt.uuid0x2abb" },
    { 0x2abc,   "Bluetooth GATT Attribute TDS Control Point (UUID 0x2abc)", "BT GATT TDS Control Point (UUID 0x2abc)", "btgatt.uuid0x2abc" },
    { 0x2abd,   "Bluetooth GATT Attribute OTS Feature (UUID 0x2abd)", "BT GATT OTS Feature (UUID 0x2abd)", "btgatt.uuid0x2abd" },
    { 0x2abe,   "Bluetooth GATT Attribute Object Name (UUID 0x2abe)", "BT GATT Object Name (UUID 0x2abe)", "btgatt.uuid0x2abe" },
    { 0x2abf,   "Bluetooth GATT Attribute Object Type (UUID 0x2abf)", "BT GATT Object Type (UUID 0x2abf)", "btgatt.uuid0x2abf" },
    { 0x2ac0,   "Bluetooth GATT Attribute Object Size (UUID 0x2ac0)", "BT GATT Object Size (UUID 0x2ac0)", "btgatt.uuid0x2ac0" },
    { 0x2ac1,   "Bluetooth GATT Attribute Object First-Created (UUID 0x2ac1)", "BT GATT Object First-Created (UUID 0x2ac1)", "btgatt.uuid0x2ac1" },
    { 0x2ac2,   "Bluetooth GATT Attribute Object Last-Modified (UUID 0x2ac2)", "BT GATT Object Last-Modified (UUID 0x2ac2)", "btgatt.uuid0x2ac2" },
    { 0x2ac3,   "Bluetooth GATT Attribute Object ID (UUID 0x2ac3)", "BT GATT Object ID (UUID 0x2ac3)", "btgatt.uuid0x2ac3" },
    { 0x2ac4,   "Bluetooth GATT Attribute Object Properties (UUID 0x2ac4)", "BT GATT Object Properties (UUID 0x2ac4)", "btgatt.uuid0x2ac4" },
    { 0x2ac5,   "Bluetooth GATT Attribute Object Action Control Point (UUID 0x2ac5)", "BT GATT Object Action Control Point (UUID 0x2ac5)", "btgatt.uuid0x2ac5" },
    { 0x2ac6,   "Bluetooth GATT Attribute Object List Control Point (UUID 0x2ac6)", "BT GATT Object List Control Point (UUID 0x2ac6)", "btgatt.uuid0x2ac6" },
    { 0x2ac7,   "Bluetooth GATT Attribute Object List Filter (UUID 0x2ac7)", "BT GATT Object List Filter (UUID 0x2ac7)", "btgatt.uuid0x2ac7" },
    { 0x2ac8,   "Bluetooth GATT Attribute Object Changed (UUID 0x2ac8)", "BT GATT Object Changed (UUID 0x2ac8)", "btgatt.uuid0x2ac8" },
    { 0x2ac9,   "Bluetooth GATT Attribute Resolvable Private Address Only (UUID 0x2ac9)", "BT GATT Resolvable Private Address Only (UUID 0x2ac9)", "btgatt.uuid0x2ac9" },
    { 0x2aca,   "Bluetooth GATT Attribute Unspecified (UUID 0x2aca)", "BT GATT Unspecified (UUID 0x2aca)", "btgatt.uuid0x2aca" },
    { 0x2acb,   "Bluetooth GATT Attribute Directory Listing (UUID 0x2acb)", "BT GATT Directory Listing (UUID 0x2acb)", "btgatt.uuid0x2acb" },
    { 0x2acc,   "Bluetooth GATT Attribute Fitness Machine Feature (UUID 0x2acc)", "BT GATT Fitness Machine Feature (UUID 0x2acc)", "btgatt.uuid0x2acc" },
    { 0x2acd,   "Bluetooth GATT Attribute Treadmill Data (UUID 0x2acd)", "BT GATT Treadmill Data (UUID 0x2acd)", "btgatt.uuid0x2acd" },
    { 0x2ace,   "Bluetooth GATT Attribute Cross Trainer Data (UUID 0x2ace)", "BT GATT Cross Trainer Data (UUID 0x2ace)", "btgatt.uuid0x2ace" },
    { 0x2acf,   "Bluetooth GATT Attribute Step Climber Data (UUID 0x2acf)", "BT GATT Step Climber Data (UUID 0x2acf)", "btgatt.uuid0x2acf" },
    { 0x2ad0,   "Bluetooth GATT Attribute Stair Climber Data (UUID 0x2ad0)", "BT GATT Stair Climber Data (UUID 0x2ad0)", "btgatt.uuid0x2ad0" },
    { 0x2ad1,   "Bluetooth GATT Attribute Rower Data (UUID 0x2ad1)", "BT GATT Rower Data (UUID 0x2ad1)", "btgatt.uuid0x2ad1" },
    { 0x2ad2,   "Bluetooth GATT Attribute Indoor Bike Data (UUID 0x2ad2)", "BT GATT Indoor Bike Data (UUID 0x2ad2)", "btgatt.uuid0x2ad2" },
    { 0x2ad3,   "Bluetooth GATT Attribute Training Status (UUID 0x2ad3)", "BT GATT Training Status (UUID 0x2ad3)", "btgatt.uuid0x2ad3" },
    { 0x2ad4,   "Bluetooth GATT Attribute Supported Speed Range (UUID 0x2ad4)", "BT GATT Supported Speed Range (UUID 0x2ad4)", "btgatt.uuid0x2ad4" },
    { 0x2ad5,   "Bluetooth GATT Attribute Supported Inclination Range (UUID 0x2ad5)", "BT GATT Supported Inclination Range (UUID 0x2ad5)", "btgatt.uuid0x2ad5" },
    { 0x2ad6,   "Bluetooth GATT Attribute Supported Resistance Level Range (UUID 0x2ad6)", "BT GATT Supported Resistance Level Range (UUID 0x2ad6)", "btgatt.uuid0x2ad6" },
    { 0x2ad7,   "Bluetooth GATT Attribute Supported Heart Rate Range (UUID 0x2ad7)", "BT GATT Supported Heart Rate Range (UUID 0x2ad7)", "btgatt.uuid0x2ad7" },
    { 0x2ad8,   "Bluetooth GATT Attribute Supported Power Range (UUID 0x2ad8)", "BT GATT Supported Power Range (UUID 0x2ad8)", "btgatt.uuid0x2ad8" },
    { 0x2ad9,   "Bluetooth GATT Attribute Fitness Machine Control Point (UUID 0x2ad9)", "BT GATT Fitness Machine Control Point (UUID 0x2ad9)", "btgatt.uuid0x2ad9" },
    { 0x2ada,   "Bluetooth GATT Attribute Fitness Machine Status (UUID 0x2ada)", "BT GATT Fitness Machine Status (UUID 0x2ada)", "btgatt.uuid0x2ada" },
    { 0x2adb,   "Bluetooth GATT Attribute Mesh Provisioning Data In (UUID 0x2adb)", "BT GATT Mesh Provisioning Data In (UUID 0x2adb)", "btgatt.uuid0x2adb" },
    { 0x2adc,   "Bluetooth GATT Attribute Mesh Provisioning Data Out (UUID 0x2adc)", "BT GATT Mesh Provisioning Data Out (UUID 0x2adc)", "btgatt.uuid0x2adc" },
    { 0x2add,   "Bluetooth GATT Attribute Mesh Proxy Data In (UUID 0x2add)", "BT GATT Mesh Proxy Data In (UUID 0x2add)", "btgatt.uuid0x2add" },
    { 0x2ade,   "Bluetooth GATT Attribute Mesh Proxy Data Out (UUID 0x2ade)", "BT GATT Mesh Proxy Data Out (UUID 0x2ade)", "btgatt.uuid0x2ade" },
    { 0x2ae0,   "Bluetooth GATT Attribute Average Current (UUID 0x2ae0)", "BT GATT Average Current (UUID 0x2ae0)", "btgatt.uuid0x2ae0" },
    { 0x2ae1,   "Bluetooth GATT Attribute Average Voltage (UUID 0x2ae1)", "BT GATT Average Voltage (UUID 0x2ae1)", "btgatt.uuid0x2ae1" },
    { 0x2ae2,   "Bluetooth GATT Attribute Boolean (UUID 0x2ae2)", "BT GATT Boolean (UUID 0x2ae2)", "btgatt.uuid0x2ae2" },
    { 0x2ae3,   "Bluetooth GATT Attribute Chromatic Distance from Planckian (UUID 0x2ae3)", "BT GATT Chromatic Distance from Planckian (UUID 0x2ae3)", "btgatt.uuid0x2ae3" },
    { 0x2ae4,   "Bluetooth GATT Attribute Chromaticity Coordinates (UUID 0x2ae4)", "BT GATT Chromaticity Coordinates (UUID 0x2ae4)", "btgatt.uuid0x2ae4" },
    { 0x2ae5,   "Bluetooth GATT Attribute Chromaticity in CCT and Duv Values (UUID 0x2ae5)", "BT GATT Chromaticity in CCT and Duv Values (UUID 0x2ae5)", "btgatt.uuid0x2ae5" },
    { 0x2ae6,   "Bluetooth GATT Attribute Chromaticity Tolerance (UUID 0x2ae6)", "BT GATT Chromaticity Tolerance (UUID 0x2ae6)", "btgatt.uuid0x2ae6" },
    { 0x2ae7,   "Bluetooth GATT Attribute CIE 13.3-1995 Color Rendering Index (UUID 0x2ae7)", "BT GATT CIE 13.3-1995 Color Rendering Index (UUID 0x2ae7)", "btgatt.uuid0x2ae7" },
    { 0x2ae8,   "Bluetooth GATT Attribute Coefficient (UUID 0x2ae8)", "BT GATT Coefficient (UUID 0x2ae8)", "btgatt.uuid0x2ae8" },
    { 0x2ae9,   "Bluetooth GATT Attribute Correlated Color Temperature (UUID 0x2ae9)", "BT GATT Correlated Color Temperature (UUID 0x2ae9)", "btgatt.uuid0x2ae9" },
    { 0x2aea,   "Bluetooth GATT Attribute Count 16 (UUID 0x2aea)", "BT GATT Count 16 (UUID 0x2aea)", "btgatt.uuid0x2aea" },
    { 0x2aeb,   "Bluetooth GATT Attribute Count 24 (UUID 0x2aeb)", "BT GATT Count 24 (UUID 0x2aeb)", "btgatt.uuid0x2aeb" },
    { 0x2aec,   "Bluetooth GATT Attribute Country Code (UUID 0x2aec)", "BT GATT Country Code (UUID 0x2aec)", "btgatt.uuid0x2aec" },
    { 0x2aed,   "Bluetooth GATT Attribute Date UTC (UUID 0x2aed)", "BT GATT Date UTC (UUID 0x2aed)", "btgatt.uuid0x2aed" },
    { 0x2aee,   "Bluetooth GATT Attribute Electric Current (UUID 0x2aee)", "BT GATT Electric Current (UUID 0x2aee)", "btgatt.uuid0x2aee" },
    { 0x2aef,   "Bluetooth GATT Attribute Electric Current Range (UUID 0x2aef)", "BT GATT Electric Current Range (UUID 0x2aef)", "btgatt.uuid0x2aef" },
    { 0x2af0,   "Bluetooth GATT Attribute Electric Current Specification (UUID 0x2af0)", "BT GATT Electric Current Specification (UUID 0x2af0)", "btgatt.uuid0x2af0" },
    { 0x2af1,   "Bluetooth GATT Attribute Electric Current Statistics (UUID 0x2af1)", "BT GATT Electric Current Statistics (UUID 0x2af1)", "btgatt.uuid0x2af1" },
    { 0x2af2,   "Bluetooth GATT Attribute Energy (UUID 0x2af2)", "BT GATT Energy (UUID 0x2af2)", "btgatt.uuid0x2af2" },
    { 0x2af3,   "Bluetooth GATT Attribute Energy in a Period of Day (UUID 0x2af3)", "BT GATT Energy in a Period of Day (UUID 0x2af3)", "btgatt.uuid0x2af3" },
    { 0x2af4,   "Bluetooth GATT Attribute Event Statistics (UUID 0x2af4)", "BT GATT Event Statistics (UUID 0x2af4)", "btgatt.uuid0x2af4" },
    { 0x2af5,   "Bluetooth GATT Attribute Fixed String 16 (UUID 0x2af5)", "BT GATT Fixed String 16 (UUID 0x2af5)", "btgatt.uuid0x2af5" },
    { 0x2af6,   "Bluetooth GATT Attribute Fixed String 24 (UUID 0x2af6)", "BT GATT Fixed String 24 (UUID 0x2af6)", "btgatt.uuid0x2af6" },
    { 0x2af7,   "Bluetooth GATT Attribute Fixed String 36 (UUID 0x2af7)", "BT GATT Fixed String 36 (UUID 0x2af7)", "btgatt.uuid0x2af7" },
    { 0x2af8,   "Bluetooth GATT Attribute Fixed String 8 (UUID 0x2af8)", "BT GATT Fixed String 8 (UUID 0x2af8)", "btgatt.uuid0x2af8" },
    { 0x2af9,   "Bluetooth GATT Attribute Generic Level (UUID 0x2af9)", "BT GATT Generic Level (UUID 0x2af9)", "btgatt.uuid0x2af9" },
    { 0x2afa,   "Bluetooth GATT Attribute Global Trade Item Number (UUID 0x2afa)", "BT GATT Global Trade Item Number (UUID 0x2afa)", "btgatt.uuid0x2afa" },
    { 0x2afb,   "Bluetooth GATT Attribute Illuminance (UUID 0x2afb)", "BT GATT Illuminance (UUID 0x2afb)", "btgatt.uuid0x2afb" },
    { 0x2afc,   "Bluetooth GATT Attribute Luminous Efficacy (UUID 0x2afc)", "BT GATT Luminous Efficacy (UUID 0x2afc)", "btgatt.uuid0x2afc" },
    { 0x2afd,   "Bluetooth GATT Attribute Luminous Energy (UUID 0x2afd)", "BT GATT Luminous Energy (UUID 0x2afd)", "btgatt.uuid0x2afd" },
    { 0x2afe,   "Bluetooth GATT Attribute Luminous Exposure (UUID 0x2afe)", "BT GATT Luminous Exposure (UUID 0x2afe)", "btgatt.uuid0x2afe" },
    { 0x2aff,   "Bluetooth GATT Attribute Luminous Flux (UUID 0x2aff)", "BT GATT Luminous Flux (UUID 0x2aff)", "btgatt.uuid0x2aff" },
    { 0x2b00,   "Bluetooth GATT Attribute Luminous Flux Range (UUID 0x2b00)", "BT GATT Luminous Flux Range (UUID 0x2b00)", "btgatt.uuid0x2b00" },
    { 0x2b01,   "Bluetooth GATT Attribute Luminous Intensity (UUID 0x2b01)", "BT GATT Luminous Intensity (UUID 0x2b01)", "btgatt.uuid0x2b01" },
    { 0x2b02,   "Bluetooth GATT Attribute Mass Flow (UUID 0x2b02)", "BT GATT Mass Flow (UUID 0x2b02)", "btgatt.uuid0x2b02" },
    { 0x2b03,   "Bluetooth GATT Attribute Perceived Lightness (UUID 0x2b03)", "BT GATT Perceived Lightness (UUID 0x2b03)", "btgatt.uuid0x2b03" },
    { 0x2b04,   "Bluetooth GATT Attribute Percentage 8 (UUID 0x2b04)", "BT GATT Percentage 8 (UUID 0x2b04)", "btgatt.uuid0x2b04" },
    { 0x2b05,   "Bluetooth GATT Attribute Power (UUID 0x2b05)", "BT GATT Power (UUID 0x2b05)", "btgatt.uuid0x2b05" },
    { 0x2b06,   "Bluetooth GATT Attribute Power Specification (UUID 0x2b06)", "BT GATT Power Specification (UUID 0x2b06)", "btgatt.uuid0x2b06" },
    { 0x2b07,   "Bluetooth GATT Attribute Relative Runtime in a Current Range (UUID 0x2b07)", "BT GATT Relative Runtime in a Current Range (UUID 0x2b07)", "btgatt.uuid0x2b07" },
    { 0x2b08,   "Bluetooth GATT Attribute Relative Runtime in a Generic Level Range (UUID 0x2b08)", "BT GATT Relative Runtime in a Generic Level Range (UUID 0x2b08)", "btgatt.uuid0x2b08" },
    { 0x2b09,   "Bluetooth GATT Attribute Relative Value in a Voltage Range (UUID 0x2b09)", "BT GATT Relative Value in a Voltage Range (UUID 0x2b09)", "btgatt.uuid0x2b09" },
    { 0x2b0a,   "Bluetooth GATT Attribute Relative Value in an Illuminance Range (UUID 0x2b0a)", "BT GATT Relative Value in an Illuminance Range (UUID 0x2b0a)", "btgatt.uuid0x2b0a" },
    { 0x2b0b,   "Bluetooth GATT Attribute Relative Value in a Period of Day (UUID 0x2b0b)", "BT GATT Relative Value in a Period of Day (UUID 0x2b0b)", "btgatt.uuid0x2b0b" },
    { 0x2b0c,   "Bluetooth GATT Attribute Relative Value in a Temperature Range (UUID 0x2b0c)", "BT GATT Relative Value in a Temperature Range (UUID 0x2b0c)", "btgatt.uuid0x2b0c" },
    { 0x2b0d,   "Bluetooth GATT Attribute Temperature 8 (UUID 0x2b0d)", "BT GATT Temperature 8 (UUID 0x2b0d)", "btgatt.uuid0x2b0d" },
    { 0x2b0e,   "Bluetooth GATT Attribute Temperature 8 in a Period of Day (UUID 0x2b0e)", "BT GATT Temperature 8 in a Period of Day (UUID 0x2b0e)", "btgatt.uuid0x2b0e" },
    { 0x2b0f,   "Bluetooth GATT Attribute Temperature 8 Statistics (UUID 0x2b0f)", "BT GATT Temperature 8 Statistics (UUID 0x2b0f)", "btgatt.uuid0x2b0f" },
    { 0x2b10,   "Bluetooth GATT Attribute Temperature Range (UUID 0x2b10)", "BT GATT Temperature Range (UUID 0x2b10)", "btgatt.uuid0x2b10" },
    { 0x2b11,   "Bluetooth GATT Attribute Temperature Statistics (UUID 0x2b11)", "BT GATT Temperature Statistics (UUID 0x2b11)", "btgatt.uuid0x2b11" },
    { 0x2b12,   "Bluetooth GATT Attribute Time Decihour 8 (UUID 0x2b12)", "BT GATT Time Decihour 8 (UUID 0x2b12)", "btgatt.uuid0x2b12" },
    { 0x2b13,   "Bluetooth GATT Attribute Time Exponential 8 (UUID 0x2b13)", "BT GATT Time Exponential 8 (UUID 0x2b13)", "btgatt.uuid0x2b13" },
    { 0x2b14,   "Bluetooth GATT Attribute Time Hour 24 (UUID 0x2b14)", "BT GATT Time Hour 24 (UUID 0x2b14)", "btgatt.uuid0x2b14" },
    { 0x2b15,   "Bluetooth GATT Attribute Time Millisecond 24 (UUID 0x2b15)", "BT GATT Time Millisecond 24 (UUID 0x2b15)", "btgatt.uuid0x2b15" },
    { 0x2b16,   "Bluetooth GATT Attribute Time Second 16 (UUID 0x2b16)", "BT GATT Time Second 16 (UUID 0x2b16)", "btgatt.uuid0x2b16" },
    { 0x2b17,   "Bluetooth GATT Attribute Time Second 8 (UUID 0x2b17)", "BT GATT Time Second 8 (UUID 0x2b17)", "btgatt.uuid0x2b17" },
    { 0x2b18,   "Bluetooth GATT Attribute Voltage (UUID 0x2b18)", "BT GATT Voltage (UUID 0x2b18)", "btgatt.uuid0x2b18" },
    { 0x2b19,   "Bluetooth GATT Attribute Voltage Specification (UUID 0x2b19)", "BT GATT Voltage Specification (UUID 0x2b19)", "btgatt.uuid0x2b19" },
    { 0x2b1a,   "Bluetooth GATT Attribute Voltage Statistics (UUID 0x2b1a)", "BT GATT Voltage Statistics (UUID 0x2b1a)", "btgatt.uuid0x2b1a" },
    { 0x2b1b,   "Bluetooth GATT Attribute Volume Flow (UUID 0x2b1b)", "BT GATT Volume Flow (UUID 0x2b1b)", "btgatt.uuid0x2b1b" },
    { 0x2b1c,   "Bluetooth GATT Attribute Chromaticity Coordinate (UUID 0x2b1c)", "BT GATT Chromaticity Coordinate (UUID 0x2b1c)", "btgatt.uuid0x2b1c" },
    { 0x2b1d,   "Bluetooth GATT Attribute RC Feature (UUID 0x2b1d)", "BT GATT RC Feature (UUID 0x2b1d)", "btgatt.uuid0x2b1d" },
    { 0x2b1e,   "Bluetooth GATT Attribute RC Settings (UUID 0x2b1e)", "BT GATT RC Settings (UUID 0x2b1e)", "btgatt.uuid0x2b1e" },
    { 0x2b1f,   "Bluetooth GATT Attribute Reconnection Configuration Control Point (UUID 0x2b1f)", "BT GATT Reconnection Configuration Control Point (UUID 0x2b1f)", "btgatt.uuid0x2b1f" },
    { 0x2b20,   "Bluetooth GATT Attribute IDD Status Changed (UUID 0x2b20)", "BT GATT IDD Status Changed (UUID 0x2b20)", "btgatt.uuid0x2b20" },
    { 0x2b21,   "Bluetooth GATT Attribute IDD Status (UUID 0x2b21)", "BT GATT IDD Status (UUID 0x2b21)", "btgatt.uuid0x2b21" },
    { 0x2b22,   "Bluetooth GATT Attribute IDD Annunciation Status (UUID 0x2b22)", "BT GATT IDD Annunciation Status (UUID 0x2b22)", "btgatt.uuid0x2b22" },
    { 0x2b23,   "Bluetooth GATT Attribute IDD Features (UUID 0x2b23)", "BT GATT IDD Features (UUID 0x2b23)", "btgatt.uuid0x2b23" },
    { 0x2b24,   "Bluetooth GATT Attribute IDD Status Reader Control Point (UUID 0x2b24)", "BT GATT IDD Status Reader Control Point (UUID 0x2b24)", "btgatt.uuid0x2b24" },
    { 0x2b25,   "Bluetooth GATT Attribute IDD Command Control Point (UUID 0x2b25)", "BT GATT IDD Command Control Point (UUID 0x2b25)", "btgatt.uuid0x2b25" },
    { 0x2b26,   "Bluetooth GATT Attribute IDD Command Data (UUID 0x2b26)", "BT GATT IDD Command Data (UUID 0x2b26)", "btgatt.uuid0x2b26" },
    { 0x2b27,   "Bluetooth GATT Attribute IDD Record Access Control Point (UUID 0x2b27)", "BT GATT IDD Record Access Control Point (UUID 0x2b27)", "btgatt.uuid0x2b27" },
    { 0x2b28,   "Bluetooth GATT Attribute IDD History Data (UUID 0x2b28)", "BT GATT IDD History Data (UUID 0x2b28)", "btgatt.uuid0x2b28" },
    { 0x2b29,   "Bluetooth GATT Attribute Client Supported Features (UUID 0x2b29)", "BT GATT Client Supported Features (UUID 0x2b29)", "btgatt.uuid0x2b29" },
    { 0x2b2a,   "Bluetooth GATT Attribute Database Hash (UUID 0x2b2a)", "BT GATT Database Hash (UUID 0x2b2a)", "btgatt.uuid0x2b2a" },
    { 0x2b2b,   "Bluetooth GATT Attribute BSS Control Point (UUID 0x2b2b)", "BT GATT BSS Control Point (UUID 0x2b2b)", "btgatt.uuid0x2b2b" },
    { 0x2b2c,   "Bluetooth GATT Attribute BSS Response (UUID 0x2b2c)", "BT GATT BSS Response (UUID 0x2b2c)", "btgatt.uuid0x2b2c" },
    { 0x2b2d,   "Bluetooth GATT Attribute Emergency ID (UUID 0x2b2d)", "BT GATT Emergency ID (UUID 0x2b2d)", "btgatt.uuid0x2b2d" },
    { 0x2b2e,   "Bluetooth GATT Attribute Emergency Text (UUID 0x2b2e)", "BT GATT Emergency Text (UUID 0x2b2e)", "btgatt.uuid0x2b2e" },
    { 0x2b2f,   "Bluetooth GATT Attribute ACS Status (UUID 0x2b2f)", "BT GATT ACS Status (UUID 0x2b2f)", "btgatt.uuid0x2b2f" },
    { 0x2b30,   "Bluetooth GATT Attribute ACS Data In (UUID 0x2b30)", "BT GATT ACS Data In (UUID 0x2b30)", "btgatt.uuid0x2b30" },
    { 0x2b31,   "Bluetooth GATT Attribute ACS Data Out Notify (UUID 0x2b31)", "BT GATT ACS Data Out Notify (UUID 0x2b31)", "btgatt.uuid0x2b31" },
    { 0x2b32,   "Bluetooth GATT Attribute ACS Data Out Indicate (UUID 0x2b32)", "BT GATT ACS Data Out Indicate (UUID 0x2b32)", "btgatt.uuid0x2b32" },
    { 0x2b33,   "Bluetooth GATT Attribute ACS Control Point (UUID 0x2b33)", "BT GATT ACS Control Point (UUID 0x2b33)", "btgatt.uuid0x2b33" },
    { 0x2b34,   "Bluetooth GATT Attribute Enhanced Blood Pressure Measurement (UUID 0x2b34)", "BT GATT Enhanced Blood Pressure Measurement (UUID 0x2b34)", "btgatt.uuid0x2b34" },
    { 0x2b35,   "Bluetooth GATT Attribute Enhanced Intermediate Cuff Pressure (UUID 0x2b35)", "BT GATT Enhanced Intermediate Cuff Pressure (UUID 0x2b35)", "btgatt.uuid0x2b35" },
    { 0x2b36,   "Bluetooth GATT Attribute Blood Pressure Record (UUID 0x2b36)", "BT GATT Blood Pressure Record (UUID 0x2b36)", "btgatt.uuid0x2b36" },
    { 0x2b37,   "Bluetooth GATT Attribute Registered User (UUID 0x2b37)", "BT GATT Registered User (UUID 0x2b37)", "btgatt.uuid0x2b37" },
    { 0x2b38,   "Bluetooth GATT Attribute BR-EDR Handover Data (UUID 0x2b38)", "BT GATT BR-EDR Handover Data (UUID 0x2b38)", "btgatt.uuid0x2b38" },
    { 0x2b39,   "Bluetooth GATT Attribute Bluetooth SIG Data (UUID 0x2b39)", "BT GATT Bluetooth SIG Data (UUID 0x2b39)", "btgatt.uuid0x2b39" },
    { 0x2b3a,   "Bluetooth GATT Attribute Server Supported Features (UUID 0x2b3a)", "BT GATT Server Supported Features (UUID 0x2b3a)", "btgatt.uuid0x2b3a" },
    { 0x2b3b,   "Bluetooth GATT Attribute Physical Activity Monitor Features (UUID 0x2b3b)", "BT GATT Physical Activity Monitor Features (UUID 0x2b3b)", "btgatt.uuid0x2b3b" },
    { 0x2b3c,   "Bluetooth GATT Attribute General Activity Instantaneous Data (UUID 0x2b3c)", "BT GATT General Activity Instantaneous Data (UUID 0x2b3c)", "btgatt.uuid0x2b3c" },
    { 0x2b3d,   "Bluetooth GATT Attribute General Activity Summary Data (UUID 0x2b3d)", "BT GATT General Activity Summary Data (UUID 0x2b3d)", "btgatt.uuid0x2b3d" },
    { 0x2b3e,   "Bluetooth GATT Attribute CardioRespiratory Activity Instantaneous Data (UUID 0x2b3e)", "BT GATT CardioRespiratory Activity Instantaneous Data (UUID 0x2b3e)", "btgatt.uuid0x2b3e" },
    { 0x2b3f,   "Bluetooth GATT Attribute CardioRespiratory Activity Summary Data (UUID 0x2b3f)", "BT GATT CardioRespiratory Activity Summary Data (UUID 0x2b3f)", "btgatt.uuid0x2b3f" },
    { 0x2b40,   "Bluetooth GATT Attribute Step Counter Activity Summary Data (UUID 0x2b40)", "BT GATT Step Counter Activity Summary Data (UUID 0x2b40)", "btgatt.uuid0x2b40" },
    { 0x2b41,   "Bluetooth GATT Attribute Sleep Activity Instantaneous Data (UUID 0x2b41)", "BT GATT Sleep Activity Instantaneous Data (UUID 0x2b41)", "btgatt.uuid0x2b41" },
    { 0x2b42,   "Bluetooth GATT Attribute Sleep Activity Summary Data (UUID 0x2b42)", "BT GATT Sleep Activity Summary Data (UUID 0x2b42)", "btgatt.uuid0x2b42" },
    { 0x2b43,   "Bluetooth GATT Attribute Physical Activity Monitor Control Point (UUID 0x2b43)", "BT GATT Physical Activity Monitor Control Point (UUID 0x2b43)", "btgatt.uuid0x2b43" },
    { 0x2b44,   "Bluetooth GATT Attribute Physical Activity Current Session (UUID 0x2b44)", "BT GATT Physical Activity Current Session (UUID 0x2b44)", "btgatt.uuid0x2b44" },
    { 0x2b45,   "Bluetooth GATT Attribute Physical Activity Session Descriptor (UUID 0x2b45)", "BT GATT Physical Activity Session Descriptor (UUID 0x2b45)", "btgatt.uuid0x2b45" },
    { 0x2b46,   "Bluetooth GATT Attribute Preferred Units (UUID 0x2b46)", "BT GATT Preferred Units (UUID 0x2b46)", "btgatt.uuid0x2b46" },
    { 0x2b47,   "Bluetooth GATT Attribute High Resolution Height (UUID 0x2b47)", "BT GATT High Resolution Height (UUID 0x2b47)", "btgatt.uuid0x2b47" },
    { 0x2b48,   "Bluetooth GATT Attribute Middle Name (UUID 0x2b48)", "BT GATT Middle Name (UUID 0x2b48)", "btgatt.uuid0x2b48" },
    { 0x2b49,   "Bluetooth GATT Attribute Stride Length (UUID 0x2b49)", "BT GATT Stride Length (UUID 0x2b49)", "btgatt.uuid0x2b49" },
    { 0x2b4a,   "Bluetooth GATT Attribute Handedness (UUID 0x2b4a)", "BT GATT Handedness (UUID 0x2b4a)", "btgatt.uuid0x2b4a" },
    { 0x2b4b,   "Bluetooth GATT Attribute Device Wearing Position (UUID 0x2b4b)", "BT GATT Device Wearing Position (UUID 0x2b4b)", "btgatt.uuid0x2b4b" },
    { 0x2b4c,   "Bluetooth GATT Attribute Four Zone Heart Rate Limits (UUID 0x2b4c)", "BT GATT Four Zone Heart Rate Limits (UUID 0x2b4c)", "btgatt.uuid0x2b4c" },
    { 0x2b4d,   "Bluetooth GATT Attribute High Intensity Exercise Threshold (UUID 0x2b4d)", "BT GATT High Intensity Exercise Threshold (UUID 0x2b4d)", "btgatt.uuid0x2b4d" },
    { 0x2b4e,   "Bluetooth GATT Attribute Activity Goal (UUID 0x2b4e)", "BT GATT Activity Goal (UUID 0x2b4e)", "btgatt.uuid0x2b4e" },
    { 0x2b4f,   "Bluetooth GATT Attribute Sedentary Interval Notification (UUID 0x2b4f)", "BT GATT Sedentary Interval Notification (UUID 0x2b4f)", "btgatt.uuid0x2b4f" },
    { 0x2b50,   "Bluetooth GATT Attribute Caloric Intake (UUID 0x2b50)", "BT GATT Caloric Intake (UUID 0x2b50)", "btgatt.uuid0x2b50" },
    { 0x2b51,   "Bluetooth GATT Attribute TMAP Role (UUID 0x2b51)", "BT GATT TMAP Role (UUID 0x2b51)", "btgatt.uuid0x2b51" },
    { 0x2b77,   "Bluetooth GATT Attribute Audio Input State (UUID 0x2b77)", "BT GATT Audio Input State (UUID 0x2b77)", "btgatt.uuid0x2b77" },
    { 0x2b78,   "Bluetooth GATT Attribute Gain Settings Attribute (UUID 0x2b78)", "BT GATT Gain Settings Attribute (UUID 0x2b78)", "btgatt.uuid0x2b78" },
    { 0x2b79,   "Bluetooth GATT Attribute Audio Input Type (UUID 0x2b79)", "BT GATT Audio Input Type (UUID 0x2b79)", "btgatt.uuid0x2b79" },
    { 0x2b7a,   "Bluetooth GATT Attribute Audio Input Status (UUID 0x2b7a)", "BT GATT Audio Input Status (UUID 0x2b7a)", "btgatt.uuid0x2b7a" },
    { 0x2b7b,   "Bluetooth GATT Attribute Audio Input Control Point (UUID 0x2b7b)", "BT GATT Audio Input Control Point (UUID 0x2b7b)", "btgatt.uuid0x2b7b" },
    { 0x2b7c,   "Bluetooth GATT Attribute Audio Input Description (UUID 0x2b7c)", "BT GATT Audio Input Description (UUID 0x2b7c)", "btgatt.uuid0x2b7c" },
    { 0x2b7d,   "Bluetooth GATT Attribute Volume State (UUID 0x2b7d)", "BT GATT Volume State (UUID 0x2b7d)", "btgatt.uuid0x2b7d" },
    { 0x2b7e,   "Bluetooth GATT Attribute Volume Control Point (UUID 0x2b7e)", "BT GATT Volume Control Point (UUID 0x2b7e)", "btgatt.uuid0x2b7e" },
    { 0x2b7f,   "Bluetooth GATT Attribute Volume Flags (UUID 0x2b7f)", "BT GATT Volume Flags (UUID 0x2b7f)", "btgatt.uuid0x2b7f" },
    { 0x2b80,   "Bluetooth GATT Attribute Volume Offset State (UUID 0x2b80)", "BT GATT Volume Offset State (UUID 0x2b80)", "btgatt.uuid0x2b80" },
    { 0x2b81,   "Bluetooth GATT Attribute Audio Location (UUID 0x2b81)", "BT GATT Audio Location (UUID 0x2b81)", "btgatt.uuid0x2b81" },
    { 0x2b82,   "Bluetooth GATT Attribute Volume Offset Control Point (UUID 0x2b82)", "BT GATT Volume Offset Control Point (UUID 0x2b82)", "btgatt.uuid0x2b82" },
    { 0x2b83,   "Bluetooth GATT Attribute Audio Output Description (UUID 0x2b83)", "BT GATT Audio Output Description (UUID 0x2b83)", "btgatt.uuid0x2b83" },
    { 0x2b84,   "Bluetooth GATT Attribute Set Identity Resolving Key (UUID 0x2b84)", "BT GATT Set Identity Resolving Key (UUID 0x2b84)", "btgatt.uuid0x2b84" },
    { 0x2b85,   "Bluetooth GATT Attribute Coordinated Set Size (UUID 0x2b85)", "BT GATT Coordinated Set Size (UUID 0x2b85)", "btgatt.uuid0x2b85" },
    { 0x2b86,   "Bluetooth GATT Attribute Set Member Lock (UUID 0x2b86)", "BT GATT Set Member Lock (UUID 0x2b86)", "btgatt.uuid0x2b86" },
    { 0x2b87,   "Bluetooth GATT Attribute Set Member Rank (UUID 0x2b87)", "BT GATT Set Member Rank (UUID 0x2b87)", "btgatt.uuid0x2b87" },
    { 0x2b88,   "Bluetooth GATT Attribute Encrypted Data Key Material (UUID 0x2b88)", "BT GATT Encrypted Data Key Material (UUID 0x2b88)", "btgatt.uuid0x2b88" },
    { 0x2b89,   "Bluetooth GATT Attribute Apparent Energy 32 (UUID 0x2b89)", "BT GATT Apparent Energy 32 (UUID 0x2b89)", "btgatt.uuid0x2b89" },
    { 0x2b8a,   "Bluetooth GATT Attribute Apparent Power (UUID 0x2b8a)", "BT GATT Apparent Power (UUID 0x2b8a)", "btgatt.uuid0x2b8a" },
    { 0x2b8b,   "Bluetooth GATT Attribute Live Health Observations (UUID 0x2b8b)", "BT GATT Live Health Observations (UUID 0x2b8b)", "btgatt.uuid0x2b8b" },
    { 0x2b8c,   "Bluetooth GATT Attribute CO₂ Concentration (UUID 0x2b8c)", "BT GATT CO₂ Concentration (UUID 0x2b8c)", "btgatt.uuid0x2b8c" },
    { 0x2b8d,   "Bluetooth GATT Attribute Cosine of the Angle (UUID 0x2b8d)", "BT GATT Cosine of the Angle (UUID 0x2b8d)", "btgatt.uuid0x2b8d" },
    { 0x2b8e,   "Bluetooth GATT Attribute Device Time Feature (UUID 0x2b8e)", "BT GATT Device Time Feature (UUID 0x2b8e)", "btgatt.uuid0x2b8e" },
    { 0x2b8f,   "Bluetooth GATT Attribute Device Time Parameters (UUID 0x2b8f)", "BT GATT Device Time Parameters (UUID 0x2b8f)", "btgatt.uuid0x2b8f" },
    { 0x2b90,   "Bluetooth GATT Attribute Device Time (UUID 0x2b90)", "BT GATT Device Time (UUID 0x2b90)", "btgatt.uuid0x2b90" },
    { 0x2b91,   "Bluetooth GATT Attribute Device Time Control Point (UUID 0x2b91)", "BT GATT Device Time Control Point (UUID 0x2b91)", "btgatt.uuid0x2b91" },
    { 0x2b92,   "Bluetooth GATT Attribute Time Change Log Data (UUID 0x2b92)", "BT GATT Time Change Log Data (UUID 0x2b92)", "btgatt.uuid0x2b92" },
    { 0x2b93,   "Bluetooth GATT Attribute Media Player Name (UUID 0x2b93)", "BT GATT Media Player Name (UUID 0x2b93)", "btgatt.uuid0x2b93" },
    { 0x2b94,   "Bluetooth GATT Attribute Media Player Icon Object ID (UUID 0x2b94)", "BT GATT Media Player Icon Object ID (UUID 0x2b94)", "btgatt.uuid0x2b94" },
    { 0x2b95,   "Bluetooth GATT Attribute Media Player Icon URL (UUID 0x2b95)", "BT GATT Media Player Icon URL (UUID 0x2b95)", "btgatt.uuid0x2b95" },
    { 0x2b96,   "Bluetooth GATT Attribute Track Changed (UUID 0x2b96)", "BT GATT Track Changed (UUID 0x2b96)", "btgatt.uuid0x2b96" },
    { 0x2b97,   "Bluetooth GATT Attribute Track Title (UUID 0x2b97)", "BT GATT Track Title (UUID 0x2b97)", "btgatt.uuid0x2b97" },
    { 0x2b98,   "Bluetooth GATT Attribute Track Duration (UUID 0x2b98)", "BT GATT Track Duration (UUID 0x2b98)", "btgatt.uuid0x2b98" },
    { 0x2b99,   "Bluetooth GATT Attribute Track Position (UUID 0x2b99)", "BT GATT Track Position (UUID 0x2b99)", "btgatt.uuid0x2b99" },
    { 0x2b9a,   "Bluetooth GATT Attribute Playback Speed (UUID 0x2b9a)", "BT GATT Playback Speed (UUID 0x2b9a)", "btgatt.uuid0x2b9a" },
    { 0x2b9b,   "Bluetooth GATT Attribute Seeking Speed (UUID 0x2b9b)", "BT GATT Seeking Speed (UUID 0x2b9b)", "btgatt.uuid0x2b9b" },
    { 0x2b9c,   "Bluetooth GATT Attribute Current Track Segments Object ID (UUID 0x2b9c)", "BT GATT Current Track Segments Object ID (UUID 0x2b9c)", "btgatt.uuid0x2b9c" },
    { 0x2b9d,   "Bluetooth GATT Attribute Current Track Object ID (UUID 0x2b9d)", "BT GATT Current Track Object ID (UUID 0x2b9d)", "btgatt.uuid0x2b9d" },
    { 0x2b9e,   "Bluetooth GATT Attribute Next Track Object ID (UUID 0x2b9e)", "BT GATT Next Track Object ID (UUID 0x2b9e)", "btgatt.uuid0x2b9e" },
    { 0x2b9f,   "Bluetooth GATT Attribute Parent Group Object ID (UUID 0x2b9f)", "BT GATT Parent Group Object ID (UUID 0x2b9f)", "btgatt.uuid0x2b9f" },
    { 0x2ba0,   "Bluetooth GATT Attribute Current Group Object ID (UUID 0x2ba0)", "BT GATT Current Group Object ID (UUID 0x2ba0)", "btgatt.uuid0x2ba0" },
    { 0x2ba1,   "Bluetooth GATT Attribute Playing Order (UUID 0x2ba1)", "BT GATT Playing Order (UUID 0x2ba1)", "btgatt.uuid0x2ba1" },
    { 0x2ba2,   "Bluetooth GATT Attribute Playing Orders Supported (UUID 0x2ba2)", "BT GATT Playing Orders Supported (UUID 0x2ba2)", "btgatt.uuid0x2ba2" },
    { 0x2ba3,   "Bluetooth GATT Attribute Media State (UUID 0x2ba3)", "BT GATT Media State (UUID 0x2ba3)", "btgatt.uuid0x2ba3" },
    { 0x2ba4,   "Bluetooth GATT Attribute Media Control Point (UUID 0x2ba4)", "BT GATT Media Control Point (UUID 0x2ba4)", "btgatt.uuid0x2ba4" },
    { 0x2ba5,   "Bluetooth GATT Attribute Media Control Point Opcodes Supported (UUID 0x2ba5)", "BT GATT Media Control Point Opcodes Supported (UUID 0x2ba5)", "btgatt.uuid0x2ba5" },
    { 0x2ba6,   "Bluetooth GATT Attribute Search Results Object ID (UUID 0x2ba6)", "BT GATT Search Results Object ID (UUID 0x2ba6)", "btgatt.uuid0x2ba6" },
    { 0x2ba7,   "Bluetooth GATT Attribute Search Control Point (UUID 0x2ba7)", "BT GATT Search Control Point (UUID 0x2ba7)", "btgatt.uuid0x2ba7" },
    { 0x2ba8,   "Bluetooth GATT Attribute Energy 32 (UUID 0x2ba8)", "BT GATT Energy 32 (UUID 0x2ba8)", "btgatt.uuid0x2ba8" },
    { 0x2ba9,   "Bluetooth GATT Attribute Media Player Icon Object Type (UUID 0x2ba9)", "BT GATT Media Player Icon Object Type (UUID 0x2ba9)", "btgatt.uuid0x2ba9" },
    { 0x2baa,   "Bluetooth GATT Attribute Track Segments Object Type (UUID 0x2baa)", "BT GATT Track Segments Object Type (UUID 0x2baa)", "btgatt.uuid0x2baa" },
    { 0x2bab,   "Bluetooth GATT Attribute Track Object Type (UUID 0x2bab)", "BT GATT Track Object Type (UUID 0x2bab)", "btgatt.uuid0x2bab" },
    { 0x2bac,   "Bluetooth GATT Attribute Group Object Type (UUID 0x2bac)", "BT GATT Group Object Type (UUID 0x2bac)", "btgatt.uuid0x2bac" },
    { 0x2bad,   "Bluetooth GATT Attribute Constant Tone Extension Enable (UUID 0x2bad)", "BT GATT Constant Tone Extension Enable (UUID 0x2bad)", "btgatt.uuid0x2bad" },
    { 0x2bae,   "Bluetooth GATT Attribute Advertising Constant Tone Extension Minimum Length (UUID 0x2bae)", "BT GATT Advertising Constant Tone Extension Minimum Length (UUID 0x2bae)", "btgatt.uuid0x2bae" },
    { 0x2baf,   "Bluetooth GATT Attribute Advertising Constant Tone Extension Minimum Transmit Count (UUID 0x2baf)", "BT GATT Advertising Constant Tone Extension Minimum Transmit Count (UUID 0x2baf)", "btgatt.uuid0x2baf" },
    { 0x2bb0,   "Bluetooth GATT Attribute Advertising Constant Tone Extension Transmit Duration (UUID 0x2bb0)", "BT GATT Advertising Constant Tone Extension Transmit Duration (UUID 0x2bb0)", "btgatt.uuid0x2bb0" },
    { 0x2bb1,   "Bluetooth GATT Attribute Advertising Constant Tone Extension Interval (UUID 0x2bb1)", "BT GATT Advertising Constant Tone Extension Interval (UUID 0x2bb1)", "btgatt.uuid0x2bb1" },
    { 0x2bb2,   "Bluetooth GATT Attribute Advertising Constant Tone Extension PHY (UUID 0x2bb2)", "BT GATT Advertising Constant Tone Extension PHY (UUID 0x2bb2)", "btgatt.uuid0x2bb2" },
    { 0x2bb3,   "Bluetooth GATT Attribute Bearer Provider Name (UUID 0x2bb3)", "BT GATT Bearer Provider Name (UUID 0x2bb3)", "btgatt.uuid0x2bb3" },
    { 0x2bb4,   "Bluetooth GATT Attribute Bearer UCI (UUID 0x2bb4)", "BT GATT Bearer UCI (UUID 0x2bb4)", "btgatt.uuid0x2bb4" },
    { 0x2bb5,   "Bluetooth GATT Attribute Bearer Technology (UUID 0x2bb5)", "BT GATT Bearer Technology (UUID 0x2bb5)", "btgatt.uuid0x2bb5" },
    { 0x2bb6,   "Bluetooth GATT Attribute Bearer URI Schemes Supported List (UUID 0x2bb6)", "BT GATT Bearer URI Schemes Supported List (UUID 0x2bb6)", "btgatt.uuid0x2bb6" },
    { 0x2bb7,   "Bluetooth GATT Attribute Bearer Signal Strength (UUID 0x2bb7)", "BT GATT Bearer Signal Strength (UUID 0x2bb7)", "btgatt.uuid0x2bb7" },
    { 0x2bb8,   "Bluetooth GATT Attribute Bearer Signal Strength Reporting Interval (UUID 0x2bb8)", "BT GATT Bearer Signal Strength Reporting Interval (UUID 0x2bb8)", "btgatt.uuid0x2bb8" },
    { 0x2bb9,   "Bluetooth GATT Attribute Bearer List Current Calls (UUID 0x2bb9)", "BT GATT Bearer List Current Calls (UUID 0x2bb9)", "btgatt.uuid0x2bb9" },
    { 0x2bba,   "Bluetooth GATT Attribute Content Control ID (UUID 0x2bba)", "BT GATT Content Control ID (UUID 0x2bba)", "btgatt.uuid0x2bba" },
    { 0x2bbb,   "Bluetooth GATT Attribute Status Flags (UUID 0x2bbb)", "BT GATT Status Flags (UUID 0x2bbb)", "btgatt.uuid0x2bbb" },
    { 0x2bbc,   "Bluetooth GATT Attribute Incoming Call Target Bearer URI (UUID 0x2bbc)", "BT GATT Incoming Call Target Bearer URI (UUID 0x2bbc)", "btgatt.uuid0x2bbc" },
    { 0x2bbd,   "Bluetooth GATT Attribute Call State (UUID 0x2bbd)", "BT GATT Call State (UUID 0x2bbd)", "btgatt.uuid0x2bbd" },
    { 0x2bbe,   "Bluetooth GATT Attribute Call Control Point (UUID 0x2bbe)", "BT GATT Call Control Point (UUID 0x2bbe)", "btgatt.uuid0x2bbe" },
    { 0x2bbf,   "Bluetooth GATT Attribute Call Control Point Optional Opcodes (UUID 0x2bbf)", "BT GATT Call Control Point Optional Opcodes (UUID 0x2bbf)", "btgatt.uuid0x2bbf" },
    { 0x2bc0,   "Bluetooth GATT Attribute Termination Reason (UUID 0x2bc0)", "BT GATT Termination Reason (UUID 0x2bc0)", "btgatt.uuid0x2bc0" },
    { 0x2bc1,   "Bluetooth GATT Attribute Incoming Call (UUID 0x2bc1)", "BT GATT Incoming Call (UUID 0x2bc1)", "btgatt.uuid0x2bc1" },
    { 0x2bc2,   "Bluetooth GATT Attribute Call Friendly Name (UUID 0x2bc2)", "BT GATT Call Friendly Name (UUID 0x2bc2)", "btgatt.uuid0x2bc2" },
    { 0x2bc3,   "Bluetooth GATT Attribute Mute (UUID 0x2bc3)", "BT GATT Mute (UUID 0x2bc3)", "btgatt.uuid0x2bc3" },
    { 0x2bc4,   "Bluetooth GATT Attribute Sink ASE (UUID 0x2bc4)", "BT GATT Sink ASE (UUID 0x2bc4)", "btgatt.uuid0x2bc4" },
    { 0x2bc5,   "Bluetooth GATT Attribute Source ASE (UUID 0x2bc5)", "BT GATT Source ASE (UUID 0x2bc5)", "btgatt.uuid0x2bc5" },
    { 0x2bc6,   "Bluetooth GATT Attribute ASE Control Point (UUID 0x2bc6)", "BT GATT ASE Control Point (UUID 0x2bc6)", "btgatt.uuid0x2bc6" },
    { 0x2bc7,   "Bluetooth GATT Attribute Broadcast Audio Scan Control Point (UUID 0x2bc7)", "BT GATT Broadcast Audio Scan Control Point (UUID 0x2bc7)", "btgatt.uuid0x2bc7" },
    { 0x2bc8,   "Bluetooth GATT Attribute Broadcast Receive State (UUID 0x2bc8)", "BT GATT Broadcast Receive State (UUID 0x2bc8)", "btgatt.uuid0x2bc8" },
    { 0x2bc9,   "Bluetooth GATT Attribute Sink PAC (UUID 0x2bc9)", "BT GATT Sink PAC (UUID 0x2bc9)", "btgatt.uuid0x2bc9" },
    { 0x2bca,   "Bluetooth GATT Attribute Sink Audio Locations (UUID 0x2bca)", "BT GATT Sink Audio Locations (UUID 0x2bca)", "btgatt.uuid0x2bca" },
    { 0x2bcb,   "Bluetooth GATT Attribute Source PAC (UUID 0x2bcb)", "BT GATT Source PAC (UUID 0x2bcb)", "btgatt.uuid0x2bcb" },
    { 0x2bcc,   "Bluetooth GATT Attribute Source Audio Locations (UUID 0x2bcc)", "BT GATT Source Audio Locations (UUID 0x2bcc)", "btgatt.uuid0x2bcc" },
    { 0x2bcd,   "Bluetooth GATT Attribute Available Audio Contexts (UUID 0x2bcd)", "BT GATT Available Audio Contexts (UUID 0x2bcd)", "btgatt.uuid0x2bcd" },
    { 0x2bce,   "Bluetooth GATT Attribute Supported Audio Contexts (UUID 0x2bce)", "BT GATT Supported Audio Contexts (UUID 0x2bce)", "btgatt.uuid0x2bce" },
    { 0x2bcf,   "Bluetooth GATT Attribute Ammonia Concentration (UUID 0x2bcf)", "BT GATT Ammonia Concentration (UUID 0x2bcf)", "btgatt.uuid0x2bcf" },
    { 0x2bd0,   "Bluetooth GATT Attribute Carbon Monoxide Concentration (UUID 0x2bd0)", "BT GATT Carbon Monoxide Concentration (UUID 0x2bd0)", "btgatt.uuid0x2bd0" },
    { 0x2bd1,   "Bluetooth GATT Attribute Methane Concentration (UUID 0x2bd1)", "BT GATT Methane Concentration (UUID 0x2bd1)", "btgatt.uuid0x2bd1" },
    { 0x2bd2,   "Bluetooth GATT Attribute Nitrogen Dioxide Concentration (UUID 0x2bd2)", "BT GATT Nitrogen Dioxide Concentration (UUID 0x2bd2)", "btgatt.uuid0x2bd2" },
    { 0x2bd3,   "Bluetooth GATT Attribute Non-Methane Volatile Organic Compounds Concentration (UUID 0x2bd3)", "BT GATT Non-Methane Volatile Organic Compounds Concentration (UUID 0x2bd3)", "btgatt.uuid0x2bd3" },
    { 0x2bd4,   "Bluetooth GATT Attribute Ozone Concentration (UUID 0x2bd4)", "BT GATT Ozone Concentration (UUID 0x2bd4)", "btgatt.uuid0x2bd4" },
    { 0x2bd5,   "Bluetooth GATT Attribute Particulate Matter - PM1 Concentration (UUID 0x2bd5)", "BT GATT Particulate Matter - PM1 Concentration (UUID 0x2bd5)", "btgatt.uuid0x2bd5" },
    { 0x2bd6,   "Bluetooth GATT Attribute Particulate Matter - PM2.5 Concentration (UUID 0x2bd6)", "BT GATT Particulate Matter - PM2.5 Concentration (UUID 0x2bd6)", "btgatt.uuid0x2bd6" },
    { 0x2bd7,   "Bluetooth GATT Attribute Particulate Matter - PM10 Concentration (UUID 0x2bd7)", "BT GATT Particulate Matter - PM10 Concentration (UUID 0x2bd7)", "btgatt.uuid0x2bd7" },
    { 0x2bd8,   "Bluetooth GATT Attribute Sulfur Dioxide Concentration (UUID 0x2bd8)", "BT GATT Sulfur Dioxide Concentration (UUID 0x2bd8)", "btgatt.uuid0x2bd8" },
    { 0x2bd9,   "Bluetooth GATT Attribute Sulfur Hexafluoride Concentration (UUID 0x2bd9)", "BT GATT Sulfur Hexafluoride Concentration (UUID 0x2bd9)", "btgatt.uuid0x2bd9" },
    { 0x2bda,   "Bluetooth GATT Attribute Hearing Aid Features (UUID 0x2bda)", "BT GATT Hearing Aid Features (UUID 0x2bda)", "btgatt.uuid0x2bda" },
    { 0x2bdb,   "Bluetooth GATT Attribute Hearing Aid Preset Control Point (UUID 0x2bdb)", "BT GATT Hearing Aid Preset Control Point (UUID 0x2bdb)", "btgatt.uuid0x2bdb" },
    { 0x2bdc,   "Bluetooth GATT Attribute Active Preset Index (UUID 0x2bdc)", "BT GATT Active Preset Index (UUID 0x2bdc)", "btgatt.uuid0x2bdc" },
    { 0x2bdd,   "Bluetooth GATT Attribute Stored Health Observations (UUID 0x2bdd)", "BT GATT Stored Health Observations (UUID 0x2bdd)", "btgatt.uuid0x2bdd" },
    { 0x2bde,   "Bluetooth GATT Attribute Fixed String 64 (UUID 0x2bde)", "BT GATT Fixed String 64 (UUID 0x2bde)", "btgatt.uuid0x2bde" },
    { 0x2bdf,   "Bluetooth GATT Attribute High Temperature (UUID 0x2bdf)", "BT GATT High Temperature (UUID 0x2bdf)", "btgatt.uuid0x2bdf" },
    { 0x2be0,   "Bluetooth GATT Attribute High Voltage (UUID 0x2be0)", "BT GATT High Voltage (UUID 0x2be0)", "btgatt.uuid0x2be0" },
    { 0x2be1,   "Bluetooth GATT Attribute Light Distribution (UUID 0x2be1)", "BT GATT Light Distribution (UUID 0x2be1)", "btgatt.uuid0x2be1" },
    { 0x2be2,   "Bluetooth GATT Attribute Light Output (UUID 0x2be2)", "BT GATT Light Output (UUID 0x2be2)", "btgatt.uuid0x2be2" },
    { 0x2be3,   "Bluetooth GATT Attribute Light Source Type (UUID 0x2be3)", "BT GATT Light Source Type (UUID 0x2be3)", "btgatt.uuid0x2be3" },
    { 0x2be4,   "Bluetooth GATT Attribute Noise (UUID 0x2be4)", "BT GATT Noise (UUID 0x2be4)", "btgatt.uuid0x2be4" },
    { 0x2be5,   "Bluetooth GATT Attribute Relative Runtime in a Correlated Color Temperature Range (UUID 0x2be5)", "BT GATT Relative Runtime in a Correlated Color Temperature Range (UUID 0x2be5)", "btgatt.uuid0x2be5" },
    { 0x2be6,   "Bluetooth GATT Attribute Time Second 32 (UUID 0x2be6)", "BT GATT Time Second 32 (UUID 0x2be6)", "btgatt.uuid0x2be6" },
    { 0x2be7,   "Bluetooth GATT Attribute VOC Concentration (UUID 0x2be7)", "BT GATT VOC Concentration (UUID 0x2be7)", "btgatt.uuid0x2be7" },
    { 0x2be8,   "Bluetooth GATT Attribute Voltage Frequency (UUID 0x2be8)", "BT GATT Voltage Frequency (UUID 0x2be8)", "btgatt.uuid0x2be8" },
    { 0x2be9,   "Bluetooth GATT Attribute Battery Critical Status (UUID 0x2be9)", "BT GATT Battery Critical Status (UUID 0x2be9)", "btgatt.uuid0x2be9" },
    { 0x2bea,   "Bluetooth GATT Attribute Battery Health Status (UUID 0x2bea)", "BT GATT Battery Health Status (UUID 0x2bea)", "btgatt.uuid0x2bea" },
    { 0x2beb,   "Bluetooth GATT Attribute Battery Health Information (UUID 0x2beb)", "BT GATT Battery Health Information (UUID 0x2beb)", "btgatt.uuid0x2beb" },
    { 0x2bec,   "Bluetooth GATT Attribute Battery Information (UUID 0x2bec)", "BT GATT Battery Information (UUID 0x2bec)", "btgatt.uuid0x2bec" },
    { 0x2bed,   "Bluetooth GATT Attribute Battery Level Status (UUID 0x2bed)", "BT GATT Battery Level Status (UUID 0x2bed)", "btgatt.uuid0x2bed" },
    { 0x2bee,   "Bluetooth GATT Attribute Battery Time Status (UUID 0x2bee)", "BT GATT Battery Time Status (UUID 0x2bee)", "btgatt.uuid0x2bee" },
    { 0x2bef,   "Bluetooth GATT Attribute Estimated Service Date (UUID 0x2bef)", "BT GATT Estimated Service Date (UUID 0x2bef)", "btgatt.uuid0x2bef" },
    { 0x2bf0,   "Bluetooth GATT Attribute Battery Energy Status (UUID 0x2bf0)", "BT GATT Battery Energy Status (UUID 0x2bf0)", "btgatt.uuid0x2bf0" },
    { 0x2bf1,   "Bluetooth GATT Attribute Observation Schedule Changed (UUID 0x2bf1)", "BT GATT Observation Schedule Changed (UUID 0x2bf1)", "btgatt.uuid0x2bf1" },
    { 0x2bf2,   "Bluetooth GATT Attribute Current Elapsed Time (UUID 0x2bf2)", "BT GATT Current Elapsed Time (UUID 0x2bf2)", "btgatt.uuid0x2bf2" },
    { 0x2bf3,   "Bluetooth GATT Attribute Health Sensor Features (UUID 0x2bf3)", "BT GATT Health Sensor Features (UUID 0x2bf3)", "btgatt.uuid0x2bf3" },
    { 0x2bf4,   "Bluetooth GATT Attribute GHS Control Point (UUID 0x2bf4)", "BT GATT GHS Control Point (UUID 0x2bf4)", "btgatt.uuid0x2bf4" },
    { 0x2bf5,   "Bluetooth GATT Attribute LE GATT Security Levels (UUID 0x2bf5)", "BT GATT LE GATT Security Levels (UUID 0x2bf5)", "btgatt.uuid0x2bf5" },
    { 0x2bf6,   "Bluetooth GATT Attribute ESL Address (UUID 0x2bf6)", "BT GATT ESL Address (UUID 0x2bf6)", "btgatt.uuid0x2bf6" },
    { 0x2bf7,   "Bluetooth GATT Attribute AP Sync Key Material (UUID 0x2bf7)", "BT GATT AP Sync Key Material (UUID 0x2bf7)", "btgatt.uuid0x2bf7" },
    { 0x2bf8,   "Bluetooth GATT Attribute ESL Response Key Material (UUID 0x2bf8)", "BT GATT ESL Response Key Material (UUID 0x2bf8)", "btgatt.uuid0x2bf8" },
    { 0x2bf9,   "Bluetooth GATT Attribute ESL Current Absolute Time (UUID 0x2bf9)", "BT GATT ESL Current Absolute Time (UUID 0x2bf9)", "btgatt.uuid0x2bf9" },
    { 0x2bfa,   "Bluetooth GATT Attribute ESL Display Information (UUID 0x2bfa)", "BT GATT ESL Display Information (UUID 0x2bfa)", "btgatt.uuid0x2bfa" },
    { 0x2bfb,   "Bluetooth GATT Attribute ESL Image Information (UUID 0x2bfb)", "BT GATT ESL Image Information (UUID 0x2bfb)", "btgatt.uuid0x2bfb" },
    { 0x2bfc,   "Bluetooth GATT Attribute ESL Sensor Information (UUID 0x2bfc)", "BT GATT ESL Sensor Information (UUID 0x2bfc)", "btgatt.uuid0x2bfc" },
    { 0x2bfd,   "Bluetooth GATT Attribute ESL LED Information (UUID 0x2bfd)", "BT GATT ESL LED Information (UUID 0x2bfd)", "btgatt.uuid0x2bfd" },
    { 0x2bfe,   "Bluetooth GATT Attribute ESL Control Point (UUID 0x2bfe)", "BT GATT ESL Control Point (UUID 0x2bfe)", "btgatt.uuid0x2bfe" },
    { 0x2bff,   "Bluetooth GATT Attribute UDI for Medical Devices (UUID 0x2bff)", "BT GATT UDI for Medical Devices (UUID 0x2bff)", "btgatt.uuid0x2bff" },
    { 0x2c00,   "Bluetooth GATT Attribute GMAP Role (UUID 0x2c00)", "BT GATT GMAP Role (UUID 0x2c00)", "btgatt.uuid0x2c00" },
    { 0x2c01,   "Bluetooth GATT Attribute UGG Features (UUID 0x2c01)", "BT GATT UGG Features (UUID 0x2c01)", "btgatt.uuid0x2c01" },
    { 0x2c02,   "Bluetooth GATT Attribute UGT Features (UUID 0x2c02)", "BT GATT UGT Features (UUID 0x2c02)", "btgatt.uuid0x2c02" },
    { 0x2c03,   "Bluetooth GATT Attribute BGS Features (UUID 0x2c03)", "BT GATT BGS Features (UUID 0x2c03)", "btgatt.uuid0x2c03" },
    { 0x2c04,   "Bluetooth GATT Attribute BGR Features (UUID 0x2c04)", "BT GATT BGR Features (UUID 0x2c04)", "btgatt.uuid0x2c04" },
    { 0x2c05,   "Bluetooth GATT Attribute Percentage 8 Steps (UUID 0x2c05)", "BT GATT Percentage 8 Steps (UUID 0x2c05)", "btgatt.uuid0x2c05" },
    { 0x2c06,   "Bluetooth GATT Attribute Acceleration (UUID 0x2c06)", "BT GATT Acceleration (UUID 0x2c06)", "btgatt.uuid0x2c06" },
    { 0x2c07,   "Bluetooth GATT Attribute Force (UUID 0x2c07)", "BT GATT Force (UUID 0x2c07)", "btgatt.uuid0x2c07" },
    { 0x2c08,   "Bluetooth GATT Attribute Linear Position (UUID 0x2c08)", "BT GATT Linear Position (UUID 0x2c08)", "btgatt.uuid0x2c08" },
    { 0x2c09,   "Bluetooth GATT Attribute Rotational Speed (UUID 0x2c09)", "BT GATT Rotational Speed (UUID 0x2c09)", "btgatt.uuid0x2c09" },
    { 0x2c0a,   "Bluetooth GATT Attribute Length (UUID 0x2c0a)", "BT GATT Length (UUID 0x2c0a)", "btgatt.uuid0x2c0a" },
    { 0x2c0b,   "Bluetooth GATT Attribute Torque (UUID 0x2c0b)", "BT GATT Torque (UUID 0x2c0b)", "btgatt.uuid0x2c0b" },
    { 0x2c0c,   "Bluetooth GATT Attribute IMD Status (UUID 0x2c0c)", "BT GATT IMD Status (UUID 0x2c0c)", "btgatt.uuid0x2c0c" },
    { 0x2c0d,   "Bluetooth GATT Attribute IMDS Descriptor Value Changed (UUID 0x2c0d)", "BT GATT IMDS Descriptor Value Changed (UUID 0x2c0d)", "btgatt.uuid0x2c0d" },
    { 0x2c0e,   "Bluetooth GATT Attribute First Use Date (UUID 0x2c0e)", "BT GATT First Use Date (UUID 0x2c0e)", "btgatt.uuid0x2c0e" },
    { 0x2c0f,   "Bluetooth GATT Attribute Life Cycle Data (UUID 0x2c0f)", "BT GATT Life Cycle Data (UUID 0x2c0f)", "btgatt.uuid0x2c0f" },
    { 0x2c10,   "Bluetooth GATT Attribute Work Cycle Data (UUID 0x2c10)", "BT GATT Work Cycle Data (UUID 0x2c10)", "btgatt.uuid0x2c10" },
    { 0x2c11,   "Bluetooth GATT Attribute Service Cycle Data (UUID 0x2c11)", "BT GATT Service Cycle Data (UUID 0x2c11)", "btgatt.uuid0x2c11" },
    { 0x2c12,   "Bluetooth GATT Attribute IMD Control (UUID 0x2c12)", "BT GATT IMD Control (UUID 0x2c12)", "btgatt.uuid0x2c12" },
    { 0x2c13,   "Bluetooth GATT Attribute IMD Historical Data (UUID 0x2c13)", "BT GATT IMD Historical Data (UUID 0x2c13)", "btgatt.uuid0x2c13" },
    { 0x2c14,   "Bluetooth GATT Attribute RAS Features (UUID 0x2c14)", "BT GATT RAS Features (UUID 0x2c14)", "btgatt.uuid0x2c14" },
    { 0x2c15,   "Bluetooth GATT Attribute Real-time Ranging Data (UUID 0x2c15)", "BT GATT Real-time Ranging Data (UUID 0x2c15)", "btgatt.uuid0x2c15" },
    { 0x2c16,   "Bluetooth GATT Attribute On-demand Ranging Data (UUID 0x2c16)", "BT GATT On-demand Ranging Data (UUID 0x2c16)", "btgatt.uuid0x2c16" },
    { 0x2c17,   "Bluetooth GATT Attribute RAS Control Point (UUID 0x2c17)", "BT GATT RAS Control Point (UUID 0x2c17)", "btgatt.uuid0x2c17" },
    { 0x2c18,   "Bluetooth GATT Attribute Ranging Data Ready (UUID 0x2c18)", "BT GATT Ranging Data Ready (UUID 0x2c18)", "btgatt.uuid0x2c18" },
    { 0x2c19,   "Bluetooth GATT Attribute Ranging Data Overwritten (UUID 0x2c19)", "BT GATT Ranging Data Overwritten (UUID 0x2c19)", "btgatt.uuid0x2c19" },
    { 0x2c1a,   "Bluetooth GATT Attribute Coordinated Set Name (UUID 0x2c1a)", "BT GATT Coordinated Set Name (UUID 0x2c1a)", "btgatt.uuid0x2c1a" },
    { 0x2c1b,   "Bluetooth GATT Attribute Humidity 8 (UUID 0x2c1b)", "BT GATT Humidity 8 (UUID 0x2c1b)", "btgatt.uuid0x2c1b" },
    { 0x2c1c,   "Bluetooth GATT Attribute Illuminance 16 (UUID 0x2c1c)", "BT GATT Illuminance 16 (UUID 0x2c1c)", "btgatt.uuid0x2c1c" },
    { 0x2c1d,   "Bluetooth GATT Attribute Acceleration - 3D (UUID 0x2c1d)", "BT GATT Acceleration - 3D (UUID 0x2c1d)", "btgatt.uuid0x2c1d" },
    { 0x2c1e,   "Bluetooth GATT Attribute Precise Acceleration - 3D (UUID 0x2c1e)", "BT GATT Precise Acceleration - 3D (UUID 0x2c1e)", "btgatt.uuid0x2c1e" },
    { 0x2c1f,   "Bluetooth GATT Attribute Acceleration Detection Status (UUID 0x2c1f)", "BT GATT Acceleration Detection Status (UUID 0x2c1f)", "btgatt.uuid0x2c1f" },
    { 0x2c20,   "Bluetooth GATT Attribute Door/Window Status (UUID 0x2c20)", "BT GATT Door/Window Status (UUID 0x2c20)", "btgatt.uuid0x2c20" },
    { 0x2c21,   "Bluetooth GATT Attribute Pushbutton Status 8 (UUID 0x2c21)", "BT GATT Pushbutton Status 8 (UUID 0x2c21)", "btgatt.uuid0x2c21" },
    { 0x2c22,   "Bluetooth GATT Attribute Contact Status 8 (UUID 0x2c22)", "BT GATT Contact Status 8 (UUID 0x2c22)", "btgatt.uuid0x2c22" },
    { 0x2c23,   "Bluetooth GATT Attribute HID ISO Properties (UUID 0x2c23)", "BT GATT HID ISO Properties (UUID 0x2c23)", "btgatt.uuid0x2c23" },
    { 0x2c24,   "Bluetooth GATT Attribute LE HID Operation Mode (UUID 0x2c24)", "BT GATT LE HID Operation Mode (UUID 0x2c24)", "btgatt.uuid0x2c24" },
    { 0x2c25,   "Bluetooth GATT Attribute Cookware Description (UUID 0x2c25)", "BT GATT Cookware Description (UUID 0x2c25)", "btgatt.uuid0x2c25" },
    { 0x2c26,   "Bluetooth GATT Attribute Recipe Control (UUID 0x2c26)", "BT GATT Recipe Control (UUID 0x2c26)", "btgatt.uuid0x2c26" },
    { 0x2c27,   "Bluetooth GATT Attribute Recipe Parameters (UUID 0x2c27)", "BT GATT Recipe Parameters (UUID 0x2c27)", "btgatt.uuid0x2c27" },
    { 0x2c28,   "Bluetooth GATT Attribute Cooking Step Status (UUID 0x2c28)", "BT GATT Cooking Step Status (UUID 0x2c28)", "btgatt.uuid0x2c28" },
    { 0x2c29,   "Bluetooth GATT Attribute Cooking Zone Capabilities (UUID 0x2c29)", "BT GATT Cooking Zone Capabilities (UUID 0x2c29)", "btgatt.uuid0x2c29" },
    { 0x2c2a,   "Bluetooth GATT Attribute Cooking Zone Desired Cooking Conditions (UUID 0x2c2a)", "BT GATT Cooking Zone Desired Cooking Conditions (UUID 0x2c2a)", "btgatt.uuid0x2c2a" },
    { 0x2c2b,   "Bluetooth GATT Attribute Cooking Zone Actual Cooking Conditions (UUID 0x2c2b)", "BT GATT Cooking Zone Actual Cooking Conditions (UUID 0x2c2b)", "btgatt.uuid0x2c2b" },
    { 0x2c2c,   "Bluetooth GATT Attribute Cookware Sensor Data (UUID 0x2c2c)", "BT GATT Cookware Sensor Data (UUID 0x2c2c)", "btgatt.uuid0x2c2c" },
    { 0x2c2d,   "Bluetooth GATT Attribute Cookware Sensor Aggregate (UUID 0x2c2d)", "BT GATT Cookware Sensor Aggregate (UUID 0x2c2d)", "btgatt.uuid0x2c2d" },
    { 0x2c2e,   "Bluetooth GATT Attribute Cooking Temperature (UUID 0x2c2e)", "BT GATT Cooking Temperature (UUID 0x2c2e)", "btgatt.uuid0x2c2e" },
    { 0x2c2f,   "Bluetooth GATT Attribute Cooking Zone Perceived Power (UUID 0x2c2f)", "BT GATT Cooking Zone Perceived Power (UUID 0x2c2f)", "btgatt.uuid0x2c2f" },
    { 0x2c30,   "Bluetooth GATT Attribute Kitchen Appliance Airflow (UUID 0x2c30)", "BT GATT Kitchen Appliance Airflow (UUID 0x2c30)", "btgatt.uuid0x2c30" },
    /* Members - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/member_uuids.yaml */
    { 0xfc47,   "Bluetooth GATT Attribute Shanghai Ingeek Technology Co., Ltd. (UUID 0xfc47)", "BT GATT Shanghai Ingeek Technology Co., Ltd. (UUID 0xfc47)", "btgatt.uuid0xfc47" },
    { 0xfc48,   "Bluetooth GATT Attribute Michelin (UUID 0xfc48)", "BT GATT Michelin (UUID 0xfc48)", "btgatt.uuid0xfc48" },
    { 0xfc49,   "Bluetooth GATT Attribute Golioth, Inc. (UUID 0xfc49)", "BT GATT Golioth, Inc. (UUID 0xfc49)", "btgatt.uuid0xfc49" },
    { 0xfc4a,   "Bluetooth GATT Attribute Shenzhen Shokz Co.,Ltd. (UUID 0xfc4a)", "BT GATT Shenzhen Shokz Co.,Ltd. (UUID 0xfc4a)", "btgatt.uuid0xfc4a" },
    { 0xfc4b,   "Bluetooth GATT Attribute WinMagic Inc. (UUID 0xfc4b)", "BT GATT WinMagic Inc. (UUID 0xfc4b)", "btgatt.uuid0xfc4b" },
    { 0xfc4c,   "Bluetooth GATT Attribute HP Inc. (UUID 0xfc4c)", "BT GATT HP Inc. (UUID 0xfc4c)", "btgatt.uuid0xfc4c" },
    { 0xfc4d,   "Bluetooth GATT Attribute Lodestar Technology Inc. (UUID 0xfc4d)", "BT GATT Lodestar Technology Inc. (UUID 0xfc4d)", "btgatt.uuid0xfc4d" },
    { 0xfc4e,   "Bluetooth GATT Attribute Lodestar Technology Inc. (UUID 0xfc4e)", "BT GATT Lodestar Technology Inc. (UUID 0xfc4e)", "btgatt.uuid0xfc4e" },
    { 0xfc4f,   "Bluetooth GATT Attribute WaveRF, Corp. (UUID 0xfc4f)", "BT GATT WaveRF, Corp. (UUID 0xfc4f)", "btgatt.uuid0xfc4f" },
    { 0xfc50,   "Bluetooth GATT Attribute Ant Group Co., Ltd. (UUID 0xfc50)", "BT GATT Ant Group Co., Ltd. (UUID 0xfc50)", "btgatt.uuid0xfc50" },
    { 0xfc51,   "Bluetooth GATT Attribute Ant Group Co., Ltd. (UUID 0xfc51)", "BT GATT Ant Group Co., Ltd. (UUID 0xfc51)", "btgatt.uuid0xfc51" },
    { 0xfc52,   "Bluetooth GATT Attribute LG Electronics Inc. (UUID 0xfc52)", "BT GATT LG Electronics Inc. (UUID 0xfc52)", "btgatt.uuid0xfc52" },
    { 0xfc53,   "Bluetooth GATT Attribute LEGIC Identsystems AG (UUID 0xfc53)", "BT GATT LEGIC Identsystems AG (UUID 0xfc53)", "btgatt.uuid0xfc53" },
    { 0xfc54,   "Bluetooth GATT Attribute Shenzhen Yinwang Intelligent Technologies Co., Ltd. (UUID 0xfc54)", "BT GATT Shenzhen Yinwang Intelligent Technologies Co., Ltd. (UUID 0xfc54)", "btgatt.uuid0xfc54" },
    { 0xfc55,   "Bluetooth GATT Attribute BYD Company Limited (UUID 0xfc55)", "BT GATT BYD Company Limited (UUID 0xfc55)", "btgatt.uuid0xfc55" },
    { 0xfc56,   "Bluetooth GATT Attribute Google LLC (UUID 0xfc56)", "BT GATT Google LLC (UUID 0xfc56)", "btgatt.uuid0xfc56" },
    { 0xfc57,   "Bluetooth GATT Attribute Ambient Life Inc. (UUID 0xfc57)", "BT GATT Ambient Life Inc. (UUID 0xfc57)", "btgatt.uuid0xfc57" },
    { 0xfc58,   "Bluetooth GATT Attribute Shenzhen Minew Technologies Co., Ltd. (UUID 0xfc58)", "BT GATT Shenzhen Minew Technologies Co., Ltd. (UUID 0xfc58)", "btgatt.uuid0xfc58" },
    { 0xfc59,   "Bluetooth GATT Attribute Ant Group Co., Ltd. (UUID 0xfc59)", "BT GATT Ant Group Co., Ltd. (UUID 0xfc59)", "btgatt.uuid0xfc59" },
    { 0xfc5a,   "Bluetooth GATT Attribute LAST LOCK INC. (UUID 0xfc5a)", "BT GATT LAST LOCK INC. (UUID 0xfc5a)", "btgatt.uuid0xfc5a" },
    { 0xfc5b,   "Bluetooth GATT Attribute Time Location Systems AS (UUID 0xfc5b)", "BT GATT Time Location Systems AS (UUID 0xfc5b)", "btgatt.uuid0xfc5b" },
    { 0xfc5c,   "Bluetooth GATT Attribute PLASTIC RESEARCH AND DEVELOPMENT CORPORATION (UUID 0xfc5c)", "BT GATT PLASTIC RESEARCH AND DEVELOPMENT CORPORATION (UUID 0xfc5c)", "btgatt.uuid0xfc5c" },
    { 0xfc5d,   "Bluetooth GATT Attribute GP Acoustics International Limited (UUID 0xfc5d)", "BT GATT GP Acoustics International Limited (UUID 0xfc5d)", "btgatt.uuid0xfc5d" },
    { 0xfc5e,   "Bluetooth GATT Attribute KUBU SMART LIMITED (UUID 0xfc5e)", "BT GATT KUBU SMART LIMITED (UUID 0xfc5e)", "btgatt.uuid0xfc5e" },
    { 0xfc5f,   "Bluetooth GATT Attribute PI-CRYSTAL INC. (UUID 0xfc5f)", "BT GATT PI-CRYSTAL INC. (UUID 0xfc5f)", "btgatt.uuid0xfc5f" },
    { 0xfc60,   "Bluetooth GATT Attribute Ohme Operations UK Limited (UUID 0xfc60)", "BT GATT Ohme Operations UK Limited (UUID 0xfc60)", "btgatt.uuid0xfc60" },
    { 0xfc61,   "Bluetooth GATT Attribute QIKCONNEX LLC (UUID 0xfc61)", "BT GATT QIKCONNEX LLC (UUID 0xfc61)", "btgatt.uuid0xfc61" },
    { 0xfc62,   "Bluetooth GATT Attribute SPRiNTUS GmbH (UUID 0xfc62)", "BT GATT SPRiNTUS GmbH (UUID 0xfc62)", "btgatt.uuid0xfc62" },
    { 0xfc63,   "Bluetooth GATT Attribute Volvo Technology AB (UUID 0xfc63)", "BT GATT Volvo Technology AB (UUID 0xfc63)", "btgatt.uuid0xfc63" },
    { 0xfc64,   "Bluetooth GATT Attribute Volvo Technology AB (UUID 0xfc64)", "BT GATT Volvo Technology AB (UUID 0xfc64)", "btgatt.uuid0xfc64" },
    { 0xfc65,   "Bluetooth GATT Attribute Robor Electronics B.V. (UUID 0xfc65)", "BT GATT Robor Electronics B.V. (UUID 0xfc65)", "btgatt.uuid0xfc65" },
    { 0xfc66,   "Bluetooth GATT Attribute Xiaomi Inc. (UUID 0xfc66)", "BT GATT Xiaomi Inc. (UUID 0xfc66)", "btgatt.uuid0xfc66" },
    { 0xfc67,   "Bluetooth GATT Attribute Guangdong Hengqin Xingtong Technology Co.,ltd. (UUID 0xfc67)", "BT GATT Guangdong Hengqin Xingtong Technology Co.,ltd. (UUID 0xfc67)", "btgatt.uuid0xfc67" },
    { 0xfc68,   "Bluetooth GATT Attribute RIGH, INC. (UUID 0xfc68)", "BT GATT RIGH, INC. (UUID 0xfc68)", "btgatt.uuid0xfc68" },
    { 0xfc69,   "Bluetooth GATT Attribute Harman International (UUID 0xfc69)", "BT GATT Harman International (UUID 0xfc69)", "btgatt.uuid0xfc69" },
    { 0xfc6a,   "Bluetooth GATT Attribute Sonos Inc (UUID 0xfc6a)", "BT GATT Sonos Inc (UUID 0xfc6a)", "btgatt.uuid0xfc6a" },
    { 0xfc6b,   "Bluetooth GATT Attribute Sonos Inc (UUID 0xfc6b)", "BT GATT Sonos Inc (UUID 0xfc6b)", "btgatt.uuid0xfc6b" },
    { 0xfc6c,   "Bluetooth GATT Attribute Powerstick.com (UUID 0xfc6c)", "BT GATT Powerstick.com (UUID 0xfc6c)", "btgatt.uuid0xfc6c" },
    { 0xfc6d,   "Bluetooth GATT Attribute MOTIVE TECHNOLOGIES, INC. (UUID 0xfc6d)", "BT GATT MOTIVE TECHNOLOGIES, INC. (UUID 0xfc6d)", "btgatt.uuid0xfc6d" },
    { 0xfc6e,   "Bluetooth GATT Attribute stryker (UUID 0xfc6e)", "BT GATT stryker (UUID 0xfc6e)", "btgatt.uuid0xfc6e" },
    { 0xfc6f,   "Bluetooth GATT Attribute NextSense, Inc. (UUID 0xfc6f)", "BT GATT NextSense, Inc. (UUID 0xfc6f)", "btgatt.uuid0xfc6f" },
    { 0xfc70,   "Bluetooth GATT Attribute MOTIVE TECHNOLOGIES, INC. (UUID 0xfc70)", "BT GATT MOTIVE TECHNOLOGIES, INC. (UUID 0xfc70)", "btgatt.uuid0xfc70" },
    { 0xfc71,   "Bluetooth GATT Attribute Hive-Zox International SA (UUID 0xfc71)", "BT GATT Hive-Zox International SA (UUID 0xfc71)", "btgatt.uuid0xfc71" },
    { 0xfc72,   "Bluetooth GATT Attribute iodyne, LLC (UUID 0xfc72)", "BT GATT iodyne, LLC (UUID 0xfc72)", "btgatt.uuid0xfc72" },
    { 0xfc73,   "Bluetooth GATT Attribute Google LLC (UUID 0xfc73)", "BT GATT Google LLC (UUID 0xfc73)", "btgatt.uuid0xfc73" },
    { 0xfc74,   "Bluetooth GATT Attribute EMBEINT INC (UUID 0xfc74)", "BT GATT EMBEINT INC (UUID 0xfc74)", "btgatt.uuid0xfc74" },
    { 0xfc75,   "Bluetooth GATT Attribute Xiaomi Inc. (UUID 0xfc75)", "BT GATT Xiaomi Inc. (UUID 0xfc75)", "btgatt.uuid0xfc75" },
    { 0xfc76,   "Bluetooth GATT Attribute Weber-Stephen Products LLC (UUID 0xfc76)", "BT GATT Weber-Stephen Products LLC (UUID 0xfc76)", "btgatt.uuid0xfc76" },
    { 0xfc77,   "Bluetooth GATT Attribute SING SUN TECHNOLOGY (INTERNATIONAL) LIMITED (UUID 0xfc77)", "BT GATT SING SUN TECHNOLOGY (INTERNATIONAL) LIMITED (UUID 0xfc77)", "btgatt.uuid0xfc77" },
    { 0xfc78,   "Bluetooth GATT Attribute DHL (UUID 0xfc78)", "BT GATT DHL (UUID 0xfc78)", "btgatt.uuid0xfc78" },
    { 0xfc79,   "Bluetooth GATT Attribute LG Electronics Inc. (UUID 0xfc79)", "BT GATT LG Electronics Inc. (UUID 0xfc79)", "btgatt.uuid0xfc79" },
    { 0xfc7a,   "Bluetooth GATT Attribute Outshiny India Private Limited (UUID 0xfc7a)", "BT GATT Outshiny India Private Limited (UUID 0xfc7a)", "btgatt.uuid0xfc7a" },
    { 0xfc7b,   "Bluetooth GATT Attribute Testo SE & Co. KGaA (UUID 0xfc7b)", "BT GATT Testo SE & Co. KGaA (UUID 0xfc7b)", "btgatt.uuid0xfc7b" },
    { 0xfc7c,   "Bluetooth GATT Attribute Motorola Mobility, LLC (UUID 0xfc7c)", "BT GATT Motorola Mobility, LLC (UUID 0xfc7c)", "btgatt.uuid0xfc7c" },
    { 0xfc7d,   "Bluetooth GATT Attribute MML US, Inc (UUID 0xfc7d)", "BT GATT MML US, Inc (UUID 0xfc7d)", "btgatt.uuid0xfc7d" },
    { 0xfc7e,   "Bluetooth GATT Attribute Harman International (UUID 0xfc7e)", "BT GATT Harman International (UUID 0xfc7e)", "btgatt.uuid0xfc7e" },
    { 0xfc7f,   "Bluetooth GATT Attribute Southco (UUID 0xfc7f)", "BT GATT Southco (UUID 0xfc7f)", "btgatt.uuid0xfc7f" },
    { 0xfc80,   "Bluetooth GATT Attribute TELE System Communications Pte. Ltd. (UUID 0xfc80)", "BT GATT TELE System Communications Pte. Ltd. (UUID 0xfc80)", "btgatt.uuid0xfc80" },
    { 0xfc81,   "Bluetooth GATT Attribute Axon Enterprise, Inc. (UUID 0xfc81)", "BT GATT Axon Enterprise, Inc. (UUID 0xfc81)", "btgatt.uuid0xfc81" },
    { 0xfc82,   "Bluetooth GATT Attribute Zwift, Inc. (UUID 0xfc82)", "BT GATT Zwift, Inc. (UUID 0xfc82)", "btgatt.uuid0xfc82" },
    { 0xfc83,   "Bluetooth GATT Attribute iHealth Labs, Inc. (UUID 0xfc83)", "BT GATT iHealth Labs, Inc. (UUID 0xfc83)", "btgatt.uuid0xfc83" },
    { 0xfc84,   "Bluetooth GATT Attribute NINGBO FOTILE KITCHENWARE CO., LTD. (UUID 0xfc84)", "BT GATT NINGBO FOTILE KITCHENWARE CO., LTD. (UUID 0xfc84)", "btgatt.uuid0xfc84" },
    { 0xfc85,   "Bluetooth GATT Attribute Zhejiang Huanfu Technology Co., LTD (UUID 0xfc85)", "BT GATT Zhejiang Huanfu Technology Co., LTD (UUID 0xfc85)", "btgatt.uuid0xfc85" },
    { 0xfc86,   "Bluetooth GATT Attribute Samsara Networks, Inc (UUID 0xfc86)", "BT GATT Samsara Networks, Inc (UUID 0xfc86)", "btgatt.uuid0xfc86" },
    { 0xfc87,   "Bluetooth GATT Attribute Samsara Networks, Inc (UUID 0xfc87)", "BT GATT Samsara Networks, Inc (UUID 0xfc87)", "btgatt.uuid0xfc87" },
    { 0xfc88,   "Bluetooth GATT Attribute CCC del Uruguay (UUID 0xfc88)", "BT GATT CCC del Uruguay (UUID 0xfc88)", "btgatt.uuid0xfc88" },
    { 0xfc89,   "Bluetooth GATT Attribute Intel Corporation (UUID 0xfc89)", "BT GATT Intel Corporation (UUID 0xfc89)", "btgatt.uuid0xfc89" },
    { 0xfc8a,   "Bluetooth GATT Attribute Intel Corporation (UUID 0xfc8a)", "BT GATT Intel Corporation (UUID 0xfc8a)", "btgatt.uuid0xfc8a" },
    { 0xfc8b,   "Bluetooth GATT Attribute Kaspersky Lab Middle East FZ-LLC (UUID 0xfc8b)", "BT GATT Kaspersky Lab Middle East FZ-LLC (UUID 0xfc8b)", "btgatt.uuid0xfc8b" },
    { 0xfc8c,   "Bluetooth GATT Attribute VusionGroup (UUID 0xfc8c)", "BT GATT VusionGroup (UUID 0xfc8c)", "btgatt.uuid0xfc8c" },
    { 0xfc8d,   "Bluetooth GATT Attribute Caire Inc. (UUID 0xfc8d)", "BT GATT Caire Inc. (UUID 0xfc8d)", "btgatt.uuid0xfc8d" },
    { 0xfc8e,   "Bluetooth GATT Attribute Blue Iris Labs, Inc. (UUID 0xfc8e)", "BT GATT Blue Iris Labs, Inc. (UUID 0xfc8e)", "btgatt.uuid0xfc8e" },
    { 0xfc8f,   "Bluetooth GATT Attribute Bose Corporation (UUID 0xfc8f)", "BT GATT Bose Corporation (UUID 0xfc8f)", "btgatt.uuid0xfc8f" },
    { 0xfc90,   "Bluetooth GATT Attribute Wiliot LTD. (UUID 0xfc90)", "BT GATT Wiliot LTD. (UUID 0xfc90)", "btgatt.uuid0xfc90" },
    { 0xfc91,   "Bluetooth GATT Attribute Samsung Electronics Co., Ltd. (UUID 0xfc91)", "BT GATT Samsung Electronics Co., Ltd. (UUID 0xfc91)", "btgatt.uuid0xfc91" },
    { 0xfc92,   "Bluetooth GATT Attribute Furuno Electric Co., Ltd. (UUID 0xfc92)", "BT GATT Furuno Electric Co., Ltd. (UUID 0xfc92)", "btgatt.uuid0xfc92" },
    { 0xfc93,   "Bluetooth GATT Attribute Komatsu Ltd. (UUID 0xfc93)", "BT GATT Komatsu Ltd. (UUID 0xfc93)", "btgatt.uuid0xfc93" },
    { 0xfc94,   "Bluetooth GATT Attribute Apple Inc. (UUID 0xfc94)", "BT GATT Apple Inc. (UUID 0xfc94)", "btgatt.uuid0xfc94" },
    { 0xfc95,   "Bluetooth GATT Attribute Hippo Camp Software Ltd. (UUID 0xfc95)", "BT GATT Hippo Camp Software Ltd. (UUID 0xfc95)", "btgatt.uuid0xfc95" },
    { 0xfc96,   "Bluetooth GATT Attribute LEGO System A/S (UUID 0xfc96)", "BT GATT LEGO System A/S (UUID 0xfc96)", "btgatt.uuid0xfc96" },
    { 0xfc97,   "Bluetooth GATT Attribute Japan Display Inc. (UUID 0xfc97)", "BT GATT Japan Display Inc. (UUID 0xfc97)", "btgatt.uuid0xfc97" },
    { 0xfc98,   "Bluetooth GATT Attribute Ruuvi Innovations Ltd. (UUID 0xfc98)", "BT GATT Ruuvi Innovations Ltd. (UUID 0xfc98)", "btgatt.uuid0xfc98" },
    { 0xfc99,   "Bluetooth GATT Attribute Badger Meter (UUID 0xfc99)", "BT GATT Badger Meter (UUID 0xfc99)", "btgatt.uuid0xfc99" },
    { 0xfc9a,   "Bluetooth GATT Attribute Koppli AB (UUID 0xfc9a)", "BT GATT Koppli AB (UUID 0xfc9a)", "btgatt.uuid0xfc9a" },
    { 0xfc9b,   "Bluetooth GATT Attribute Merry Electronics (S) Pte Ltd (UUID 0xfc9b)", "BT GATT Merry Electronics (S) Pte Ltd (UUID 0xfc9b)", "btgatt.uuid0xfc9b" },
    { 0xfc9d,   "Bluetooth GATT Attribute Lenovo (Singapore) Pte Ltd. (UUID 0xfc9d)", "BT GATT Lenovo (Singapore) Pte Ltd. (UUID 0xfc9d)", "btgatt.uuid0xfc9d" },
    { 0xfc9e,   "Bluetooth GATT Attribute Dell Computer Corporation (UUID 0xfc9e)", "BT GATT Dell Computer Corporation (UUID 0xfc9e)", "btgatt.uuid0xfc9e" },
    { 0xfc9f,   "Bluetooth GATT Attribute Delta Development Team, Inc (UUID 0xfc9f)", "BT GATT Delta Development Team, Inc (UUID 0xfc9f)", "btgatt.uuid0xfc9f" },
    { 0xfca0,   "Bluetooth GATT Attribute Apple Inc. (UUID 0xfca0)", "BT GATT Apple Inc. (UUID 0xfca0)", "btgatt.uuid0xfca0" },
    { 0xfca1,   "Bluetooth GATT Attribute PF SCHWEISSTECHNOLOGIE GMBH (UUID 0xfca1)", "BT GATT PF SCHWEISSTECHNOLOGIE GMBH (UUID 0xfca1)", "btgatt.uuid0xfca1" },
    { 0xfca2,   "Bluetooth GATT Attribute Meizu Technology Co., Ltd. (UUID 0xfca2)", "BT GATT Meizu Technology Co., Ltd. (UUID 0xfca2)", "btgatt.uuid0xfca2" },
    { 0xfca3,   "Bluetooth GATT Attribute Gunnebo Aktiebolag (UUID 0xfca3)", "BT GATT Gunnebo Aktiebolag (UUID 0xfca3)", "btgatt.uuid0xfca3" },
    { 0xfca4,   "Bluetooth GATT Attribute HP Inc. (UUID 0xfca4)", "BT GATT HP Inc. (UUID 0xfca4)", "btgatt.uuid0xfca4" },
    { 0xfca5,   "Bluetooth GATT Attribute HAYWARD INDUSTRIES, INC. (UUID 0xfca5)", "BT GATT HAYWARD INDUSTRIES, INC. (UUID 0xfca5)", "btgatt.uuid0xfca5" },
    { 0xfca6,   "Bluetooth GATT Attribute Hubble Network Inc. (UUID 0xfca6)", "BT GATT Hubble Network Inc. (UUID 0xfca6)", "btgatt.uuid0xfca6" },
    { 0xfca7,   "Bluetooth GATT Attribute Hubble Network Inc. (UUID 0xfca7)", "BT GATT Hubble Network Inc. (UUID 0xfca7)", "btgatt.uuid0xfca7" },
    { 0xfca8,   "Bluetooth GATT Attribute Medtronic Inc. (UUID 0xfca8)", "BT GATT Medtronic Inc. (UUID 0xfca8)", "btgatt.uuid0xfca8" },
    { 0xfca9,   "Bluetooth GATT Attribute Medtronic Inc. (UUID 0xfca9)", "BT GATT Medtronic Inc. (UUID 0xfca9)", "btgatt.uuid0xfca9" },
    { 0xfcaa,   "Bluetooth GATT Attribute Spintly, Inc. (UUID 0xfcaa)", "BT GATT Spintly, Inc. (UUID 0xfcaa)", "btgatt.uuid0xfcaa" },
    { 0xfcab,   "Bluetooth GATT Attribute IRISS INC. (UUID 0xfcab)", "BT GATT IRISS INC. (UUID 0xfcab)", "btgatt.uuid0xfcab" },
    { 0xfcac,   "Bluetooth GATT Attribute IRISS INC. (UUID 0xfcac)", "BT GATT IRISS INC. (UUID 0xfcac)", "btgatt.uuid0xfcac" },
    { 0xfcad,   "Bluetooth GATT Attribute Beijing 99help Safety Technology Co., Ltd (UUID 0xfcad)", "BT GATT Beijing 99help Safety Technology Co., Ltd (UUID 0xfcad)", "btgatt.uuid0xfcad" },
    { 0xfcae,   "Bluetooth GATT Attribute Imagine Marketing Limited (UUID 0xfcae)", "BT GATT Imagine Marketing Limited (UUID 0xfcae)", "btgatt.uuid0xfcae" },
    { 0xfcaf,   "Bluetooth GATT Attribute AltoBeam Inc. (UUID 0xfcaf)", "BT GATT AltoBeam Inc. (UUID 0xfcaf)", "btgatt.uuid0xfcaf" },
    { 0xfcb0,   "Bluetooth GATT Attribute Ford Motor Company (UUID 0xfcb0)", "BT GATT Ford Motor Company (UUID 0xfcb0)", "btgatt.uuid0xfcb0" },
    { 0xfcb1,   "Bluetooth GATT Attribute Google LLC (UUID 0xfcb1)", "BT GATT Google LLC (UUID 0xfcb1)", "btgatt.uuid0xfcb1" },
    { 0xfcb2,   "Bluetooth GATT Attribute Apple Inc. (UUID 0xfcb2)", "BT GATT Apple Inc. (UUID 0xfcb2)", "btgatt.uuid0xfcb2" },
    { 0xfcb3,   "Bluetooth GATT Attribute SWEEN (UUID 0xfcb3)", "BT GATT SWEEN (UUID 0xfcb3)", "btgatt.uuid0xfcb3" },
    { 0xfcb4,   "Bluetooth GATT Attribute OMRON HEALTHCARE Co., Ltd. (UUID 0xfcb4)", "BT GATT OMRON HEALTHCARE Co., Ltd. (UUID 0xfcb4)", "btgatt.uuid0xfcb4" },
    { 0xfcb5,   "Bluetooth GATT Attribute OMRON HEALTHCARE Co., Ltd. (UUID 0xfcb5)", "BT GATT OMRON HEALTHCARE Co., Ltd. (UUID 0xfcb5)", "btgatt.uuid0xfcb5" },
    { 0xfcb6,   "Bluetooth GATT Attribute OMRON HEALTHCARE Co., Ltd. (UUID 0xfcb6)", "BT GATT OMRON HEALTHCARE Co., Ltd. (UUID 0xfcb6)", "btgatt.uuid0xfcb6" },
    { 0xfcb7,   "Bluetooth GATT Attribute T-Mobile USA (UUID 0xfcb7)", "BT GATT T-Mobile USA (UUID 0xfcb7)", "btgatt.uuid0xfcb7" },
    { 0xfcb8,   "Bluetooth GATT Attribute Ribbiot, INC. (UUID 0xfcb8)", "BT GATT Ribbiot, INC. (UUID 0xfcb8)", "btgatt.uuid0xfcb8" },
    { 0xfcb9,   "Bluetooth GATT Attribute Lumi United Technology Co., Ltd (UUID 0xfcb9)", "BT GATT Lumi United Technology Co., Ltd (UUID 0xfcb9)", "btgatt.uuid0xfcb9" },
    { 0xfcba,   "Bluetooth GATT Attribute BlueID GmbH (UUID 0xfcba)", "BT GATT BlueID GmbH (UUID 0xfcba)", "btgatt.uuid0xfcba" },
    { 0xfcbb,   "Bluetooth GATT Attribute SharkNinja Operating LLC (UUID 0xfcbb)", "BT GATT SharkNinja Operating LLC (UUID 0xfcbb)", "btgatt.uuid0xfcbb" },
    { 0xfcbc,   "Bluetooth GATT Attribute Drowsy Digital, Inc. (UUID 0xfcbc)", "BT GATT Drowsy Digital, Inc. (UUID 0xfcbc)", "btgatt.uuid0xfcbc" },
    { 0xfcbd,   "Bluetooth GATT Attribute Toshiba Corporation (UUID 0xfcbd)", "BT GATT Toshiba Corporation (UUID 0xfcbd)", "btgatt.uuid0xfcbd" },
    { 0xfcbe,   "Bluetooth GATT Attribute Musen Connect, Inc. (UUID 0xfcbe)", "BT GATT Musen Connect, Inc. (UUID 0xfcbe)", "btgatt.uuid0xfcbe" },
    { 0xfcbf,   "Bluetooth GATT Attribute ASSA ABLOY Opening Solutions Sweden AB (UUID 0xfcbf)", "BT GATT ASSA ABLOY Opening Solutions Sweden AB (UUID 0xfcbf)", "btgatt.uuid0xfcbf" },
    { 0xfcc0,   "Bluetooth GATT Attribute Xiaomi Inc. (UUID 0xfcc0)", "BT GATT Xiaomi Inc. (UUID 0xfcc0)", "btgatt.uuid0xfcc0" },
    { 0xfcc1,   "Bluetooth GATT Attribute TIMECODE SYSTEMS LIMITED (UUID 0xfcc1)", "BT GATT TIMECODE SYSTEMS LIMITED (UUID 0xfcc1)", "btgatt.uuid0xfcc1" },
    { 0xfcc2,   "Bluetooth GATT Attribute Qualcomm Technologies, Inc. (UUID 0xfcc2)", "BT GATT Qualcomm Technologies, Inc. (UUID 0xfcc2)", "btgatt.uuid0xfcc2" },
    { 0xfcc3,   "Bluetooth GATT Attribute HP Inc. (UUID 0xfcc3)", "BT GATT HP Inc. (UUID 0xfcc3)", "btgatt.uuid0xfcc3" },
    { 0xfcc4,   "Bluetooth GATT Attribute OMRON(DALIAN) CO,.LTD. (UUID 0xfcc4)", "BT GATT OMRON(DALIAN) CO,.LTD. (UUID 0xfcc4)", "btgatt.uuid0xfcc4" },
    { 0xfcc5,   "Bluetooth GATT Attribute OMRON(DALIAN) CO,.LTD. (UUID 0xfcc5)", "BT GATT OMRON(DALIAN) CO,.LTD. (UUID 0xfcc5)", "btgatt.uuid0xfcc5" },
    { 0xfcc6,   "Bluetooth GATT Attribute Wiliot LTD. (UUID 0xfcc6)", "BT GATT Wiliot LTD. (UUID 0xfcc6)", "btgatt.uuid0xfcc6" },
    { 0xfcc7,   "Bluetooth GATT Attribute PB INC. (UUID 0xfcc7)", "BT GATT PB INC. (UUID 0xfcc7)", "btgatt.uuid0xfcc7" },
    { 0xfcc8,   "Bluetooth GATT Attribute Allthenticate, Inc. (UUID 0xfcc8)", "BT GATT Allthenticate, Inc. (UUID 0xfcc8)", "btgatt.uuid0xfcc8" },
    { 0xfcc9,   "Bluetooth GATT Attribute SkyHawke Technologies (UUID 0xfcc9)", "BT GATT SkyHawke Technologies (UUID 0xfcc9)", "btgatt.uuid0xfcc9" },
    { 0xfcca,   "Bluetooth GATT Attribute Cosmed s.r.l. (UUID 0xfcca)", "BT GATT Cosmed s.r.l. (UUID 0xfcca)", "btgatt.uuid0xfcca" },
    { 0xfccb,   "Bluetooth GATT Attribute TOTO LTD. (UUID 0xfccb)", "BT GATT TOTO LTD. (UUID 0xfccb)", "btgatt.uuid0xfccb" },
    { 0xfccc,   "Bluetooth GATT Attribute Wi-Fi Easy Connect Specification (UUID 0xfccc)", "BT GATT Wi-Fi Easy Connect Specification (UUID 0xfccc)", "btgatt.uuid0xfccc" },
    { 0xfccd,   "Bluetooth GATT Attribute Marshall Group AB (UUID 0xfccd)", "BT GATT Marshall Group AB (UUID 0xfccd)", "btgatt.uuid0xfccd" },
    { 0xfcce,   "Bluetooth GATT Attribute Luna Health, Inc. (UUID 0xfcce)", "BT GATT Luna Health, Inc. (UUID 0xfcce)", "btgatt.uuid0xfcce" },
    { 0xfccf,   "Bluetooth GATT Attribute Google LLC (UUID 0xfccf)", "BT GATT Google LLC (UUID 0xfccf)", "btgatt.uuid0xfccf" },
    { 0xfcd0,   "Bluetooth GATT Attribute Laerdal Medical AS (UUID 0xfcd0)", "BT GATT Laerdal Medical AS (UUID 0xfcd0)", "btgatt.uuid0xfcd0" },
    { 0xfcd1,   "Bluetooth GATT Attribute Shenzhen Benwei Media Co.,Ltd. (UUID 0xfcd1)", "BT GATT Shenzhen Benwei Media Co.,Ltd. (UUID 0xfcd1)", "btgatt.uuid0xfcd1" },
    { 0xfcd2,   "Bluetooth GATT Attribute Allterco Robotics ltd (UUID 0xfcd2)", "BT GATT Allterco Robotics ltd (UUID 0xfcd2)", "btgatt.uuid0xfcd2" },
    { 0xfcd3,   "Bluetooth GATT Attribute Fisher & Paykel Healthcare (UUID 0xfcd3)", "BT GATT Fisher & Paykel Healthcare (UUID 0xfcd3)", "btgatt.uuid0xfcd3" },
    { 0xfcd4,   "Bluetooth GATT Attribute OMRON HEALTHCARE (UUID 0xfcd4)", "BT GATT OMRON HEALTHCARE (UUID 0xfcd4)", "btgatt.uuid0xfcd4" },
    { 0xfcd5,   "Bluetooth GATT Attribute Nortek Security & Control (UUID 0xfcd5)", "BT GATT Nortek Security & Control (UUID 0xfcd5)", "btgatt.uuid0xfcd5" },
    { 0xfcd6,   "Bluetooth GATT Attribute SWISSINNO SOLUTIONS AG (UUID 0xfcd6)", "BT GATT SWISSINNO SOLUTIONS AG (UUID 0xfcd6)", "btgatt.uuid0xfcd6" },
    { 0xfcd7,   "Bluetooth GATT Attribute PowerPal Pty Ltd (UUID 0xfcd7)", "BT GATT PowerPal Pty Ltd (UUID 0xfcd7)", "btgatt.uuid0xfcd7" },
    { 0xfcd8,   "Bluetooth GATT Attribute Appex Factory S.L. (UUID 0xfcd8)", "BT GATT Appex Factory S.L. (UUID 0xfcd8)", "btgatt.uuid0xfcd8" },
    { 0xfcd9,   "Bluetooth GATT Attribute Huso, INC (UUID 0xfcd9)", "BT GATT Huso, INC (UUID 0xfcd9)", "btgatt.uuid0xfcd9" },
    { 0xfcda,   "Bluetooth GATT Attribute Draeger (UUID 0xfcda)", "BT GATT Draeger (UUID 0xfcda)", "btgatt.uuid0xfcda" },
    { 0xfcdb,   "Bluetooth GATT Attribute aconno GmbH (UUID 0xfcdb)", "BT GATT aconno GmbH (UUID 0xfcdb)", "btgatt.uuid0xfcdb" },
    { 0xfcdc,   "Bluetooth GATT Attribute Amazon.com Services, LLC (UUID 0xfcdc)", "BT GATT Amazon.com Services, LLC (UUID 0xfcdc)", "btgatt.uuid0xfcdc" },
    { 0xfcdd,   "Bluetooth GATT Attribute Mobilaris AB (UUID 0xfcdd)", "BT GATT Mobilaris AB (UUID 0xfcdd)", "btgatt.uuid0xfcdd" },
    { 0xfcde,   "Bluetooth GATT Attribute ARCTOP, INC. (UUID 0xfcde)", "BT GATT ARCTOP, INC. (UUID 0xfcde)", "btgatt.uuid0xfcde" },
    { 0xfcdf,   "Bluetooth GATT Attribute NIO USA, Inc. (UUID 0xfcdf)", "BT GATT NIO USA, Inc. (UUID 0xfcdf)", "btgatt.uuid0xfcdf" },
    { 0xfce0,   "Bluetooth GATT Attribute Akciju sabiedriba \"SAF TEHNIKA\" (UUID 0xfce0)", "BT GATT Akciju sabiedriba \"SAF TEHNIKA\" (UUID 0xfce0)", "btgatt.uuid0xfce0" },
    { 0xfce1,   "Bluetooth GATT Attribute Sony Group Corporation (UUID 0xfce1)", "BT GATT Sony Group Corporation (UUID 0xfce1)", "btgatt.uuid0xfce1" },
    { 0xfce2,   "Bluetooth GATT Attribute Baracoda Daily Healthtech (UUID 0xfce2)", "BT GATT Baracoda Daily Healthtech (UUID 0xfce2)", "btgatt.uuid0xfce2" },
    { 0xfce3,   "Bluetooth GATT Attribute Smith & Nephew Medical Limited (UUID 0xfce3)", "BT GATT Smith & Nephew Medical Limited (UUID 0xfce3)", "btgatt.uuid0xfce3" },
    { 0xfce4,   "Bluetooth GATT Attribute Samsara Networks, Inc (UUID 0xfce4)", "BT GATT Samsara Networks, Inc (UUID 0xfce4)", "btgatt.uuid0xfce4" },
    { 0xfce5,   "Bluetooth GATT Attribute Samsara Networks, Inc (UUID 0xfce5)", "BT GATT Samsara Networks, Inc (UUID 0xfce5)", "btgatt.uuid0xfce5" },
    { 0xfce6,   "Bluetooth GATT Attribute Guard RFID Solutions Inc. (UUID 0xfce6)", "BT GATT Guard RFID Solutions Inc. (UUID 0xfce6)", "btgatt.uuid0xfce6" },
    { 0xfce7,   "Bluetooth GATT Attribute TKH Security B.V. (UUID 0xfce7)", "BT GATT TKH Security B.V. (UUID 0xfce7)", "btgatt.uuid0xfce7" },
    { 0xfce8,   "Bluetooth GATT Attribute ITT Industries (UUID 0xfce8)", "BT GATT ITT Industries (UUID 0xfce8)", "btgatt.uuid0xfce8" },
    { 0xfce9,   "Bluetooth GATT Attribute MindRhythm, Inc. (UUID 0xfce9)", "BT GATT MindRhythm, Inc. (UUID 0xfce9)", "btgatt.uuid0xfce9" },
    { 0xfcea,   "Bluetooth GATT Attribute Chess Wise B.V. (UUID 0xfcea)", "BT GATT Chess Wise B.V. (UUID 0xfcea)", "btgatt.uuid0xfcea" },
    { 0xfceb,   "Bluetooth GATT Attribute Avi-On (UUID 0xfceb)", "BT GATT Avi-On (UUID 0xfceb)", "btgatt.uuid0xfceb" },
    { 0xfcec,   "Bluetooth GATT Attribute Griffwerk GmbH (UUID 0xfcec)", "BT GATT Griffwerk GmbH (UUID 0xfcec)", "btgatt.uuid0xfcec" },
    { 0xfced,   "Bluetooth GATT Attribute Workaround Gmbh (UUID 0xfced)", "BT GATT Workaround Gmbh (UUID 0xfced)", "btgatt.uuid0xfced" },
    { 0xfcee,   "Bluetooth GATT Attribute Velentium, LLC (UUID 0xfcee)", "BT GATT Velentium, LLC (UUID 0xfcee)", "btgatt.uuid0xfcee" },
    { 0xfcef,   "Bluetooth GATT Attribute Divesoft s.r.o. (UUID 0xfcef)", "BT GATT Divesoft s.r.o. (UUID 0xfcef)", "btgatt.uuid0xfcef" },
    { 0xfcf0,   "Bluetooth GATT Attribute Security Enhancement Systems, LLC (UUID 0xfcf0)", "BT GATT Security Enhancement Systems, LLC (UUID 0xfcf0)", "btgatt.uuid0xfcf0" },
    { 0xfcf1,   "Bluetooth GATT Attribute Google LLC (UUID 0xfcf1)", "BT GATT Google LLC (UUID 0xfcf1)", "btgatt.uuid0xfcf1" },
    { 0xfcf2,   "Bluetooth GATT Attribute Bitwards Oy (UUID 0xfcf2)", "BT GATT Bitwards Oy (UUID 0xfcf2)", "btgatt.uuid0xfcf2" },
    { 0xfcf3,   "Bluetooth GATT Attribute Armatura LLC (UUID 0xfcf3)", "BT GATT Armatura LLC (UUID 0xfcf3)", "btgatt.uuid0xfcf3" },
    { 0xfcf4,   "Bluetooth GATT Attribute Allegion (UUID 0xfcf4)", "BT GATT Allegion (UUID 0xfcf4)", "btgatt.uuid0xfcf4" },
    { 0xfcf5,   "Bluetooth GATT Attribute Trident Communication Technology, LLC (UUID 0xfcf5)", "BT GATT Trident Communication Technology, LLC (UUID 0xfcf5)", "btgatt.uuid0xfcf5" },
    { 0xfcf6,   "Bluetooth GATT Attribute The Linux Foundation (UUID 0xfcf6)", "BT GATT The Linux Foundation (UUID 0xfcf6)", "btgatt.uuid0xfcf6" },
    { 0xfcf7,   "Bluetooth GATT Attribute Honor Device Co., Ltd. (UUID 0xfcf7)", "BT GATT Honor Device Co., Ltd. (UUID 0xfcf7)", "btgatt.uuid0xfcf7" },
    { 0xfcf8,   "Bluetooth GATT Attribute Honor Device Co., Ltd. (UUID 0xfcf8)", "BT GATT Honor Device Co., Ltd. (UUID 0xfcf8)", "btgatt.uuid0xfcf8" },
    { 0xfcf9,   "Bluetooth GATT Attribute Leupold & Stevens, Inc. (UUID 0xfcf9)", "BT GATT Leupold & Stevens, Inc. (UUID 0xfcf9)", "btgatt.uuid0xfcf9" },
    { 0xfcfa,   "Bluetooth GATT Attribute Leupold & Stevens, Inc. (UUID 0xfcfa)", "BT GATT Leupold & Stevens, Inc. (UUID 0xfcfa)", "btgatt.uuid0xfcfa" },
    { 0xfcfb,   "Bluetooth GATT Attribute Shenzhen Benwei Media Co., Ltd. (UUID 0xfcfb)", "BT GATT Shenzhen Benwei Media Co., Ltd. (UUID 0xfcfb)", "btgatt.uuid0xfcfb" },
    { 0xfcfc,   "Bluetooth GATT Attribute Barrot Technology Co.,Ltd. (UUID 0xfcfc)", "BT GATT Barrot Technology Co.,Ltd. (UUID 0xfcfc)", "btgatt.uuid0xfcfc" },
    { 0xfcfd,   "Bluetooth GATT Attribute Barrot Technology Co.,Ltd. (UUID 0xfcfd)", "BT GATT Barrot Technology Co.,Ltd. (UUID 0xfcfd)", "btgatt.uuid0xfcfd" },
    { 0xfcfe,   "Bluetooth GATT Attribute Sonova Consumer Hearing GmbH (UUID 0xfcfe)", "BT GATT Sonova Consumer Hearing GmbH (UUID 0xfcfe)", "btgatt.uuid0xfcfe" },
    { 0xfcff,   "Bluetooth GATT Attribute 701x (UUID 0xfcff)", "BT GATT 701x (UUID 0xfcff)", "btgatt.uuid0xfcff" },
    { 0xfd00,   "Bluetooth GATT Attribute FUTEK Advanced Sensor Technology, Inc. (UUID 0xfd00)", "BT GATT FUTEK Advanced Sensor Technology, Inc. (UUID 0xfd00)", "btgatt.uuid0xfd00" },
    { 0xfd01,   "Bluetooth GATT Attribute Sanvita Medical Corporation (UUID 0xfd01)", "BT GATT Sanvita Medical Corporation (UUID 0xfd01)", "btgatt.uuid0xfd01" },
    { 0xfd02,   "Bluetooth GATT Attribute LEGO System A/S (UUID 0xfd02)", "BT GATT LEGO System A/S (UUID 0xfd02)", "btgatt.uuid0xfd02" },
    { 0xfd03,   "Bluetooth GATT Attribute Quuppa Oy (UUID 0xfd03)", "BT GATT Quuppa Oy (UUID 0xfd03)", "btgatt.uuid0xfd03" },
    { 0xfd04,   "Bluetooth GATT Attribute Shure Inc. (UUID 0xfd04)", "BT GATT Shure Inc. (UUID 0xfd04)", "btgatt.uuid0xfd04" },
    { 0xfd05,   "Bluetooth GATT Attribute Qualcomm Technologies, Inc. (UUID 0xfd05)", "BT GATT Qualcomm Technologies, Inc. (UUID 0xfd05)", "btgatt.uuid0xfd05" },
    { 0xfd06,   "Bluetooth GATT Attribute RACE-AI LLC (UUID 0xfd06)", "BT GATT RACE-AI LLC (UUID 0xfd06)", "btgatt.uuid0xfd06" },
    { 0xfd07,   "Bluetooth GATT Attribute Swedlock AB (UUID 0xfd07)", "BT GATT Swedlock AB (UUID 0xfd07)", "btgatt.uuid0xfd07" },
    { 0xfd08,   "Bluetooth GATT Attribute Bull Group Incorporated Company (UUID 0xfd08)", "BT GATT Bull Group Incorporated Company (UUID 0xfd08)", "btgatt.uuid0xfd08" },
    { 0xfd09,   "Bluetooth GATT Attribute Cousins and Sears LLC (UUID 0xfd09)", "BT GATT Cousins and Sears LLC (UUID 0xfd09)", "btgatt.uuid0xfd09" },
    { 0xfd0a,   "Bluetooth GATT Attribute Luminostics, Inc. (UUID 0xfd0a)", "BT GATT Luminostics, Inc. (UUID 0xfd0a)", "btgatt.uuid0xfd0a" },
    { 0xfd0b,   "Bluetooth GATT Attribute Luminostics, Inc. (UUID 0xfd0b)", "BT GATT Luminostics, Inc. (UUID 0xfd0b)", "btgatt.uuid0xfd0b" },
    { 0xfd0c,   "Bluetooth GATT Attribute OSM HK Limited (UUID 0xfd0c)", "BT GATT OSM HK Limited (UUID 0xfd0c)", "btgatt.uuid0xfd0c" },
    { 0xfd0d,   "Bluetooth GATT Attribute Blecon Ltd (UUID 0xfd0d)", "BT GATT Blecon Ltd (UUID 0xfd0d)", "btgatt.uuid0xfd0d" },
    { 0xfd0e,   "Bluetooth GATT Attribute HerdDogg, Inc (UUID 0xfd0e)", "BT GATT HerdDogg, Inc (UUID 0xfd0e)", "btgatt.uuid0xfd0e" },
    { 0xfd0f,   "Bluetooth GATT Attribute AEON MOTOR CO.,LTD. (UUID 0xfd0f)", "BT GATT AEON MOTOR CO.,LTD. (UUID 0xfd0f)", "btgatt.uuid0xfd0f" },
    { 0xfd10,   "Bluetooth GATT Attribute AEON MOTOR CO.,LTD. (UUID 0xfd10)", "BT GATT AEON MOTOR CO.,LTD. (UUID 0xfd10)", "btgatt.uuid0xfd10" },
    { 0xfd11,   "Bluetooth GATT Attribute AEON MOTOR CO.,LTD. (UUID 0xfd11)", "BT GATT AEON MOTOR CO.,LTD. (UUID 0xfd11)", "btgatt.uuid0xfd11" },
    { 0xfd12,   "Bluetooth GATT Attribute AEON MOTOR CO.,LTD. (UUID 0xfd12)", "BT GATT AEON MOTOR CO.,LTD. (UUID 0xfd12)", "btgatt.uuid0xfd12" },
    { 0xfd13,   "Bluetooth GATT Attribute BRG Sports, Inc. (UUID 0xfd13)", "BT GATT BRG Sports, Inc. (UUID 0xfd13)", "btgatt.uuid0xfd13" },
    { 0xfd14,   "Bluetooth GATT Attribute BRG Sports, Inc. (UUID 0xfd14)", "BT GATT BRG Sports, Inc. (UUID 0xfd14)", "btgatt.uuid0xfd14" },
    { 0xfd15,   "Bluetooth GATT Attribute Panasonic Corporation (UUID 0xfd15)", "BT GATT Panasonic Corporation (UUID 0xfd15)", "btgatt.uuid0xfd15" },
    { 0xfd16,   "Bluetooth GATT Attribute Sensitech, Inc. (UUID 0xfd16)", "BT GATT Sensitech, Inc. (UUID 0xfd16)", "btgatt.uuid0xfd16" },
    { 0xfd17,   "Bluetooth GATT Attribute LEGIC Identsystems AG (UUID 0xfd17)", "BT GATT LEGIC Identsystems AG (UUID 0xfd17)", "btgatt.uuid0xfd17" },
    { 0xfd18,   "Bluetooth GATT Attribute LEGIC Identsystems AG (UUID 0xfd18)", "BT GATT LEGIC Identsystems AG (UUID 0xfd18)", "btgatt.uuid0xfd18" },
    { 0xfd19,   "Bluetooth GATT Attribute Smith & Nephew Medical Limited (UUID 0xfd19)", "BT GATT Smith & Nephew Medical Limited (UUID 0xfd19)", "btgatt.uuid0xfd19" },
    { 0xfd1a,   "Bluetooth GATT Attribute CSIRO (UUID 0xfd1a)", "BT GATT CSIRO (UUID 0xfd1a)", "btgatt.uuid0xfd1a" },
    { 0xfd1b,   "Bluetooth GATT Attribute Helios Sports, Inc. (UUID 0xfd1b)", "BT GATT Helios Sports, Inc. (UUID 0xfd1b)", "btgatt.uuid0xfd1b" },
    { 0xfd1c,   "Bluetooth GATT Attribute Brady Worldwide Inc. (UUID 0xfd1c)", "BT GATT Brady Worldwide Inc. (UUID 0xfd1c)", "btgatt.uuid0xfd1c" },
    { 0xfd1d,   "Bluetooth GATT Attribute Samsung Electronics Co., Ltd (UUID 0xfd1d)", "BT GATT Samsung Electronics Co., Ltd (UUID 0xfd1d)", "btgatt.uuid0xfd1d" },
    { 0xfd1e,   "Bluetooth GATT Attribute Plume Design Inc. (UUID 0xfd1e)", "BT GATT Plume Design Inc. (UUID 0xfd1e)", "btgatt.uuid0xfd1e" },
    { 0xfd1f,   "Bluetooth GATT Attribute 3M (UUID 0xfd1f)", "BT GATT 3M (UUID 0xfd1f)", "btgatt.uuid0xfd1f" },
    { 0xfd20,   "Bluetooth GATT Attribute GN Hearing A/S (UUID 0xfd20)", "BT GATT GN Hearing A/S (UUID 0xfd20)", "btgatt.uuid0xfd20" },
    { 0xfd21,   "Bluetooth GATT Attribute Huawei Technologies Co., Ltd. (UUID 0xfd21)", "BT GATT Huawei Technologies Co., Ltd. (UUID 0xfd21)", "btgatt.uuid0xfd21" },
    { 0xfd22,   "Bluetooth GATT Attribute Huawei Technologies Co., Ltd. (UUID 0xfd22)", "BT GATT Huawei Technologies Co., Ltd. (UUID 0xfd22)", "btgatt.uuid0xfd22" },
    { 0xfd23,   "Bluetooth GATT Attribute DOM Sicherheitstechnik GmbH & Co. KG (UUID 0xfd23)", "BT GATT DOM Sicherheitstechnik GmbH & Co. KG (UUID 0xfd23)", "btgatt.uuid0xfd23" },
    { 0xfd24,   "Bluetooth GATT Attribute GD Midea Air-Conditioning Equipment Co., Ltd. (UUID 0xfd24)", "BT GATT GD Midea Air-Conditioning Equipment Co., Ltd. (UUID 0xfd24)", "btgatt.uuid0xfd24" },
    { 0xfd25,   "Bluetooth GATT Attribute GD Midea Air-Conditioning Equipment Co., Ltd. (UUID 0xfd25)", "BT GATT GD Midea Air-Conditioning Equipment Co., Ltd. (UUID 0xfd25)", "btgatt.uuid0xfd25" },
    { 0xfd26,   "Bluetooth GATT Attribute Novo Nordisk A/S (UUID 0xfd26)", "BT GATT Novo Nordisk A/S (UUID 0xfd26)", "btgatt.uuid0xfd26" },
    { 0xfd27,   "Bluetooth GATT Attribute Integrated Illumination Systems, Inc. (UUID 0xfd27)", "BT GATT Integrated Illumination Systems, Inc. (UUID 0xfd27)", "btgatt.uuid0xfd27" },
    { 0xfd28,   "Bluetooth GATT Attribute Julius Blum GmbH (UUID 0xfd28)", "BT GATT Julius Blum GmbH (UUID 0xfd28)", "btgatt.uuid0xfd28" },
    { 0xfd29,   "Bluetooth GATT Attribute Asahi Kasei Corporation (UUID 0xfd29)", "BT GATT Asahi Kasei Corporation (UUID 0xfd29)", "btgatt.uuid0xfd29" },
    { 0xfd2a,   "Bluetooth GATT Attribute Sony Corporation (UUID 0xfd2a)", "BT GATT Sony Corporation (UUID 0xfd2a)", "btgatt.uuid0xfd2a" },
    { 0xfd2b,   "Bluetooth GATT Attribute The Access Technologies (UUID 0xfd2b)", "BT GATT The Access Technologies (UUID 0xfd2b)", "btgatt.uuid0xfd2b" },
    { 0xfd2c,   "Bluetooth GATT Attribute The Access Technologies (UUID 0xfd2c)", "BT GATT The Access Technologies (UUID 0xfd2c)", "btgatt.uuid0xfd2c" },
    { 0xfd2d,   "Bluetooth GATT Attribute Xiaomi Inc. (UUID 0xfd2d)", "BT GATT Xiaomi Inc. (UUID 0xfd2d)", "btgatt.uuid0xfd2d" },
    { 0xfd2e,   "Bluetooth GATT Attribute Bitstrata Systems Inc. (UUID 0xfd2e)", "BT GATT Bitstrata Systems Inc. (UUID 0xfd2e)", "btgatt.uuid0xfd2e" },
    { 0xfd2f,   "Bluetooth GATT Attribute Bitstrata Systems Inc. (UUID 0xfd2f)", "BT GATT Bitstrata Systems Inc. (UUID 0xfd2f)", "btgatt.uuid0xfd2f" },
    { 0xfd30,   "Bluetooth GATT Attribute Sesam Solutions BV (UUID 0xfd30)", "BT GATT Sesam Solutions BV (UUID 0xfd30)", "btgatt.uuid0xfd30" },
    { 0xfd31,   "Bluetooth GATT Attribute LG Electronics Inc. (UUID 0xfd31)", "BT GATT LG Electronics Inc. (UUID 0xfd31)", "btgatt.uuid0xfd31" },
    { 0xfd32,   "Bluetooth GATT Attribute Gemalto Holding BV (UUID 0xfd32)", "BT GATT Gemalto Holding BV (UUID 0xfd32)", "btgatt.uuid0xfd32" },
    { 0xfd33,   "Bluetooth GATT Attribute DashLogic, Inc. (UUID 0xfd33)", "BT GATT DashLogic, Inc. (UUID 0xfd33)", "btgatt.uuid0xfd33" },
    { 0xfd34,   "Bluetooth GATT Attribute Aerosens LLC. (UUID 0xfd34)", "BT GATT Aerosens LLC. (UUID 0xfd34)", "btgatt.uuid0xfd34" },
    { 0xfd35,   "Bluetooth GATT Attribute Transsion Holdings Limited (UUID 0xfd35)", "BT GATT Transsion Holdings Limited (UUID 0xfd35)", "btgatt.uuid0xfd35" },
    { 0xfd36,   "Bluetooth GATT Attribute Google LLC (UUID 0xfd36)", "BT GATT Google LLC (UUID 0xfd36)", "btgatt.uuid0xfd36" },
    { 0xfd37,   "Bluetooth GATT Attribute TireCheck GmbH (UUID 0xfd37)", "BT GATT TireCheck GmbH (UUID 0xfd37)", "btgatt.uuid0xfd37" },
    { 0xfd38,   "Bluetooth GATT Attribute Danfoss A/S (UUID 0xfd38)", "BT GATT Danfoss A/S (UUID 0xfd38)", "btgatt.uuid0xfd38" },
    { 0xfd39,   "Bluetooth GATT Attribute PREDIKTAS (UUID 0xfd39)", "BT GATT PREDIKTAS (UUID 0xfd39)", "btgatt.uuid0xfd39" },
    { 0xfd3a,   "Bluetooth GATT Attribute Verkada Inc. (UUID 0xfd3a)", "BT GATT Verkada Inc. (UUID 0xfd3a)", "btgatt.uuid0xfd3a" },
    { 0xfd3b,   "Bluetooth GATT Attribute Verkada Inc. (UUID 0xfd3b)", "BT GATT Verkada Inc. (UUID 0xfd3b)", "btgatt.uuid0xfd3b" },
    { 0xfd3c,   "Bluetooth GATT Attribute Redline Communications Inc. (UUID 0xfd3c)", "BT GATT Redline Communications Inc. (UUID 0xfd3c)", "btgatt.uuid0xfd3c" },
    { 0xfd3d,   "Bluetooth GATT Attribute Woan Technology (Shenzhen) Co., Ltd. (UUID 0xfd3d)", "BT GATT Woan Technology (Shenzhen) Co., Ltd. (UUID 0xfd3d)", "btgatt.uuid0xfd3d" },
    { 0xfd3e,   "Bluetooth GATT Attribute Pure Watercraft, inc. (UUID 0xfd3e)", "BT GATT Pure Watercraft, inc. (UUID 0xfd3e)", "btgatt.uuid0xfd3e" },
    { 0xfd3f,   "Bluetooth GATT Attribute Cognosos, Inc (UUID 0xfd3f)", "BT GATT Cognosos, Inc (UUID 0xfd3f)", "btgatt.uuid0xfd3f" },
    { 0xfd40,   "Bluetooth GATT Attribute Beflex Inc. (UUID 0xfd40)", "BT GATT Beflex Inc. (UUID 0xfd40)", "btgatt.uuid0xfd40" },
    { 0xfd41,   "Bluetooth GATT Attribute Amazon Lab126 (UUID 0xfd41)", "BT GATT Amazon Lab126 (UUID 0xfd41)", "btgatt.uuid0xfd41" },
    { 0xfd42,   "Bluetooth GATT Attribute Globe (Jiangsu) Co.,Ltd (UUID 0xfd42)", "BT GATT Globe (Jiangsu) Co.,Ltd (UUID 0xfd42)", "btgatt.uuid0xfd42" },
    { 0xfd43,   "Bluetooth GATT Attribute Apple Inc. (UUID 0xfd43)", "BT GATT Apple Inc. (UUID 0xfd43)", "btgatt.uuid0xfd43" },
    { 0xfd44,   "Bluetooth GATT Attribute Apple Inc. (UUID 0xfd44)", "BT GATT Apple Inc. (UUID 0xfd44)", "btgatt.uuid0xfd44" },
    { 0xfd45,   "Bluetooth GATT Attribute GB Solution co.,Ltd (UUID 0xfd45)", "BT GATT GB Solution co.,Ltd (UUID 0xfd45)", "btgatt.uuid0xfd45" },
    { 0xfd46,   "Bluetooth GATT Attribute Lemco IKE (UUID 0xfd46)", "BT GATT Lemco IKE (UUID 0xfd46)", "btgatt.uuid0xfd46" },
    { 0xfd47,   "Bluetooth GATT Attribute Liberty Global Inc. (UUID 0xfd47)", "BT GATT Liberty Global Inc. (UUID 0xfd47)", "btgatt.uuid0xfd47" },
    { 0xfd48,   "Bluetooth GATT Attribute Geberit International AG (UUID 0xfd48)", "BT GATT Geberit International AG (UUID 0xfd48)", "btgatt.uuid0xfd48" },
    { 0xfd49,   "Bluetooth GATT Attribute Panasonic Corporation (UUID 0xfd49)", "BT GATT Panasonic Corporation (UUID 0xfd49)", "btgatt.uuid0xfd49" },
    { 0xfd4a,   "Bluetooth GATT Attribute Sigma Elektro GmbH (UUID 0xfd4a)", "BT GATT Sigma Elektro GmbH (UUID 0xfd4a)", "btgatt.uuid0xfd4a" },
    { 0xfd4b,   "Bluetooth GATT Attribute Samsung Electronics Co., Ltd. (UUID 0xfd4b)", "BT GATT Samsung Electronics Co., Ltd. (UUID 0xfd4b)", "btgatt.uuid0xfd4b" },
    { 0xfd4c,   "Bluetooth GATT Attribute Adolf Wuerth GmbH & Co KG (UUID 0xfd4c)", "BT GATT Adolf Wuerth GmbH & Co KG (UUID 0xfd4c)", "btgatt.uuid0xfd4c" },
    { 0xfd4d,   "Bluetooth GATT Attribute 70mai Co.,Ltd. (UUID 0xfd4d)", "BT GATT 70mai Co.,Ltd. (UUID 0xfd4d)", "btgatt.uuid0xfd4d" },
    { 0xfd4e,   "Bluetooth GATT Attribute 70mai Co.,Ltd. (UUID 0xfd4e)", "BT GATT 70mai Co.,Ltd. (UUID 0xfd4e)", "btgatt.uuid0xfd4e" },
    { 0xfd4f,   "Bluetooth GATT Attribute SONITOR TECHNOLOGIES AS (UUID 0xfd4f)", "BT GATT SONITOR TECHNOLOGIES AS (UUID 0xfd4f)", "btgatt.uuid0xfd4f" },
    { 0xfd50,   "Bluetooth GATT Attribute Hangzhou Tuya Information  Technology Co., Ltd (UUID 0xfd50)", "BT GATT Hangzhou Tuya Information  Technology Co., Ltd (UUID 0xfd50)", "btgatt.uuid0xfd50" },
    { 0xfd51,   "Bluetooth GATT Attribute UTC Fire and Security (UUID 0xfd51)", "BT GATT UTC Fire and Security (UUID 0xfd51)", "btgatt.uuid0xfd51" },
    { 0xfd52,   "Bluetooth GATT Attribute UTC Fire and Security (UUID 0xfd52)", "BT GATT UTC Fire and Security (UUID 0xfd52)", "btgatt.uuid0xfd52" },
    { 0xfd53,   "Bluetooth GATT Attribute PCI Private Limited (UUID 0xfd53)", "BT GATT PCI Private Limited (UUID 0xfd53)", "btgatt.uuid0xfd53" },
    { 0xfd54,   "Bluetooth GATT Attribute Qingdao Haier Technology Co., Ltd. (UUID 0xfd54)", "BT GATT Qingdao Haier Technology Co., Ltd. (UUID 0xfd54)", "btgatt.uuid0xfd54" },
    { 0xfd55,   "Bluetooth GATT Attribute Braveheart Wireless, Inc. (UUID 0xfd55)", "BT GATT Braveheart Wireless, Inc. (UUID 0xfd55)", "btgatt.uuid0xfd55" },
    { 0xfd56,   "Bluetooth GATT Attribute Resmed Ltd (UUID 0xfd56)", "BT GATT Resmed Ltd (UUID 0xfd56)", "btgatt.uuid0xfd56" },
    { 0xfd57,   "Bluetooth GATT Attribute Volvo Car Corporation (UUID 0xfd57)", "BT GATT Volvo Car Corporation (UUID 0xfd57)", "btgatt.uuid0xfd57" },
    { 0xfd58,   "Bluetooth GATT Attribute Volvo Car Corporation (UUID 0xfd58)", "BT GATT Volvo Car Corporation (UUID 0xfd58)", "btgatt.uuid0xfd58" },
    { 0xfd59,   "Bluetooth GATT Attribute Samsung Electronics Co., Ltd. (UUID 0xfd59)", "BT GATT Samsung Electronics Co., Ltd. (UUID 0xfd59)", "btgatt.uuid0xfd59" },
    { 0xfd5a,   "Bluetooth GATT Attribute Samsung Electronics Co., Ltd. (UUID 0xfd5a)", "BT GATT Samsung Electronics Co., Ltd. (UUID 0xfd5a)", "btgatt.uuid0xfd5a" },
    { 0xfd5b,   "Bluetooth GATT Attribute V2SOFT INC. (UUID 0xfd5b)", "BT GATT V2SOFT INC. (UUID 0xfd5b)", "btgatt.uuid0xfd5b" },
    { 0xfd5c,   "Bluetooth GATT Attribute React Mobile (UUID 0xfd5c)", "BT GATT React Mobile (UUID 0xfd5c)", "btgatt.uuid0xfd5c" },
    { 0xfd5d,   "Bluetooth GATT Attribute maxon motor ltd. (UUID 0xfd5d)", "BT GATT maxon motor ltd. (UUID 0xfd5d)", "btgatt.uuid0xfd5d" },
    { 0xfd5e,   "Bluetooth GATT Attribute Tapkey GmbH (UUID 0xfd5e)", "BT GATT Tapkey GmbH (UUID 0xfd5e)", "btgatt.uuid0xfd5e" },
    { 0xfd5f,   "Bluetooth GATT Attribute Meta Platforms Technologies, LLC (UUID 0xfd5f)", "BT GATT Meta Platforms Technologies, LLC (UUID 0xfd5f)", "btgatt.uuid0xfd5f" },
    { 0xfd60,   "Bluetooth GATT Attribute Sercomm Corporation (UUID 0xfd60)", "BT GATT Sercomm Corporation (UUID 0xfd60)", "btgatt.uuid0xfd60" },
    { 0xfd61,   "Bluetooth GATT Attribute Arendi AG (UUID 0xfd61)", "BT GATT Arendi AG (UUID 0xfd61)", "btgatt.uuid0xfd61" },
    { 0xfd62,   "Bluetooth GATT Attribute Google LLC (UUID 0xfd62)", "BT GATT Google LLC (UUID 0xfd62)", "btgatt.uuid0xfd62" },
    { 0xfd63,   "Bluetooth GATT Attribute Google LLC (UUID 0xfd63)", "BT GATT Google LLC (UUID 0xfd63)", "btgatt.uuid0xfd63" },
    { 0xfd64,   "Bluetooth GATT Attribute INRIA (UUID 0xfd64)", "BT GATT INRIA (UUID 0xfd64)", "btgatt.uuid0xfd64" },
    { 0xfd65,   "Bluetooth GATT Attribute Razer Inc. (UUID 0xfd65)", "BT GATT Razer Inc. (UUID 0xfd65)", "btgatt.uuid0xfd65" },
    { 0xfd66,   "Bluetooth GATT Attribute Zebra Technologies Corporation (UUID 0xfd66)", "BT GATT Zebra Technologies Corporation (UUID 0xfd66)", "btgatt.uuid0xfd66" },
    { 0xfd67,   "Bluetooth GATT Attribute Montblanc Simplo GmbH (UUID 0xfd67)", "BT GATT Montblanc Simplo GmbH (UUID 0xfd67)", "btgatt.uuid0xfd67" },
    { 0xfd68,   "Bluetooth GATT Attribute Ubique Innovation AG (UUID 0xfd68)", "BT GATT Ubique Innovation AG (UUID 0xfd68)", "btgatt.uuid0xfd68" },
    { 0xfd69,   "Bluetooth GATT Attribute Samsung Electronics Co., Ltd (UUID 0xfd69)", "BT GATT Samsung Electronics Co., Ltd (UUID 0xfd69)", "btgatt.uuid0xfd69" },
    { 0xfd6a,   "Bluetooth GATT Attribute Emerson (UUID 0xfd6a)", "BT GATT Emerson (UUID 0xfd6a)", "btgatt.uuid0xfd6a" },
    { 0xfd6b,   "Bluetooth GATT Attribute rapitag GmbH (UUID 0xfd6b)", "BT GATT rapitag GmbH (UUID 0xfd6b)", "btgatt.uuid0xfd6b" },
    { 0xfd6c,   "Bluetooth GATT Attribute Samsung Electronics Co., Ltd. (UUID 0xfd6c)", "BT GATT Samsung Electronics Co., Ltd. (UUID 0xfd6c)", "btgatt.uuid0xfd6c" },
    { 0xfd6d,   "Bluetooth GATT Attribute Sigma Elektro GmbH (UUID 0xfd6d)", "BT GATT Sigma Elektro GmbH (UUID 0xfd6d)", "btgatt.uuid0xfd6d" },
    { 0xfd6e,   "Bluetooth GATT Attribute Polidea sp. z o.o. (UUID 0xfd6e)", "BT GATT Polidea sp. z o.o. (UUID 0xfd6e)", "btgatt.uuid0xfd6e" },
    { 0xfd6f,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfd6f)", "BT GATT Apple, Inc. (UUID 0xfd6f)", "btgatt.uuid0xfd6f" },
    { 0xfd70,   "Bluetooth GATT Attribute GuangDong Oppo Mobile Telecommunications Corp., Ltd (UUID 0xfd70)", "BT GATT GuangDong Oppo Mobile Telecommunications Corp., Ltd (UUID 0xfd70)", "btgatt.uuid0xfd70" },
    { 0xfd71,   "Bluetooth GATT Attribute GN Hearing A/S (UUID 0xfd71)", "BT GATT GN Hearing A/S (UUID 0xfd71)", "btgatt.uuid0xfd71" },
    { 0xfd72,   "Bluetooth GATT Attribute Logitech International SA (UUID 0xfd72)", "BT GATT Logitech International SA (UUID 0xfd72)", "btgatt.uuid0xfd72" },
    { 0xfd73,   "Bluetooth GATT Attribute BRControls Products BV (UUID 0xfd73)", "BT GATT BRControls Products BV (UUID 0xfd73)", "btgatt.uuid0xfd73" },
    { 0xfd74,   "Bluetooth GATT Attribute BRControls Products BV (UUID 0xfd74)", "BT GATT BRControls Products BV (UUID 0xfd74)", "btgatt.uuid0xfd74" },
    { 0xfd75,   "Bluetooth GATT Attribute Insulet Corporation (UUID 0xfd75)", "BT GATT Insulet Corporation (UUID 0xfd75)", "btgatt.uuid0xfd75" },
    { 0xfd76,   "Bluetooth GATT Attribute Insulet Corporation (UUID 0xfd76)", "BT GATT Insulet Corporation (UUID 0xfd76)", "btgatt.uuid0xfd76" },
    { 0xfd77,   "Bluetooth GATT Attribute Withings (UUID 0xfd77)", "BT GATT Withings (UUID 0xfd77)", "btgatt.uuid0xfd77" },
    { 0xfd78,   "Bluetooth GATT Attribute Withings (UUID 0xfd78)", "BT GATT Withings (UUID 0xfd78)", "btgatt.uuid0xfd78" },
    { 0xfd79,   "Bluetooth GATT Attribute Withings (UUID 0xfd79)", "BT GATT Withings (UUID 0xfd79)", "btgatt.uuid0xfd79" },
    { 0xfd7a,   "Bluetooth GATT Attribute Withings (UUID 0xfd7a)", "BT GATT Withings (UUID 0xfd7a)", "btgatt.uuid0xfd7a" },
    { 0xfd7b,   "Bluetooth GATT Attribute WYZE LABS, INC. (UUID 0xfd7b)", "BT GATT WYZE LABS, INC. (UUID 0xfd7b)", "btgatt.uuid0xfd7b" },
    { 0xfd7c,   "Bluetooth GATT Attribute Toshiba Information Systems(Japan) Corporation (UUID 0xfd7c)", "BT GATT Toshiba Information Systems(Japan) Corporation (UUID 0xfd7c)", "btgatt.uuid0xfd7c" },
    { 0xfd7d,   "Bluetooth GATT Attribute Center for Advanced Research Wernher Von Braun (UUID 0xfd7d)", "BT GATT Center for Advanced Research Wernher Von Braun (UUID 0xfd7d)", "btgatt.uuid0xfd7d" },
    { 0xfd7e,   "Bluetooth GATT Attribute Samsung Electronics Co., Ltd. (UUID 0xfd7e)", "BT GATT Samsung Electronics Co., Ltd. (UUID 0xfd7e)", "btgatt.uuid0xfd7e" },
    { 0xfd7f,   "Bluetooth GATT Attribute Husqvarna AB (UUID 0xfd7f)", "BT GATT Husqvarna AB (UUID 0xfd7f)", "btgatt.uuid0xfd7f" },
    { 0xfd80,   "Bluetooth GATT Attribute Phindex Technologies, Inc (UUID 0xfd80)", "BT GATT Phindex Technologies, Inc (UUID 0xfd80)", "btgatt.uuid0xfd80" },
    { 0xfd81,   "Bluetooth GATT Attribute CANDY HOUSE, Inc. (UUID 0xfd81)", "BT GATT CANDY HOUSE, Inc. (UUID 0xfd81)", "btgatt.uuid0xfd81" },
    { 0xfd82,   "Bluetooth GATT Attribute Sony Corporation (UUID 0xfd82)", "BT GATT Sony Corporation (UUID 0xfd82)", "btgatt.uuid0xfd82" },
    { 0xfd83,   "Bluetooth GATT Attribute iNFORM Technology GmbH (UUID 0xfd83)", "BT GATT iNFORM Technology GmbH (UUID 0xfd83)", "btgatt.uuid0xfd83" },
    { 0xfd84,   "Bluetooth GATT Attribute Tile, Inc. (UUID 0xfd84)", "BT GATT Tile, Inc. (UUID 0xfd84)", "btgatt.uuid0xfd84" },
    { 0xfd85,   "Bluetooth GATT Attribute Husqvarna AB (UUID 0xfd85)", "BT GATT Husqvarna AB (UUID 0xfd85)", "btgatt.uuid0xfd85" },
    { 0xfd86,   "Bluetooth GATT Attribute Abbott (UUID 0xfd86)", "BT GATT Abbott (UUID 0xfd86)", "btgatt.uuid0xfd86" },
    { 0xfd87,   "Bluetooth GATT Attribute Google LLC (UUID 0xfd87)", "BT GATT Google LLC (UUID 0xfd87)", "btgatt.uuid0xfd87" },
    { 0xfd88,   "Bluetooth GATT Attribute Urbanminded LTD (UUID 0xfd88)", "BT GATT Urbanminded LTD (UUID 0xfd88)", "btgatt.uuid0xfd88" },
    { 0xfd89,   "Bluetooth GATT Attribute Urbanminded LTD (UUID 0xfd89)", "BT GATT Urbanminded LTD (UUID 0xfd89)", "btgatt.uuid0xfd89" },
    { 0xfd8a,   "Bluetooth GATT Attribute Signify Netherlands B.V. (UUID 0xfd8a)", "BT GATT Signify Netherlands B.V. (UUID 0xfd8a)", "btgatt.uuid0xfd8a" },
    { 0xfd8b,   "Bluetooth GATT Attribute Jigowatts Inc. (UUID 0xfd8b)", "BT GATT Jigowatts Inc. (UUID 0xfd8b)", "btgatt.uuid0xfd8b" },
    { 0xfd8c,   "Bluetooth GATT Attribute Google LLC (UUID 0xfd8c)", "BT GATT Google LLC (UUID 0xfd8c)", "btgatt.uuid0xfd8c" },
    { 0xfd8d,   "Bluetooth GATT Attribute quip NYC Inc. (UUID 0xfd8d)", "BT GATT quip NYC Inc. (UUID 0xfd8d)", "btgatt.uuid0xfd8d" },
    { 0xfd8e,   "Bluetooth GATT Attribute Motorola Solutions (UUID 0xfd8e)", "BT GATT Motorola Solutions (UUID 0xfd8e)", "btgatt.uuid0xfd8e" },
    { 0xfd90,   "Bluetooth GATT Attribute Guangzhou SuperSound Information Technology Co.,Ltd (UUID 0xfd90)", "BT GATT Guangzhou SuperSound Information Technology Co.,Ltd (UUID 0xfd90)", "btgatt.uuid0xfd90" },
    { 0xfd91,   "Bluetooth GATT Attribute Groove X, Inc. (UUID 0xfd91)", "BT GATT Groove X, Inc. (UUID 0xfd91)", "btgatt.uuid0xfd91" },
    { 0xfd92,   "Bluetooth GATT Attribute Qualcomm Technologies International, Ltd. (QTIL) (UUID 0xfd92)", "BT GATT Qualcomm Technologies International, Ltd. (QTIL) (UUID 0xfd92)", "btgatt.uuid0xfd92" },
    { 0xfd93,   "Bluetooth GATT Attribute Bayerische Motoren Werke AG (UUID 0xfd93)", "BT GATT Bayerische Motoren Werke AG (UUID 0xfd93)", "btgatt.uuid0xfd93" },
    { 0xfd94,   "Bluetooth GATT Attribute Hewlett Packard Enterprise (UUID 0xfd94)", "BT GATT Hewlett Packard Enterprise (UUID 0xfd94)", "btgatt.uuid0xfd94" },
    { 0xfd95,   "Bluetooth GATT Attribute Rigado (UUID 0xfd95)", "BT GATT Rigado (UUID 0xfd95)", "btgatt.uuid0xfd95" },
    { 0xfd96,   "Bluetooth GATT Attribute Google LLC (UUID 0xfd96)", "BT GATT Google LLC (UUID 0xfd96)", "btgatt.uuid0xfd96" },
    { 0xfd97,   "Bluetooth GATT Attribute June Life, Inc. (UUID 0xfd97)", "BT GATT June Life, Inc. (UUID 0xfd97)", "btgatt.uuid0xfd97" },
    { 0xfd98,   "Bluetooth GATT Attribute Disney Worldwide Services, Inc. (UUID 0xfd98)", "BT GATT Disney Worldwide Services, Inc. (UUID 0xfd98)", "btgatt.uuid0xfd98" },
    { 0xfd99,   "Bluetooth GATT Attribute ABB Oy (UUID 0xfd99)", "BT GATT ABB Oy (UUID 0xfd99)", "btgatt.uuid0xfd99" },
    { 0xfd9a,   "Bluetooth GATT Attribute Huawei Technologies Co., Ltd. (UUID 0xfd9a)", "BT GATT Huawei Technologies Co., Ltd. (UUID 0xfd9a)", "btgatt.uuid0xfd9a" },
    { 0xfd9b,   "Bluetooth GATT Attribute Huawei Technologies Co., Ltd. (UUID 0xfd9b)", "BT GATT Huawei Technologies Co., Ltd. (UUID 0xfd9b)", "btgatt.uuid0xfd9b" },
    { 0xfd9c,   "Bluetooth GATT Attribute Huawei Technologies Co., Ltd. (UUID 0xfd9c)", "BT GATT Huawei Technologies Co., Ltd. (UUID 0xfd9c)", "btgatt.uuid0xfd9c" },
    { 0xfd9d,   "Bluetooth GATT Attribute Gastec Corporation (UUID 0xfd9d)", "BT GATT Gastec Corporation (UUID 0xfd9d)", "btgatt.uuid0xfd9d" },
    { 0xfd9e,   "Bluetooth GATT Attribute The Coca-Cola Company (UUID 0xfd9e)", "BT GATT The Coca-Cola Company (UUID 0xfd9e)", "btgatt.uuid0xfd9e" },
    { 0xfd9f,   "Bluetooth GATT Attribute VitalTech Affiliates LLC (UUID 0xfd9f)", "BT GATT VitalTech Affiliates LLC (UUID 0xfd9f)", "btgatt.uuid0xfd9f" },
    { 0xfda0,   "Bluetooth GATT Attribute Secugen Corporation (UUID 0xfda0)", "BT GATT Secugen Corporation (UUID 0xfda0)", "btgatt.uuid0xfda0" },
    { 0xfda1,   "Bluetooth GATT Attribute Groove X, Inc (UUID 0xfda1)", "BT GATT Groove X, Inc (UUID 0xfda1)", "btgatt.uuid0xfda1" },
    { 0xfda2,   "Bluetooth GATT Attribute Groove X, Inc (UUID 0xfda2)", "BT GATT Groove X, Inc (UUID 0xfda2)", "btgatt.uuid0xfda2" },
    { 0xfda3,   "Bluetooth GATT Attribute Inseego Corp. (UUID 0xfda3)", "BT GATT Inseego Corp. (UUID 0xfda3)", "btgatt.uuid0xfda3" },
    { 0xfda4,   "Bluetooth GATT Attribute Inseego Corp. (UUID 0xfda4)", "BT GATT Inseego Corp. (UUID 0xfda4)", "btgatt.uuid0xfda4" },
    { 0xfda5,   "Bluetooth GATT Attribute Neurostim OAB, Inc. (UUID 0xfda5)", "BT GATT Neurostim OAB, Inc. (UUID 0xfda5)", "btgatt.uuid0xfda5" },
    { 0xfda6,   "Bluetooth GATT Attribute WWZN Information Technology Company Limited (UUID 0xfda6)", "BT GATT WWZN Information Technology Company Limited (UUID 0xfda6)", "btgatt.uuid0xfda6" },
    { 0xfda7,   "Bluetooth GATT Attribute WWZN Information Technology Company Limited (UUID 0xfda7)", "BT GATT WWZN Information Technology Company Limited (UUID 0xfda7)", "btgatt.uuid0xfda7" },
    { 0xfda8,   "Bluetooth GATT Attribute PSA Peugeot Citroën (UUID 0xfda8)", "BT GATT PSA Peugeot Citroën (UUID 0xfda8)", "btgatt.uuid0xfda8" },
    { 0xfda9,   "Bluetooth GATT Attribute Rhombus Systems, Inc. (UUID 0xfda9)", "BT GATT Rhombus Systems, Inc. (UUID 0xfda9)", "btgatt.uuid0xfda9" },
    { 0xfdaa,   "Bluetooth GATT Attribute Xiaomi Inc. (UUID 0xfdaa)", "BT GATT Xiaomi Inc. (UUID 0xfdaa)", "btgatt.uuid0xfdaa" },
    { 0xfdab,   "Bluetooth GATT Attribute Xiaomi Inc. (UUID 0xfdab)", "BT GATT Xiaomi Inc. (UUID 0xfdab)", "btgatt.uuid0xfdab" },
    { 0xfdac,   "Bluetooth GATT Attribute Tentacle Sync GmbH (UUID 0xfdac)", "BT GATT Tentacle Sync GmbH (UUID 0xfdac)", "btgatt.uuid0xfdac" },
    { 0xfdad,   "Bluetooth GATT Attribute Houwa System Design, k.k. (UUID 0xfdad)", "BT GATT Houwa System Design, k.k. (UUID 0xfdad)", "btgatt.uuid0xfdad" },
    { 0xfdae,   "Bluetooth GATT Attribute Houwa System Design, k.k. (UUID 0xfdae)", "BT GATT Houwa System Design, k.k. (UUID 0xfdae)", "btgatt.uuid0xfdae" },
    { 0xfdaf,   "Bluetooth GATT Attribute Wiliot LTD (UUID 0xfdaf)", "BT GATT Wiliot LTD (UUID 0xfdaf)", "btgatt.uuid0xfdaf" },
    { 0xfdb0,   "Bluetooth GATT Attribute Oura Health Ltd (UUID 0xfdb0)", "BT GATT Oura Health Ltd (UUID 0xfdb0)", "btgatt.uuid0xfdb0" },
    { 0xfdb1,   "Bluetooth GATT Attribute Oura Health Ltd (UUID 0xfdb1)", "BT GATT Oura Health Ltd (UUID 0xfdb1)", "btgatt.uuid0xfdb1" },
    { 0xfdb2,   "Bluetooth GATT Attribute Portable Multimedia Ltd (UUID 0xfdb2)", "BT GATT Portable Multimedia Ltd (UUID 0xfdb2)", "btgatt.uuid0xfdb2" },
    { 0xfdb3,   "Bluetooth GATT Attribute Audiodo AB (UUID 0xfdb3)", "BT GATT Audiodo AB (UUID 0xfdb3)", "btgatt.uuid0xfdb3" },
    { 0xfdb4,   "Bluetooth GATT Attribute HP Inc (UUID 0xfdb4)", "BT GATT HP Inc (UUID 0xfdb4)", "btgatt.uuid0xfdb4" },
    { 0xfdb5,   "Bluetooth GATT Attribute ECSG (UUID 0xfdb5)", "BT GATT ECSG (UUID 0xfdb5)", "btgatt.uuid0xfdb5" },
    { 0xfdb6,   "Bluetooth GATT Attribute GWA Hygiene GmbH (UUID 0xfdb6)", "BT GATT GWA Hygiene GmbH (UUID 0xfdb6)", "btgatt.uuid0xfdb6" },
    { 0xfdb7,   "Bluetooth GATT Attribute LivaNova USA Inc. (UUID 0xfdb7)", "BT GATT LivaNova USA Inc. (UUID 0xfdb7)", "btgatt.uuid0xfdb7" },
    { 0xfdb8,   "Bluetooth GATT Attribute LivaNova USA Inc. (UUID 0xfdb8)", "BT GATT LivaNova USA Inc. (UUID 0xfdb8)", "btgatt.uuid0xfdb8" },
    { 0xfdbb,   "Bluetooth GATT Attribute Profoto (UUID 0xfdbb)", "BT GATT Profoto (UUID 0xfdbb)", "btgatt.uuid0xfdbb" },
    { 0xfdbc,   "Bluetooth GATT Attribute Emerson (UUID 0xfdbc)", "BT GATT Emerson (UUID 0xfdbc)", "btgatt.uuid0xfdbc" },
    { 0xfdbd,   "Bluetooth GATT Attribute Clover Network, Inc. (UUID 0xfdbd)", "BT GATT Clover Network, Inc. (UUID 0xfdbd)", "btgatt.uuid0xfdbd" },
    { 0xfdbe,   "Bluetooth GATT Attribute California Things Inc. (UUID 0xfdbe)", "BT GATT California Things Inc. (UUID 0xfdbe)", "btgatt.uuid0xfdbe" },
    { 0xfdbf,   "Bluetooth GATT Attribute California Things Inc. (UUID 0xfdbf)", "BT GATT California Things Inc. (UUID 0xfdbf)", "btgatt.uuid0xfdbf" },
    { 0xfdc0,   "Bluetooth GATT Attribute Hunter Douglas (UUID 0xfdc0)", "BT GATT Hunter Douglas (UUID 0xfdc0)", "btgatt.uuid0xfdc0" },
    { 0xfdc1,   "Bluetooth GATT Attribute Hunter Douglas (UUID 0xfdc1)", "BT GATT Hunter Douglas (UUID 0xfdc1)", "btgatt.uuid0xfdc1" },
    { 0xfdc2,   "Bluetooth GATT Attribute Baidu Online Network Technology (Beijing) Co., Ltd (UUID 0xfdc2)", "BT GATT Baidu Online Network Technology (Beijing) Co., Ltd (UUID 0xfdc2)", "btgatt.uuid0xfdc2" },
    { 0xfdc3,   "Bluetooth GATT Attribute Baidu Online Network Technology (Beijing) Co., Ltd (UUID 0xfdc3)", "BT GATT Baidu Online Network Technology (Beijing) Co., Ltd (UUID 0xfdc3)", "btgatt.uuid0xfdc3" },
    { 0xfdc4,   "Bluetooth GATT Attribute Simavita (Aust) Pty Ltd (UUID 0xfdc4)", "BT GATT Simavita (Aust) Pty Ltd (UUID 0xfdc4)", "btgatt.uuid0xfdc4" },
    { 0xfdc5,   "Bluetooth GATT Attribute Automatic Labs (UUID 0xfdc5)", "BT GATT Automatic Labs (UUID 0xfdc5)", "btgatt.uuid0xfdc5" },
    { 0xfdc6,   "Bluetooth GATT Attribute Eli Lilly and Company (UUID 0xfdc6)", "BT GATT Eli Lilly and Company (UUID 0xfdc6)", "btgatt.uuid0xfdc6" },
    { 0xfdc7,   "Bluetooth GATT Attribute Eli Lilly and Company (UUID 0xfdc7)", "BT GATT Eli Lilly and Company (UUID 0xfdc7)", "btgatt.uuid0xfdc7" },
    { 0xfdc8,   "Bluetooth GATT Attribute Hach – Danaher (UUID 0xfdc8)", "BT GATT Hach – Danaher (UUID 0xfdc8)", "btgatt.uuid0xfdc8" },
    { 0xfdc9,   "Bluetooth GATT Attribute Busch-Jaeger Elektro GmbH (UUID 0xfdc9)", "BT GATT Busch-Jaeger Elektro GmbH (UUID 0xfdc9)", "btgatt.uuid0xfdc9" },
    { 0xfdca,   "Bluetooth GATT Attribute Fortin Electronic Systems (UUID 0xfdca)", "BT GATT Fortin Electronic Systems (UUID 0xfdca)", "btgatt.uuid0xfdca" },
    { 0xfdcb,   "Bluetooth GATT Attribute Meggitt SA (UUID 0xfdcb)", "BT GATT Meggitt SA (UUID 0xfdcb)", "btgatt.uuid0xfdcb" },
    { 0xfdcc,   "Bluetooth GATT Attribute Shoof Technologies (UUID 0xfdcc)", "BT GATT Shoof Technologies (UUID 0xfdcc)", "btgatt.uuid0xfdcc" },
    { 0xfdcd,   "Bluetooth GATT Attribute Qingping Technology (Beijing) Co., Ltd. (UUID 0xfdcd)", "BT GATT Qingping Technology (Beijing) Co., Ltd. (UUID 0xfdcd)", "btgatt.uuid0xfdcd" },
    { 0xfdce,   "Bluetooth GATT Attribute SENNHEISER electronic GmbH & Co. KG (UUID 0xfdce)", "BT GATT SENNHEISER electronic GmbH & Co. KG (UUID 0xfdce)", "btgatt.uuid0xfdce" },
    { 0xfdcf,   "Bluetooth GATT Attribute Nalu Medical, Inc (UUID 0xfdcf)", "BT GATT Nalu Medical, Inc (UUID 0xfdcf)", "btgatt.uuid0xfdcf" },
    { 0xfdd0,   "Bluetooth GATT Attribute Huawei Technologies Co., Ltd (UUID 0xfdd0)", "BT GATT Huawei Technologies Co., Ltd (UUID 0xfdd0)", "btgatt.uuid0xfdd0" },
    { 0xfdd1,   "Bluetooth GATT Attribute Huawei Technologies Co., Ltd (UUID 0xfdd1)", "BT GATT Huawei Technologies Co., Ltd (UUID 0xfdd1)", "btgatt.uuid0xfdd1" },
    { 0xfdd2,   "Bluetooth GATT Attribute Bose Corporation (UUID 0xfdd2)", "BT GATT Bose Corporation (UUID 0xfdd2)", "btgatt.uuid0xfdd2" },
    { 0xfdd3,   "Bluetooth GATT Attribute FUBA Automotive Electronics GmbH (UUID 0xfdd3)", "BT GATT FUBA Automotive Electronics GmbH (UUID 0xfdd3)", "btgatt.uuid0xfdd3" },
    { 0xfdd4,   "Bluetooth GATT Attribute LX Solutions Pty Limited (UUID 0xfdd4)", "BT GATT LX Solutions Pty Limited (UUID 0xfdd4)", "btgatt.uuid0xfdd4" },
    { 0xfdd5,   "Bluetooth GATT Attribute Brompton Bicycle Ltd (UUID 0xfdd5)", "BT GATT Brompton Bicycle Ltd (UUID 0xfdd5)", "btgatt.uuid0xfdd5" },
    { 0xfdd6,   "Bluetooth GATT Attribute Ministry of Supply (UUID 0xfdd6)", "BT GATT Ministry of Supply (UUID 0xfdd6)", "btgatt.uuid0xfdd6" },
    { 0xfdd7,   "Bluetooth GATT Attribute Copeland Cold Chain LP (UUID 0xfdd7)", "BT GATT Copeland Cold Chain LP (UUID 0xfdd7)", "btgatt.uuid0xfdd7" },
    { 0xfdd8,   "Bluetooth GATT Attribute Jiangsu Teranovo Tech Co., Ltd. (UUID 0xfdd8)", "BT GATT Jiangsu Teranovo Tech Co., Ltd. (UUID 0xfdd8)", "btgatt.uuid0xfdd8" },
    { 0xfdd9,   "Bluetooth GATT Attribute Jiangsu Teranovo Tech Co., Ltd. (UUID 0xfdd9)", "BT GATT Jiangsu Teranovo Tech Co., Ltd. (UUID 0xfdd9)", "btgatt.uuid0xfdd9" },
    { 0xfdda,   "Bluetooth GATT Attribute MHCS (UUID 0xfdda)", "BT GATT MHCS (UUID 0xfdda)", "btgatt.uuid0xfdda" },
    { 0xfddb,   "Bluetooth GATT Attribute Samsung Electronics Co., Ltd. (UUID 0xfddb)", "BT GATT Samsung Electronics Co., Ltd. (UUID 0xfddb)", "btgatt.uuid0xfddb" },
    { 0xfddc,   "Bluetooth GATT Attribute 4iiii Innovations Inc. (UUID 0xfddc)", "BT GATT 4iiii Innovations Inc. (UUID 0xfddc)", "btgatt.uuid0xfddc" },
    { 0xfddd,   "Bluetooth GATT Attribute Arch Systems Inc (UUID 0xfddd)", "BT GATT Arch Systems Inc (UUID 0xfddd)", "btgatt.uuid0xfddd" },
    { 0xfdde,   "Bluetooth GATT Attribute Noodle Technology Inc. (UUID 0xfdde)", "BT GATT Noodle Technology Inc. (UUID 0xfdde)", "btgatt.uuid0xfdde" },
    { 0xfddf,   "Bluetooth GATT Attribute Harman International (UUID 0xfddf)", "BT GATT Harman International (UUID 0xfddf)", "btgatt.uuid0xfddf" },
    { 0xfde0,   "Bluetooth GATT Attribute John Deere (UUID 0xfde0)", "BT GATT John Deere (UUID 0xfde0)", "btgatt.uuid0xfde0" },
    { 0xfde1,   "Bluetooth GATT Attribute Fortin Electronic Systems (UUID 0xfde1)", "BT GATT Fortin Electronic Systems (UUID 0xfde1)", "btgatt.uuid0xfde1" },
    { 0xfde2,   "Bluetooth GATT Attribute Google LLC (UUID 0xfde2)", "BT GATT Google LLC (UUID 0xfde2)", "btgatt.uuid0xfde2" },
    { 0xfde3,   "Bluetooth GATT Attribute Abbott Diabetes Care (UUID 0xfde3)", "BT GATT Abbott Diabetes Care (UUID 0xfde3)", "btgatt.uuid0xfde3" },
    { 0xfde4,   "Bluetooth GATT Attribute JUUL Labs, Inc. (UUID 0xfde4)", "BT GATT JUUL Labs, Inc. (UUID 0xfde4)", "btgatt.uuid0xfde4" },
    { 0xfde5,   "Bluetooth GATT Attribute SMK Corporation (UUID 0xfde5)", "BT GATT SMK Corporation (UUID 0xfde5)", "btgatt.uuid0xfde5" },
    { 0xfde6,   "Bluetooth GATT Attribute Intelletto Technologies Inc (UUID 0xfde6)", "BT GATT Intelletto Technologies Inc (UUID 0xfde6)", "btgatt.uuid0xfde6" },
    { 0xfde7,   "Bluetooth GATT Attribute SECOM Co., LTD (UUID 0xfde7)", "BT GATT SECOM Co., LTD (UUID 0xfde7)", "btgatt.uuid0xfde7" },
    { 0xfde8,   "Bluetooth GATT Attribute Robert Bosch GmbH (UUID 0xfde8)", "BT GATT Robert Bosch GmbH (UUID 0xfde8)", "btgatt.uuid0xfde8" },
    { 0xfde9,   "Bluetooth GATT Attribute Spacesaver Corporation (UUID 0xfde9)", "BT GATT Spacesaver Corporation (UUID 0xfde9)", "btgatt.uuid0xfde9" },
    { 0xfdea,   "Bluetooth GATT Attribute SeeScan, Inc (UUID 0xfdea)", "BT GATT SeeScan, Inc (UUID 0xfdea)", "btgatt.uuid0xfdea" },
    { 0xfdeb,   "Bluetooth GATT Attribute Syntronix Corporation (UUID 0xfdeb)", "BT GATT Syntronix Corporation (UUID 0xfdeb)", "btgatt.uuid0xfdeb" },
    { 0xfdec,   "Bluetooth GATT Attribute Mannkind Corporation (UUID 0xfdec)", "BT GATT Mannkind Corporation (UUID 0xfdec)", "btgatt.uuid0xfdec" },
    { 0xfded,   "Bluetooth GATT Attribute Pole Star (UUID 0xfded)", "BT GATT Pole Star (UUID 0xfded)", "btgatt.uuid0xfded" },
    { 0xfdee,   "Bluetooth GATT Attribute Huawei Technologies Co., Ltd. (UUID 0xfdee)", "BT GATT Huawei Technologies Co., Ltd. (UUID 0xfdee)", "btgatt.uuid0xfdee" },
    { 0xfdef,   "Bluetooth GATT Attribute ART AND PROGRAM, INC. (UUID 0xfdef)", "BT GATT ART AND PROGRAM, INC. (UUID 0xfdef)", "btgatt.uuid0xfdef" },
    { 0xfdf0,   "Bluetooth GATT Attribute Google LLC (UUID 0xfdf0)", "BT GATT Google LLC (UUID 0xfdf0)", "btgatt.uuid0xfdf0" },
    { 0xfdf1,   "Bluetooth GATT Attribute LAMPLIGHT Co.,Ltd (UUID 0xfdf1)", "BT GATT LAMPLIGHT Co.,Ltd (UUID 0xfdf1)", "btgatt.uuid0xfdf1" },
    { 0xfdf2,   "Bluetooth GATT Attribute AMICCOM Electronics Corporation (UUID 0xfdf2)", "BT GATT AMICCOM Electronics Corporation (UUID 0xfdf2)", "btgatt.uuid0xfdf2" },
    { 0xfdf3,   "Bluetooth GATT Attribute Amersports (UUID 0xfdf3)", "BT GATT Amersports (UUID 0xfdf3)", "btgatt.uuid0xfdf3" },
    { 0xfdf4,   "Bluetooth GATT Attribute O. E. M. Controls, Inc. (UUID 0xfdf4)", "BT GATT O. E. M. Controls, Inc. (UUID 0xfdf4)", "btgatt.uuid0xfdf4" },
    { 0xfdf5,   "Bluetooth GATT Attribute Milwaukee Electric Tools (UUID 0xfdf5)", "BT GATT Milwaukee Electric Tools (UUID 0xfdf5)", "btgatt.uuid0xfdf5" },
    { 0xfdf6,   "Bluetooth GATT Attribute AIAIAI ApS (UUID 0xfdf6)", "BT GATT AIAIAI ApS (UUID 0xfdf6)", "btgatt.uuid0xfdf6" },
    { 0xfdf7,   "Bluetooth GATT Attribute HP Inc. (UUID 0xfdf7)", "BT GATT HP Inc. (UUID 0xfdf7)", "btgatt.uuid0xfdf7" },
    { 0xfdf8,   "Bluetooth GATT Attribute Onvocal (UUID 0xfdf8)", "BT GATT Onvocal (UUID 0xfdf8)", "btgatt.uuid0xfdf8" },
    { 0xfdf9,   "Bluetooth GATT Attribute INIA (UUID 0xfdf9)", "BT GATT INIA (UUID 0xfdf9)", "btgatt.uuid0xfdf9" },
    { 0xfdfa,   "Bluetooth GATT Attribute Tandem Diabetes Care (UUID 0xfdfa)", "BT GATT Tandem Diabetes Care (UUID 0xfdfa)", "btgatt.uuid0xfdfa" },
    { 0xfdfb,   "Bluetooth GATT Attribute Tandem Diabetes Care (UUID 0xfdfb)", "BT GATT Tandem Diabetes Care (UUID 0xfdfb)", "btgatt.uuid0xfdfb" },
    { 0xfdfc,   "Bluetooth GATT Attribute Optrel AG (UUID 0xfdfc)", "BT GATT Optrel AG (UUID 0xfdfc)", "btgatt.uuid0xfdfc" },
    { 0xfdfd,   "Bluetooth GATT Attribute RecursiveSoft Inc. (UUID 0xfdfd)", "BT GATT RecursiveSoft Inc. (UUID 0xfdfd)", "btgatt.uuid0xfdfd" },
    { 0xfdfe,   "Bluetooth GATT Attribute ADHERIUM(NZ) LIMITED (UUID 0xfdfe)", "BT GATT ADHERIUM(NZ) LIMITED (UUID 0xfdfe)", "btgatt.uuid0xfdfe" },
    { 0xfdff,   "Bluetooth GATT Attribute OSRAM GmbH (UUID 0xfdff)", "BT GATT OSRAM GmbH (UUID 0xfdff)", "btgatt.uuid0xfdff" },
    { 0xfe00,   "Bluetooth GATT Attribute Amazon.com Services, Inc. (UUID 0xfe00)", "BT GATT Amazon.com Services, Inc. (UUID 0xfe00)", "btgatt.uuid0xfe00" },
    { 0xfe01,   "Bluetooth GATT Attribute Duracell U.S. Operations Inc. (UUID 0xfe01)", "BT GATT Duracell U.S. Operations Inc. (UUID 0xfe01)", "btgatt.uuid0xfe01" },
    { 0xfe02,   "Bluetooth GATT Attribute Robert Bosch GmbH (UUID 0xfe02)", "BT GATT Robert Bosch GmbH (UUID 0xfe02)", "btgatt.uuid0xfe02" },
    { 0xfe03,   "Bluetooth GATT Attribute Amazon.com Services, Inc. (UUID 0xfe03)", "BT GATT Amazon.com Services, Inc. (UUID 0xfe03)", "btgatt.uuid0xfe03" },
    { 0xfe04,   "Bluetooth GATT Attribute Motorola Solutions, Inc. (UUID 0xfe04)", "BT GATT Motorola Solutions, Inc. (UUID 0xfe04)", "btgatt.uuid0xfe04" },
    { 0xfe05,   "Bluetooth GATT Attribute CORE Transport Technologies NZ Limited (UUID 0xfe05)", "BT GATT CORE Transport Technologies NZ Limited (UUID 0xfe05)", "btgatt.uuid0xfe05" },
    { 0xfe06,   "Bluetooth GATT Attribute Qualcomm Technologies, Inc. (UUID 0xfe06)", "BT GATT Qualcomm Technologies, Inc. (UUID 0xfe06)", "btgatt.uuid0xfe06" },
    { 0xfe07,   "Bluetooth GATT Attribute Sonos, Inc. (UUID 0xfe07)", "BT GATT Sonos, Inc. (UUID 0xfe07)", "btgatt.uuid0xfe07" },
    { 0xfe08,   "Bluetooth GATT Attribute Microsoft (UUID 0xfe08)", "BT GATT Microsoft (UUID 0xfe08)", "btgatt.uuid0xfe08" },
    { 0xfe09,   "Bluetooth GATT Attribute Pillsy, Inc. (UUID 0xfe09)", "BT GATT Pillsy, Inc. (UUID 0xfe09)", "btgatt.uuid0xfe09" },
    { 0xfe0a,   "Bluetooth GATT Attribute ruwido austria gmbh (UUID 0xfe0a)", "BT GATT ruwido austria gmbh (UUID 0xfe0a)", "btgatt.uuid0xfe0a" },
    { 0xfe0b,   "Bluetooth GATT Attribute ruwido austria gmbh (UUID 0xfe0b)", "BT GATT ruwido austria gmbh (UUID 0xfe0b)", "btgatt.uuid0xfe0b" },
    { 0xfe0c,   "Bluetooth GATT Attribute Procter & Gamble (UUID 0xfe0c)", "BT GATT Procter & Gamble (UUID 0xfe0c)", "btgatt.uuid0xfe0c" },
    { 0xfe0d,   "Bluetooth GATT Attribute Procter & Gamble (UUID 0xfe0d)", "BT GATT Procter & Gamble (UUID 0xfe0d)", "btgatt.uuid0xfe0d" },
    { 0xfe0e,   "Bluetooth GATT Attribute Setec Pty Ltd (UUID 0xfe0e)", "BT GATT Setec Pty Ltd (UUID 0xfe0e)", "btgatt.uuid0xfe0e" },
    { 0xfe0f,   "Bluetooth GATT Attribute Signify Netherlands B.V. (formerly Philips Lighting B.V.) (UUID 0xfe0f)", "BT GATT Signify Netherlands B.V. (formerly Philips Lighting B.V.) (UUID 0xfe0f)", "btgatt.uuid0xfe0f" },
    { 0xfe10,   "Bluetooth GATT Attribute LAPIS Technology Co., Ltd. (UUID 0xfe10)", "BT GATT LAPIS Technology Co., Ltd. (UUID 0xfe10)", "btgatt.uuid0xfe10" },
    { 0xfe11,   "Bluetooth GATT Attribute GMC-I Messtechnik GmbH (UUID 0xfe11)", "BT GATT GMC-I Messtechnik GmbH (UUID 0xfe11)", "btgatt.uuid0xfe11" },
    { 0xfe12,   "Bluetooth GATT Attribute M-Way Solutions GmbH (UUID 0xfe12)", "BT GATT M-Way Solutions GmbH (UUID 0xfe12)", "btgatt.uuid0xfe12" },
    { 0xfe13,   "Bluetooth GATT Attribute Apple Inc. (UUID 0xfe13)", "BT GATT Apple Inc. (UUID 0xfe13)", "btgatt.uuid0xfe13" },
    { 0xfe14,   "Bluetooth GATT Attribute Flextronics International USA Inc. (UUID 0xfe14)", "BT GATT Flextronics International USA Inc. (UUID 0xfe14)", "btgatt.uuid0xfe14" },
    { 0xfe15,   "Bluetooth GATT Attribute Amazon.com Services, Inc.. (UUID 0xfe15)", "BT GATT Amazon.com Services, Inc.. (UUID 0xfe15)", "btgatt.uuid0xfe15" },
    { 0xfe16,   "Bluetooth GATT Attribute Footmarks, Inc. (UUID 0xfe16)", "BT GATT Footmarks, Inc. (UUID 0xfe16)", "btgatt.uuid0xfe16" },
    { 0xfe17,   "Bluetooth GATT Attribute Telit Wireless Solutions GmbH (UUID 0xfe17)", "BT GATT Telit Wireless Solutions GmbH (UUID 0xfe17)", "btgatt.uuid0xfe17" },
    { 0xfe18,   "Bluetooth GATT Attribute Runtime, Inc. (UUID 0xfe18)", "BT GATT Runtime, Inc. (UUID 0xfe18)", "btgatt.uuid0xfe18" },
    { 0xfe19,   "Bluetooth GATT Attribute Google LLC (UUID 0xfe19)", "BT GATT Google LLC (UUID 0xfe19)", "btgatt.uuid0xfe19" },
    { 0xfe1a,   "Bluetooth GATT Attribute Tyto Life LLC (UUID 0xfe1a)", "BT GATT Tyto Life LLC (UUID 0xfe1a)", "btgatt.uuid0xfe1a" },
    { 0xfe1b,   "Bluetooth GATT Attribute Tyto Life LLC (UUID 0xfe1b)", "BT GATT Tyto Life LLC (UUID 0xfe1b)", "btgatt.uuid0xfe1b" },
    { 0xfe1c,   "Bluetooth GATT Attribute NetMedia, Inc. (UUID 0xfe1c)", "BT GATT NetMedia, Inc. (UUID 0xfe1c)", "btgatt.uuid0xfe1c" },
    { 0xfe1d,   "Bluetooth GATT Attribute Illuminati Instrument Corporation (UUID 0xfe1d)", "BT GATT Illuminati Instrument Corporation (UUID 0xfe1d)", "btgatt.uuid0xfe1d" },
    { 0xfe1e,   "Bluetooth GATT Attribute LAMPLIGHT Co., Ltd. (UUID 0xfe1e)", "BT GATT LAMPLIGHT Co., Ltd. (UUID 0xfe1e)", "btgatt.uuid0xfe1e" },
    { 0xfe1f,   "Bluetooth GATT Attribute Garmin International, Inc. (UUID 0xfe1f)", "BT GATT Garmin International, Inc. (UUID 0xfe1f)", "btgatt.uuid0xfe1f" },
    { 0xfe20,   "Bluetooth GATT Attribute Emerson (UUID 0xfe20)", "BT GATT Emerson (UUID 0xfe20)", "btgatt.uuid0xfe20" },
    { 0xfe21,   "Bluetooth GATT Attribute Bose Corporation (UUID 0xfe21)", "BT GATT Bose Corporation (UUID 0xfe21)", "btgatt.uuid0xfe21" },
    { 0xfe22,   "Bluetooth GATT Attribute Zoll Medical Corporation (UUID 0xfe22)", "BT GATT Zoll Medical Corporation (UUID 0xfe22)", "btgatt.uuid0xfe22" },
    { 0xfe23,   "Bluetooth GATT Attribute Zoll Medical Corporation (UUID 0xfe23)", "BT GATT Zoll Medical Corporation (UUID 0xfe23)", "btgatt.uuid0xfe23" },
    { 0xfe24,   "Bluetooth GATT Attribute August Home Inc (UUID 0xfe24)", "BT GATT August Home Inc (UUID 0xfe24)", "btgatt.uuid0xfe24" },
    { 0xfe25,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfe25)", "BT GATT Apple, Inc. (UUID 0xfe25)", "btgatt.uuid0xfe25" },
    { 0xfe26,   "Bluetooth GATT Attribute Google LLC (UUID 0xfe26)", "BT GATT Google LLC (UUID 0xfe26)", "btgatt.uuid0xfe26" },
    { 0xfe27,   "Bluetooth GATT Attribute Google LLC (UUID 0xfe27)", "BT GATT Google LLC (UUID 0xfe27)", "btgatt.uuid0xfe27" },
    { 0xfe28,   "Bluetooth GATT Attribute Ayla Networks (UUID 0xfe28)", "BT GATT Ayla Networks (UUID 0xfe28)", "btgatt.uuid0xfe28" },
    { 0xfe29,   "Bluetooth GATT Attribute Gibson Innovations (UUID 0xfe29)", "BT GATT Gibson Innovations (UUID 0xfe29)", "btgatt.uuid0xfe29" },
    { 0xfe2a,   "Bluetooth GATT Attribute DaisyWorks, Inc. (UUID 0xfe2a)", "BT GATT DaisyWorks, Inc. (UUID 0xfe2a)", "btgatt.uuid0xfe2a" },
    { 0xfe2b,   "Bluetooth GATT Attribute ITT Industries (UUID 0xfe2b)", "BT GATT ITT Industries (UUID 0xfe2b)", "btgatt.uuid0xfe2b" },
    { 0xfe2c,   "Bluetooth GATT Attribute Google LLC (UUID 0xfe2c)", "BT GATT Google LLC (UUID 0xfe2c)", "btgatt.uuid0xfe2c" },
    { 0xfe2d,   "Bluetooth GATT Attribute LAMPLIGHT Co., Ltd. (UUID 0xfe2d)", "BT GATT LAMPLIGHT Co., Ltd. (UUID 0xfe2d)", "btgatt.uuid0xfe2d" },
    { 0xfe2e,   "Bluetooth GATT Attribute ERi,Inc. (UUID 0xfe2e)", "BT GATT ERi,Inc. (UUID 0xfe2e)", "btgatt.uuid0xfe2e" },
    { 0xfe2f,   "Bluetooth GATT Attribute CRESCO Wireless, Inc (UUID 0xfe2f)", "BT GATT CRESCO Wireless, Inc (UUID 0xfe2f)", "btgatt.uuid0xfe2f" },
    { 0xfe30,   "Bluetooth GATT Attribute Volkswagen AG (UUID 0xfe30)", "BT GATT Volkswagen AG (UUID 0xfe30)", "btgatt.uuid0xfe30" },
    { 0xfe31,   "Bluetooth GATT Attribute Volkswagen AG (UUID 0xfe31)", "BT GATT Volkswagen AG (UUID 0xfe31)", "btgatt.uuid0xfe31" },
    { 0xfe32,   "Bluetooth GATT Attribute Pro-Mark, Inc. (UUID 0xfe32)", "BT GATT Pro-Mark, Inc. (UUID 0xfe32)", "btgatt.uuid0xfe32" },
    { 0xfe33,   "Bluetooth GATT Attribute CHIPOLO d.o.o. (UUID 0xfe33)", "BT GATT CHIPOLO d.o.o. (UUID 0xfe33)", "btgatt.uuid0xfe33" },
    { 0xfe34,   "Bluetooth GATT Attribute SmallLoop LLC (UUID 0xfe34)", "BT GATT SmallLoop LLC (UUID 0xfe34)", "btgatt.uuid0xfe34" },
    { 0xfe35,   "Bluetooth GATT Attribute HUAWEI Technologies Co., Ltd (UUID 0xfe35)", "BT GATT HUAWEI Technologies Co., Ltd (UUID 0xfe35)", "btgatt.uuid0xfe35" },
    { 0xfe36,   "Bluetooth GATT Attribute HUAWEI Technologies Co., Ltd (UUID 0xfe36)", "BT GATT HUAWEI Technologies Co., Ltd (UUID 0xfe36)", "btgatt.uuid0xfe36" },
    { 0xfe39,   "Bluetooth GATT Attribute TTS Tooltechnic Systems AG & Co. KG (UUID 0xfe39)", "BT GATT TTS Tooltechnic Systems AG & Co. KG (UUID 0xfe39)", "btgatt.uuid0xfe39" },
    { 0xfe3a,   "Bluetooth GATT Attribute TTS Tooltechnic Systems AG & Co. KG (UUID 0xfe3a)", "BT GATT TTS Tooltechnic Systems AG & Co. KG (UUID 0xfe3a)", "btgatt.uuid0xfe3a" },
    { 0xfe3b,   "Bluetooth GATT Attribute Dolby Laboratories (UUID 0xfe3b)", "BT GATT Dolby Laboratories (UUID 0xfe3b)", "btgatt.uuid0xfe3b" },
    { 0xfe3c,   "Bluetooth GATT Attribute alibaba (UUID 0xfe3c)", "BT GATT alibaba (UUID 0xfe3c)", "btgatt.uuid0xfe3c" },
    { 0xfe3d,   "Bluetooth GATT Attribute BD Medical (UUID 0xfe3d)", "BT GATT BD Medical (UUID 0xfe3d)", "btgatt.uuid0xfe3d" },
    { 0xfe3e,   "Bluetooth GATT Attribute BD Medical (UUID 0xfe3e)", "BT GATT BD Medical (UUID 0xfe3e)", "btgatt.uuid0xfe3e" },
    { 0xfe3f,   "Bluetooth GATT Attribute Friday Labs Limited (UUID 0xfe3f)", "BT GATT Friday Labs Limited (UUID 0xfe3f)", "btgatt.uuid0xfe3f" },
    { 0xfe40,   "Bluetooth GATT Attribute Inugo Systems Limited (UUID 0xfe40)", "BT GATT Inugo Systems Limited (UUID 0xfe40)", "btgatt.uuid0xfe40" },
    { 0xfe41,   "Bluetooth GATT Attribute Inugo Systems Limited (UUID 0xfe41)", "BT GATT Inugo Systems Limited (UUID 0xfe41)", "btgatt.uuid0xfe41" },
    { 0xfe42,   "Bluetooth GATT Attribute Nets A/S (UUID 0xfe42)", "BT GATT Nets A/S (UUID 0xfe42)", "btgatt.uuid0xfe42" },
    { 0xfe43,   "Bluetooth GATT Attribute Andreas Stihl AG & Co. KG (UUID 0xfe43)", "BT GATT Andreas Stihl AG & Co. KG (UUID 0xfe43)", "btgatt.uuid0xfe43" },
    { 0xfe44,   "Bluetooth GATT Attribute SK Telecom (UUID 0xfe44)", "BT GATT SK Telecom (UUID 0xfe44)", "btgatt.uuid0xfe44" },
    { 0xfe45,   "Bluetooth GATT Attribute Snapchat Inc (UUID 0xfe45)", "BT GATT Snapchat Inc (UUID 0xfe45)", "btgatt.uuid0xfe45" },
    { 0xfe46,   "Bluetooth GATT Attribute B&O Play A/S (UUID 0xfe46)", "BT GATT B&O Play A/S (UUID 0xfe46)", "btgatt.uuid0xfe46" },
    { 0xfe47,   "Bluetooth GATT Attribute General Motors (UUID 0xfe47)", "BT GATT General Motors (UUID 0xfe47)", "btgatt.uuid0xfe47" },
    { 0xfe48,   "Bluetooth GATT Attribute General Motors (UUID 0xfe48)", "BT GATT General Motors (UUID 0xfe48)", "btgatt.uuid0xfe48" },
    { 0xfe49,   "Bluetooth GATT Attribute SenionLab AB (UUID 0xfe49)", "BT GATT SenionLab AB (UUID 0xfe49)", "btgatt.uuid0xfe49" },
    { 0xfe4a,   "Bluetooth GATT Attribute OMRON HEALTHCARE Co., Ltd. (UUID 0xfe4a)", "BT GATT OMRON HEALTHCARE Co., Ltd. (UUID 0xfe4a)", "btgatt.uuid0xfe4a" },
    { 0xfe4b,   "Bluetooth GATT Attribute Signify Netherlands B.V. (formerly Philips Lighting B.V.) (UUID 0xfe4b)", "BT GATT Signify Netherlands B.V. (formerly Philips Lighting B.V.) (UUID 0xfe4b)", "btgatt.uuid0xfe4b" },
    { 0xfe4c,   "Bluetooth GATT Attribute Volkswagen AG (UUID 0xfe4c)", "BT GATT Volkswagen AG (UUID 0xfe4c)", "btgatt.uuid0xfe4c" },
    { 0xfe4d,   "Bluetooth GATT Attribute Casambi Technologies Oy (UUID 0xfe4d)", "BT GATT Casambi Technologies Oy (UUID 0xfe4d)", "btgatt.uuid0xfe4d" },
    { 0xfe4e,   "Bluetooth GATT Attribute NTT docomo (UUID 0xfe4e)", "BT GATT NTT docomo (UUID 0xfe4e)", "btgatt.uuid0xfe4e" },
    { 0xfe4f,   "Bluetooth GATT Attribute Molekule, Inc. (UUID 0xfe4f)", "BT GATT Molekule, Inc. (UUID 0xfe4f)", "btgatt.uuid0xfe4f" },
    { 0xfe50,   "Bluetooth GATT Attribute Google LLC (UUID 0xfe50)", "BT GATT Google LLC (UUID 0xfe50)", "btgatt.uuid0xfe50" },
    { 0xfe51,   "Bluetooth GATT Attribute SRAM (UUID 0xfe51)", "BT GATT SRAM (UUID 0xfe51)", "btgatt.uuid0xfe51" },
    { 0xfe52,   "Bluetooth GATT Attribute SetPoint Medical (UUID 0xfe52)", "BT GATT SetPoint Medical (UUID 0xfe52)", "btgatt.uuid0xfe52" },
    { 0xfe53,   "Bluetooth GATT Attribute 3M (UUID 0xfe53)", "BT GATT 3M (UUID 0xfe53)", "btgatt.uuid0xfe53" },
    { 0xfe54,   "Bluetooth GATT Attribute Motiv, Inc. (UUID 0xfe54)", "BT GATT Motiv, Inc. (UUID 0xfe54)", "btgatt.uuid0xfe54" },
    { 0xfe55,   "Bluetooth GATT Attribute Google LLC (UUID 0xfe55)", "BT GATT Google LLC (UUID 0xfe55)", "btgatt.uuid0xfe55" },
    { 0xfe56,   "Bluetooth GATT Attribute Google LLC (UUID 0xfe56)", "BT GATT Google LLC (UUID 0xfe56)", "btgatt.uuid0xfe56" },
    { 0xfe57,   "Bluetooth GATT Attribute Dotted Labs (UUID 0xfe57)", "BT GATT Dotted Labs (UUID 0xfe57)", "btgatt.uuid0xfe57" },
    { 0xfe58,   "Bluetooth GATT Attribute Nordic Semiconductor ASA (UUID 0xfe58)", "BT GATT Nordic Semiconductor ASA (UUID 0xfe58)", "btgatt.uuid0xfe58" },
    { 0xfe59,   "Bluetooth GATT Attribute Nordic Semiconductor ASA (UUID 0xfe59)", "BT GATT Nordic Semiconductor ASA (UUID 0xfe59)", "btgatt.uuid0xfe59" },
    { 0xfe5a,   "Bluetooth GATT Attribute Cronologics Corporation (UUID 0xfe5a)", "BT GATT Cronologics Corporation (UUID 0xfe5a)", "btgatt.uuid0xfe5a" },
    { 0xfe5b,   "Bluetooth GATT Attribute GT-tronics HK Ltd (UUID 0xfe5b)", "BT GATT GT-tronics HK Ltd (UUID 0xfe5b)", "btgatt.uuid0xfe5b" },
    { 0xfe5c,   "Bluetooth GATT Attribute million hunters GmbH (UUID 0xfe5c)", "BT GATT million hunters GmbH (UUID 0xfe5c)", "btgatt.uuid0xfe5c" },
    { 0xfe5d,   "Bluetooth GATT Attribute Grundfos A/S (UUID 0xfe5d)", "BT GATT Grundfos A/S (UUID 0xfe5d)", "btgatt.uuid0xfe5d" },
    { 0xfe5e,   "Bluetooth GATT Attribute Plastc Corporation (UUID 0xfe5e)", "BT GATT Plastc Corporation (UUID 0xfe5e)", "btgatt.uuid0xfe5e" },
    { 0xfe5f,   "Bluetooth GATT Attribute Eyefi, Inc. (UUID 0xfe5f)", "BT GATT Eyefi, Inc. (UUID 0xfe5f)", "btgatt.uuid0xfe5f" },
    { 0xfe60,   "Bluetooth GATT Attribute Lierda Science & Technology Group Co., Ltd. (UUID 0xfe60)", "BT GATT Lierda Science & Technology Group Co., Ltd. (UUID 0xfe60)", "btgatt.uuid0xfe60" },
    { 0xfe61,   "Bluetooth GATT Attribute Logitech International SA (UUID 0xfe61)", "BT GATT Logitech International SA (UUID 0xfe61)", "btgatt.uuid0xfe61" },
    { 0xfe62,   "Bluetooth GATT Attribute Indagem Tech LLC (UUID 0xfe62)", "BT GATT Indagem Tech LLC (UUID 0xfe62)", "btgatt.uuid0xfe62" },
    { 0xfe63,   "Bluetooth GATT Attribute Connected Yard, Inc. (UUID 0xfe63)", "BT GATT Connected Yard, Inc. (UUID 0xfe63)", "btgatt.uuid0xfe63" },
    { 0xfe64,   "Bluetooth GATT Attribute Siemens AG (UUID 0xfe64)", "BT GATT Siemens AG (UUID 0xfe64)", "btgatt.uuid0xfe64" },
    { 0xfe65,   "Bluetooth GATT Attribute CHIPOLO d.o.o. (UUID 0xfe65)", "BT GATT CHIPOLO d.o.o. (UUID 0xfe65)", "btgatt.uuid0xfe65" },
    { 0xfe66,   "Bluetooth GATT Attribute Intel Corporation (UUID 0xfe66)", "BT GATT Intel Corporation (UUID 0xfe66)", "btgatt.uuid0xfe66" },
    { 0xfe67,   "Bluetooth GATT Attribute Lab Sensor Solutions (UUID 0xfe67)", "BT GATT Lab Sensor Solutions (UUID 0xfe67)", "btgatt.uuid0xfe67" },
    { 0xfe68,   "Bluetooth GATT Attribute Capsle Technologies Inc. (UUID 0xfe68)", "BT GATT Capsle Technologies Inc. (UUID 0xfe68)", "btgatt.uuid0xfe68" },
    { 0xfe69,   "Bluetooth GATT Attribute Capsle Technologies Inc. (UUID 0xfe69)", "BT GATT Capsle Technologies Inc. (UUID 0xfe69)", "btgatt.uuid0xfe69" },
    { 0xfe6a,   "Bluetooth GATT Attribute Kontakt Micro-Location Sp. z o.o. (UUID 0xfe6a)", "BT GATT Kontakt Micro-Location Sp. z o.o. (UUID 0xfe6a)", "btgatt.uuid0xfe6a" },
    { 0xfe6b,   "Bluetooth GATT Attribute TASER International, Inc. (UUID 0xfe6b)", "BT GATT TASER International, Inc. (UUID 0xfe6b)", "btgatt.uuid0xfe6b" },
    { 0xfe6c,   "Bluetooth GATT Attribute TASER International, Inc. (UUID 0xfe6c)", "BT GATT TASER International, Inc. (UUID 0xfe6c)", "btgatt.uuid0xfe6c" },
    { 0xfe6d,   "Bluetooth GATT Attribute The University of Tokyo (UUID 0xfe6d)", "BT GATT The University of Tokyo (UUID 0xfe6d)", "btgatt.uuid0xfe6d" },
    { 0xfe6e,   "Bluetooth GATT Attribute The University of Tokyo (UUID 0xfe6e)", "BT GATT The University of Tokyo (UUID 0xfe6e)", "btgatt.uuid0xfe6e" },
    { 0xfe6f,   "Bluetooth GATT Attribute LINE Corporation (UUID 0xfe6f)", "BT GATT LINE Corporation (UUID 0xfe6f)", "btgatt.uuid0xfe6f" },
    { 0xfe70,   "Bluetooth GATT Attribute Beijing Jingdong Century Trading Co., Ltd. (UUID 0xfe70)", "BT GATT Beijing Jingdong Century Trading Co., Ltd. (UUID 0xfe70)", "btgatt.uuid0xfe70" },
    { 0xfe71,   "Bluetooth GATT Attribute Plume Design Inc (UUID 0xfe71)", "BT GATT Plume Design Inc (UUID 0xfe71)", "btgatt.uuid0xfe71" },
    { 0xfe72,   "Bluetooth GATT Attribute Abbott (formerly St. Jude Medical, Inc.) (UUID 0xfe72)", "BT GATT Abbott (formerly St. Jude Medical, Inc.) (UUID 0xfe72)", "btgatt.uuid0xfe72" },
    { 0xfe73,   "Bluetooth GATT Attribute Abbott (formerly St. Jude Medical, Inc.) (UUID 0xfe73)", "BT GATT Abbott (formerly St. Jude Medical, Inc.) (UUID 0xfe73)", "btgatt.uuid0xfe73" },
    { 0xfe74,   "Bluetooth GATT Attribute unwire (UUID 0xfe74)", "BT GATT unwire (UUID 0xfe74)", "btgatt.uuid0xfe74" },
    { 0xfe75,   "Bluetooth GATT Attribute TangoMe (UUID 0xfe75)", "BT GATT TangoMe (UUID 0xfe75)", "btgatt.uuid0xfe75" },
    { 0xfe76,   "Bluetooth GATT Attribute TangoMe (UUID 0xfe76)", "BT GATT TangoMe (UUID 0xfe76)", "btgatt.uuid0xfe76" },
    { 0xfe77,   "Bluetooth GATT Attribute Hewlett-Packard Company (UUID 0xfe77)", "BT GATT Hewlett-Packard Company (UUID 0xfe77)", "btgatt.uuid0xfe77" },
    { 0xfe78,   "Bluetooth GATT Attribute Hewlett-Packard Company (UUID 0xfe78)", "BT GATT Hewlett-Packard Company (UUID 0xfe78)", "btgatt.uuid0xfe78" },
    { 0xfe79,   "Bluetooth GATT Attribute Zebra Technologies (UUID 0xfe79)", "BT GATT Zebra Technologies (UUID 0xfe79)", "btgatt.uuid0xfe79" },
    { 0xfe7a,   "Bluetooth GATT Attribute Bragi GmbH (UUID 0xfe7a)", "BT GATT Bragi GmbH (UUID 0xfe7a)", "btgatt.uuid0xfe7a" },
    { 0xfe7b,   "Bluetooth GATT Attribute Orion Labs, Inc. (UUID 0xfe7b)", "BT GATT Orion Labs, Inc. (UUID 0xfe7b)", "btgatt.uuid0xfe7b" },
    { 0xfe7c,   "Bluetooth GATT Attribute Telit Wireless Solutions (Formerly Stollmann E+V GmbH) (UUID 0xfe7c)", "BT GATT Telit Wireless Solutions (Formerly Stollmann E+V GmbH) (UUID 0xfe7c)", "btgatt.uuid0xfe7c" },
    { 0xfe7d,   "Bluetooth GATT Attribute Aterica Health Inc. (UUID 0xfe7d)", "BT GATT Aterica Health Inc. (UUID 0xfe7d)", "btgatt.uuid0xfe7d" },
    { 0xfe7e,   "Bluetooth GATT Attribute Awear Solutions Ltd (UUID 0xfe7e)", "BT GATT Awear Solutions Ltd (UUID 0xfe7e)", "btgatt.uuid0xfe7e" },
    { 0xfe7f,   "Bluetooth GATT Attribute Doppler Lab (UUID 0xfe7f)", "BT GATT Doppler Lab (UUID 0xfe7f)", "btgatt.uuid0xfe7f" },
    { 0xfe80,   "Bluetooth GATT Attribute Doppler Lab (UUID 0xfe80)", "BT GATT Doppler Lab (UUID 0xfe80)", "btgatt.uuid0xfe80" },
    { 0xfe81,   "Bluetooth GATT Attribute Medtronic Inc. (UUID 0xfe81)", "BT GATT Medtronic Inc. (UUID 0xfe81)", "btgatt.uuid0xfe81" },
    { 0xfe82,   "Bluetooth GATT Attribute Medtronic Inc. (UUID 0xfe82)", "BT GATT Medtronic Inc. (UUID 0xfe82)", "btgatt.uuid0xfe82" },
    { 0xfe83,   "Bluetooth GATT Attribute Blue Bite (UUID 0xfe83)", "BT GATT Blue Bite (UUID 0xfe83)", "btgatt.uuid0xfe83" },
    { 0xfe84,   "Bluetooth GATT Attribute RF Digital Corp (UUID 0xfe84)", "BT GATT RF Digital Corp (UUID 0xfe84)", "btgatt.uuid0xfe84" },
    { 0xfe85,   "Bluetooth GATT Attribute RF Digital Corp (UUID 0xfe85)", "BT GATT RF Digital Corp (UUID 0xfe85)", "btgatt.uuid0xfe85" },
    { 0xfe86,   "Bluetooth GATT Attribute HUAWEI Technologies Co., Ltd (UUID 0xfe86)", "BT GATT HUAWEI Technologies Co., Ltd (UUID 0xfe86)", "btgatt.uuid0xfe86" },
    { 0xfe87,   "Bluetooth GATT Attribute Qingdao Yeelink Information Technology Co., Ltd. ( 青岛亿联客信息技术有限公司 ) (UUID 0xfe87)", "BT GATT Qingdao Yeelink Information Technology Co., Ltd. ( 青岛亿联客信息技术有限公司 ) (UUID 0xfe87)", "btgatt.uuid0xfe87" },
    { 0xfe88,   "Bluetooth GATT Attribute SALTO SYSTEMS S.L. (UUID 0xfe88)", "BT GATT SALTO SYSTEMS S.L. (UUID 0xfe88)", "btgatt.uuid0xfe88" },
    { 0xfe89,   "Bluetooth GATT Attribute B&O Play A/S (UUID 0xfe89)", "BT GATT B&O Play A/S (UUID 0xfe89)", "btgatt.uuid0xfe89" },
    { 0xfe8a,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfe8a)", "BT GATT Apple, Inc. (UUID 0xfe8a)", "btgatt.uuid0xfe8a" },
    { 0xfe8b,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfe8b)", "BT GATT Apple, Inc. (UUID 0xfe8b)", "btgatt.uuid0xfe8b" },
    { 0xfe8c,   "Bluetooth GATT Attribute TRON Forum (UUID 0xfe8c)", "BT GATT TRON Forum (UUID 0xfe8c)", "btgatt.uuid0xfe8c" },
    { 0xfe8d,   "Bluetooth GATT Attribute Interaxon Inc. (UUID 0xfe8d)", "BT GATT Interaxon Inc. (UUID 0xfe8d)", "btgatt.uuid0xfe8d" },
    { 0xfe8e,   "Bluetooth GATT Attribute ARM Ltd (UUID 0xfe8e)", "BT GATT ARM Ltd (UUID 0xfe8e)", "btgatt.uuid0xfe8e" },
    { 0xfe8f,   "Bluetooth GATT Attribute CSR (UUID 0xfe8f)", "BT GATT CSR (UUID 0xfe8f)", "btgatt.uuid0xfe8f" },
    { 0xfe90,   "Bluetooth GATT Attribute JUMA (UUID 0xfe90)", "BT GATT JUMA (UUID 0xfe90)", "btgatt.uuid0xfe90" },
    { 0xfe91,   "Bluetooth GATT Attribute Shanghai Imilab Technology Co.,Ltd (UUID 0xfe91)", "BT GATT Shanghai Imilab Technology Co.,Ltd (UUID 0xfe91)", "btgatt.uuid0xfe91" },
    { 0xfe92,   "Bluetooth GATT Attribute Jarden Safety & Security (UUID 0xfe92)", "BT GATT Jarden Safety & Security (UUID 0xfe92)", "btgatt.uuid0xfe92" },
    { 0xfe93,   "Bluetooth GATT Attribute OttoQ In (UUID 0xfe93)", "BT GATT OttoQ In (UUID 0xfe93)", "btgatt.uuid0xfe93" },
    { 0xfe94,   "Bluetooth GATT Attribute OttoQ In (UUID 0xfe94)", "BT GATT OttoQ In (UUID 0xfe94)", "btgatt.uuid0xfe94" },
    { 0xfe95,   "Bluetooth GATT Attribute Xiaomi Inc. (UUID 0xfe95)", "BT GATT Xiaomi Inc. (UUID 0xfe95)", "btgatt.uuid0xfe95" },
    { 0xfe96,   "Bluetooth GATT Attribute Tesla Motors Inc. (UUID 0xfe96)", "BT GATT Tesla Motors Inc. (UUID 0xfe96)", "btgatt.uuid0xfe96" },
    { 0xfe97,   "Bluetooth GATT Attribute Tesla Motors Inc. (UUID 0xfe97)", "BT GATT Tesla Motors Inc. (UUID 0xfe97)", "btgatt.uuid0xfe97" },
    { 0xfe98,   "Bluetooth GATT Attribute Currant Inc (UUID 0xfe98)", "BT GATT Currant Inc (UUID 0xfe98)", "btgatt.uuid0xfe98" },
    { 0xfe99,   "Bluetooth GATT Attribute Currant Inc (UUID 0xfe99)", "BT GATT Currant Inc (UUID 0xfe99)", "btgatt.uuid0xfe99" },
    { 0xfe9a,   "Bluetooth GATT Attribute Estimote (UUID 0xfe9a)", "BT GATT Estimote (UUID 0xfe9a)", "btgatt.uuid0xfe9a" },
    { 0xfe9b,   "Bluetooth GATT Attribute Samsara Networks, Inc (UUID 0xfe9b)", "BT GATT Samsara Networks, Inc (UUID 0xfe9b)", "btgatt.uuid0xfe9b" },
    { 0xfe9c,   "Bluetooth GATT Attribute GSI Laboratories, Inc. (UUID 0xfe9c)", "BT GATT GSI Laboratories, Inc. (UUID 0xfe9c)", "btgatt.uuid0xfe9c" },
    { 0xfe9d,   "Bluetooth GATT Attribute Mobiquity Networks Inc (UUID 0xfe9d)", "BT GATT Mobiquity Networks Inc (UUID 0xfe9d)", "btgatt.uuid0xfe9d" },
    { 0xfe9e,   "Bluetooth GATT Attribute Renesas Design Netherlands B.V. (UUID 0xfe9e)", "BT GATT Renesas Design Netherlands B.V. (UUID 0xfe9e)", "btgatt.uuid0xfe9e" },
    { 0xfe9f,   "Bluetooth GATT Attribute Google LLC (UUID 0xfe9f)", "BT GATT Google LLC (UUID 0xfe9f)", "btgatt.uuid0xfe9f" },
    { 0xfea0,   "Bluetooth GATT Attribute Google LLC (UUID 0xfea0)", "BT GATT Google LLC (UUID 0xfea0)", "btgatt.uuid0xfea0" },
    { 0xfea3,   "Bluetooth GATT Attribute ITT Industries (UUID 0xfea3)", "BT GATT ITT Industries (UUID 0xfea3)", "btgatt.uuid0xfea3" },
    { 0xfea4,   "Bluetooth GATT Attribute Paxton Access Ltd (UUID 0xfea4)", "BT GATT Paxton Access Ltd (UUID 0xfea4)", "btgatt.uuid0xfea4" },
    { 0xfea5,   "Bluetooth GATT Attribute GoPro, Inc. (UUID 0xfea5)", "BT GATT GoPro, Inc. (UUID 0xfea5)", "btgatt.uuid0xfea5" },
    { 0xfea6,   "Bluetooth GATT Attribute GoPro, Inc. (UUID 0xfea6)", "BT GATT GoPro, Inc. (UUID 0xfea6)", "btgatt.uuid0xfea6" },
    { 0xfea7,   "Bluetooth GATT Attribute UTC Fire and Security (UUID 0xfea7)", "BT GATT UTC Fire and Security (UUID 0xfea7)", "btgatt.uuid0xfea7" },
    { 0xfea8,   "Bluetooth GATT Attribute Savant Systems LLC (UUID 0xfea8)", "BT GATT Savant Systems LLC (UUID 0xfea8)", "btgatt.uuid0xfea8" },
    { 0xfea9,   "Bluetooth GATT Attribute Savant Systems LLC (UUID 0xfea9)", "BT GATT Savant Systems LLC (UUID 0xfea9)", "btgatt.uuid0xfea9" },
    { 0xfeaa,   "Bluetooth GATT Attribute Google LLC (UUID 0xfeaa)", "BT GATT Google LLC (UUID 0xfeaa)", "btgatt.uuid0xfeaa" },
    { 0xfeab,   "Bluetooth GATT Attribute Nokia (UUID 0xfeab)", "BT GATT Nokia (UUID 0xfeab)", "btgatt.uuid0xfeab" },
    { 0xfeac,   "Bluetooth GATT Attribute Nokia (UUID 0xfeac)", "BT GATT Nokia (UUID 0xfeac)", "btgatt.uuid0xfeac" },
    { 0xfead,   "Bluetooth GATT Attribute Nokia (UUID 0xfead)", "BT GATT Nokia (UUID 0xfead)", "btgatt.uuid0xfead" },
    { 0xfeae,   "Bluetooth GATT Attribute Nokia (UUID 0xfeae)", "BT GATT Nokia (UUID 0xfeae)", "btgatt.uuid0xfeae" },
    { 0xfeaf,   "Bluetooth GATT Attribute Nest Labs Inc (UUID 0xfeaf)", "BT GATT Nest Labs Inc (UUID 0xfeaf)", "btgatt.uuid0xfeaf" },
    { 0xfeb0,   "Bluetooth GATT Attribute Nest Labs Inc (UUID 0xfeb0)", "BT GATT Nest Labs Inc (UUID 0xfeb0)", "btgatt.uuid0xfeb0" },
    { 0xfeb1,   "Bluetooth GATT Attribute Electronics Tomorrow Limited (UUID 0xfeb1)", "BT GATT Electronics Tomorrow Limited (UUID 0xfeb1)", "btgatt.uuid0xfeb1" },
    { 0xfeb2,   "Bluetooth GATT Attribute Microsoft Corporation (UUID 0xfeb2)", "BT GATT Microsoft Corporation (UUID 0xfeb2)", "btgatt.uuid0xfeb2" },
    { 0xfeb3,   "Bluetooth GATT Attribute Taobao (UUID 0xfeb3)", "BT GATT Taobao (UUID 0xfeb3)", "btgatt.uuid0xfeb3" },
    { 0xfeb4,   "Bluetooth GATT Attribute WiSilica Inc. (UUID 0xfeb4)", "BT GATT WiSilica Inc. (UUID 0xfeb4)", "btgatt.uuid0xfeb4" },
    { 0xfeb5,   "Bluetooth GATT Attribute WiSilica Inc. (UUID 0xfeb5)", "BT GATT WiSilica Inc. (UUID 0xfeb5)", "btgatt.uuid0xfeb5" },
    { 0xfeb6,   "Bluetooth GATT Attribute Vencer Co., Ltd (UUID 0xfeb6)", "BT GATT Vencer Co., Ltd (UUID 0xfeb6)", "btgatt.uuid0xfeb6" },
    { 0xfeb7,   "Bluetooth GATT Attribute Meta Platforms, Inc. (UUID 0xfeb7)", "BT GATT Meta Platforms, Inc. (UUID 0xfeb7)", "btgatt.uuid0xfeb7" },
    { 0xfeb8,   "Bluetooth GATT Attribute Meta Platforms, Inc. (UUID 0xfeb8)", "BT GATT Meta Platforms, Inc. (UUID 0xfeb8)", "btgatt.uuid0xfeb8" },
    { 0xfeb9,   "Bluetooth GATT Attribute LG Electronics (UUID 0xfeb9)", "BT GATT LG Electronics (UUID 0xfeb9)", "btgatt.uuid0xfeb9" },
    { 0xfeba,   "Bluetooth GATT Attribute Tencent Holdings Limited (UUID 0xfeba)", "BT GATT Tencent Holdings Limited (UUID 0xfeba)", "btgatt.uuid0xfeba" },
    { 0xfebb,   "Bluetooth GATT Attribute adafruit industries (UUID 0xfebb)", "BT GATT adafruit industries (UUID 0xfebb)", "btgatt.uuid0xfebb" },
    { 0xfebc,   "Bluetooth GATT Attribute Dexcom Inc (UUID 0xfebc)", "BT GATT Dexcom Inc (UUID 0xfebc)", "btgatt.uuid0xfebc" },
    { 0xfebd,   "Bluetooth GATT Attribute Clover Network, Inc (UUID 0xfebd)", "BT GATT Clover Network, Inc (UUID 0xfebd)", "btgatt.uuid0xfebd" },
    { 0xfebe,   "Bluetooth GATT Attribute Bose Corporation (UUID 0xfebe)", "BT GATT Bose Corporation (UUID 0xfebe)", "btgatt.uuid0xfebe" },
    { 0xfebf,   "Bluetooth GATT Attribute Nod, Inc. (UUID 0xfebf)", "BT GATT Nod, Inc. (UUID 0xfebf)", "btgatt.uuid0xfebf" },
    { 0xfec0,   "Bluetooth GATT Attribute KDDI Corporation (UUID 0xfec0)", "BT GATT KDDI Corporation (UUID 0xfec0)", "btgatt.uuid0xfec0" },
    { 0xfec1,   "Bluetooth GATT Attribute KDDI Corporation (UUID 0xfec1)", "BT GATT KDDI Corporation (UUID 0xfec1)", "btgatt.uuid0xfec1" },
    { 0xfec2,   "Bluetooth GATT Attribute Blue Spark Technologies, Inc. (UUID 0xfec2)", "BT GATT Blue Spark Technologies, Inc. (UUID 0xfec2)", "btgatt.uuid0xfec2" },
    { 0xfec3,   "Bluetooth GATT Attribute 360fly, Inc. (UUID 0xfec3)", "BT GATT 360fly, Inc. (UUID 0xfec3)", "btgatt.uuid0xfec3" },
    { 0xfec4,   "Bluetooth GATT Attribute PLUS Location Systems (UUID 0xfec4)", "BT GATT PLUS Location Systems (UUID 0xfec4)", "btgatt.uuid0xfec4" },
    { 0xfec5,   "Bluetooth GATT Attribute Realtek Semiconductor Corp. (UUID 0xfec5)", "BT GATT Realtek Semiconductor Corp. (UUID 0xfec5)", "btgatt.uuid0xfec5" },
    { 0xfec6,   "Bluetooth GATT Attribute Kocomojo, LLC (UUID 0xfec6)", "BT GATT Kocomojo, LLC (UUID 0xfec6)", "btgatt.uuid0xfec6" },
    { 0xfec7,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfec7)", "BT GATT Apple, Inc. (UUID 0xfec7)", "btgatt.uuid0xfec7" },
    { 0xfec8,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfec8)", "BT GATT Apple, Inc. (UUID 0xfec8)", "btgatt.uuid0xfec8" },
    { 0xfec9,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfec9)", "BT GATT Apple, Inc. (UUID 0xfec9)", "btgatt.uuid0xfec9" },
    { 0xfeca,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfeca)", "BT GATT Apple, Inc. (UUID 0xfeca)", "btgatt.uuid0xfeca" },
    { 0xfecb,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfecb)", "BT GATT Apple, Inc. (UUID 0xfecb)", "btgatt.uuid0xfecb" },
    { 0xfecc,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfecc)", "BT GATT Apple, Inc. (UUID 0xfecc)", "btgatt.uuid0xfecc" },
    { 0xfecd,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfecd)", "BT GATT Apple, Inc. (UUID 0xfecd)", "btgatt.uuid0xfecd" },
    { 0xfece,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfece)", "BT GATT Apple, Inc. (UUID 0xfece)", "btgatt.uuid0xfece" },
    { 0xfecf,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfecf)", "BT GATT Apple, Inc. (UUID 0xfecf)", "btgatt.uuid0xfecf" },
    { 0xfed0,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfed0)", "BT GATT Apple, Inc. (UUID 0xfed0)", "btgatt.uuid0xfed0" },
    { 0xfed1,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfed1)", "BT GATT Apple, Inc. (UUID 0xfed1)", "btgatt.uuid0xfed1" },
    { 0xfed2,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfed2)", "BT GATT Apple, Inc. (UUID 0xfed2)", "btgatt.uuid0xfed2" },
    { 0xfed3,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfed3)", "BT GATT Apple, Inc. (UUID 0xfed3)", "btgatt.uuid0xfed3" },
    { 0xfed4,   "Bluetooth GATT Attribute Apple, Inc. (UUID 0xfed4)", "BT GATT Apple, Inc. (UUID 0xfed4)", "btgatt.uuid0xfed4" },
    { 0xfed5,   "Bluetooth GATT Attribute Plantronics Inc. (UUID 0xfed5)", "BT GATT Plantronics Inc. (UUID 0xfed5)", "btgatt.uuid0xfed5" },
    { 0xfed6,   "Bluetooth GATT Attribute Broadcom (UUID 0xfed6)", "BT GATT Broadcom (UUID 0xfed6)", "btgatt.uuid0xfed6" },
    { 0xfed7,   "Bluetooth GATT Attribute Broadcom (UUID 0xfed7)", "BT GATT Broadcom (UUID 0xfed7)", "btgatt.uuid0xfed7" },
    { 0xfed8,   "Bluetooth GATT Attribute Google LLC (UUID 0xfed8)", "BT GATT Google LLC (UUID 0xfed8)", "btgatt.uuid0xfed8" },
    { 0xfed9,   "Bluetooth GATT Attribute Pebble Technology Corporation (UUID 0xfed9)", "BT GATT Pebble Technology Corporation (UUID 0xfed9)", "btgatt.uuid0xfed9" },
    { 0xfeda,   "Bluetooth GATT Attribute ISSC Technologies Corp. (UUID 0xfeda)", "BT GATT ISSC Technologies Corp. (UUID 0xfeda)", "btgatt.uuid0xfeda" },
    { 0xfedb,   "Bluetooth GATT Attribute Perka, Inc. (UUID 0xfedb)", "BT GATT Perka, Inc. (UUID 0xfedb)", "btgatt.uuid0xfedb" },
    { 0xfedc,   "Bluetooth GATT Attribute Jawbone (UUID 0xfedc)", "BT GATT Jawbone (UUID 0xfedc)", "btgatt.uuid0xfedc" },
    { 0xfedd,   "Bluetooth GATT Attribute Jawbone (UUID 0xfedd)", "BT GATT Jawbone (UUID 0xfedd)", "btgatt.uuid0xfedd" },
    { 0xfede,   "Bluetooth GATT Attribute Coin, Inc. (UUID 0xfede)", "BT GATT Coin, Inc. (UUID 0xfede)", "btgatt.uuid0xfede" },
    { 0xfee0,   "Bluetooth GATT Attribute Anhui Huami Information Technology Co., Ltd. (UUID 0xfee0)", "BT GATT Anhui Huami Information Technology Co., Ltd. (UUID 0xfee0)", "btgatt.uuid0xfee0" },
    { 0xfee1,   "Bluetooth GATT Attribute Anhui Huami Information Technology Co., Ltd. (UUID 0xfee1)", "BT GATT Anhui Huami Information Technology Co., Ltd. (UUID 0xfee1)", "btgatt.uuid0xfee1" },
    { 0xfee2,   "Bluetooth GATT Attribute Anki, Inc. (UUID 0xfee2)", "BT GATT Anki, Inc. (UUID 0xfee2)", "btgatt.uuid0xfee2" },
    { 0xfee3,   "Bluetooth GATT Attribute Anki, Inc. (UUID 0xfee3)", "BT GATT Anki, Inc. (UUID 0xfee3)", "btgatt.uuid0xfee3" },
    { 0xfee4,   "Bluetooth GATT Attribute Nordic Semiconductor ASA (UUID 0xfee4)", "BT GATT Nordic Semiconductor ASA (UUID 0xfee4)", "btgatt.uuid0xfee4" },
    { 0xfee5,   "Bluetooth GATT Attribute Nordic Semiconductor ASA (UUID 0xfee5)", "BT GATT Nordic Semiconductor ASA (UUID 0xfee5)", "btgatt.uuid0xfee5" },
    { 0xfee6,   "Bluetooth GATT Attribute Silvair, Inc. (UUID 0xfee6)", "BT GATT Silvair, Inc. (UUID 0xfee6)", "btgatt.uuid0xfee6" },
    { 0xfee7,   "Bluetooth GATT Attribute Tencent Holdings Limited. (UUID 0xfee7)", "BT GATT Tencent Holdings Limited. (UUID 0xfee7)", "btgatt.uuid0xfee7" },
    { 0xfee8,   "Bluetooth GATT Attribute Quintic Corp. (UUID 0xfee8)", "BT GATT Quintic Corp. (UUID 0xfee8)", "btgatt.uuid0xfee8" },
    { 0xfee9,   "Bluetooth GATT Attribute Quintic Corp. (UUID 0xfee9)", "BT GATT Quintic Corp. (UUID 0xfee9)", "btgatt.uuid0xfee9" },
    { 0xfeea,   "Bluetooth GATT Attribute Swirl Networks, Inc. (UUID 0xfeea)", "BT GATT Swirl Networks, Inc. (UUID 0xfeea)", "btgatt.uuid0xfeea" },
    { 0xfeeb,   "Bluetooth GATT Attribute Swirl Networks, Inc. (UUID 0xfeeb)", "BT GATT Swirl Networks, Inc. (UUID 0xfeeb)", "btgatt.uuid0xfeeb" },
    { 0xfeec,   "Bluetooth GATT Attribute Tile, Inc. (UUID 0xfeec)", "BT GATT Tile, Inc. (UUID 0xfeec)", "btgatt.uuid0xfeec" },
    { 0xfeed,   "Bluetooth GATT Attribute Tile, Inc. (UUID 0xfeed)", "BT GATT Tile, Inc. (UUID 0xfeed)", "btgatt.uuid0xfeed" },
    { 0xfeee,   "Bluetooth GATT Attribute Polar Electro Oy (UUID 0xfeee)", "BT GATT Polar Electro Oy (UUID 0xfeee)", "btgatt.uuid0xfeee" },
    { 0xfeef,   "Bluetooth GATT Attribute Polar Electro Oy (UUID 0xfeef)", "BT GATT Polar Electro Oy (UUID 0xfeef)", "btgatt.uuid0xfeef" },
    { 0xfef0,   "Bluetooth GATT Attribute Intel (UUID 0xfef0)", "BT GATT Intel (UUID 0xfef0)", "btgatt.uuid0xfef0" },
    { 0xfef1,   "Bluetooth GATT Attribute CSR (UUID 0xfef1)", "BT GATT CSR (UUID 0xfef1)", "btgatt.uuid0xfef1" },
    { 0xfef2,   "Bluetooth GATT Attribute CSR (UUID 0xfef2)", "BT GATT CSR (UUID 0xfef2)", "btgatt.uuid0xfef2" },
    { 0xfef3,   "Bluetooth GATT Attribute Google LLC (UUID 0xfef3)", "BT GATT Google LLC (UUID 0xfef3)", "btgatt.uuid0xfef3" },
    { 0xfef4,   "Bluetooth GATT Attribute Google LLC (UUID 0xfef4)", "BT GATT Google LLC (UUID 0xfef4)", "btgatt.uuid0xfef4" },
    { 0xfef5,   "Bluetooth GATT Attribute Dialog Semiconductor GmbH (UUID 0xfef5)", "BT GATT Dialog Semiconductor GmbH (UUID 0xfef5)", "btgatt.uuid0xfef5" },
    { 0xfef6,   "Bluetooth GATT Attribute Wicentric, Inc. (UUID 0xfef6)", "BT GATT Wicentric, Inc. (UUID 0xfef6)", "btgatt.uuid0xfef6" },
    { 0xfef7,   "Bluetooth GATT Attribute Aplix Corporation (UUID 0xfef7)", "BT GATT Aplix Corporation (UUID 0xfef7)", "btgatt.uuid0xfef7" },
    { 0xfef8,   "Bluetooth GATT Attribute Aplix Corporation (UUID 0xfef8)", "BT GATT Aplix Corporation (UUID 0xfef8)", "btgatt.uuid0xfef8" },
    { 0xfef9,   "Bluetooth GATT Attribute PayPal, Inc. (UUID 0xfef9)", "BT GATT PayPal, Inc. (UUID 0xfef9)", "btgatt.uuid0xfef9" },
    { 0xfefa,   "Bluetooth GATT Attribute PayPal, Inc. (UUID 0xfefa)", "BT GATT PayPal, Inc. (UUID 0xfefa)", "btgatt.uuid0xfefa" },
    { 0xfefb,   "Bluetooth GATT Attribute Telit Wireless Solutions (Formerly Stollmann E+V GmbH) (UUID 0xfefb)", "BT GATT Telit Wireless Solutions (Formerly Stollmann E+V GmbH) (UUID 0xfefb)", "btgatt.uuid0xfefb" },
    { 0xfefc,   "Bluetooth GATT Attribute Gimbal, Inc. (UUID 0xfefc)", "BT GATT Gimbal, Inc. (UUID 0xfefc)", "btgatt.uuid0xfefc" },
    { 0xfefd,   "Bluetooth GATT Attribute Gimbal, Inc. (UUID 0xfefd)", "BT GATT Gimbal, Inc. (UUID 0xfefd)", "btgatt.uuid0xfefd" },
    { 0xfefe,   "Bluetooth GATT Attribute GN Hearing A/S (UUID 0xfefe)", "BT GATT GN Hearing A/S (UUID 0xfefe)", "btgatt.uuid0xfefe" },
    { 0xfeff,   "Bluetooth GATT Attribute GN Netcom (UUID 0xfeff)", "BT GATT GN Netcom (UUID 0xfeff)", "btgatt.uuid0xfeff" },
    /* SDO - https://bitbucket.org/bluetooth-SIG/public/raw/HEAD/assigned_numbers/uuids/sdo_uuids.yaml */
    { 0xffef,   "Bluetooth GATT Attribute Wi-Fi Direct Specification (UUID 0xffef)", "BT GATT Wi-Fi Direct Specification (UUID 0xffef)", "btgatt.uuid0xffef" },
    { 0xfff0,   "Bluetooth GATT Attribute Public Key Open Credential (PKOC) (UUID 0xfff0)", "BT GATT Public Key Open Credential (PKOC) (UUID 0xfff0)", "btgatt.uuid0xfff0" },
    { 0xfff1,   "Bluetooth GATT Attribute ICCE Digital Key (UUID 0xfff1)", "BT GATT ICCE Digital Key (UUID 0xfff1)", "btgatt.uuid0xfff1" },
    { 0xfff2,   "Bluetooth GATT Attribute Aliro (UUID 0xfff2)", "BT GATT Aliro (UUID 0xfff2)", "btgatt.uuid0xfff2" },
    { 0xfff3,   "Bluetooth GATT Attribute FiRa Consortium (UUID 0xfff3)", "BT GATT FiRa Consortium (UUID 0xfff3)", "btgatt.uuid0xfff3" },
    { 0xfff4,   "Bluetooth GATT Attribute FiRa Consortium (UUID 0xfff4)", "BT GATT FiRa Consortium (UUID 0xfff4)", "btgatt.uuid0xfff4" },
    { 0xfff5,   "Bluetooth GATT Attribute Car Connectivity Consortium, LLC (UUID 0xfff5)", "BT GATT Car Connectivity Consortium, LLC (UUID 0xfff5)", "btgatt.uuid0xfff5" },
    { 0xfff6,   "Bluetooth GATT Attribute Matter Profile ID (UUID 0xfff6)", "BT GATT Matter Profile ID (UUID 0xfff6)", "btgatt.uuid0xfff6" },
    { 0xfff7,   "Bluetooth GATT Attribute Zigbee Direct (UUID 0xfff7)", "BT GATT Zigbee Direct (UUID 0xfff7)", "btgatt.uuid0xfff7" },
    { 0xfff8,   "Bluetooth GATT Attribute Mopria Alliance BLE (UUID 0xfff8)", "BT GATT Mopria Alliance BLE (UUID 0xfff8)", "btgatt.uuid0xfff8" },
    { 0xfff9,   "Bluetooth GATT Attribute FIDO2 secure client-to-authenticator transport (UUID 0xfff9)", "BT GATT FIDO2 secure client-to-authenticator transport (UUID 0xfff9)", "btgatt.uuid0xfff9" },
    { 0xfffa,   "Bluetooth GATT Attribute ASTM Remote ID (UUID 0xfffa)", "BT GATT ASTM Remote ID (UUID 0xfffa)", "btgatt.uuid0xfffa" },
    { 0xfffb,   "Bluetooth GATT Attribute Direct Thread Commissioning (UUID 0xfffb)", "BT GATT Direct Thread Commissioning (UUID 0xfffb)", "btgatt.uuid0xfffb" },
    { 0xfffc,   "Bluetooth GATT Attribute Wireless Power Transfer (WPT) (UUID 0xfffc)", "BT GATT Wireless Power Transfer (WPT) (UUID 0xfffc)", "btgatt.uuid0xfffc" },
    { 0xfffd,   "Bluetooth GATT Attribute Universal Second Factor Authenticator (UUID 0xfffd)", "BT GATT Universal Second Factor Authenticator (UUID 0xfffd)", "btgatt.uuid0xfffd" },
    { 0xfffe,   "Bluetooth GATT Attribute Wireless Power Transfer (UUID 0xfffe)", "BT GATT Wireless Power Transfer (UUID 0xfffe)", "btgatt.uuid0xfffe" },
    {      0,   NULL, NULL, NULL }
};
